// API_SampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "API_Sample.h"
#include "API_SampleDlg.h"
#include "ImportAPI.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CAPI_SampleDlg dialog


//////////////////////////////////////////////////////////////////////////////////////////////
//Mounting PrinterAPI  
//////////////////////////////////////////////////////////////////////////////////////////////
CPrinterAPI	PrinterAPI;

CAPI_SampleDlg::CAPI_SampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAPI_SampleDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAPI_SampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAPI_SampleDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDNPrint, &CAPI_SampleDlg::OnBnClickedNprint)
	ON_BN_CLICKED(IDNDPrint, &CAPI_SampleDlg::OnBnClickedNdprint)
	ON_BN_CLICKED(IDNImagePrint, &CAPI_SampleDlg::OnBnClickedNimageprint)
	ON_BN_CLICKED(IDNBitImagePrint, &CAPI_SampleDlg::OnBnClickedNBitimageprint)
	ON_BN_CLICKED(IDNImagePrintF, &CAPI_SampleDlg::OnBnClickedNimageprintf)
	ON_BN_CLICKED(IDNBitImagePrintF, &CAPI_SampleDlg::OnBnClickedNbitimageprintf)
	ON_BN_CLICKED(IDNGetStatus, &CAPI_SampleDlg::OnBnClickedNgetstatus)
	ON_BN_CLICKED(IDNGetInformatino, &CAPI_SampleDlg::OnBnClickedNgetinformatino)
	ON_BN_CLICKED(IDPractice, &CAPI_SampleDlg::OnBnClickedPractice)
	ON_BN_CLICKED(IDNResetPrinter, &CAPI_SampleDlg::OnBnClickedNresetprinter)
END_MESSAGE_MAP()


// CAPI_SampleDlg message handlers

BOOL CAPI_SampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	//////////////////////////////////////////////////////////////////////////////////////////////
	//Load PrinterAPI
	//////////////////////////////////////////////////////////////////////////////////////////////
	if ( PrinterAPI.Initialize() == FALSE ) 
	{
		AfxMessageBox(_T("Error :Load PrinterAPI"));
		return FALSE;
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAPI_SampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAPI_SampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CAPI_SampleDlg::OnBnClickedNprint()
{
	//!!!! NPrint̑1͊eňقȂ܂
//	PrinterAPI.NPrint("NPI NP Series Integration Driver", "\"NPI NP Series Integration Driver\"0A", 36, NULL);
//	PrinterAPI.NPrint("NPI Integration Driver", "\"NPI Integration Driver\"0A", 29, NULL);
	PrinterAPI.NPrint("NPI Integration Driver", "1B2102\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A1B4A601B69", 857, NULL);
}

void CAPI_SampleDlg::OnBnClickedNdprint()
{
BYTE cmd[14];

	cmd[0] = 'H';
	cmd[1] = 'e';
	cmd[2] = 'l';
	cmd[3] = 'l';
	cmd[4] = 'o';
	cmd[5] = ' ';
	cmd[6] = 'P';
	cmd[7] = 'r';
	cmd[8] = 'i';
	cmd[9] = 'n';
	cmd[10] = 't';
	cmd[11] = 'e';
	cmd[12] = 'r';
	cmd[13] = 0x0A;
	//!!!! NDPrint̑1͊eňقȂ܂
//	PrinterAPI.NDPrint("NPI NP Series Integration Driver", cmd, 14, NULL);
	PrinterAPI.NDPrint("NPI Integration Driver", cmd, 14, NULL);
}

void CAPI_SampleDlg::OnBnClickedNimageprint()
{
HDC hdc;
HBITMAP hBitmap;
RECT lprc;
HFONT hFont,hBeforeFont;

	hdc = CreateCompatibleDC(NULL);
	hBitmap = CreateCompatibleBitmap(hdc, 576, 200);
	SelectObject(hdc, hBitmap);

	lprc.left = 0;
	lprc.top = 0;
	lprc.right = 576;
	lprc.bottom = 200;

	FillRect(hdc,&lprc,(HBRUSH)GetStockObject( WHITE_BRUSH ));
	Rectangle( hdc, 0, 50, 575, 150 );     

	hFont = CreateFont(57, 0, 0, 0, FW_NORMAL, FALSE, FALSE, 0,
            SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
            DEFAULT_QUALITY, DEFAULT_PITCH, "Century");
	hBeforeFont = (HFONT)SelectObject(hdc, hFont);
	TextOut(hdc, 2, 65, "NImagePrint Sample", 22);
	SelectObject(hdc, hBeforeFont);
    DeleteObject(hFont);

//	PrinterAPI.NImagePrint("NPI NP Series Integration Driver", hdc, 576, 200, 0x01, NULL);
	PrinterAPI.NImagePrint("NPI Integration Driver", hdc, 576, 200, 0x01, NULL);
	DeleteDC(hdc);
}

void CAPI_SampleDlg::OnBnClickedNBitimageprint()
{
	HDC hdc;
	HBITMAP hBitmap;
	RECT lprc;
	HFONT hFont, hBeforeFont;

	hdc = CreateCompatibleDC(NULL);
	hBitmap = CreateCompatibleBitmap(hdc, 576, 200);
	SelectObject(hdc, hBitmap);

	lprc.left = 0;
	lprc.top = 0;
	lprc.right = 576;
	lprc.bottom = 200;

	FillRect(hdc, &lprc, (HBRUSH)GetStockObject(WHITE_BRUSH));
	Rectangle(hdc, 0, 50, 575, 150);

	hFont = CreateFont(57, 0, 0, 0, FW_NORMAL, FALSE, FALSE, 0,
		SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, DEFAULT_PITCH, "Century");
	hBeforeFont = (HFONT)SelectObject(hdc, hFont);
	TextOut(hdc, 2, 65, "NImagePrint Sample", 22);
	SelectObject(hdc, hBeforeFont);
	DeleteObject(hFont);

//	PrinterAPI.NImagePrint("NPI NP Series Integration Driver", hdc, 576, 200, 0x10, NULL);
	PrinterAPI.NImagePrint("NPI Integration Driver", hdc, 576, 200, 0x10, NULL);
	DeleteDC(hdc);
}

void CAPI_SampleDlg::OnBnClickedNimageprintf()
{
	//!!!! NImagePrint̑1͊eňقȂ܂
//	PrinterAPI.NImagePrintF("NPI NP Series Integration Driver", "c:\\TEST.BMP", 1, NULL);
	PrinterAPI.NImagePrintF("NPI Integration Driver", "c:\\TEST.BMP", 1, NULL);
}

void CAPI_SampleDlg::OnBnClickedNbitimageprintf()
{
	//!!!! NImagePrint̑1͊eňقȂ܂
//	PrinterAPI.NImagePrintF("NPI NP Series Integration Driver", "c:\\TEST.BMP", 1, NULL);
	PrinterAPI.NImagePrintF("NPI Integration Driver", "c:\\TEST.BMP", 1, NULL);
}

void CAPI_SampleDlg::OnBnClickedNgetstatus()
{
int ret;
DWORD st;

	//!!!! NGetStatus̑1͊eňقȂ܂
//	ret = PrinterAPI.NGetStatus("NPI NP Series Integration Driver", &st);
	ret = PrinterAPI.NGetStatus("NPI Integration Driver", &st);

	//ڑ󋵃`FbN
	if(ret == -5)
	{
		AfxMessageBox(_T("Printer OFFLINE"));
	}
	else if(ret < -100)
	{
		AfxMessageBox(_T("Printer Service Error"));
	}
	else if(ret < 0)
	{
		AfxMessageBox(_T("Communication Error"));
	}
	//v^ԃ`FbN
	if((st & 0x01) > 0)
	{
		AfxMessageBox(_T("Paper Near End"));
	}
	if((st & 0x02) > 0)
	{
		AfxMessageBox(_T("Head Open"));
	}
	if((st & 0x04) > 0)
	{
		AfxMessageBox(_T("Paper End"));
	}
	if((st & 0xF8) > 0)
	{
		AfxMessageBox(_T("Other Error"));
	}
	if(st == 0)
		AfxMessageBox(_T("Ready"),MB_ICONINFORMATION);


}

void CAPI_SampleDlg::OnBnClickedNgetinformatino()
{
int ret;
char prtname[64];
DWORD tm;
DWORD htm;

	//ݏԎ擾
	//!!!! NGetInformation̑1͊eňقȂ܂
//	ret = PrinterAPI.NGetInformation("NPI NP Series Integration Driver", 2, prtname, &tm);
	ret = PrinterAPI.NGetInformation("NPI Integration Driver", 2, prtname, &tm);
	htm = tm;

	//v^擾vs
	//!!!! NGetStatus̑1͊eňقȂ܂
//	PrinterAPI.NPrint("NPI NP Series Integration Driver", "1B7302", 6, NULL);
	PrinterAPI.NPrint("NPI Integration Driver", "1B7302", 6, NULL);

	//M҂
	while(htm == tm)
	{
		//!!!! NGetInformation̑1͊eňقȂ܂
//	ret = PrinterAPI.NGetInformation("NPI NP Series Integration Driver", 2, prtname, &tm);
		ret = PrinterAPI.NGetInformation("NPI Integration Driver", 2, prtname, &tm);

		//ڑ󋵃`FbN
		if(ret != 0)
		{
			AfxMessageBox(_T("Get Error"));
			return;
		}
	}
	AfxMessageBox(prtname,MB_ICONINFORMATION);
}

void CAPI_SampleDlg::OnBnClickedPractice()
{
int ret;
DWORD st;
BYTE prtinf[64];
DWORD tm;
DWORD htm;
DWORD JOBID;

DWORD wk;

char szCommand[256];   //o̓f[^i[GA

	//ݏ󋵊mF
//	ret = PrinterAPI.NGetStatus("NPI NP Series Integration Driver", &st);
	ret = PrinterAPI.NGetStatus("NPI Integration Driver", &st);

	//ڑ󋵃`FbN
	if(ret == -5)
	{
		AfxMessageBox(_T("Printer OFFLINE"));
		return;
	}
	else if(ret < -100)
	{
		AfxMessageBox(_T("Printer Service Error"));
		return;
	}
	else if(ret < 0)
	{
		AfxMessageBox(_T("Communication Error"));
		return;
	}
	//v^ԃ`FbN
	if((st & 0x02) > 0)
	{
		AfxMessageBox(_T("Head Open"));
		return;
	}
	if((st & 0x04) > 0)
	{
		AfxMessageBox(_T("Paper End"));
		return;
	}
	if((st & 0xF8) > 0)
	{
		AfxMessageBox(_T("Other Error"));
		return;
	}

RETRY:

//	ret = PrinterAPI.NGetInformation("NPI NP Series Integration Driver", 19, prtinf, &tm);			//݈󎚊ʒmԎ擾
	ret = PrinterAPI.NGetInformation("NPI Integration Driver", 19, prtinf, &tm);			//݈󎚊ʒmԎ擾
	htm = tm;
//	ret = PrinterAPI.NStartDoc("NPI NP Series Integration Driver", &JOBID);						//hLgJn
	ret = PrinterAPI.NStartDoc("NPI Integration Driver", &JOBID);						//hLgJn
	if(ret != 0)
	{	
		AfxMessageBox(_T("Error:StartDoc"));
		return;
	}

	//󎚊Jn錾(GS G 11)R}h
	sprintf_s(szCommand, 256, "1D4711\"");
	memcpy(&szCommand[7],&JOBID,4);
	szCommand[11] = '\"';
	PrinterAPI.NPrint("NPI Integration Driver",szCommand,12,NULL);					//󎚊Jn錾(GS G 11)R}hs
	PrinterAPI.NPrint("NPI Integration Driver","1D\"P\"001B\"J\"08",strlen("1D\"P\"001B\"J\"08"),NULL);	//NVC[WR}h,R}hs

	//󎚃f[^MiV[gj
	PrinterAPI.NPrint("NPI Integration Driver","\"Part Name          Num       Price     SubTotal\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"-----------------------------------------------\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Paper                2          60          120\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pencil               1         100          100\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Eraser               1          90           90\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Note                 1          80           80\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Book                 1         500          500\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Calendar             1        1200         1200\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Rule                 1         120          120\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Calculator           1        3980         3980\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Bookends             1          90           90\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Stapler              1         110          110\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(black)           1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(red)             1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(blue)            1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(yellow)          1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(green)           1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(pink)            1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Pen(Purple)          1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"Scissors             1         200          200\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"-----------------------------------------------\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","\"                                    Total 7,080\"0a", 51,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","1B\"J\"68",strlen("1B\"J\"68"),NULL);	//R}hs(Jbgʒu܂ňړj
	PrinterAPI.NPrint("NPI Integration Driver","1B\"m\"",strlen("1B\"m\""),NULL);		//JbgR}hs
	
	//󎚃f[^Miij
	PrinterAPI.NImagePrintF("NPI Integration Driver","c:\\GIFT_Certificate.bmp",1,NULL);
	PrinterAPI.NPrint("NPI Integration Driver","1B\"J\"97",strlen("1B\"J\"97"),NULL);	//R}hs(Jbgʒu܂ňړj
	PrinterAPI.NPrint("NPI Integration Driver","1B\"m\"",strlen("1B\"m\""),NULL);		//JbgR}hs

	PrinterAPI.NPrint("NPI Integration Driver","1D4710",6,NULL);						//󎚊錾(GS G 10)R}hs
	PrinterAPI.NEndDoc("NPI Integration Driver");

RETRYWAIT:
	//M҂
	while(htm == tm)
	{
//		ret = PrinterAPI.NGetInformation("NPI NP Series Integration Driver", 19, prtinf, &tm);
		ret = PrinterAPI.NGetInformation("NPI Integration Driver", 19, prtinf, &tm);

		//ڑ󋵃`FbN
		if(ret != 0)
		{
			AfxMessageBox(_T("Get Error"));
			return;
		}
	}

	memcpy(&wk,prtinf,4);
	if(JOBID == wk)
	{
		memcpy(&wk,&prtinf[4],4);
		if(wk != 0)
		{
			AfxMessageBox("Failed to Print!!",MB_ICONINFORMATION);
			goto RETRY;
		}
	}
	else
	{
		htm = tm;
		goto RETRYWAIT;
	}
		 
	AfxMessageBox("FINISH!!",MB_ICONINFORMATION);
}

void CAPI_SampleDlg::OnBnClickedNresetprinter()
{
int ret;
//	ret = PrinterAPI.NResetPrinter("NPI NP Series Integration Driver");
	ret = PrinterAPI.NResetPrinter("NPI Integration Driver");

	//G[`FbN
	if(ret != 0)
	{
		AfxMessageBox(_T("Reset Error"));
		return;
	}
	AfxMessageBox(_T("Reset Success"));
}
