/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device;

import java.util.LinkedList;
import npi.sdk.common.NLogWriter;
import npi.sdk.device.NDeviceCtl;

public class NOpenThread
extends Thread {
    private String prtName;
    private boolean flgStatusFlg;
    private NLogWriter NLog;
    private NDeviceCtl deviceObj;

    public NOpenThread(String i_prt, boolean i_statusFlg, NLogWriter nLog, NDeviceCtl deviceObj) {
        this.prtName = i_prt;
        this.flgStatusFlg = i_statusFlg;
        this.NLog = nLog;
        this.deviceObj = deviceObj;
        deviceObj.setOpenResult(i_prt, 100);
        if (!deviceObj.getSendQueueMap().containsKey(i_prt)) {
            LinkedList sendQueue = new LinkedList();
            deviceObj.getSendQueueMap().put(i_prt, sendQueue);
        }
    }

    @Override
    public void run() {
        this.NLog.func("NOpenPrinter start  i_prt:" + this.prtName + " i_statusFlg:" + this.flgStatusFlg);
        if (this.prtName == null || this.prtName.equals("")) {
            this.NLog.error("NOpenPrinter error code:-91", this.prtName);
            this.deviceObj.setOpenResult(this.prtName, -91);
            return;
        }
        int nmsRet = this.deviceObj.openPrinter(this.prtName, this.flgStatusFlg);
        if (nmsRet != 0) {
            this.NLog.error("NOpenPrinter error  Result Code:" + nmsRet, this.prtName);
        } else {
            this.NLog.func("NOpenPrinter success", this.prtName);
        }
        this.deviceObj.setOpenResult(this.prtName, nmsRet);
    }
}

