/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.barcode;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class NPDF417AutoError {
    protected int cwPtr;
    protected SegmentList segmentList;
    private int lenCodewords;
    private int errorLevel;
    private int[] codewords = new int[928];
    private int codeRows;
    private int codeColumns;
    private int options = 0;
    private byte[] text;
    private float aspectRatio;
    private float yHeight;
    private int macroIndex;
    private int macroSegmentId;
    private String macroFileId;
    private int macroSegmentCount;
    private static final int[][] ERROR_LEVEL = new int[][]{{27, 917}, {522, 568, 723, 809}, {237, 308, 436, 284, 646, 653, 428, 379}, {274, 562, 232, 755, 599, 524, 801, 132, 295, 116, 442, 428, 295, 42, 176, 65}, {361, 575, 922, 525, 176, 586, 640, 321, 536, 742, 677, 742, 687, 284, 193, 517, 273, 494, 263, 147, 593, 800, 571, 320, 803, 133, 231, 390, 685, 330, 63, 410}, {539, 422, 6, 93, 862, 771, 453, 106, 610, 287, 107, 505, 733, 877, 381, 612, 723, 476, 462, 172, 430, 609, 858, 822, 543, 376, 511, 400, 672, 762, 283, 184, 440, 35, 519, 31, 460, 594, 225, 535, 517, 352, 605, 158, 651, 201, 488, 502, 648, 733, 717, 83, 404, 97, 280, 771, 840, 629, 4, 381, 843, 623, 264, 543}, {521, 310, 864, 547, 858, 580, 296, 379, 53, 779, 897, 444, 400, 925, 749, 415, 822, 93, 217, 208, 928, 244, 583, 620, 246, 148, 447, 631, 292, 908, 490, 704, 516, 258, 457, 907, 594, 723, 674, 292, 272, 96, 684, 432, 686, 606, 860, 569, 193, 219, 129, 186, 236, 287, 192, 775, 278, 173, 40, 379, 712, 463, 646, 776, 171, 491, 297, 763, 156, 732, 95, 270, 447, 90, 507, 48, 228, 821, 808, 898, 784, 663, 627, 378, 382, 262, 380, 602, 754, 336, 89, 614, 87, 432, 670, 616, 157, 374, 242, 726, 600, 269, 375, 898, 845, 454, 354, 130, 814, 587, 804, 34, 211, 330, 539, 297, 827, 865, 37, 517, 834, 315, 550, 86, 801, 4, 108, 539}, {524, 894, 75, 766, 882, 857, 74, 204, 82, 586, 708, 250, 905, 786, 138, 720, 858, 194, 311, 913, 275, 190, 375, 850, 438, 733, 194, 280, 201, 280, 828, 757, 710, 814, 919, 89, 68, 569, 11, 204, 796, 605, 540, 913, 801, 700, 799, 137, 439, 418, 592, 668, 353, 859, 370, 694, 325, 240, 216, 257, 284, 549, 209, 884, 315, 70, 329, 793, 490, 274, 877, 162, 749, 812, 684, 461, 334, 376, 849, 521, 307, 291, 803, 712, 19, 358, 399, 908, 103, 511, 51, 8, 517, 225, 289, 470, 637, 731, 66, 255, 917, 269, 463, 830, 730, 433, 848, 585, 136, 538, 906, 90, 2, 290, 743, 199, 655, 903, 329, 49, 802, 580, 355, 588, 188, 462, 10, 134, 628, 320, 479, 130, 739, 71, 263, 318, 374, 601, 192, 605, 142, 673, 687, 234, 722, 384, 177, 752, 607, 640, 455, 193, 689, 707, 805, 641, 48, 60, 732, 621, 895, 544, 261, 852, 655, 309, 697, 755, 756, 60, 231, 773, 434, 421, 726, 528, 503, 118, 49, 795, 32, 144, 500, 238, 836, 394, 280, 566, 319, 9, 647, 550, 73, 914, 342, 126, 32, 681, 331, 792, 620, 60, 609, 441, 180, 791, 893, 754, 605, 383, 228, 749, 760, 213, 54, 297, 134, 54, 834, 299, 922, 191, 910, 532, 609, 829, 189, 20, 167, 29, 872, 449, 83, 402, 41, 656, 505, 579, 481, 173, 404, 251, 688, 95, 497, 555, 642, 543, 307, 159, 924, 558, 648, 55, 497, 10}, {352, 77, 373, 504, 35, 599, 428, 207, 409, 574, 118, 498, 285, 380, 350, 492, 197, 265, 920, 155, 914, 299, 229, 643, 294, 871, 306, 88, 87, 193, 352, 781, 846, 75, 327, 520, 435, 543, 203, 666, 249, 346, 781, 621, 640, 268, 794, 534, 539, 781, 408, 390, 644, 102, 476, 499, 290, 632, 545, 37, 858, 916, 552, 41, 542, 289, 122, 272, 383, 800, 485, 98, 752, 472, 761, 107, 784, 860, 658, 741, 290, 204, 681, 407, 855, 85, 99, 62, 482, 180, 20, 297, 451, 593, 913, 142, 808, 684, 287, 536, 561, 76, 653, 899, 729, 567, 744, 390, 513, 192, 516, 258, 240, 518, 794, 395, 768, 848, 51, 610, 384, 168, 190, 826, 328, 596, 786, 303, 570, 381, 415, 641, 156, 237, 151, 429, 531, 207, 676, 710, 89, 168, 304, 402, 40, 708, 575, 162, 864, 229, 65, 861, 841, 512, 164, 477, 221, 92, 358, 785, 288, 357, 850, 836, 827, 736, 707, 94, 8, 494, 114, 521, 2, 499, 851, 543, 152, 729, 771, 95, 248, 361, 578, 323, 856, 797, 289, 51, 684, 466, 533, 820, 669, 45, 902, 452, 167, 342, 244, 173, 35, 463, 651, 51, 699, 591, 452, 578, 37, 124, 298, 332, 552, 43, 427, 119, 662, 777, 475, 850, 764, 364, 578, 911, 283, 711, 472, 420, 245, 288, 594, 394, 511, 327, 589, 777, 699, 688, 43, 408, 842, 383, 721, 521, 560, 644, 714, 559, 62, 145, 873, 663, 713, 159, 672, 729, 624, 59, 193, 417, 158, 209, 563, 564, 343, 693, 109, 608, 563, 365, 181, 772, 677, 310, 248, 353, 708, 410, 579, 870, 617, 841, 632, 860, 289, 536, 35, 777, 618, 586, 424, 833, 77, 597, 346, 269, 757, 632, 695, 751, 331, 247, 184, 45, 787, 680, 18, 66, 407, 369, 54, 492, 228, 613, 830, 922, 437, 519, 644, 905, 789, 420, 305, 441, 207, 300, 892, 827, 141, 537, 381, 662, 513, 56, 252, 341, 242, 797, 838, 837, 720, 224, 307, 631, 61, 87, 560, 310, 756, 665, 397, 808, 851, 309, 473, 795, 378, 31, 647, 915, 459, 806, 590, 731, 425, 216, 548, 249, 321, 881, 699, 535, 673, 782, 210, 815, 905, 303, 843, 922, 281, 73, 469, 791, 660, 162, 498, 308, 155, 422, 907, 817, 187, 62, 16, 425, 535, 336, 286, 437, 375, 273, 610, 296, 183, 923, 116, 667, 751, 353, 62, 366, 691, 379, 687, 842, 37, 357, 720, 742, 330, 5, 39, 923, 311, 424, 242, 749, 321, 54, 669, 316, 342, 299, 534, 105, 667, 488, 640, 672, 576, 540, 316, 486, 721, 610, 46, 656, 447, 171, 616, 464, 190, 531, 297, 321, 762, 752, 533, 175, 134, 14, 381, 433, 717, 45, 111, 20, 596, 284, 736, 138, 646, 411, 877, 669, 141, 919, 45, 780, 407, 164, 332, 899, 165, 726, 600, 325, 498, 655, 357, 752, 768, 223, 849, 647, 63, 310, 863, 251, 366, 304, 282, 738, 675, 410, 389, 244, 31, 121, 303, 263}};

    public NPDF417AutoError() {
        this.setDefaultParameters();
    }

    public void setDefaultParameters() {
        this.options = 0;
        this.text = new byte[0];
        this.yHeight = 3.0f;
        this.aspectRatio = 0.5f;
    }

    public void setText(String str) {
        try {
            this.text = str.getBytes("shift-jis");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.text = str.getBytes();
        }
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public int getLenCodewords() {
        return this.lenCodewords;
    }

    public void paintCode() {
        if ((this.options & 0x40) != 0) {
            if (this.lenCodewords > 926 || this.lenCodewords < 1 || this.lenCodewords != this.codewords[0]) {
                throw new IllegalArgumentException();
            }
        } else {
            if (this.text == null) {
                throw new NullPointerException();
            }
            if (this.text.length > 5420) {
                throw new IndexOutOfBoundsException();
            }
            this.segmentList = new SegmentList();
            this.breakString();
            this.assemble();
            this.segmentList = null;
            this.codewords[0] = this.lenCodewords = this.cwPtr;
        }
        int maxErr = NPDF417AutoError.maxPossibleErrorLevel(928 - this.lenCodewords);
        if ((this.options & 0x10) == 0) {
            this.errorLevel = this.lenCodewords < 41 ? 2 : (this.lenCodewords < 161 ? 3 : (this.lenCodewords < 321 ? 4 : 5));
        }
        if (this.errorLevel < 0) {
            this.errorLevel = 0;
        } else if (this.errorLevel > maxErr) {
            this.errorLevel = maxErr;
        }
        if (this.codeColumns < 1) {
            this.codeColumns = 1;
        } else if (this.codeColumns > 30) {
            this.codeColumns = 30;
        }
        if (this.codeRows < 3) {
            this.codeRows = 3;
        } else if (this.codeRows > 90) {
            this.codeRows = 90;
        }
        int lenErr = 2 << this.errorLevel;
        boolean fixedColumn = (this.options & 4) == 0;
        boolean skipRowColAdjust = false;
        int tot = this.lenCodewords + lenErr;
        if ((this.options & 1) != 0) {
            tot = this.codeColumns * this.codeRows;
            if (tot > 928) {
                tot = this.getMaxSquare();
            }
            if (tot < this.lenCodewords + lenErr) {
                tot = this.lenCodewords + lenErr;
            } else {
                skipRowColAdjust = true;
            }
        } else if ((this.options & 6) == 0) {
            fixedColumn = true;
            if ((double)this.aspectRatio < 0.001) {
                this.aspectRatio = 0.001f;
            } else if (this.aspectRatio > 1000.0f) {
                this.aspectRatio = 1000.0f;
            }
            double b = 73.0f * this.aspectRatio - 4.0f;
            double c = (-b + Math.sqrt(b * b + (double)(68.0f * this.aspectRatio * (float)(this.lenCodewords + lenErr) * this.yHeight))) / (double)(34.0f * this.aspectRatio);
            this.codeColumns = (int)(c + 0.5);
            if (this.codeColumns < 1) {
                this.codeColumns = 1;
            } else if (this.codeColumns > 30) {
                this.codeColumns = 30;
            }
        }
        if (!skipRowColAdjust) {
            if (fixedColumn) {
                this.codeRows = (tot - 1) / this.codeColumns + 1;
                if (this.codeRows < 3) {
                    this.codeRows = 3;
                } else if (this.codeRows > 90) {
                    this.codeRows = 90;
                    this.codeColumns = (tot - 1) / 90 + 1;
                }
            } else {
                this.codeColumns = (tot - 1) / this.codeRows + 1;
                if (this.codeColumns > 30) {
                    this.codeColumns = 30;
                    this.codeRows = (tot - 1) / 30 + 1;
                }
            }
            tot = this.codeRows * this.codeColumns;
        }
        if (tot > 928) {
            tot = this.getMaxSquare();
        }
        this.errorLevel = NPDF417AutoError.maxPossibleErrorLevel(tot - this.lenCodewords);
        lenErr = 2 << this.errorLevel;
        int pad = tot - lenErr - this.lenCodewords;
        if ((this.options & 0x100) != 0) {
            System.arraycopy(this.codewords, this.macroIndex, this.codewords, this.macroIndex + pad, pad);
            this.cwPtr = this.lenCodewords + pad;
            while (pad-- != 0) {
                this.codewords[this.macroIndex++] = 900;
            }
        } else {
            this.cwPtr = this.lenCodewords;
            while (pad-- != 0) {
                this.codewords[this.cwPtr++] = 900;
            }
        }
        this.codewords[0] = this.lenCodewords = this.cwPtr;
        this.calculateErrorCorrection(this.lenCodewords);
        this.lenCodewords = tot;
    }

    protected void calculateErrorCorrection(int dest) {
        if (this.errorLevel < 0 || this.errorLevel > 8) {
            this.errorLevel = 0;
        }
        int[] A = ERROR_LEVEL[this.errorLevel];
        int Alength = 2 << this.errorLevel;
        int k = 0;
        while (k < Alength) {
            this.codewords[dest + k] = 0;
            ++k;
        }
        int lastE = Alength - 1;
        int k2 = 0;
        while (k2 < this.lenCodewords) {
            int t1 = this.codewords[k2] + this.codewords[dest];
            int e = 0;
            while (e <= lastE) {
                int t2 = t1 * A[lastE - e] % 929;
                int t3 = 929 - t2;
                this.codewords[dest + e] = ((e != lastE ? this.codewords[dest + e + 1] : 0) + t3) % 929;
                ++e;
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < Alength) {
            this.codewords[dest + k2] = (929 - this.codewords[dest + k2]) % 929;
            ++k2;
        }
    }

    void breakString() {
        boolean redo;
        int textLength = this.text.length;
        int lastP = 0;
        int startN = 0;
        int nd = 0;
        char c = '\u0000';
        if ((this.options & 0x20) != 0) {
            this.segmentList.add('B', 0, textLength);
            return;
        }
        int k = 0;
        while (k < textLength) {
            c = (char)(this.text[k] & 0xFF);
            if (c >= '0' && c <= '9') {
                if (nd == 0) {
                    startN = k;
                }
                ++nd;
            } else {
                if (nd >= 13) {
                    if (lastP != startN) {
                        c = (char)(this.text[lastP] & 0xFF);
                        boolean lastTxt = c >= ' ' && c < '\u007f' || c == '\r' || c == '\n' || c == '\t';
                        int j = lastP;
                        while (j < startN) {
                            boolean txt;
                            c = (char)(this.text[j] & 0xFF);
                            boolean bl = txt = c >= ' ' && c < '\u007f' || c == '\r' || c == '\n' || c == '\t';
                            if (txt != lastTxt) {
                                this.segmentList.add(lastTxt ? (char)'T' : 'B', lastP, j);
                                lastP = j;
                                lastTxt = txt;
                            }
                            ++j;
                        }
                        this.segmentList.add(lastTxt ? (char)'T' : 'B', lastP, startN);
                    }
                    this.segmentList.add('N', startN, k);
                    lastP = k;
                }
                nd = 0;
            }
            ++k;
        }
        if (nd < 13) {
            startN = textLength;
        }
        if (lastP != startN) {
            c = (char)(this.text[lastP] & 0xFF);
            boolean lastTxt = c >= ' ' && c < '\u007f' || c == '\r' || c == '\n' || c == '\t';
            int j = lastP;
            while (j < startN) {
                boolean txt;
                c = (char)(this.text[j] & 0xFF);
                boolean bl = txt = c >= ' ' && c < '\u007f' || c == '\r' || c == '\n' || c == '\t';
                if (txt != lastTxt) {
                    this.segmentList.add(lastTxt ? (char)'T' : 'B', lastP, j);
                    lastP = j;
                    lastTxt = txt;
                }
                ++j;
            }
            this.segmentList.add(lastTxt ? (char)'T' : 'B', lastP, startN);
        }
        if (nd >= 13) {
            this.segmentList.add('N', startN, textLength);
        }
        int k2 = 0;
        while (k2 < this.segmentList.size()) {
            Segment v = this.segmentList.get(k2);
            Segment vp = this.segmentList.get(k2 - 1);
            Segment vn = this.segmentList.get(k2 + 1);
            if (this.checkSegmentType(v, 'B') && this.getSegmentLength(v) == 1 && this.checkSegmentType(vp, 'T') && this.checkSegmentType(vn, 'T') && this.getSegmentLength(vp) + this.getSegmentLength(vn) >= 3) {
                vp.end = vn.end;
                this.segmentList.remove(k2);
                this.segmentList.remove(k2);
                k2 = -1;
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < this.segmentList.size()) {
            Segment v = this.segmentList.get(k2);
            Segment vp = this.segmentList.get(k2 - 1);
            Segment vn = this.segmentList.get(k2 + 1);
            if (this.checkSegmentType(v, 'T') && this.getSegmentLength(v) >= 5) {
                redo = false;
                if (this.checkSegmentType(vp, 'B') && this.getSegmentLength(vp) == 1 || this.checkSegmentType(vp, 'T')) {
                    redo = true;
                    v.start = vp.start;
                    this.segmentList.remove(k2 - 1);
                    --k2;
                }
                if (this.checkSegmentType(vn, 'B') && this.getSegmentLength(vn) == 1 || this.checkSegmentType(vn, 'T')) {
                    redo = true;
                    v.end = vn.end;
                    this.segmentList.remove(k2 + 1);
                }
                if (redo) {
                    k2 = -1;
                }
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < this.segmentList.size()) {
            Segment v = this.segmentList.get(k2);
            Segment vp = this.segmentList.get(k2 - 1);
            Segment vn = this.segmentList.get(k2 + 1);
            if (this.checkSegmentType(v, 'B')) {
                redo = false;
                if (this.checkSegmentType(vp, 'T') && this.getSegmentLength(vp) < 5 || this.checkSegmentType(vp, 'B')) {
                    redo = true;
                    v.start = vp.start;
                    this.segmentList.remove(k2 - 1);
                    --k2;
                }
                if (this.checkSegmentType(vn, 'T') && this.getSegmentLength(vn) < 5 || this.checkSegmentType(vn, 'B')) {
                    redo = true;
                    v.end = vn.end;
                    this.segmentList.remove(k2 + 1);
                }
                if (redo) {
                    k2 = -1;
                }
            }
            ++k2;
        }
        if (this.segmentList.size() == 1) {
            Segment v = this.segmentList.get(0);
            if (v.type == 'T' && this.getSegmentLength(v) >= 8) {
                for (k2 = v.start; k2 < v.end && (c = (char)(this.text[k2] & 0xFF)) >= '0' && c <= '9'; ++k2) {
                }
                if (k2 == v.end) {
                    v.type = (char)78;
                }
            }
        }
    }

    private void numberCompaction(byte[] input, int start, int length) {
        int full = length / 44 * 15;
        int size = length % 44;
        size = size == 0 ? full : full + size / 3 + 1;
        if (size + this.cwPtr > 926) {
            throw new IndexOutOfBoundsException();
        }
        length += start;
        int k = start;
        while (k < length) {
            size = length - k >= 44 ? 44 : length - k;
            this.basicNumberCompaction(input, k, size);
            k += 44;
        }
    }

    protected void basicNumberCompaction(int start, int length) {
        this.basicNumberCompaction(this.text, start, length);
    }

    private void basicNumberCompaction(byte[] input, int start, int length) {
        int ret = this.cwPtr;
        int retLast = length / 3;
        this.cwPtr += retLast + 1;
        int k = 0;
        while (k <= retLast) {
            this.codewords[ret + k] = 0;
            ++k;
        }
        this.codewords[ret + retLast] = 1;
        length += start;
        int ni = start;
        while (ni < length) {
            int k2 = retLast;
            while (k2 >= 0) {
                int n = ret + k2;
                this.codewords[n] = this.codewords[n] * 10;
                --k2;
            }
            int n = ret + retLast;
            this.codewords[n] = this.codewords[n] + (input[ni] - 48);
            k2 = retLast;
            while (k2 > 0) {
                int n2 = ret + k2 - 1;
                this.codewords[n2] = this.codewords[n2] + this.codewords[ret + k2] / 900;
                int n3 = ret + k2;
                this.codewords[n3] = this.codewords[n3] % 900;
                --k2;
            }
            ++ni;
        }
    }

    protected void numberCompaction(int start, int length) {
        this.numberCompaction(this.text, start, length);
    }

    protected void assemble() {
        if (this.segmentList.size() == 0) {
            return;
        }
        this.cwPtr = 1;
        int k = 0;
        while (k < this.segmentList.size()) {
            Segment v = this.segmentList.get(k);
            switch (v.type) {
                default: {
                    break;
                }
                case 'T': {
                    if (k != 0) {
                        this.codewords[this.cwPtr++] = 900;
                    }
                    this.textCompaction(v.start, this.getSegmentLength(v));
                    break;
                }
                case 'N': {
                    this.codewords[this.cwPtr++] = 902;
                    this.numberCompaction(v.start, this.getSegmentLength(v));
                    break;
                }
                case 'B': {
                    this.codewords[this.cwPtr++] = this.getSegmentLength(v) % 6 == 0 ? 924 : 901;
                    this.byteCompaction(v.start, this.getSegmentLength(v));
                }
            }
            ++k;
        }
        if ((this.options & 0x100) != 0) {
            this.macroCodes();
        }
    }

    private void macroCodes() {
        if (this.macroSegmentId < 0) {
            throw new IllegalStateException();
        }
        if (this.macroSegmentId >= this.macroSegmentCount) {
            throw new IllegalStateException();
        }
        if (this.macroSegmentCount < 1) {
            throw new IllegalStateException();
        }
        this.macroIndex = this.cwPtr;
        this.codewords[this.cwPtr++] = 928;
        this.append(this.macroSegmentId, 5);
        if (this.macroFileId != null) {
            this.append(this.macroFileId);
        }
        if (this.macroSegmentId >= this.macroSegmentCount - 1) {
            this.codewords[this.cwPtr++] = 922;
        }
    }

    private void append(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes("shift-jis");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            bytes = s.getBytes();
        }
        this.textCompaction(bytes, 0, bytes.length);
    }

    private void append(int in, int len) {
        StringBuffer sb = new StringBuffer(len + 1);
        sb.append(Integer.toString(in));
        int i = sb.length();
        while (i < len) {
            sb.insert(0, "0");
            ++i;
        }
        byte[] bytes = sb.toString().getBytes();
        this.numberCompaction(bytes, 0, bytes.length);
    }

    protected void byteCompaction6(int start) {
        int length = 6;
        int ret = this.cwPtr;
        int retLast = 4;
        this.cwPtr += retLast + 1;
        int k = 0;
        while (k <= retLast) {
            this.codewords[ret + k] = 0;
            ++k;
        }
        length += start;
        int ni = start;
        while (ni < length) {
            int k2 = retLast;
            while (k2 >= 0) {
                int n = ret + k2;
                this.codewords[n] = this.codewords[n] * 256;
                --k2;
            }
            int n = ret + retLast;
            this.codewords[n] = this.codewords[n] + (this.text[ni] & 0xFF);
            k2 = retLast;
            while (k2 > 0) {
                int n2 = ret + k2 - 1;
                this.codewords[n2] = this.codewords[n2] + this.codewords[ret + k2] / 900;
                int n3 = ret + k2;
                this.codewords[n3] = this.codewords[n3] % 900;
                --k2;
            }
            ++ni;
        }
    }

    void byteCompaction(int start, int length) {
        int size = length / 6 * 5 + length % 6;
        if (size + this.cwPtr > 926) {
            throw new IndexOutOfBoundsException();
        }
        length += start;
        int k = start;
        while (k < length) {
            int n = size = length - k >= 44 ? 6 : length - k;
            if (size < 6) {
                int j = 0;
                while (j < size) {
                    this.codewords[this.cwPtr++] = this.text[k + j] & 0xFF;
                    ++j;
                }
            } else {
                this.byteCompaction6(k);
            }
            k += 6;
        }
    }

    protected boolean checkSegmentType(Segment segment, char type) {
        if (segment == null) {
            return false;
        }
        return segment.type == type;
    }

    protected int getSegmentLength(Segment segment) {
        if (segment == null) {
            return 0;
        }
        return segment.end - segment.start;
    }

    protected int getMaxSquare() {
        if (this.codeColumns > 21) {
            this.codeColumns = 29;
            this.codeRows = 32;
        } else {
            this.codeColumns = 16;
            this.codeRows = 58;
        }
        return 928;
    }

    protected static int maxPossibleErrorLevel(int remain) {
        int level = 8;
        int size = 512;
        while (level > 0) {
            if (remain >= size) {
                return level;
            }
            --level;
            size >>= 1;
        }
        return 0;
    }

    private static int getTextTypeAndValue(byte[] input, int maxLength, int idx) {
        if (idx >= maxLength) {
            return 0;
        }
        char c = (char)(input[idx] & 0xFF);
        if (c >= 'A' && c <= 'Z') {
            return 65536 + c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return 131072 + c - 97;
        }
        if (c == ' ') {
            return 458778;
        }
        int ms = "0123456789&\r\t,:#-.$/+%*=^".indexOf(c);
        int ps = ";<>@[\\]_`~!\r\t,:\n-.$/\"|*()?{}'".indexOf(c);
        if (ms < 0 && ps < 0) {
            return 0x100000 + c;
        }
        if (ms == ps) {
            return 786432 + ms;
        }
        if (ms >= 0) {
            return 262144 + ms;
        }
        return 524288 + ps;
    }

    protected int getTextTypeAndValue(int maxLength, int idx) {
        return NPDF417AutoError.getTextTypeAndValue(this.text, maxLength, idx);
    }

    private void textCompaction(byte[] input, int start, int length) {
        int size;
        int[] dest = new int[10840];
        int mode = 65536;
        int ptr = 0;
        int fullBytes = 0;
        int v = 0;
        length += start;
        int k = start;
        while (k < length) {
            v = NPDF417AutoError.getTextTypeAndValue(input, length, k);
            if ((v & mode) != 0) {
                dest[ptr++] = v & 0xFF;
            } else if ((v & 0x100000) != 0) {
                if ((ptr & 1) != 0) {
                    dest[ptr++] = 29;
                    mode = (mode & 0x80000) == 0 ? mode : 65536;
                }
                dest[ptr++] = 913;
                dest[ptr++] = v & 0xFF;
                fullBytes += 2;
            } else {
                switch (mode) {
                    default: {
                        break;
                    }
                    case 65536: {
                        if ((v & 0x20000) != 0) {
                            dest[ptr++] = 27;
                            dest[ptr++] = v & 0xFF;
                            mode = 131072;
                            break;
                        }
                        if ((v & 0x40000) != 0) {
                            dest[ptr++] = 28;
                            dest[ptr++] = v & 0xFF;
                            mode = 262144;
                            break;
                        }
                        if ((NPDF417AutoError.getTextTypeAndValue(input, length, k + 1) & NPDF417AutoError.getTextTypeAndValue(input, length, k + 2) & 0x80000) != 0) {
                            dest[ptr++] = 28;
                            dest[ptr++] = 25;
                            dest[ptr++] = v & 0xFF;
                            mode = 524288;
                            break;
                        }
                        dest[ptr++] = 29;
                        dest[ptr++] = v & 0xFF;
                        break;
                    }
                    case 131072: {
                        if ((v & 0x10000) != 0) {
                            if ((NPDF417AutoError.getTextTypeAndValue(input, length, k + 1) & NPDF417AutoError.getTextTypeAndValue(input, length, k + 2) & 0x10000) != 0) {
                                dest[ptr++] = 28;
                                dest[ptr++] = 28;
                                mode = 65536;
                            } else {
                                dest[ptr++] = 27;
                            }
                            dest[ptr++] = v & 0xFF;
                            break;
                        }
                        if ((v & 0x40000) != 0) {
                            dest[ptr++] = 28;
                            dest[ptr++] = v & 0xFF;
                            mode = 262144;
                            break;
                        }
                        if ((NPDF417AutoError.getTextTypeAndValue(input, length, k + 1) & NPDF417AutoError.getTextTypeAndValue(input, length, k + 2) & 0x80000) != 0) {
                            dest[ptr++] = 28;
                            dest[ptr++] = 25;
                            dest[ptr++] = v & 0xFF;
                            mode = 524288;
                            break;
                        }
                        dest[ptr++] = 29;
                        dest[ptr++] = v & 0xFF;
                        break;
                    }
                    case 262144: {
                        if ((v & 0x20000) != 0) {
                            dest[ptr++] = 27;
                            dest[ptr++] = v & 0xFF;
                            mode = 131072;
                            break;
                        }
                        if ((v & 0x10000) != 0) {
                            dest[ptr++] = 28;
                            dest[ptr++] = v & 0xFF;
                            mode = 65536;
                            break;
                        }
                        if ((NPDF417AutoError.getTextTypeAndValue(input, length, k + 1) & NPDF417AutoError.getTextTypeAndValue(input, length, k + 2) & 0x80000) != 0) {
                            dest[ptr++] = 25;
                            dest[ptr++] = v & 0xFF;
                            mode = 524288;
                            break;
                        }
                        dest[ptr++] = 29;
                        dest[ptr++] = v & 0xFF;
                        break;
                    }
                    case 524288: {
                        dest[ptr++] = 29;
                        mode = 65536;
                        --k;
                    }
                }
            }
            ++k;
        }
        if (ptr & true) {
            dest[ptr++] = 29;
        }
        if ((size = (ptr + fullBytes) / 2) + this.cwPtr > 926) {
            throw new IndexOutOfBoundsException();
        }
        length = ptr;
        ptr = 0;
        while (ptr < length) {
            if ((v = dest[ptr++]) >= 30) {
                this.codewords[this.cwPtr++] = v;
                this.codewords[this.cwPtr++] = dest[ptr++];
                continue;
            }
            this.codewords[this.cwPtr++] = v * 30 + dest[ptr++];
        }
    }

    protected void textCompaction(int start, int length) {
        this.textCompaction(this.text, start, length);
    }

    protected static class Segment {
        public char type;
        public int start;
        public int end;

        public Segment(char type, int start, int end) {
            this.type = type;
            this.start = start;
            this.end = end;
        }
    }

    protected static class SegmentList {
        protected ArrayList list = new ArrayList();

        public void add(char type, int start, int end) {
            this.list.add(new Segment(type, start, end));
        }

        public Segment get(int idx) {
            if (idx < 0 || idx >= this.list.size()) {
                return null;
            }
            return (Segment)this.list.get(idx);
        }

        public void remove(int idx) {
            if (idx < 0 || idx >= this.list.size()) {
                return;
            }
            this.list.remove(idx);
        }

        public int size() {
            return this.list.size();
        }

        protected SegmentList() {
        }
    }
}

