/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.common;

import java.util.Arrays;

public class NByteBuffer {
    private static int DEFAULTSIZE = 1024;
    private byte[] buffer;
    private int position = 0;
    private int maxsize;

    public NByteBuffer() {
        this(DEFAULTSIZE);
    }

    public NByteBuffer(int size) {
        this.maxsize = size;
        this.buffer = new byte[size];
    }

    public byte[] getBuffer() {
        if (this.position <= 0) {
            return null;
        }
        byte[] tmpBuf = new byte[this.position];
        System.arraycopy(this.buffer, 0, tmpBuf, 0, this.position);
        return tmpBuf;
    }

    public byte[] getAllBuffer() {
        return this.buffer;
    }

    public boolean setBuffer(byte[] newBuf) {
        if (newBuf == null) {
            return false;
        }
        this.buffer = new byte[newBuf.length];
        System.arraycopy(newBuf, 0, this.buffer, 0, newBuf.length);
        this.position = newBuf.length;
        return true;
    }

    public void clear() {
        Arrays.fill(this.buffer, (byte)0);
        this.position = 0;
    }

    public boolean addBuffer(byte addNum) {
        byte[] addBuf = new byte[]{addNum};
        return this.addBuffer(addBuf);
    }

    public boolean addBuffer(byte[] addBuf) {
        return this.addBuffer(addBuf, addBuf.length);
    }

    public boolean addBuffer(byte[] addBuf, int addSize) {
        if (addBuf == null) {
            return false;
        }
        byte[] tmpBuf = null;
        int nRemain = this.maxsize - this.position;
        if (addSize > addBuf.length) {
            addSize = addBuf.length;
        }
        if (nRemain < addSize) {
            tmpBuf = new byte[this.maxsize];
            System.arraycopy(this.buffer, 0, tmpBuf, 0, this.buffer.length);
            this.maxsize = addSize < DEFAULTSIZE ? (this.maxsize += DEFAULTSIZE) : (this.maxsize += addSize - nRemain);
            this.buffer = new byte[this.maxsize];
            System.arraycopy(tmpBuf, 0, this.buffer, 0, tmpBuf.length);
        }
        System.arraycopy(addBuf, 0, this.buffer, this.position, addSize);
        this.position += addSize;
        return true;
    }
}

