/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.common;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Environment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import npi.sdk.common.NExDataArray;
import npi.sdk.common.NLogWriter;
import npi.sdk.data.NInt;
import npi.sdk.data.NString;

public class NCommon {
    public static final String SDKVERSION = "1.1.0.0 / 2014.02.14";
    public static final String TAGNAME = "NPISDK";
    private static final String DEFAULT_DATE_PATTERN = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final int[] EXTEND_DATA_SIZE;
    public static final int N_ERR_OTHER = -999;
    public static final int USB_PMS_NONE = 0;
    public static final int USB_PMS_OK = 1;
    public static final int USB_PMS_NG = -1;
    public static final int USB_CONNSUCCESS = 0;
    public static final int USB_RETRY = 1;
    public static final int USB_NORETRY = 2;
    public static final String USB_PERMISSION_STR = "npi.sdk.usb.USB_PERMISSION";
    public static final String SPP_UUIDSTRING = "00001101-0000-1000-8000-00805F9B34FB";
    public static final UUID SPP_UUID;
    public static final int BLTH_CONNSUCCESS = 0;
    public static final int BLTH_RETRY = 1;
    public static final int BLTH_NORETRY = 2;
    public static final String LOGNAME = "/npi/log/SDKLog";
    public static final String LOGINF = "/npi/NLogInf";
    public static final String LOGSECTION = "LOGSETTING";
    public static final String LOGOUTPUT_VALUE = "OUTPUT";
    public static final String LOGSIZE_VALUE = "SIZE";
    public static final String LOGOUTPUT_DEFAULT = "1,2";
    public static final int LOGSIZE_DEFAULT = 1000000;
    public static final int LOG_TYPE_ERROR = 1;
    public static final int LOG_TYPE_WARN = 2;
    public static final int LOG_TYPE_FUNC = 3;
    public static final int LOG_TYPE_DATAIN = 4;
    public static final int LOG_TYPE_DATAOUT = 5;
    public static final String LOG_STR_ERROR = "[ERR]";
    public static final String LOG_STR_WARN = "[WRN]";
    public static final String LOG_STR_FUNC = "[FNC]";
    public static final String LOG_STR_DATAIN = "[I N]";
    public static final String LOG_STR_DATAOUT = "[OUT]";
    public static final byte IMG_RASTER_LINE = 0;
    public static final byte IMG_RASTER_BLOCK = 1;
    public static final byte IMG_RASTER_GRADATION = 2;
    public static final byte IMG_BITIMG = 16;
    public static final int COLOR_SIZE = 140;
    public static final String CHARSETINF = "/npi/NCharSetInf";
    public static final String BARCODEINF = "/npi/NBarcodeInf";
    public static final String BARCODEFOLDER = "/npi/image/";
    public static final int HRI_NONE = 0;
    public static final int HRI_TOP_FONTA = 1;
    public static final int HRI_BTM_FONTA = 2;
    public static final int HRI_BOTH_FONTA = 3;
    public static final int HRI_TOP_FONTB = 4;
    public static final int HRI_BTM_FONTB = 5;
    public static final int HRI_BOTH_FONTB = 6;
    public static final int FONT_A = 24;
    public static final int FONT_B = 17;
    public static final int FONT_C = 16;
    public static final String[] BCDFONTARRAY_1D;
    public static final String[] BCDFONTARRAY_2D;
    public static final int TYPE_UPCA = 0;
    public static final int TYPE_UPCE = 1;
    public static final int TYPE_EAN13 = 2;
    public static final int TYPE_EAN8 = 3;
    public static final int TYPE_CODE39 = 4;
    public static final int TYPE_ITF = 5;
    public static final int TYPE_CODABAR = 6;
    public static final int TYPE_CODE128 = 7;
    public static final int TYPE_CODE93 = 8;
    public static final int TYPE_QRCCODEMODEL2 = 0;
    public static final int TYPE_PDF417 = 1;
    public static final int ERR_QRMODEL2_L = 0;
    public static final int ERR_QRMODEL2_M = 1;
    public static final int ERR_QRMODEL2_Q = 2;
    public static final int ERR_QRMODEL2_H = 3;
    public static final int ERR_PDF417_AUTO = -1;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    public static final int BIT_A = 0;
    public static final int BIT_B = 1;
    public static final int BIT_C = 2;
    public static final int BIT_D = 3;
    public static final int VENDOR_ID = 4177;
    public static final int TYPE_SERIAL = 0;
    public static final int TYPE_USB = 1;
    public static final int TYPE_BLUETOOTH = 2;
    public static final String PRTINF = "/npi/NPrinterInf";
    public static final int AUTOOPEN_DISABLE = 0;
    public static final int AUTOOPEN_ENABLE = 1;
    public static final int AUTOOPEN_GETFLG = 2;
    public static final int EXTEND_NONE = 0;
    public static final int EXTEND_FOUNDTYPE = 1;
    public static final int EXTEND_PUTVALUE = 2;
    public static final int RECVBUFF_FLOW = 0;
    public static final int RECVBUFF_NONFLOW = 1;
    public static final int RECVBUFF_SETTING = 2;
    public static final int RECVBUFF_DEFAULTSIZE = 15000;
    public static final int FWFERRCHECK_OFF = 0;
    public static final int FWFERRCHECK_ON = 1;
    public static final String[] RENAMEPRINTER_CHECK;

    static {
        int[] nArray = new int[32];
        nArray[1] = 4;
        nArray[2] = 32;
        nArray[3] = 8;
        nArray[4] = 8;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 4;
        nArray[8] = 4;
        nArray[9] = 16;
        nArray[10] = 16;
        nArray[11] = 64;
        nArray[12] = 32;
        nArray[13] = 32;
        nArray[14] = 32;
        nArray[15] = 16;
        nArray[16] = 16;
        nArray[17] = 16;
        nArray[18] = 16;
        nArray[19] = 8;
        nArray[20] = 8;
        nArray[21] = 8;
        nArray[22] = 8;
        nArray[23] = 8;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 4;
        nArray[27] = 4;
        nArray[28] = 2;
        nArray[29] = 2;
        nArray[30] = 2;
        nArray[31] = 2;
        EXTEND_DATA_SIZE = nArray;
        SPP_UUID = UUID.fromString(SPP_UUIDSTRING);
        BCDFONTARRAY_1D = new String[]{"Barcode1", "Barcode2", "Barcode3", "Barcode4", "Barcode5", "Barcode6", "Barcode7", "Barcode8", "Barcode9", "Barcode10"};
        BCDFONTARRAY_2D = new String[]{"2D-Barcode1", "2D-Barcode2", "2D-Barcode3", "2D-Barcode4", "2D-Barcode5"};
        RENAMEPRINTER_CHECK = new String[]{"[", "]", "\\", "/", ":", "?", "*", "\"", "<", ">", "|", "'", ",", ".", " "};
    }

    public static boolean sleep(long millsec) {
        try {
            Thread.sleep(millsec);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static String getStoragePath() {
        return Environment.getExternalStorageDirectory().toString();
    }

    public static Bitmap ImageRotate(Bitmap bmpBefore, int iDegree) {
        if (bmpBefore == null || iDegree < 0 || iDegree > 360) {
            return null;
        }
        Matrix matrixObj = new Matrix();
        matrixObj.setRotate((float)iDegree);
        return Bitmap.createBitmap((Bitmap)bmpBefore, (int)0, (int)0, (int)bmpBefore.getWidth(), (int)bmpBefore.getHeight(), (Matrix)matrixObj, (boolean)false);
    }

    public static String stackTraceToStr(Exception e) {
        String retStr;
        StringWriter stringWriter;
        block10: {
            stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            retStr = stringWriter.toString();
            try {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                printWriter = null;
                throw throwable;
            }
            printWriter = null;
        }
        try {
            try {
                stringWriter.close();
            }
            catch (Exception exception) {
                stringWriter = null;
            }
        }
        finally {
            stringWriter = null;
        }
        return retStr;
    }

    public static String dumpString(String message, byte[] dumpData, int writeSize) {
        if (writeSize > dumpData.length) {
            writeSize = dumpData.length;
        }
        StringBuilder strObj = new StringBuilder("*** DumpLog[" + message + "] ***\r\n");
        strObj.append("+0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F\r\n");
        strObj.append("------------------------------------------------\r\n");
        StringBuilder dumpStr = new StringBuilder();
        int index = 0;
        while (index < writeSize) {
            dumpStr.append(NCommon.byteToHexString(dumpData[index])).append(" ");
            if (index % 16 == 15) {
                strObj.append(dumpStr.toString());
                strObj.append("\r\n");
                dumpStr = new StringBuilder();
            }
            ++index;
        }
        if (!dumpStr.equals("")) {
            strObj.append(dumpStr.toString());
            strObj.append("\r\n");
        }
        return strObj.toString();
    }

    private static String byteToHexString(byte value) {
        String retStr = Integer.toHexString(value).toUpperCase();
        int length = retStr.getBytes().length;
        if (length == 2) {
            return retStr;
        }
        if (length == 1) {
            return "0" + retStr;
        }
        return retStr.substring(length - 2, length);
    }

    public static int HexEChk(int i_bcnt, byte i_high, byte[] o_rawData, NInt o_size) {
        if (i_bcnt == 1) {
            if (o_rawData != null) {
                o_rawData[o_size.getValue()] = NCommon.StrToHex((byte)48, i_high);
            }
            o_size.plusCount(1);
        }
        return 0;
    }

    public static byte StrToHex(byte i_high, byte i_low) {
        byte[] dat = new byte[]{i_high, i_low};
        int cnth = 0;
        while (cnth < 2) {
            if (dat[cnth] >= 97 && dat[cnth] <= 102) {
                dat[cnth] = (byte)(dat[cnth] - 32);
            }
            dat[cnth] = (byte)(dat[cnth] - 48);
            if (dat[cnth] > 9) {
                dat[cnth] = (byte)(dat[cnth] - 7);
            }
            ++cnth;
        }
        byte odat = (byte)((dat[0] << 4) + dat[1]);
        return odat;
    }

    public static void BuffToHex(byte[] ioBuf) {
        int index = 0;
        while (index < ioBuf.length) {
            if (ioBuf[index] >= 0 && ioBuf[index] <= 9) {
                int n = index;
                ioBuf[n] = (byte)(ioBuf[n] + 48);
            } else if (ioBuf[index] >= 0) {
                byte cfr_ignored_0 = ioBuf[index];
            }
            ++index;
        }
    }

    public static int PasData(byte[] i_rawrb, int i_size, NInt io_ReadCnt, byte[] o_rawData, NInt o_size, NLogWriter NLog) {
        BufferedInputStream fis = null;
        StringBuilder objPasData = new StringBuilder();
        byte cr = i_rawrb[io_ReadCnt.getValue()];
        io_ReadCnt.plusCount(1);
        while (cr != 62) {
            objPasData.append((char)cr);
            cr = i_rawrb[io_ReadCnt.getValue()];
            io_ReadCnt.plusCount(1);
            if (io_ReadCnt.getValue() <= i_size) continue;
            return -90;
        }
        int avail = 0;
        int readSize = 0;
        int index = 0;
        int sizeCount = 0;
        try {
            try {
                fis = new BufferedInputStream(new FileInputStream(new File(objPasData.toString())));
                while ((avail = fis.available()) > 0) {
                    byte[] buf = new byte[avail];
                    readSize = fis.read(buf);
                    if (o_rawData != null) {
                        int n = 0;
                        while (n < readSize) {
                            o_rawData[index] = buf[n];
                            ++index;
                            ++n;
                        }
                    }
                    sizeCount += readSize;
                }
                o_size.plusCount(sizeCount);
            }
            catch (Exception e) {
                NLog.error(e);
                try {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {
                        fis = null;
                    }
                }
                finally {
                    fis = null;
                }
                return -10;
            }
        }
        finally {
            block25: {
                try {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {
                        fis = null;
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    fis = null;
                    throw throwable;
                }
                fis = null;
            }
        }
        return 0;
    }

    public static int CommentData(byte[] i_rawrb, int i_size, NInt io_ReadCnt, byte[] o_rawData, NInt o_size) {
        byte cr = i_rawrb[io_ReadCnt.getValue()];
        io_ReadCnt.plusCount(1);
        while (cr != 10) {
            cr = i_rawrb[io_ReadCnt.getValue()];
            io_ReadCnt.plusCount(1);
            if (io_ReadCnt.getValue() < i_size) continue;
        }
        return 0;
    }

    public static int AnalysisRecvData(byte[] recvBuf, NExDataArray exInfArray, NLogWriter NLog, String deviceName) {
        int prtStatus = 255;
        int nSize = 0;
        byte[] tmpData = null;
        int nCounter = 0;
        int nInfoType = 0;
        int nAnalysisType = 0;
        int index = 0;
        while (index < recvBuf.length) {
            switch (nAnalysisType) {
                case 0: {
                    if ((recvBuf[index] & 0xFF) == 255) {
                        nAnalysisType = 1;
                        break;
                    }
                    prtStatus = recvBuf[index] & 0xFF;
                    break;
                }
                case 1: {
                    if (recvBuf[index] < 1 || recvBuf[index] > 31) {
                        NLog.warn("extend info type error:" + recvBuf[index], deviceName);
                        nAnalysisType = 0;
                        break;
                    }
                    nInfoType = recvBuf[index];
                    nSize = EXTEND_DATA_SIZE[nInfoType];
                    tmpData = new byte[nSize];
                    Arrays.fill(tmpData, (byte)0);
                    nAnalysisType = 2;
                    nCounter = 0;
                    break;
                }
                case 2: {
                    tmpData[nCounter] = recvBuf[index];
                    ++nCounter;
                    if ((nInfoType == 2 || nInfoType == 11 || nInfoType == 12) && recvBuf[index] == 0) {
                        nAnalysisType = 0;
                    } else if (nCounter >= nSize) {
                        nAnalysisType = 0;
                    }
                    if (nAnalysisType != 0) break;
                    exInfArray.setData(nInfoType, tmpData, System.currentTimeMillis());
                    nSize = 0;
                    tmpData = null;
                    nInfoType = 0;
                    break;
                }
            }
            ++index;
        }
        return prtStatus;
    }

    /*
     * Exception decompiling
     */
    public static int getPrinterInf(String i_prt, NString o_ports) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getDateString(long dateNum) {
        return new SimpleDateFormat(DEFAULT_DATE_PATTERN).format(new Date(dateNum));
    }
}

