/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import java.util.Arrays;
import npi.sdk.common.NCommon;
import npi.sdk.common.NLogWriter;
import npi.sdk.device.usb.NUsb;

public class NUsbRecvThread
extends Thread {
    private NLogWriter NLog;
    private String printerName;
    private Object recvLockObj;
    private boolean flgLoop;
    private boolean flgThreadEnd;
    private NUsb usbObj;

    public NUsbRecvThread(NUsb usbObj) {
        this.usbObj = usbObj;
        this.NLog = usbObj.getLogObj();
        this.recvLockObj = usbObj.getLockObj();
        this.flgLoop = true;
        this.flgThreadEnd = false;
        this.printerName = usbObj.getPrinterName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int nSize = 0;
        byte[] buffer = null;
        int prtStatus = 255;
        boolean flgRetryConnect = false;
        UsbDeviceConnection connObj = this.usbObj.getConnection();
        UsbEndpoint inObj = this.usbObj.getEndPointIn();
        this.NLog.func("USB recv thread start Thread Id:" + this.getId(), this.printerName);
        if (connObj == null) {
            this.NLog.error("Connection is null...", this.printerName);
            return;
        }
        buffer = new byte[inObj.getMaxPacketSize()];
        while (this.flgLoop) {
            if (flgRetryConnect) {
                switch (this.usbObj.reconnect()) {
                    case 0: {
                        this.NLog.warn("USB reconnect OK:" + this.printerName + " ThreadID:" + this.getId());
                        flgRetryConnect = false;
                        connObj = this.usbObj.getConnection();
                        inObj = this.usbObj.getEndPointIn();
                        this.usbObj.setOpenFlg(0);
                        this.usbObj.setFlgRetry(false);
                        break;
                    }
                    case 1: {
                        NCommon.sleep(100L);
                        break;
                    }
                    default: {
                        this.usbObj.setFlgSendStop(true);
                        this.flgLoop = false;
                        this.usbObj.setOpenFlg(-2);
                        this.usbObj.setFlgRetry(false);
                    }
                }
                if (flgRetryConnect) continue;
            }
            Object object = this.recvLockObj;
            synchronized (object) {
                try {
                    nSize = connObj.bulkTransfer(inObj, buffer, buffer.length, inObj.getInterval());
                }
                catch (Exception e) {
                    this.NLog.error("USB recv error :" + e.getMessage());
                    nSize = 0;
                }
            }
            if (nSize > 0) {
                this.usbObj.setOnline(true);
                prtStatus = NCommon.AnalysisRecvData(Arrays.copyOfRange(buffer, 0, nSize), this.usbObj.getUSBExtendArray(), this.NLog, this.printerName);
                this.NLog.write("USB recv data size=" + nSize, Arrays.copyOfRange(buffer, 0, nSize), 4);
                Arrays.fill(buffer, (byte)0);
                this.usbObj.setCheckedRecv(true);
                this.usbObj.setPrinterStatus(prtStatus);
            } else {
                this.NLog.error("Offline detection! recv size:" + nSize, this.printerName);
                this.usbObj.setOnline(false);
                prtStatus = 255;
                this.usbObj.close(false);
                flgRetryConnect = true;
                this.usbObj.setFlgRetry(true);
            }
            NCommon.sleep(50L);
        }
        this.flgThreadEnd = true;
        this.NLog.func("USB recv thread end... Thread Id:" + this.getId());
    }

    public boolean stopThread() {
        if (this.flgThreadEnd) {
            return true;
        }
        this.flgLoop = false;
        return false;
    }

    protected void finalize() {
    }
}

