/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.barcode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Environment;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import npi.sdk.barcode.NBcdCommon;
import npi.sdk.barcode.zxing.pdf417.Dimensions;
import npi.sdk.barcode.zxing.pdf417.PDF417Writer;
import npi.sdk.common.NBarcodeData;
import npi.sdk.common.NCommon;
import npi.sdk.common.NLogWriter;
import npi.sdk.data.NByte;
import npi.sdk.data.NInt;

public class NBarcodeConvert {
    private final String ENCORD_NAME = "ISO-8859-1";
    private NLogWriter NLog;
    private int mErrorFlg;

    public NBarcodeConvert(NLogWriter NLog) {
        this.NLog = NLog;
    }

    public int convert1DBarcode(String i_fontName, NBarcodeData bData, Bitmap i_bmp, int i_x, int i_y, int i_width, int i_height, byte[] i_dat, int i_size) {
        int wsize = 0;
        byte[] odat = null;
        byte[] HRIData = null;
        int widthTimes = bData.getWidth();
        int heightTimes = bData.getHeight();
        if (bData.getHexMode() == 1) {
            i_dat = this.convertHexMode(i_dat);
        }
        switch (bData.getType()) {
            case 0: {
                wsize = this.convertUPC_A(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertUPC_A(i_dat, i_size, odat);
                break;
            }
            case 1: {
                wsize = this.convertUPC_E(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertUPC_E(i_dat, i_size, odat);
                break;
            }
            case 2: {
                wsize = this.convertJAN_13(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertJAN_13(i_dat, i_size, odat);
                break;
            }
            case 3: {
                wsize = this.convertJAN_8(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertJAN_8(i_dat, i_size, odat);
                break;
            }
            case 4: {
                wsize = this.convertCODE39(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertCODE39(i_dat, i_size, odat);
                break;
            }
            case 5: {
                wsize = this.convertITF(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertITF(i_dat, i_size, odat);
                break;
            }
            case 6: {
                wsize = this.convertCODABAR(i_dat, i_size, null, bData.getStartbit(), bData.getStopbit());
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertCODABAR(i_dat, i_size, odat, bData.getStartbit(), bData.getStopbit());
                break;
            }
            case 7: {
                wsize = this.convertCODE128_EP(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertCODE128_EP(i_dat, i_size, odat);
                break;
            }
            case 8: {
                wsize = this.convertCODE93(i_dat, i_size, null);
                if (wsize <= 0) break;
                odat = new byte[wsize];
                this.convertCODE93(i_dat, i_size, odat);
                break;
            }
            default: {
                this.NLog.warn("Fontname : " + i_fontName + " 01 DATA Error[1]");
                return -90;
            }
        }
        if (odat == null || odat.length == 0) {
            this.NLog.warn("Fontname : " + i_fontName + " 01 DATA Error[2]");
            return -162;
        }
        if (bData.getHRI() != 0) {
            switch (bData.getType()) {
                case 0: {
                    wsize = this.fncGetDataUPCA(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataUPCA(i_dat, i_size, HRIData);
                    break;
                }
                case 1: {
                    wsize = this.fncGetDataUPCE(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataUPCE(i_dat, i_size, HRIData);
                    break;
                }
                case 2: {
                    wsize = this.fncGetDataJAN13(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataJAN13(i_dat, i_size, HRIData);
                    break;
                }
                case 3: {
                    wsize = this.fncGetDataJAN8(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataJAN8(i_dat, i_size, HRIData);
                    break;
                }
                case 4: {
                    wsize = this.fncGetDataCODE39(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataCODE39(i_dat, i_size, HRIData);
                    break;
                }
                case 5: {
                    wsize = this.fncGetDataITF(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataITF(i_dat, i_size, HRIData);
                    break;
                }
                case 6: {
                    wsize = this.fncGetDataCODABAR(i_dat, i_size, null, bData.getStartbit(), bData.getStopbit());
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    wsize = this.fncGetDataCODABAR(i_dat, i_size, HRIData, bData.getStartbit(), bData.getStopbit());
                    break;
                }
                case 7: {
                    wsize = this.fncGetDataCODE128_EP(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataCODE128_EP(i_dat, i_size, HRIData);
                    break;
                }
                case 8: {
                    wsize = this.fncGetDataCODE93(i_dat, i_size, null);
                    if (wsize <= 0) break;
                    HRIData = new byte[wsize];
                    this.fncGetDataCODE93(i_dat, i_size, HRIData);
                    break;
                }
                default: {
                    this.NLog.warn("Fontname : " + i_fontName + " HRI Error");
                    return -90;
                }
            }
        }
        Bitmap objBitmap = Bitmap.createBitmap((int)i_width, (int)i_height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        objBitmap.eraseColor(-1);
        Canvas tmpCanvas = new Canvas(objBitmap);
        Bitmap objBcdBitmap = this.create1DBcdBitmap(bData, i_width, odat, HRIData, widthTimes, heightTimes);
        int nDegree = 0;
        if (bData.getRotate() != 0) {
            switch (bData.getRotate()) {
                case 1: {
                    nDegree = 90;
                    break;
                }
                case 2: {
                    nDegree = 180;
                    break;
                }
                case 3: {
                    nDegree = 270;
                    break;
                }
            }
            objBcdBitmap = NCommon.ImageRotate(objBcdBitmap, nDegree);
        }
        tmpCanvas.drawBitmap(objBcdBitmap, 0.0f, 0.0f, null);
        Canvas mCanvas = new Canvas(i_bmp);
        mCanvas.drawBitmap(objBitmap, (float)i_x, (float)i_y, null);
        if (bData.getFileName() != null && !bData.getFileName().equals("")) {
            try {
                FileOutputStream fos = new FileOutputStream(Environment.getExternalStorageDirectory() + "/npi/image/" + bData.getFileName());
                i_bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            }
            catch (FileNotFoundException e) {
                this.NLog.error(e);
                return -161;
            }
        }
        return 0;
    }

    private Bitmap create1DBcdBitmap(NBarcodeData bData, int i_width, byte[] odat, byte[] HRIData, int widthTimes, int heightTimes) {
        Bitmap objHRIBitmap = null;
        Bitmap objBcdBitmap = null;
        int nmsBcdHeight = 0;
        int tmpCanvasHeight = 0;
        int x = 0;
        if (bData.getHRI() != 0 && HRIData != null) {
            objHRIBitmap = this.createHRIBitmap(bData, i_width, odat, HRIData, widthTimes);
        }
        objBcdBitmap = Bitmap.createBitmap((int)(odat.length * widthTimes), (int)heightTimes, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        objBcdBitmap.eraseColor(-1);
        nmsBcdHeight += heightTimes;
        int y = 0;
        while (y < heightTimes) {
            x = 0;
            int n = 0;
            while (n < odat.length) {
                int rgbNum = odat[n] == 49 ? -16777216 : -1;
                int m = 0;
                while (m < widthTimes) {
                    objBcdBitmap.setPixel(x, y, rgbNum);
                    ++x;
                    ++m;
                }
                ++n;
            }
            ++y;
        }
        switch (bData.getHRI()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                nmsBcdHeight += objHRIBitmap.getHeight();
                break;
            }
            case 3: 
            case 6: {
                nmsBcdHeight += objHRIBitmap.getHeight() * 2;
                break;
            }
        }
        Bitmap objRetBitmap = Bitmap.createBitmap((int)(odat.length * widthTimes), (int)nmsBcdHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas tmpCanvas = new Canvas(objRetBitmap);
        if ((bData.getHRI() == 1 || bData.getHRI() == 4 || bData.getHRI() == 3 || bData.getHRI() == 6) && objHRIBitmap != null) {
            tmpCanvas.drawBitmap(objHRIBitmap, 0.0f, (float)tmpCanvasHeight, null);
            tmpCanvasHeight += objHRIBitmap.getHeight();
        }
        tmpCanvas.drawBitmap(objBcdBitmap, 0.0f, (float)tmpCanvasHeight, null);
        tmpCanvasHeight += objBcdBitmap.getHeight();
        if ((bData.getHRI() == 2 || bData.getHRI() == 5 || bData.getHRI() == 3 || bData.getHRI() == 6) && objHRIBitmap != null) {
            tmpCanvas.drawBitmap(objHRIBitmap, 0.0f, (float)tmpCanvasHeight, null);
            tmpCanvasHeight += objHRIBitmap.getHeight();
        }
        return objRetBitmap;
    }

    private byte[] convertHexMode(byte[] i_dat) {
        int nCount = 0;
        byte highVal = 0;
        byte lowVal = 0;
        boolean bHighSet = true;
        int size = i_dat.length / 2 + i_dat.length % 2;
        byte[] hexBuf = new byte[size];
        int index = 0;
        while (index < i_dat.length) {
            if (bHighSet) {
                highVal = i_dat[index];
                bHighSet = false;
            } else {
                lowVal = i_dat[index];
                hexBuf[nCount] = NCommon.StrToHex(highVal, lowVal);
                ++nCount;
                bHighSet = true;
            }
            ++index;
        }
        if (!bHighSet) {
            lowVal = 0;
            hexBuf[nCount] = NCommon.StrToHex(highVal, lowVal);
        }
        return hexBuf;
    }

    public int convert2DBarcode(String i_fontName, NBarcodeData bData, Bitmap i_bmp, int i_x, int i_y, int i_width, int i_height, byte[] i_dat, int i_size) {
        NInt numRet = new NInt();
        Bitmap objBitmap = null;
        Bitmap bcdBitmap = null;
        if (bData.getHexMode() == 1) {
            i_dat = this.convertHexMode(i_dat);
        }
        String data = new String(i_dat);
        switch (bData.getType()) {
            case 0: {
                bcdBitmap = this.createQRCodeImage(numRet, data, bData);
                break;
            }
            case 1: {
                bcdBitmap = this.createPDF417Image(numRet, data, bData);
                break;
            }
        }
        if (bcdBitmap == null || numRet.getValue() != 0) {
            return -162;
        }
        int nDegree = 0;
        if (bData.getRotate() != 0) {
            switch (bData.getRotate()) {
                case 1: {
                    nDegree = 90;
                    break;
                }
                case 2: {
                    nDegree = 180;
                    break;
                }
                case 3: {
                    nDegree = 270;
                    break;
                }
            }
            bcdBitmap = NCommon.ImageRotate(bcdBitmap, nDegree);
        }
        objBitmap = Bitmap.createBitmap((int)i_width, (int)i_height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        objBitmap.eraseColor(-1);
        Canvas mCanvas1 = new Canvas(objBitmap);
        mCanvas1.drawBitmap(bcdBitmap, 0.0f, 0.0f, null);
        Canvas mCanvas2 = new Canvas(i_bmp);
        mCanvas2.drawBitmap(objBitmap, (float)i_x, (float)i_y, null);
        if (bData.getFileName() != null && !bData.getFileName().equals("")) {
            try {
                this.bitmapToImage(bData.getFileName(), i_bmp);
            }
            catch (Exception e) {
                this.NLog.error(e);
                return -161;
            }
        }
        return 0;
    }

    private Bitmap createHRIBitmap(NBarcodeData bData, int i_width, byte[] odat, byte[] HRIData, int widthTimes) {
        Rect rect = null;
        Canvas cv = null;
        int HRISize = 0;
        int mojiWidth = 0;
        int fmHeight = 0;
        int nRemainSpace = 0;
        int nBaseSpace = 0;
        int nStartSpace = 0;
        int nSpace = 0;
        Bitmap bmpHRI = null;
        switch (bData.getHRI()) {
            case 1: 
            case 2: 
            case 3: {
                HRISize = 24;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                HRISize = 17;
                break;
            }
            default: {
                return null;
            }
        }
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-16777216);
        paint.setTextSize((float)HRISize);
        paint.setTypeface(Typeface.MONOSPACE);
        rect = new Rect();
        int nmsHRIWidth = odat.length * widthTimes;
        int HRIBuflen = 0;
        int n = 0;
        while (n < HRIData.length) {
            if (HRIData[n] == 0) break;
            ++HRIBuflen;
            ++n;
        }
        String strHRI = new String(HRIData, 0, HRIBuflen);
        HRIBuflen = strHRI.length();
        int index = 0;
        while (index < strHRI.length()) {
            String addStr = strHRI.substring(index, index + 1);
            paint.getTextBounds(addStr, 0, addStr.length(), rect);
            Paint.FontMetrics fm = paint.getFontMetrics();
            if (index == 0) {
                mojiWidth = (int)paint.measureText(addStr);
                fmHeight = (int)Math.abs(fm.top);
                nRemainSpace = nmsHRIWidth - mojiWidth * HRIBuflen;
                nBaseSpace = nRemainSpace / (HRIBuflen + 1);
                nStartSpace = (nRemainSpace - (HRIBuflen - 1) * nBaseSpace) / 2;
                bmpHRI = Bitmap.createBitmap((int)nmsHRIWidth, (int)fmHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                cv = new Canvas(bmpHRI);
                cv.drawColor(-1);
                nSpace = nStartSpace;
            }
            cv.drawText(addStr, (float)nSpace, Math.abs(fm.ascent), paint);
            nSpace += nBaseSpace + mojiWidth;
            ++index;
        }
        return bmpHRI;
    }

    private Bitmap createQRCodeImage(NInt nRet, String iData, NBarcodeData bData) {
        Bitmap bitmapObj = null;
        BitMatrix tmpData = null;
        BitMatrix bitData = null;
        ErrorCorrectionLevel errObj = null;
        switch (bData.getError()) {
            case 0: {
                errObj = ErrorCorrectionLevel.L;
                break;
            }
            case 1: {
                errObj = ErrorCorrectionLevel.M;
                break;
            }
            case 2: {
                errObj = ErrorCorrectionLevel.Q;
                break;
            }
            case 3: {
                errObj = ErrorCorrectionLevel.H;
                break;
            }
            default: {
                this.NLog.error("QR CODE err level :" + bData);
                nRet.setValue(-160);
                return null;
            }
        }
        QRCodeWriter writer = new QRCodeWriter();
        HashMap<EncodeHintType, Object> encodeHint = new HashMap<EncodeHintType, Object>();
        encodeHint.put(EncodeHintType.ERROR_CORRECTION, errObj);
        encodeHint.put(EncodeHintType.CHARACTER_SET, "shift_jis");
        try {
            tmpData = writer.encode(iData, BarcodeFormat.QR_CODE, 1, 1, encodeHint);
            int nWidth = tmpData.getWidth() * bData.getSize();
            int nHeight = tmpData.getHeight() * bData.getSize();
            bitData = writer.encode(iData, BarcodeFormat.QR_CODE, nWidth, nHeight, encodeHint);
            bitmapObj = this.setBarcodePixels(bitData);
        }
        catch (Exception e) {
            this.NLog.error(e);
            nRet.setValue(-161);
            return null;
        }
        nRet.setValue(0);
        return bitmapObj;
    }

    private Bitmap createPDF417Image(NInt nRet, String iData, NBarcodeData bData) {
        Bitmap bitmapObj = null;
        BitMatrix bitData = null;
        PDF417Writer writer = new PDF417Writer(bData.getError());
        HashMap<EncodeHintType, Object> encodeHint = new HashMap<EncodeHintType, Object>();
        encodeHint.put(EncodeHintType.CHARACTER_SET, "shift_jis");
        Dimensions dimensions = new Dimensions(2, 30, 2, 30);
        encodeHint.put(EncodeHintType.PDF417_DIMENSIONS, dimensions);
        encodeHint.put(EncodeHintType.PDF417_COMPACT, false);
        try {
            bitData = writer.encode(iData, BarcodeFormat.PDF_417, 1, 1, encodeHint);
            int nWidth = bitData.getWidth();
            int nHeight = bitData.getHeight();
            bitmapObj = this.setPDF417BarcodePixels(bitData);
            bitmapObj = this.resize(bitmapObj, bitmapObj.getWidth() * bData.getSize() / 2, bitmapObj.getHeight() * bData.getHeight());
        }
        catch (Exception e) {
            this.NLog.error(e);
            nRet.setValue(-161);
            return null;
        }
        nRet.setValue(0);
        return bitmapObj;
    }

    private Bitmap PDF417Resize(Bitmap bitmapObj, int rWidth, int rHeight) {
        int width = bitmapObj.getWidth();
        int height = bitmapObj.getHeight();
        int[] resizePixels = new int[width * rWidth * (height * rHeight)];
        return null;
    }

    private Bitmap setPDF417BarcodePixels(BitMatrix bitData) {
        int index = 0;
        int width = bitData.getWidth();
        int height = bitData.getHeight();
        boolean bBlack = false;
        int[] tmpPixels = new int[width * height];
        int[] tmpWidthBuff = new int[width];
        int nBlackStart = 0;
        int nBlackEnd = 0;
        int widthCount = 0;
        int nWidth = 0;
        int nHeight = 0;
        int y = 0;
        while (y < height) {
            Arrays.fill(tmpWidthBuff, 0);
            nBlackStart = 0;
            nBlackEnd = 0;
            widthCount = 0;
            int x = 0;
            while (x < width) {
                if (bitData.get(x, y)) {
                    tmpWidthBuff[widthCount] = -16777216;
                    if (nBlackStart == 0) {
                        nBlackStart = widthCount;
                    }
                    nBlackEnd = widthCount;
                } else {
                    tmpWidthBuff[widthCount] = -1;
                }
                ++widthCount;
                ++x;
            }
            if (nBlackStart != 0) {
                System.arraycopy(tmpWidthBuff, nBlackStart, tmpPixels, index, nBlackEnd - nBlackStart + 1);
                index += nBlackEnd - nBlackStart + 1;
                if (nWidth == 0) {
                    nWidth = nBlackEnd - nBlackStart + 1;
                }
                ++nHeight;
            }
            ++y;
        }
        int[] pixels = new int[index];
        System.arraycopy(tmpPixels, 0, pixels, 0, index);
        Bitmap bcdBmpObj = Bitmap.createBitmap((int)nWidth, (int)nHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bcdBmpObj.setPixels(pixels, 0, nWidth, 0, 0, nWidth, nHeight);
        return bcdBmpObj;
    }

    private boolean bitmapToImage(String fileName, Bitmap bmpObj) throws Exception {
        FileOutputStream fos = new FileOutputStream(Environment.getExternalStorageDirectory() + "/npi/image/" + fileName);
        return bmpObj.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
    }

    private Bitmap resize(Bitmap objBitmap, float resizeWidth, float resizeHeight) {
        Bitmap resizeBitmap = Bitmap.createScaledBitmap((Bitmap)objBitmap, (int)((int)resizeWidth), (int)((int)resizeHeight), (boolean)false);
        return resizeBitmap;
    }

    private Bitmap setBarcodePixels(BitMatrix bitData) {
        int width = bitData.getWidth();
        int height = bitData.getHeight();
        int[] pixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int offset = y * width;
            int x = 0;
            while (x < width) {
                pixels[offset + x] = bitData.get(x, y) ? -16777216 : -1;
                ++x;
            }
            ++y;
        }
        Bitmap bcdBmpObj = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bcdBmpObj.setPixels(pixels, 0, width, 0, 0, width, height);
        return bcdBmpObj;
    }

    public int convertUPC_A(byte[] i_data, int i_size, byte[] o_data) {
        byte[] Adata = new byte[13];
        StringBuilder data = new StringBuilder();
        if (i_size != 11 && i_size != 12) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        i = 0;
        int chk_dgt = 0;
        while (i != 11) {
            chk_dgt = (i + 1) % 2 == 0 ? (chk_dgt += (i_data[i] - 48) * 1) : (chk_dgt += (i_data[i] - 48) * 3);
            ++i;
        }
        if ((chk_dgt %= 10) == 0) {
            chk_dgt = 10;
        }
        chk_dgt = 10 - chk_dgt;
        String dgt = Integer.toString(chk_dgt);
        Arrays.fill(Adata, (byte)0);
        System.arraycopy(i_data, 0, Adata, 0, 11);
        Adata[11] = (byte)(chk_dgt + 48);
        data.append("101");
        int Asize = 3;
        i = 0;
        while (i <= 5) {
            data.append(this.BinaryCode_JANUPC(Adata, i, "O"));
            Asize += this.BinaryCode_JANUPC(Adata, i, "O").length();
            ++i;
        }
        data.append("01010");
        Asize += 5;
        i = 6;
        while (i <= 11) {
            data.append(this.BinaryCode_JANUPC(Adata, i, ""));
            Asize += this.BinaryCode_JANUPC(Adata, i, "").length();
            ++i;
        }
        data.append("101");
        Asize += 3;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, Asize);
        }
        this.mErrorFlg = 0;
        return Asize;
    }

    public int convertUPC_E(byte[] i_data, int i_size, byte[] o_data) {
        byte[] Edata = new byte[13];
        StringBuilder data = new StringBuilder();
        NByte one_data = new NByte();
        if (i_size != 11 && i_size != 12) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        if (i_data[0] != 48) {
            this.mErrorFlg = -2;
            return 0;
        }
        String code_data = this.CharacterSelect_UPCE(i_data, one_data);
        if (code_data == "") {
            this.mErrorFlg = -2;
            return 0;
        }
        Arrays.fill(Edata, (byte)0);
        System.arraycopy(i_data, 0, Edata, 0, 11);
        Edata[11] = one_data.getValue();
        i = 0;
        int chk_dgt = 0;
        while (i != 11) {
            chk_dgt = (i + 1) % 2 == 0 ? (chk_dgt += (Edata[i] - 48) * 1) : (chk_dgt += (Edata[i] - 48) * 3);
            ++i;
        }
        if ((chk_dgt %= 10) == 0) {
            chk_dgt = 10;
        }
        chk_dgt = 10 - chk_dgt;
        String dgt = Integer.toString(chk_dgt);
        String pari_data = this.ParityOE(dgt.getBytes(), "UPC-E");
        data.append("101");
        int Esize = 3;
        while (!code_data.equals("")) {
            data.append(this.BinaryCode_JANUPC(Edata, Integer.parseInt(code_data.substring(0, 1)) + 1, pari_data.substring(0, 1)));
            Esize += 7;
            code_data = code_data.substring(1, code_data.length());
            pari_data = pari_data.substring(1, pari_data.length());
        }
        data.append(this.BinaryCode_JANUPC(Edata, 11, pari_data.substring(0, 1)));
        Esize += 7;
        data.append("010101");
        Esize += 6;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, Esize);
        }
        this.mErrorFlg = 0;
        return Esize;
    }

    public int convertJAN_13(byte[] i_data, int i_size, byte[] o_data) {
        byte[] Jdata = new byte[14];
        StringBuilder data = new StringBuilder();
        if (i_size != 12 && i_size != 13) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        i = 0;
        int chk_dgt = 0;
        while (i != 12) {
            chk_dgt = (i + 1) % 2 == 0 ? (chk_dgt += (i_data[i] - 48) * 3) : (chk_dgt += (i_data[i] - 48) * 1);
            ++i;
        }
        if ((chk_dgt %= 10) == 0) {
            chk_dgt = 10;
        }
        chk_dgt = 10 - chk_dgt;
        Arrays.fill(Jdata, (byte)0);
        System.arraycopy(i_data, 0, Jdata, 0, 12);
        Jdata[12] = (byte)(chk_dgt + 48);
        String pari_data = this.ParityOE(Jdata, "JAN");
        data.append("101");
        int Jsize = 3;
        i = 1;
        while (i <= 6) {
            data.append(this.BinaryCode_JANUPC(Jdata, i, pari_data.substring(i - 1, i)));
            Jsize += 7;
            ++i;
        }
        data.append("01010");
        Jsize += 5;
        i = 7;
        while (i <= 12) {
            data.append(this.BinaryCode_JANUPC(Jdata, i, ""));
            Jsize += 7;
            ++i;
        }
        data.append("101");
        Jsize += 3;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, Jsize);
        }
        this.mErrorFlg = 0;
        return Jsize;
    }

    public int convertJAN_8(byte[] i_data, int i_size, byte[] o_data) {
        byte[] Jdata = new byte[9];
        StringBuilder data = new StringBuilder();
        if (i_size != 7 && i_size != 8) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        i = 0;
        int chk_dgt = 0;
        while (i != 7) {
            chk_dgt = (i + 1) % 2 == 0 ? (chk_dgt += (i_data[i] - 48) * 1) : (chk_dgt += (i_data[i] - 48) * 3);
            ++i;
        }
        if ((chk_dgt %= 10) == 0) {
            chk_dgt = 10;
        }
        chk_dgt = 10 - chk_dgt;
        String dgt = Integer.toString(chk_dgt);
        Arrays.fill(Jdata, (byte)0);
        System.arraycopy(i_data, 0, Jdata, 0, 7);
        Jdata[7] = (byte)(chk_dgt + 48);
        data.append("101");
        int Jsize = 3;
        i = 0;
        while (i <= 3) {
            data.append(this.BinaryCode_JANUPC(Jdata, i, "O"));
            Jsize += 7;
            ++i;
        }
        data.append("01010");
        Jsize += 5;
        i = 4;
        while (i <= 7) {
            data.append(this.BinaryCode_JANUPC(Jdata, i, ""));
            Jsize += 7;
            ++i;
        }
        data.append("101");
        Jsize += 3;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, Jsize);
        }
        this.mErrorFlg = 0;
        return Jsize;
    }

    public int convertCODE39(byte[] i_data, int i_size, byte[] o_data) {
        int dwSize;
        byte[] pdat;
        StringBuilder data = new StringBuilder();
        if (i_size <= 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        i = i_data.length;
        if (i != i_size) {
            this.mErrorFlg = -1;
            return 0;
        }
        if (i_data[0] == 42 || i_data[i_size - 1] == 42) {
            pdat = new byte[i_size - 1];
            Arrays.fill(pdat, (byte)0);
            System.arraycopy(i_data, 1, pdat, 0, i_size - 2);
            dwSize = i_size - 2;
        } else {
            pdat = new byte[i_size + 1];
            Arrays.fill(pdat, (byte)0);
            System.arraycopy(i_data, 0, pdat, 0, i_size);
            dwSize = i_size;
        }
        i = 0;
        while (i < dwSize) {
            if (!(pdat[i] >= 48 && pdat[i] <= 57 || pdat[i] >= 65 && pdat[i] <= 90 || pdat[i] == 45 || pdat[i] == 46 || pdat[i] == 32 || pdat[i] == 36 || pdat[i] == 47 || pdat[i] == 43 || pdat[i] == 37)) {
                this.mErrorFlg = -2;
                pdat = null;
                return 0;
            }
            ++i;
        }
        data.append(this.BinaryCode_39("*".getBytes(), 0));
        data.append("0");
        int size39 = 13;
        i = 0;
        while (i < dwSize) {
            data.append(this.BinaryCode_39(pdat, i));
            data.append("0");
            size39 += 13;
            ++i;
        }
        data.append(this.BinaryCode_39("*".getBytes(), 0));
        size39 += 12;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, size39);
        }
        this.mErrorFlg = 0;
        pdat = null;
        return size39;
    }

    public int convertITF(byte[] i_data, int i_size, byte[] o_data) {
        StringBuilder data = new StringBuilder();
        if (i_size % 2 != 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        i = i_data.length;
        if (i % 2 != 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int cnt = i_size;
        if (i != cnt) {
            this.mErrorFlg = -1;
            return 0;
        }
        i = 0;
        while (i < cnt) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        data.append("1010");
        int Isize = 4;
        i = 0;
        while (i < cnt) {
            String data1 = this.BinaryCode_ITF(i_data, i, true);
            String data0 = this.BinaryCode_ITF(i_data, i + 1, false);
            int c = 1;
            while (c <= 4) {
                data.append(data1.substring(0, data1.indexOf(".")));
                data1 = data1.substring(data1.indexOf(".") + 1, data1.length());
                data.append(data0.substring(0, data0.indexOf(".")));
                data0 = data0.substring(data0.indexOf(".") + 1, data0.length());
                ++c;
            }
            data.append(data1).append(data0);
            Isize += 14;
            i += 2;
        }
        data.append("1101");
        Isize += 4;
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, Isize);
        }
        this.mErrorFlg = 0;
        return Isize;
    }

    public int convertCODABAR(byte[] i_data, int i_size, byte[] o_data, int i_start, int i_stop) {
        byte[] startBitBuf = new byte[1];
        byte[] stopBitBuf = new byte[1];
        startBitBuf[0] = this.convertStartStopBit(i_start);
        stopBitBuf[0] = this.convertStartStopBit(i_stop);
        return this.convertNW_7(i_data, i_size, o_data, startBitBuf, stopBitBuf);
    }

    public int convertNW_7(byte[] i_data, int i_size, byte[] o_data, byte[] i_start, byte[] i_stop) {
        StringBuilder data = new StringBuilder();
        if (i_start[0] < 65 || i_start[0] > 68 || i_stop[0] < 65 || i_stop[0] > 68) {
            this.mErrorFlg = -2;
            return 0;
        }
        int i = 0;
        i = i_data.length;
        int cnt = i_size;
        if (i != cnt) {
            this.mErrorFlg = -1;
            return 0;
        }
        i = 0;
        while (i < cnt) {
            if ((i_data[i] < 48 || i_data[i] > 57) && i_data[i] != 45 && i_data[i] != 36 && i_data[i] != 58 && i_data[i] != 47 && i_data[i] != 46 && i_data[i] != 43) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        data.append(this.BinaryCode_NW7(i_start, 0));
        data.append("0");
        int nw_size = this.BinaryCode_NW7(i_start, 0).getBytes().length + 1;
        i = 0;
        while (i < cnt) {
            data.append(this.BinaryCode_NW7(i_data, i)).append("0");
            nw_size += this.BinaryCode_NW7(i_data, i).length() + 1;
            ++i;
        }
        data.append(this.BinaryCode_NW7(i_stop, 0));
        nw_size += this.BinaryCode_NW7(i_stop, 0).getBytes().length;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, nw_size);
        }
        this.mErrorFlg = 0;
        return nw_size;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convertCODE128_EP(byte[] i_data, int i_size, byte[] o_data) {
        int checksum = 0;
        int checksumml = 1;
        StringBuilder o_dataRet = new StringBuilder();
        if (i_size == 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        if (o_data == null) {
            this.mErrorFlg = 0;
        } else {
            Arrays.fill(o_data, (byte)0);
        }
        if (i_data[0] != 123) {
            this.mErrorFlg = -2;
            return 0;
        }
        if (i_data[1] != 65 && i_data[1] != 66 && i_data[1] != 67) {
            this.mErrorFlg = -2;
            return 0;
        }
        int now_CS = i_data[1];
        Object dat = null;
        switch (now_CS) {
            case 65: {
                o_dataRet.append(NBcdCommon.c128barpattern[103]);
                checksum += 103;
                break;
            }
            case 66: {
                o_dataRet.append(NBcdCommon.c128barpattern[104]);
                checksum += 104;
                break;
            }
            case 67: {
                o_dataRet.append(NBcdCommon.c128barpattern[105]);
                checksum += 105;
                break;
            }
        }
        int posi = 2;
        while (posi < i_size) {
            block31: {
                block32: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                switch (now_CS) {
                                                    case 65: {
                                                        if (i_data[posi] < 95 || i_data[posi] == 123) break;
                                                        this.mErrorFlg = -2;
                                                        return 0;
                                                    }
                                                    case 66: {
                                                        if (i_data[posi] >= 32 && i_data[posi] <= 127) break;
                                                        this.mErrorFlg = -2;
                                                        return 0;
                                                    }
                                                    case 67: {
                                                        if (i_data[posi] <= 99 || i_data[posi] == 123) break;
                                                        this.mErrorFlg = -2;
                                                        return 0;
                                                    }
                                                }
                                                if (i_data[posi] != 123) break block32;
                                                if (i_data[++posi] != 65) break block33;
                                                o_dataRet.append(NBcdCommon.c128barpattern[101]);
                                                checksum += 101 * checksumml++;
                                                now_CS = 65;
                                                break block31;
                                            }
                                            if (i_data[posi] != 66) break block34;
                                            o_dataRet.append(NBcdCommon.c128barpattern[100]);
                                            checksum += 100 * checksumml++;
                                            now_CS = 66;
                                            break block31;
                                        }
                                        if (i_data[posi] != 67) break block35;
                                        o_dataRet.append(NBcdCommon.c128barpattern[99]);
                                        checksum += 99 * checksumml++;
                                        now_CS = 67;
                                        break block31;
                                    }
                                    if (i_data[posi] != 83) break block36;
                                    if (now_CS == 67) {
                                        this.mErrorFlg = -2;
                                        return 0;
                                    }
                                    o_dataRet.append(NBcdCommon.c128barpattern[98]);
                                    checksum += 98 * checksumml++;
                                    break block31;
                                }
                                if (i_data[posi] != 49) break block37;
                                o_dataRet.append(NBcdCommon.c128barpattern[102]);
                                checksum += 102 * checksumml++;
                                break block31;
                            }
                            if (i_data[posi] != 50) break block38;
                            if (now_CS == 67) {
                                this.mErrorFlg = -2;
                                return 0;
                            }
                            o_dataRet.append(NBcdCommon.c128barpattern[97]);
                            checksum += 97 * checksumml++;
                            break block31;
                        }
                        if (i_data[posi] != 51) break block39;
                        if (now_CS == 67) {
                            this.mErrorFlg = -2;
                            return 0;
                        }
                        o_dataRet.append(NBcdCommon.c128barpattern[96]);
                        checksum += 96 * checksumml++;
                        break block31;
                    }
                    if (i_data[posi] == 52) {
                        if (now_CS == 65) {
                            o_dataRet.append(NBcdCommon.c128barpattern[101]);
                            checksum += 101 * checksumml++;
                            break block31;
                        } else {
                            if (now_CS != 66) {
                                this.mErrorFlg = -2;
                                return 0;
                            }
                            o_dataRet.append(NBcdCommon.c128barpattern[101]);
                            checksum += 100 * checksumml++;
                        }
                        break block31;
                    } else if (i_data[posi] == 123 && now_CS == 66) {
                        o_dataRet.append(NBcdCommon.c128barpattern[91]);
                        checksum += 91 * checksumml++;
                        break block31;
                    } else {
                        this.mErrorFlg = -2;
                        return 0;
                    }
                }
                if (now_CS == 67) {
                    o_dataRet.append(NBcdCommon.c128barpattern[i_data[posi]]);
                    checksum += i_data[posi] * checksumml++;
                } else {
                    int bpno = 0;
                    while (bpno < 96) {
                        char wk = now_CS == 65 ? (char)NBcdCommon.C128_HRI_A[bpno] : (char)NBcdCommon.C128_HRI_B[bpno];
                        if (wk == i_data[posi]) break;
                        ++bpno;
                    }
                    if (bpno == 96) {
                        this.mErrorFlg = -2;
                        return 0;
                    }
                    o_dataRet.append(NBcdCommon.c128barpattern[bpno]);
                    checksum += bpno * checksumml++;
                }
            }
            ++posi;
        }
        o_dataRet.append(NBcdCommon.c128barpattern[checksum % 103]);
        o_dataRet.append(NBcdCommon.c128barpattern[106]);
        if (o_data != null) {
            System.arraycopy(o_dataRet.toString().getBytes(), 0, o_data, 0, o_dataRet.toString().getBytes().length);
            return o_data.length;
        }
        return o_dataRet.toString().getBytes().length;
    }

    public int convertCODE128(byte[] i_data, int i_size, byte[] i_code, byte[] o_data) {
        NInt chk_cnt = new NInt();
        StringBuilder data = new StringBuilder();
        byte[] chk_data = new byte[1];
        byte[] code = new byte[i_size + 1];
        Arrays.fill(code, (byte)0);
        if (i_code == null) {
            this.CODE128_SET(i_data, i_size, code);
        } else {
            System.arraycopy(i_code, 0, code, 0, i_size);
        }
        int i = i_size;
        int cnt = 0;
        while (code[cnt] != 0) {
            if (code[cnt] < 65 || code[cnt] > 67) {
                this.mErrorFlg = -3;
                return 0;
            }
            ++cnt;
        }
        if (i != cnt) {
            this.mErrorFlg = -1;
            return 0;
        }
        i = 0;
        while (i < cnt) {
            if (code[i] == 65 && i_data[i] > 95) {
                this.mErrorFlg = -2;
                return 0;
            }
            if (code[i] == 66 && (i_data[i] < 32 || i_data[i] > 127)) {
                this.mErrorFlg = -2;
                return 0;
            }
            if (code[i] == 67 && i_data[i] >= 100) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        int size128 = 0;
        int dgt = 0;
        i = 0;
        while (i < cnt) {
            data.append(this.BinaryCode_CODE128(i_data, code, i, chk_cnt, true, true));
            size128 += this.BinaryCode_CODE128(i_data, code, i, null, true, true).length();
            dgt += chk_cnt.getValue();
            ++i;
        }
        chk_data[0] = (byte)(dgt %= 103);
        byte[] chkdgt = "C".getBytes();
        data.append(this.BinaryCode_CODE128(chk_data, chkdgt, 0, null, true, false));
        size128 += this.BinaryCode_CODE128(chk_data, chkdgt, 0, null, false, false).length();
        data.append("1100011101011");
        size128 += 13;
        if (o_data != null) {
            System.arraycopy(data.toString().getBytes(), 0, o_data, 0, size128);
        }
        this.mErrorFlg = 0;
        return size128;
    }

    public int convertCODE93(byte[] i_data, int i_size, byte[] o_data) {
        StringBuilder partial = new StringBuilder();
        int checksum_len = 0;
        int c_checksum = 0;
        int k_checksum = 0;
        if (i_size == 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int wksize = 0;
        int i = 0;
        while (i < i_size) {
            if (i_data[i] > 127) {
                this.mErrorFlg = -1;
                return 0;
            }
            if (i_data[i] < 32) {
                ++wksize;
            }
            if (i_data[i] > 32 && i_data[i] < 36) {
                ++wksize;
            }
            if (i_data[i] > 37 && i_data[i] < 43) {
                ++wksize;
            }
            if (i_data[i] == 44) {
                ++wksize;
            }
            if (i_data[i] > 90) {
                ++wksize;
            }
            ++wksize;
            ++i;
        }
        if (o_data == null) {
            this.mErrorFlg = 0;
            return 9 + wksize * 9 + 18 + 10 + 1;
        }
        int[] checksum_str = new int[(i_size + 3) * 2];
        partial.append(NBcdCommon.barpattern[47]);
        int index = 0;
        i = 0;
        while (i < i_size) {
            int code;
            if (i_data[i] != 0) {
                index = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(i_data[i]);
            }
            if (i_data[i] == 0 || index == 0) {
                switch ("%$$$$$$$$$$$$$$$$$$$$$$$$$$%%%%% ///  ///// /             /%%%%%%                          %%%%%%++++++++++++++++++++++++++%%%%%".getBytes()[i_data[i]]) {
                    case 36: {
                        code = 43;
                        break;
                    }
                    case 37: {
                        code = 44;
                        break;
                    }
                    case 47: {
                        code = 45;
                        break;
                    }
                    case 43: {
                        code = 46;
                        break;
                    }
                    default: {
                        code = 0;
                    }
                }
                partial.append(NBcdCommon.barpattern[code]);
                checksum_str[checksum_len++] = code;
                code = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf("UABCDEFGHIJKLMNOPQRSTUVWXYZABCDE ABC  FGHIJ L             ZFGHIJV                          KLMNOWABCDEFGHIJLKMNOPQRSTUVWXYZPQRST".getBytes()[i_data[i]]);
                partial.append(NBcdCommon.barpattern[code]);
                checksum_str[checksum_len++] = code;
            } else {
                code = index;
                partial.append(NBcdCommon.barpattern[code]);
                checksum_str[checksum_len++] = code;
            }
            ++i;
        }
        c_checksum = 0;
        k_checksum = 0;
        i = 1;
        while (i <= checksum_len) {
            c_checksum += i * checksum_str[checksum_len - i];
            k_checksum += (i + 1) * checksum_str[checksum_len - i];
            ++i;
        }
        k_checksum += (c_checksum %= 47);
        partial.append(NBcdCommon.barpattern[c_checksum]);
        partial.append(NBcdCommon.barpattern[k_checksum %= 47]);
        partial.append(NBcdCommon.barpattern[47]);
        partial.append("1");
        System.arraycopy(partial.toString().getBytes(), 0, o_data, 0, partial.toString().getBytes().length);
        return 9 + wksize * 9 + 18 + 10 + 1;
    }

    public int fncGetDataUPCA(byte[] i_data, int i_size, byte[] o_data) {
        byte[] dat = new byte[13];
        if (i_size != 11 && i_size != 12) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        i = 0;
        int chkdgt = 0;
        while (i != 11) {
            chkdgt = (i + 1) % 2 == 0 ? (chkdgt += (i_data[i] - 48) * 1) : (chkdgt += (i_data[i] - 48) * 3);
            ++i;
        }
        if ((chkdgt %= 10) == 0) {
            chkdgt = 10;
        }
        chkdgt = 10 - chkdgt;
        Arrays.fill(dat, (byte)0);
        System.arraycopy(i_data, 0, dat, 0, 11);
        dat[11] = (byte)(chkdgt + 48);
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(dat, 0, o_data, 0, 12);
        }
        this.mErrorFlg = 0;
        return 13;
    }

    public int fncGetDataUPCE(byte[] i_data, int i_size, byte[] o_data) {
        byte[] dat = new byte[8];
        byte[] sData = new byte[13];
        NByte one_data = new NByte();
        if (i_size != 11 && i_size != 12) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        if (i_data[0] != 48) {
            this.mErrorFlg = -2;
            return 0;
        }
        String code_data = this.CharacterSelect_UPCE(i_data, one_data);
        if (code_data == "") {
            this.mErrorFlg = -2;
            return 0;
        }
        Arrays.fill(sData, (byte)0);
        System.arraycopy(i_data, 0, sData, 0, 11);
        sData[11] = one_data.getValue();
        i = 0;
        int chkdgt = 0;
        while (i != 11) {
            chkdgt = (i + 1) % 2 == 0 ? (chkdgt += (sData[i] - 48) * 1) : (chkdgt += (sData[i] - 48) * 3);
            ++i;
        }
        if ((chkdgt %= 10) == 0) {
            chkdgt = 10;
        }
        chkdgt = 10 - chkdgt;
        Arrays.fill(dat, (byte)0);
        dat[0] = sData[code_data.getBytes()[0] - 48 + 1];
        dat[1] = sData[code_data.getBytes()[1] - 48 + 1];
        dat[2] = sData[code_data.getBytes()[2] - 48 + 1];
        dat[3] = sData[code_data.getBytes()[3] - 48 + 1];
        dat[4] = sData[code_data.getBytes()[4] - 48 + 1];
        dat[5] = one_data.getValue();
        dat[6] = 0;
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(dat, 0, o_data, 0, 7);
        }
        this.mErrorFlg = 0;
        return 7;
    }

    public int fncGetDataJAN13(byte[] i_data, int i_size, byte[] o_data) {
        byte[] dat = new byte[14];
        if (i_size != 12 && i_size != 13) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        i = 0;
        int chkdgt = 0;
        while (i != 12) {
            chkdgt = (i + 1) % 2 == 0 ? (chkdgt += (i_data[i] - 48) * 3) : (chkdgt += (i_data[i] - 48) * 1);
            ++i;
        }
        if ((chkdgt %= 10) == 0) {
            chkdgt = 10;
        }
        chkdgt = 10 - chkdgt;
        Arrays.fill(dat, (byte)0);
        System.arraycopy(i_data, 0, dat, 0, 12);
        dat[12] = (byte)(chkdgt + 48);
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(dat, 0, o_data, 0, 13);
        }
        this.mErrorFlg = 0;
        return 14;
    }

    public int fncGetDataJAN8(byte[] i_data, int i_size, byte[] o_data) {
        byte[] dat = new byte[9];
        if (i_size != 7 && i_size != 8) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        i = 0;
        int chkdgt = 0;
        while (i != 7) {
            chkdgt = (i + 1) % 2 == 0 ? (chkdgt += (i_data[i] - 48) * 1) : (chkdgt += (i_data[i] - 48) * 3);
            ++i;
        }
        if ((chkdgt %= 10) == 0) {
            chkdgt = 10;
        }
        chkdgt = 10 - chkdgt;
        Arrays.fill(dat, (byte)0);
        System.arraycopy(i_data, 0, dat, 0, 7);
        dat[7] = (byte)(chkdgt + 48);
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(dat, 0, o_data, 0, 8);
        }
        this.mErrorFlg = 0;
        return 9;
    }

    public int fncGetDataCODE39(byte[] i_data, int i_size, byte[] o_data) {
        boolean flg = true;
        if (i_size <= 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (!(i_data[i] >= 48 && i_data[i] <= 57 || i_data[i] >= 65 && i_data[i] <= 90 || i_data[i] == 45 || i_data[i] == 46 || i_data[i] == 32 || i_data[i] == 36 || i_data[i] == 47 || i_data[i] == 43 || i_data[i] == 37)) {
                if (i_data[i] == 42 && i == 0 || i == i_size - 1) {
                    flg = false;
                } else {
                    this.mErrorFlg = -2;
                    return 0;
                }
            }
            ++i;
        }
        byte[] pdat = new byte[i_size + 3];
        if (flg) {
            pdat[0] = 42;
            System.arraycopy(i_data, 0, pdat, 1, i_size);
        } else {
            System.arraycopy(i_data, 0, pdat, 0, i_size);
        }
        if (flg) {
            pdat[i_size + 1] = 42;
        }
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(pdat, 0, o_data, 0, i_size + 2);
        }
        this.mErrorFlg = 0;
        return i_size + 3;
    }

    public int fncGetDataITF(byte[] i_data, int i_size, byte[] o_data) {
        if (i_size == 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        if (i_size % 2 != 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 48 || i_data[i] > 57) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(i_data, 0, o_data, 0, i_size);
        }
        this.mErrorFlg = 0;
        return i_size + 1;
    }

    public int fncGetDataCODABAR(byte[] i_data, int i_size, byte[] o_data, int i_start, int i_stop) {
        byte[] startBitBuf = new byte[1];
        byte[] stopBitBuf = new byte[1];
        startBitBuf[0] = this.convertStartStopBit(i_start);
        stopBitBuf[0] = this.convertStartStopBit(i_stop);
        return this.fncGetDataNW7(i_data, i_size, o_data, startBitBuf, stopBitBuf);
    }

    private byte convertStartStopBit(int i_start) {
        byte ret = 0;
        switch (i_start) {
            case 0: {
                ret = 65;
                break;
            }
            case 1: {
                ret = 66;
                break;
            }
            case 2: {
                ret = 67;
                break;
            }
            case 3: {
                ret = 68;
                break;
            }
            default: {
                ret = 65;
            }
        }
        return ret;
    }

    public int fncGetDataNW7(byte[] i_data, int i_size, byte[] o_data, byte[] i_start, byte[] i_stop) {
        byte[] pdat = null;
        if (i_start[0] < 65 || i_start[0] > 68 || i_stop[0] < 65 || i_stop[0] > 68) {
            this.mErrorFlg = -2;
            return 0;
        }
        if (i_size == 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        int i = 0;
        while (i < i_size) {
            if ((i_data[i] < 48 || i_data[i] > 57) && i_data[i] != 45 && i_data[i] != 36 && i_data[i] != 58 && i_data[i] != 47 && i_data[i] != 46 && i_data[i] != 43) {
                this.mErrorFlg = -2;
                return 0;
            }
            ++i;
        }
        pdat = new byte[i_size + 3];
        Arrays.fill(pdat, (byte)0);
        pdat[0] = i_start[0];
        System.arraycopy(i_data, 0, pdat, 1, i_size);
        pdat[i_size + 1] = i_stop[0];
        if (o_data != null) {
            Arrays.fill(o_data, (byte)0);
            System.arraycopy(pdat, 0, o_data, 0, i_size + 2);
        }
        this.mErrorFlg = 0;
        return i_size + 2 + 1;
    }

    public int fncGetDataCODE128(byte[] i_data, int i_size, byte[] i_code, byte[] o_data) {
        StringBuilder mHRI = null;
        byte[] code = new byte[i_size + 1];
        Arrays.fill(code, (byte)0);
        if (i_code == null) {
            this.CODE128_SET(i_data, i_size, code);
        } else {
            System.arraycopy(i_code, 0, code, 0, i_size);
        }
        int cnt = 0;
        while (code[cnt] != 0) {
            if (code[cnt] < 65 || code[cnt] > 67) {
                this.mErrorFlg = -3;
                return 0;
            }
            ++cnt;
        }
        if (i_size != cnt) {
            this.mErrorFlg = -1;
            return 0;
        }
        mHRI = new StringBuilder();
        int i = 0;
        while (i < i_size) {
            if (code[i] == 65) {
                if (i_data[i] <= 95) {
                    if (i_data[i] < 32) {
                        mHRI.append("<").append(this.IntToHex(i_data[i], 2)).append(">");
                    } else {
                        mHRI.append((char)i_data[i]);
                    }
                } else {
                    this.mErrorFlg = -2;
                    return 0;
                }
            }
            if (code[i] == 66) {
                if (i_data[i] >= 32 && i_data[i] <= 127) {
                    if (i_data[i] == 127) {
                        mHRI.append("<").append(this.IntToHex(i_data[i], 2)).append(">");
                    } else {
                        mHRI.append((char)i_data[i]);
                    }
                } else {
                    this.mErrorFlg = -2;
                    return 0;
                }
            }
            if (code[i] == 67) {
                if (i_data[i] < 100) {
                    mHRI.append("<").append(this.IntToHex(i_data[i], 2)).append(">");
                } else {
                    this.mErrorFlg = -2;
                    return 0;
                }
            }
            ++i;
        }
        if (o_data != null) {
            System.arraycopy(mHRI.toString().getBytes(), 0, o_data, 0, mHRI.toString().getBytes().length);
        }
        this.mErrorFlg = 0;
        return mHRI.toString().getBytes().length;
    }

    public int fncGetDataCODE93(byte[] i_data, int i_size, byte[] o_data) {
        StringBuilder partial = new StringBuilder();
        byte[] wkdat = new byte[2];
        if (i_size <= 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        if (i_size == 0) {
            return -1;
        }
        wkdat[0] = 0;
        wkdat[1] = 0;
        partial.append("\u25a1");
        int i = 0;
        while (i < i_size) {
            if (i_data[i] < 32 || i_data[i] == 127) {
                partial.append("\u25a0");
                int code = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf("UABCDEFGHIJKLMNOPQRSTUVWXYZABCDE ABC  FGHIJ L             ZFGHIJV                          KLMNOWABCDEFGHIJLKMNOPQRSTUVWXYZPQRST".getBytes()[i_data[i]]);
                wkdat[0] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".getBytes()[code];
                partial.append((char)wkdat[0]);
            } else {
                wkdat[0] = i_data[i];
                partial.append((char)wkdat[0]);
            }
            ++i;
        }
        partial.append("\u25a1");
        byte[] partialBuf = partial.toString().getBytes();
        this.NLog.write("test", partialBuf, 5);
        if (o_data != null) {
            System.arraycopy(partialBuf, 0, o_data, 0, partialBuf.length);
        }
        return partialBuf.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int fncGetDataCODE128_EP(byte[] i_data, int i_size, byte[] o_data) {
        int checksum = 0;
        byte wk = 0;
        byte[] wk2 = new byte[2];
        StringBuilder o_dataRet = new StringBuilder();
        if (i_size == 0) {
            this.mErrorFlg = -1;
            return 0;
        }
        if (o_data != null) {
            o_data[0] = 0;
        }
        if (i_data[0] != 123) {
            this.mErrorFlg = -2;
            return 0;
        }
        if (i_data[1] != 65 && i_data[1] != 66 && i_data[1] != 67) {
            this.mErrorFlg = -2;
            return 0;
        }
        int now_CS = i_data[1];
        int posi = 2;
        while (posi < i_size) {
            block32: {
                block33: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            switch (now_CS) {
                                                case 65: {
                                                    if (i_data[posi] < 95 || i_data[posi] == 123) break;
                                                    this.mErrorFlg = -2;
                                                    return 0;
                                                }
                                                case 66: {
                                                    if (i_data[posi] >= 32 && i_data[posi] <= 127) break;
                                                    this.mErrorFlg = -2;
                                                    return 0;
                                                }
                                                case 67: {
                                                    if (i_data[posi] <= 99 || i_data[posi] == 123) break;
                                                    this.mErrorFlg = -2;
                                                    return 0;
                                                }
                                            }
                                            if (i_data[posi] != 123) break block33;
                                            if (i_data[++posi] != 65) break block34;
                                            now_CS = 65;
                                            break block32;
                                        }
                                        if (i_data[posi] != 66) break block35;
                                        now_CS = 66;
                                        break block32;
                                    }
                                    if (i_data[posi] != 67) break block36;
                                    now_CS = 67;
                                    break block32;
                                }
                                if (i_data[posi] != 83) break block37;
                                if (now_CS == 67) {
                                    this.mErrorFlg = -2;
                                    return 0;
                                }
                                if (o_data != null) {
                                    o_dataRet.append("");
                                }
                                ++checksum;
                                break block32;
                            }
                            if (i_data[posi] == 49) break block32;
                            if (i_data[posi] != 50) break block38;
                            if (now_CS == 67) {
                                this.mErrorFlg = -2;
                                return 0;
                            }
                            break block32;
                        }
                        if (i_data[posi] != 51) break block39;
                        if (now_CS == 67) {
                            this.mErrorFlg = -2;
                            return 0;
                        }
                        break block32;
                    }
                    if (i_data[posi] == 52) {
                        if (now_CS != 65 && now_CS != 66) {
                            this.mErrorFlg = -2;
                            return 0;
                        }
                        break block32;
                    } else if (i_data[posi] == 123 && now_CS == 66) {
                        if (o_data != null) {
                            o_dataRet.append("{");
                        }
                        ++checksum;
                        break block32;
                    } else {
                        this.mErrorFlg = -2;
                        return 0;
                    }
                }
                if (now_CS == 67) {
                    if (i_data[posi] < 10) {
                        if (o_data != null) {
                            o_dataRet.append("0");
                            o_dataRet.append(i_data[posi]);
                        }
                    } else if (o_data != null) {
                        o_dataRet.append(i_data[posi]);
                    }
                    checksum += 2;
                } else {
                    int bpno = 0;
                    while (bpno < 96) {
                        wk = now_CS == 65 ? NBcdCommon.C128_HRI_A[bpno] : NBcdCommon.C128_HRI_B[bpno];
                        if (wk == i_data[posi]) break;
                        ++bpno;
                    }
                    if (bpno == 96) {
                        this.mErrorFlg = -2;
                        return 0;
                    }
                    if (wk < 32 || wk == 127) {
                        o_dataRet.append(" ");
                    } else {
                        wk2[0] = wk;
                        wk2[1] = 0;
                        if (o_data != null) {
                            o_dataRet.append((char)wk);
                        }
                    }
                    ++checksum;
                }
            }
            ++posi;
        }
        if (o_data != null) {
            System.arraycopy(o_dataRet.toString().getBytes(), 0, o_data, 0, o_dataRet.toString().getBytes().length);
        }
        return checksum + 1;
    }

    private String ParityOE(byte[] i_data, String i_name) {
        String pri = null;
        if (i_name == "JAN") {
            pri = i_data[0] == 48 ? "OOOOOO" : (i_data[0] == 49 ? "OOEOEE" : (i_data[0] == 50 ? "OOEEOE" : (i_data[0] == 51 ? "OOEEEO" : (i_data[0] == 52 ? "OEOOEE" : (i_data[0] == 53 ? "OEEOOE" : (i_data[0] == 54 ? "OEEEOO" : (i_data[0] == 55 ? "OEOEOE" : (i_data[0] == 56 ? "OEOEEO" : (i_data[0] == 57 ? "OEEOEO" : "")))))))));
        }
        if (i_name == "UPC-E") {
            pri = i_data[0] == 48 ? "EEEOOO" : (i_data[0] == 49 ? "EEOEOO" : (i_data[0] == 50 ? "EEOOEO" : (i_data[0] == 51 ? "EEOOOE" : (i_data[0] == 52 ? "EOEEOO" : (i_data[0] == 53 ? "EOOEEO" : (i_data[0] == 54 ? "EOOOEE" : (i_data[0] == 55 ? "EOEOEO" : (i_data[0] == 56 ? "EOEOOE" : (i_data[0] == 57 ? "EOOEOE" : "")))))))));
        }
        return pri;
    }

    private String BinaryCode_JANUPC(byte[] i_data, int i_size, String i_pari) {
        String b_data = null;
        this.NLog.error("i_size:" + i_size + "  i_pari:" + i_pari);
        if (i_pari.equals("O")) {
            if (i_data[i_size] == 48) {
                b_data = "0001101";
            } else if (i_data[i_size] == 49) {
                b_data = "0011001";
            } else if (i_data[i_size] == 50) {
                b_data = "0010011";
            } else if (i_data[i_size] == 51) {
                b_data = "0111101";
            } else if (i_data[i_size] == 52) {
                b_data = "0100011";
            } else if (i_data[i_size] == 53) {
                b_data = "0110001";
            } else if (i_data[i_size] == 54) {
                b_data = "0101111";
            } else if (i_data[i_size] == 55) {
                b_data = "0111011";
            } else if (i_data[i_size] == 56) {
                b_data = "0110111";
            } else if (i_data[i_size] == 57) {
                b_data = "0001011";
            }
        } else if (i_pari.equals("E")) {
            if (i_data[i_size] == 48) {
                b_data = "0100111";
            } else if (i_data[i_size] == 49) {
                b_data = "0110011";
            } else if (i_data[i_size] == 50) {
                b_data = "0011011";
            } else if (i_data[i_size] == 51) {
                b_data = "0100001";
            } else if (i_data[i_size] == 52) {
                b_data = "0011101";
            } else if (i_data[i_size] == 53) {
                b_data = "0111001";
            } else if (i_data[i_size] == 54) {
                b_data = "0000101";
            } else if (i_data[i_size] == 55) {
                b_data = "0010001";
            } else if (i_data[i_size] == 56) {
                b_data = "0001001";
            } else if (i_data[i_size] == 57) {
                b_data = "0010111";
            }
        } else if (i_pari.equals("")) {
            if (i_data[i_size] == 48) {
                b_data = "1110010";
            } else if (i_data[i_size] == 49) {
                b_data = "1100110";
            } else if (i_data[i_size] == 50) {
                b_data = "1101100";
            } else if (i_data[i_size] == 51) {
                b_data = "1000010";
            } else if (i_data[i_size] == 52) {
                b_data = "1011100";
            } else if (i_data[i_size] == 53) {
                b_data = "1001110";
            } else if (i_data[i_size] == 54) {
                b_data = "1010000";
            } else if (i_data[i_size] == 55) {
                b_data = "1000100";
            } else if (i_data[i_size] == 56) {
                b_data = "1001000";
            } else if (i_data[i_size] == 57) {
                b_data = "1110100";
            }
        }
        return b_data;
    }

    private String CharacterSelect_UPCE(byte[] i_data, NByte o_cdata) {
        String b_data = "";
        if (i_data[5] >= 49) {
            int i = 6;
            while (i <= 9) {
                if (i_data[i] != 48) {
                    return b_data;
                }
                ++i;
            }
            if (i_data[10] < 53) {
                return b_data;
            }
            b_data = "01234";
            o_cdata.setValue(i_data[10]);
        } else if (i_data[4] >= 49) {
            int i = 5;
            while (i <= 9) {
                if (i_data[i] != 48) {
                    return b_data;
                }
                ++i;
            }
            b_data = "01239";
            o_cdata.setValue((byte)52);
        } else if (i_data[3] >= 51) {
            int i = 4;
            while (i <= 8) {
                if (i_data[i] != 48) {
                    return b_data;
                }
                ++i;
            }
            b_data = "01289";
            o_cdata.setValue((byte)51);
        } else if (i_data[3] == 50) {
            int i = 4;
            while (i <= 7) {
                if (i_data[i] != 48) {
                    return b_data;
                }
                ++i;
            }
            b_data = "01789";
            o_cdata.setValue((byte)50);
        } else if (i_data[3] == 49) {
            int i = 4;
            while (i <= 7) {
                if (i_data[i] != 48) {
                    return b_data;
                }
                ++i;
            }
            b_data = "01789";
            o_cdata.setValue((byte)49);
        } else if (i_data[3] == 48) {
            int i = 4;
            while (i <= 7) {
                if (i_data[i] != 48) {
                    return b_data;
                }
                ++i;
            }
            b_data = "01789";
            o_cdata.setValue((byte)48);
        }
        return b_data;
    }

    private String BinaryCode_39(byte[] i_data, int i_no) {
        String b_data = null;
        if (i_data[i_no] == 48) {
            b_data = "101001101101";
        } else if (i_data[i_no] == 49) {
            b_data = "110100101011";
        } else if (i_data[i_no] == 50) {
            b_data = "101100101011";
        } else if (i_data[i_no] == 51) {
            b_data = "110110010101";
        } else if (i_data[i_no] == 52) {
            b_data = "101001101011";
        } else if (i_data[i_no] == 53) {
            b_data = "110100110101";
        } else if (i_data[i_no] == 54) {
            b_data = "101100110101";
        } else if (i_data[i_no] == 55) {
            b_data = "101001011011";
        } else if (i_data[i_no] == 56) {
            b_data = "110100101101";
        } else if (i_data[i_no] == 57) {
            b_data = "101100101101";
        } else if (i_data[i_no] == 65) {
            b_data = "110101001011";
        } else if (i_data[i_no] == 66) {
            b_data = "101101001011";
        } else if (i_data[i_no] == 67) {
            b_data = "110110100101";
        } else if (i_data[i_no] == 68) {
            b_data = "101011001011";
        } else if (i_data[i_no] == 69) {
            b_data = "110101100101";
        } else if (i_data[i_no] == 70) {
            b_data = "101101100101";
        } else if (i_data[i_no] == 71) {
            b_data = "101010011011";
        } else if (i_data[i_no] == 72) {
            b_data = "110101001101";
        } else if (i_data[i_no] == 73) {
            b_data = "101101001101";
        } else if (i_data[i_no] == 74) {
            b_data = "101011001101";
        } else if (i_data[i_no] == 75) {
            b_data = "110101010011";
        } else if (i_data[i_no] == 76) {
            b_data = "101101010011";
        } else if (i_data[i_no] == 77) {
            b_data = "110110101001";
        } else if (i_data[i_no] == 78) {
            b_data = "101011010011";
        } else if (i_data[i_no] == 79) {
            b_data = "110101101001";
        } else if (i_data[i_no] == 80) {
            b_data = "101101101001";
        } else if (i_data[i_no] == 81) {
            b_data = "101010110011";
        } else if (i_data[i_no] == 82) {
            b_data = "110101011001";
        } else if (i_data[i_no] == 83) {
            b_data = "101101011001";
        } else if (i_data[i_no] == 84) {
            b_data = "101011011001";
        } else if (i_data[i_no] == 85) {
            b_data = "110010101011";
        } else if (i_data[i_no] == 86) {
            b_data = "100110101011";
        } else if (i_data[i_no] == 87) {
            b_data = "110011010101";
        } else if (i_data[i_no] == 88) {
            b_data = "100101101011";
        } else if (i_data[i_no] == 89) {
            b_data = "110010110101";
        } else if (i_data[i_no] == 90) {
            b_data = "100110110101";
        } else if (i_data[i_no] == 45) {
            b_data = "100101011011";
        } else if (i_data[i_no] == 46) {
            b_data = "110010101101";
        } else if (i_data[i_no] == 32) {
            b_data = "100110101101";
        } else if (i_data[i_no] == 36) {
            b_data = "100100100101";
        } else if (i_data[i_no] == 47) {
            b_data = "100100101001";
        } else if (i_data[i_no] == 43) {
            b_data = "100101001001";
        } else if (i_data[i_no] == 37) {
            b_data = "101001001001";
        } else if (i_data[i_no] == 42) {
            b_data = "100101101101";
        }
        return b_data;
    }

    private String BinaryCode_ITF(byte[] i_data, int i_no, boolean i_flg) {
        String b_data = null;
        if (i_flg) {
            if (i_data[i_no] == 48) {
                b_data = "1.1.11.11.1";
            } else if (i_data[i_no] == 49) {
                b_data = "11.1.1.1.11";
            } else if (i_data[i_no] == 50) {
                b_data = "1.11.1.1.11";
            } else if (i_data[i_no] == 51) {
                b_data = "11.11.1.1.1";
            } else if (i_data[i_no] == 52) {
                b_data = "1.1.11.1.11";
            } else if (i_data[i_no] == 53) {
                b_data = "11.1.11.1.1";
            } else if (i_data[i_no] == 54) {
                b_data = "1.11.11.1.1";
            } else if (i_data[i_no] == 55) {
                b_data = "1.1.1.11.11";
            } else if (i_data[i_no] == 56) {
                b_data = "11.1.1.11.1";
            } else if (i_data[i_no] == 57) {
                b_data = "1.11.1.11.1";
            }
        } else if (i_data[i_no] == 48) {
            b_data = "0.0.00.00.0";
        } else if (i_data[i_no] == 49) {
            b_data = "00.0.0.0.00";
        } else if (i_data[i_no] == 50) {
            b_data = "0.00.0.0.00";
        } else if (i_data[i_no] == 51) {
            b_data = "00.00.0.0.0";
        } else if (i_data[i_no] == 52) {
            b_data = "0.0.00.0.00";
        } else if (i_data[i_no] == 53) {
            b_data = "00.0.00.0.0";
        } else if (i_data[i_no] == 54) {
            b_data = "0.00.00.0.0";
        } else if (i_data[i_no] == 55) {
            b_data = "0.0.0.00.00";
        } else if (i_data[i_no] == 56) {
            b_data = "00.0.0.00.0";
        } else if (i_data[i_no] == 57) {
            b_data = "0.00.0.00.0";
        }
        return b_data;
    }

    private String BinaryCode_NW7(byte[] i_data, int i_no) {
        String b_data = null;
        if (i_data[i_no] == 48) {
            b_data = "101010011";
        } else if (i_data[i_no] == 49) {
            b_data = "101011001";
        } else if (i_data[i_no] == 50) {
            b_data = "101001011";
        } else if (i_data[i_no] == 51) {
            b_data = "110010101";
        } else if (i_data[i_no] == 52) {
            b_data = "101101001";
        } else if (i_data[i_no] == 53) {
            b_data = "110101001";
        } else if (i_data[i_no] == 54) {
            b_data = "100101011";
        } else if (i_data[i_no] == 55) {
            b_data = "100101101";
        } else if (i_data[i_no] == 56) {
            b_data = "100110101";
        } else if (i_data[i_no] == 57) {
            b_data = "110100101";
        } else if (i_data[i_no] == 45) {
            b_data = "101001101";
        } else if (i_data[i_no] == 36) {
            b_data = "101100101";
        } else if (i_data[i_no] == 58) {
            b_data = "1101011011";
        } else if (i_data[i_no] == 47) {
            b_data = "1101101011";
        } else if (i_data[i_no] == 46) {
            b_data = "1101101101";
        } else if (i_data[i_no] == 43) {
            b_data = "1011011011";
        } else if (i_data[i_no] == 65) {
            b_data = "1011001001";
        } else if (i_data[i_no] == 66) {
            b_data = "1001001011";
        } else if (i_data[i_no] == 67) {
            b_data = "1010010011";
        } else if (i_data[i_no] == 68) {
            b_data = "1010011001";
        }
        return b_data;
    }

    private String BinaryCode_CODE128(byte[] i_data, byte[] i_code, int i_size, NInt o_chkcnt, boolean i_flg, boolean i_dflg) {
        String data = null;
        int chkcnt = 0;
        int dg_cnt = 1;
        String sdata = "";
        int chk_scnt = 0;
        if (i_dflg && i_size == 0) {
            if (i_code[0] == 65) {
                sdata = "11010000100";
                chk_scnt = 103;
            }
            if (i_code[0] == 66) {
                sdata = "11010010000";
                chk_scnt = 104;
            }
            if (i_code[0] == 67) {
                sdata = "11010011100";
                chk_scnt = 105;
            }
        }
        if (i_size != 0) {
            if (i_code[i_size] == 65) {
                if (i_code[i_size - 1] == 66 || i_code[i_size - 1] == 67) {
                    sdata = "11101011110";
                    chk_scnt = 101;
                }
            } else if (i_code[i_size] == 66) {
                if (i_code[i_size - 1] == 65 || i_code[i_size - 1] == 67) {
                    sdata = "10111101110";
                    chk_scnt = 100;
                }
            } else if (i_code[i_size] == 67 && (i_code[i_size - 1] == 65 || i_code[i_size - 1] == 66)) {
                sdata = "10111011110";
                chk_scnt = 99;
            }
        }
        if (i_data[i_size] == 32 && i_code[i_size] == 65 || i_data[i_size] == 32 && i_code[i_size] == 66 || i_data[i_size] == 0 && i_code[i_size] == 67) {
            data = "11011001100";
            chkcnt = 0;
        } else if (i_data[i_size] == 33 && i_code[i_size] == 65 || i_data[i_size] == 33 && i_code[i_size] == 66 || i_data[i_size] == 1 && i_code[i_size] == 67) {
            data = "11001101100";
            chkcnt = 1;
        } else if (i_data[i_size] == 34 && i_code[i_size] == 65 || i_data[i_size] == 34 && i_code[i_size] == 66 || i_data[i_size] == 2 && i_code[i_size] == 67) {
            data = "11001100110";
            chkcnt = 2;
        } else if (i_data[i_size] == 35 && i_code[i_size] == 65 || i_data[i_size] == 35 && i_code[i_size] == 66 || i_data[i_size] == 3 && i_code[i_size] == 67) {
            data = "10010011000";
            chkcnt = 3;
        } else if (i_data[i_size] == 36 && i_code[i_size] == 65 || i_data[i_size] == 36 && i_code[i_size] == 66 || i_data[i_size] == 4 && i_code[i_size] == 67) {
            data = "10010001100";
            chkcnt = 4;
        } else if (i_data[i_size] == 37 && i_code[i_size] == 65 || i_data[i_size] == 37 && i_code[i_size] == 66 || i_data[i_size] == 5 && i_code[i_size] == 67) {
            data = "10001001100";
            chkcnt = 5;
        } else if (i_data[i_size] == 38 && i_code[i_size] == 65 || i_data[i_size] == 38 && i_code[i_size] == 66 || i_data[i_size] == 6 && i_code[i_size] == 67) {
            data = "10011001000";
            chkcnt = 6;
        } else if (i_data[i_size] == 39 && i_code[i_size] == 65 || i_data[i_size] == 39 && i_code[i_size] == 66 || i_data[i_size] == 7 && i_code[i_size] == 67) {
            data = "10011000100";
            chkcnt = 7;
        } else if (i_data[i_size] == 40 && i_code[i_size] == 65 || i_data[i_size] == 40 && i_code[i_size] == 66 || i_data[i_size] == 8 && i_code[i_size] == 67) {
            data = "10001100100";
            chkcnt = 8;
        } else if (i_data[i_size] == 41 && i_code[i_size] == 65 || i_data[i_size] == 41 && i_code[i_size] == 66 || i_data[i_size] == 9 && i_code[i_size] == 67) {
            data = "11001001000";
            chkcnt = 9;
        } else if (i_data[i_size] == 42 && i_code[i_size] == 65 || i_data[i_size] == 42 && i_code[i_size] == 66 || i_data[i_size] == 10 && i_code[i_size] == 67) {
            data = "11001000100";
            chkcnt = 10;
        } else if (i_data[i_size] == 43 && i_code[i_size] == 65 || i_data[i_size] == 43 && i_code[i_size] == 66 || i_data[i_size] == 11 && i_code[i_size] == 67) {
            data = "11000100100";
            chkcnt = 11;
        } else if (i_data[i_size] == 44 && i_code[i_size] == 65 || i_data[i_size] == 44 && i_code[i_size] == 66 || i_data[i_size] == 12 && i_code[i_size] == 67) {
            data = "10110011100";
            chkcnt = 12;
        } else if (i_data[i_size] == 45 && i_code[i_size] == 65 || i_data[i_size] == 45 && i_code[i_size] == 66 || i_data[i_size] == 13 && i_code[i_size] == 67) {
            data = "10011011100";
            chkcnt = 13;
        } else if (i_data[i_size] == 46 && i_code[i_size] == 65 || i_data[i_size] == 46 && i_code[i_size] == 66 || i_data[i_size] == 14 && i_code[i_size] == 67) {
            data = "10011001110";
            chkcnt = 14;
        } else if (i_data[i_size] == 47 && i_code[i_size] == 65 || i_data[i_size] == 47 && i_code[i_size] == 66 || i_data[i_size] == 15 && i_code[i_size] == 67) {
            data = "10111001100";
            chkcnt = 15;
        } else if (i_data[i_size] == 48 && i_code[i_size] == 65 || i_data[i_size] == 48 && i_code[i_size] == 66 || i_data[i_size] == 16 && i_code[i_size] == 67) {
            data = "10011101100";
            chkcnt = 16;
        } else if (i_data[i_size] == 49 && i_code[i_size] == 65 || i_data[i_size] == 49 && i_code[i_size] == 66 || i_data[i_size] == 17 && i_code[i_size] == 67) {
            data = "10011100110";
            chkcnt = 17;
        } else if (i_data[i_size] == 50 && i_code[i_size] == 65 || i_data[i_size] == 50 && i_code[i_size] == 66 || i_data[i_size] == 18 && i_code[i_size] == 67) {
            data = "11001110010";
            chkcnt = 18;
        } else if (i_data[i_size] == 51 && i_code[i_size] == 65 || i_data[i_size] == 51 && i_code[i_size] == 66 || i_data[i_size] == 19 && i_code[i_size] == 67) {
            data = "11001011100";
            chkcnt = 19;
        } else if (i_data[i_size] == 52 && i_code[i_size] == 65 || i_data[i_size] == 52 && i_code[i_size] == 66 || i_data[i_size] == 20 && i_code[i_size] == 67) {
            data = "11001001110";
            chkcnt = 20;
        } else if (i_data[i_size] == 53 && i_code[i_size] == 65 || i_data[i_size] == 53 && i_code[i_size] == 66 || i_data[i_size] == 21 && i_code[i_size] == 67) {
            data = "11011100100";
            chkcnt = 21;
        } else if (i_data[i_size] == 54 && i_code[i_size] == 65 || i_data[i_size] == 54 && i_code[i_size] == 66 || i_data[i_size] == 22 && i_code[i_size] == 67) {
            data = "11001110100";
            chkcnt = 22;
        } else if (i_data[i_size] == 55 && i_code[i_size] == 65 || i_data[i_size] == 55 && i_code[i_size] == 66 || i_data[i_size] == 23 && i_code[i_size] == 67) {
            data = "11101101110";
            chkcnt = 23;
        } else if (i_data[i_size] == 56 && i_code[i_size] == 65 || i_data[i_size] == 56 && i_code[i_size] == 66 || i_data[i_size] == 24 && i_code[i_size] == 67) {
            data = "11101001100";
            chkcnt = 24;
        } else if (i_data[i_size] == 57 && i_code[i_size] == 65 || i_data[i_size] == 57 && i_code[i_size] == 66 || i_data[i_size] == 25 && i_code[i_size] == 67) {
            data = "11100101100";
            chkcnt = 25;
        } else if (i_data[i_size] == 58 && i_code[i_size] == 65 || i_data[i_size] == 58 && i_code[i_size] == 66 || i_data[i_size] == 26 && i_code[i_size] == 67) {
            data = "11100100110";
            chkcnt = 26;
        } else if (i_data[i_size] == 59 && i_code[i_size] == 65 || i_data[i_size] == 59 && i_code[i_size] == 66 || i_data[i_size] == 27 && i_code[i_size] == 67) {
            data = "11101100100";
            chkcnt = 27;
        } else if (i_data[i_size] == 60 && i_code[i_size] == 65 || i_data[i_size] == 60 && i_code[i_size] == 66 || i_data[i_size] == 28 && i_code[i_size] == 67) {
            data = "11100110100";
            chkcnt = 28;
        } else if (i_data[i_size] == 61 && i_code[i_size] == 65 || i_data[i_size] == 61 && i_code[i_size] == 66 || i_data[i_size] == 29 && i_code[i_size] == 67) {
            data = "11100110010";
            chkcnt = 29;
        } else if (i_data[i_size] == 62 && i_code[i_size] == 65 || i_data[i_size] == 62 && i_code[i_size] == 66 || i_data[i_size] == 30 && i_code[i_size] == 67) {
            data = "11011011000";
            chkcnt = 30;
        } else if (i_data[i_size] == 63 && i_code[i_size] == 65 || i_data[i_size] == 63 && i_code[i_size] == 66 || i_data[i_size] == 31 && i_code[i_size] == 67) {
            data = "11011000110";
            chkcnt = 31;
        } else if (i_data[i_size] == 64 && i_code[i_size] == 65 || i_data[i_size] == 64 && i_code[i_size] == 66 || i_data[i_size] == 32 && i_code[i_size] == 67) {
            data = "11000110110";
            chkcnt = 32;
        } else if (i_data[i_size] == 65 && i_code[i_size] == 65 || i_data[i_size] == 65 && i_code[i_size] == 66 || i_data[i_size] == 33 && i_code[i_size] == 67) {
            data = "10100011000";
            chkcnt = 33;
        } else if (i_data[i_size] == 66 && i_code[i_size] == 65 || i_data[i_size] == 66 && i_code[i_size] == 66 || i_data[i_size] == 34 && i_code[i_size] == 67) {
            data = "10001011000";
            chkcnt = 34;
        } else if (i_data[i_size] == 67 && i_code[i_size] == 65 || i_data[i_size] == 67 && i_code[i_size] == 66 || i_data[i_size] == 35 && i_code[i_size] == 67) {
            data = "10001000110";
            chkcnt = 35;
        } else if (i_data[i_size] == 68 && i_code[i_size] == 65 || i_data[i_size] == 68 && i_code[i_size] == 66 || i_data[i_size] == 36 && i_code[i_size] == 67) {
            data = "10110001000";
            chkcnt = 36;
        } else if (i_data[i_size] == 69 && i_code[i_size] == 65 || i_data[i_size] == 69 && i_code[i_size] == 66 || i_data[i_size] == 37 && i_code[i_size] == 67) {
            data = "10001101000";
            chkcnt = 37;
        } else if (i_data[i_size] == 70 && i_code[i_size] == 65 || i_data[i_size] == 70 && i_code[i_size] == 66 || i_data[i_size] == 38 && i_code[i_size] == 67) {
            data = "10001100010";
            chkcnt = 38;
        } else if (i_data[i_size] == 71 && i_code[i_size] == 65 || i_data[i_size] == 71 && i_code[i_size] == 66 || i_data[i_size] == 39 && i_code[i_size] == 67) {
            data = "11010001000";
            chkcnt = 39;
        } else if (i_data[i_size] == 72 && i_code[i_size] == 65 || i_data[i_size] == 72 && i_code[i_size] == 66 || i_data[i_size] == 40 && i_code[i_size] == 67) {
            data = "11000101000";
            chkcnt = 40;
        } else if (i_data[i_size] == 73 && i_code[i_size] == 65 || i_data[i_size] == 73 && i_code[i_size] == 66 || i_data[i_size] == 41 && i_code[i_size] == 67) {
            data = "11000100010";
            chkcnt = 41;
        } else if (i_data[i_size] == 74 && i_code[i_size] == 65 || i_data[i_size] == 74 && i_code[i_size] == 66 || i_data[i_size] == 42 && i_code[i_size] == 67) {
            data = "10110111000";
            chkcnt = 42;
        } else if (i_data[i_size] == 75 && i_code[i_size] == 65 || i_data[i_size] == 75 && i_code[i_size] == 66 || i_data[i_size] == 43 && i_code[i_size] == 67) {
            data = "10110001110";
            chkcnt = 43;
        } else if (i_data[i_size] == 76 && i_code[i_size] == 65 || i_data[i_size] == 76 && i_code[i_size] == 66 || i_data[i_size] == 44 && i_code[i_size] == 67) {
            data = "10001101110";
            chkcnt = 44;
        } else if (i_data[i_size] == 77 && i_code[i_size] == 65 || i_data[i_size] == 77 && i_code[i_size] == 66 || i_data[i_size] == 45 && i_code[i_size] == 67) {
            data = "10111011000";
            chkcnt = 45;
        } else if (i_data[i_size] == 78 && i_code[i_size] == 65 || i_data[i_size] == 78 && i_code[i_size] == 66 || i_data[i_size] == 46 && i_code[i_size] == 67) {
            data = "10111000110";
            chkcnt = 46;
        } else if (i_data[i_size] == 79 && i_code[i_size] == 65 || i_data[i_size] == 79 && i_code[i_size] == 66 || i_data[i_size] == 47 && i_code[i_size] == 67) {
            data = "10001110110";
            chkcnt = 47;
        } else if (i_data[i_size] == 80 && i_code[i_size] == 65 || i_data[i_size] == 80 && i_code[i_size] == 66 || i_data[i_size] == 48 && i_code[i_size] == 67) {
            data = "11101110110";
            chkcnt = 48;
        } else if (i_data[i_size] == 81 && i_code[i_size] == 65 || i_data[i_size] == 81 && i_code[i_size] == 66 || i_data[i_size] == 49 && i_code[i_size] == 67) {
            data = "11010001110";
            chkcnt = 49;
        } else if (i_data[i_size] == 82 && i_code[i_size] == 65 || i_data[i_size] == 82 && i_code[i_size] == 66 || i_data[i_size] == 50 && i_code[i_size] == 67) {
            data = "11000101110";
            chkcnt = 50;
        } else if (i_data[i_size] == 83 && i_code[i_size] == 65 || i_data[i_size] == 83 && i_code[i_size] == 66 || i_data[i_size] == 51 && i_code[i_size] == 67) {
            data = "11011101000";
            chkcnt = 51;
        } else if (i_data[i_size] == 84 && i_code[i_size] == 65 || i_data[i_size] == 84 && i_code[i_size] == 66 || i_data[i_size] == 52 && i_code[i_size] == 67) {
            data = "11011100010";
            chkcnt = 52;
        } else if (i_data[i_size] == 85 && i_code[i_size] == 65 || i_data[i_size] == 85 && i_code[i_size] == 66 || i_data[i_size] == 53 && i_code[i_size] == 67) {
            data = "11011101110";
            chkcnt = 53;
        } else if (i_data[i_size] == 86 && i_code[i_size] == 65 || i_data[i_size] == 86 && i_code[i_size] == 66 || i_data[i_size] == 54 && i_code[i_size] == 67) {
            data = "11101011000";
            chkcnt = 54;
        } else if (i_data[i_size] == 87 && i_code[i_size] == 65 || i_data[i_size] == 87 && i_code[i_size] == 66 || i_data[i_size] == 55 && i_code[i_size] == 67) {
            data = "11101000110";
            chkcnt = 55;
        } else if (i_data[i_size] == 88 && i_code[i_size] == 65 || i_data[i_size] == 88 && i_code[i_size] == 66 || i_data[i_size] == 56 && i_code[i_size] == 67) {
            data = "11100010110";
            chkcnt = 56;
        } else if (i_data[i_size] == 89 && i_code[i_size] == 65 || i_data[i_size] == 89 && i_code[i_size] == 66 || i_data[i_size] == 57 && i_code[i_size] == 67) {
            data = "11101101000";
            chkcnt = 57;
        } else if (i_data[i_size] == 90 && i_code[i_size] == 65 || i_data[i_size] == 90 && i_code[i_size] == 66 || i_data[i_size] == 58 && i_code[i_size] == 67) {
            data = "11101100010";
            chkcnt = 58;
        } else if (i_data[i_size] == 91 && i_code[i_size] == 65 || i_data[i_size] == 91 && i_code[i_size] == 66 || i_data[i_size] == 59 && i_code[i_size] == 67) {
            data = "11100011010";
            chkcnt = 59;
        } else if (i_data[i_size] == 92 && i_code[i_size] == 65 || i_data[i_size] == 92 && i_code[i_size] == 66 || i_data[i_size] == 60 && i_code[i_size] == 67) {
            data = "11101111010";
            chkcnt = 60;
        } else if (i_data[i_size] == 93 && i_code[i_size] == 65 || i_data[i_size] == 93 && i_code[i_size] == 66 || i_data[i_size] == 61 && i_code[i_size] == 67) {
            data = "11001000010";
            chkcnt = 61;
        } else if (i_data[i_size] == 94 && i_code[i_size] == 65 || i_data[i_size] == 94 && i_code[i_size] == 66 || i_data[i_size] == 62 && i_code[i_size] == 67) {
            data = "11110001010";
            chkcnt = 62;
        } else if (i_data[i_size] == 95 && i_code[i_size] == 65 || i_data[i_size] == 95 && i_code[i_size] == 66 || i_data[i_size] == 63 && i_code[i_size] == 67) {
            data = "10100110000";
            chkcnt = 63;
        } else if (i_data[i_size] == 0 && i_code[i_size] == 65 || i_data[i_size] == 96 && i_code[i_size] == 66 || i_data[i_size] == 64 && i_code[i_size] == 67) {
            data = "10100001100";
            chkcnt = 64;
        } else if (i_data[i_size] == 1 && i_code[i_size] == 65 || i_data[i_size] == 97 && i_code[i_size] == 66 || i_data[i_size] == 65 && i_code[i_size] == 67) {
            data = "10010110000";
            chkcnt = 65;
        } else if (i_data[i_size] == 2 && i_code[i_size] == 65 || i_data[i_size] == 98 && i_code[i_size] == 66 || i_data[i_size] == 66 && i_code[i_size] == 67) {
            data = "10010000110";
            chkcnt = 66;
        } else if (i_data[i_size] == 3 && i_code[i_size] == 65 || i_data[i_size] == 99 && i_code[i_size] == 66 || i_data[i_size] == 67 && i_code[i_size] == 67) {
            data = "10000101100";
            chkcnt = 67;
        } else if (i_data[i_size] == 4 && i_code[i_size] == 65 || i_data[i_size] == 100 && i_code[i_size] == 66 || i_data[i_size] == 68 && i_code[i_size] == 67) {
            data = "10000100110";
            chkcnt = 68;
        } else if (i_data[i_size] == 5 && i_code[i_size] == 65 || i_data[i_size] == 101 && i_code[i_size] == 66 || i_data[i_size] == 69 && i_code[i_size] == 67) {
            data = "10110010000";
            chkcnt = 69;
        } else if (i_data[i_size] == 6 && i_code[i_size] == 65 || i_data[i_size] == 102 && i_code[i_size] == 66 || i_data[i_size] == 70 && i_code[i_size] == 67) {
            data = "10110000100";
            chkcnt = 70;
        } else if (i_data[i_size] == 7 && i_code[i_size] == 65 || i_data[i_size] == 103 && i_code[i_size] == 66 || i_data[i_size] == 71 && i_code[i_size] == 67) {
            data = "10011010000";
            chkcnt = 71;
        } else if (i_data[i_size] == 8 && i_code[i_size] == 65 || i_data[i_size] == 104 && i_code[i_size] == 66 || i_data[i_size] == 72 && i_code[i_size] == 67) {
            data = "10011000010";
            chkcnt = 72;
        } else if (i_data[i_size] == 9 && i_code[i_size] == 65 || i_data[i_size] == 105 && i_code[i_size] == 66 || i_data[i_size] == 73 && i_code[i_size] == 67) {
            data = "10000110100";
            chkcnt = 73;
        } else if (i_data[i_size] == 10 && i_code[i_size] == 65 || i_data[i_size] == 106 && i_code[i_size] == 66 || i_data[i_size] == 74 && i_code[i_size] == 67) {
            data = "10000110010";
            chkcnt = 74;
        } else if (i_data[i_size] == 11 && i_code[i_size] == 65 || i_data[i_size] == 107 && i_code[i_size] == 66 || i_data[i_size] == 75 && i_code[i_size] == 67) {
            data = "11000010010";
            chkcnt = 75;
        } else if (i_data[i_size] == 12 && i_code[i_size] == 65 || i_data[i_size] == 108 && i_code[i_size] == 66 || i_data[i_size] == 76 && i_code[i_size] == 67) {
            data = "11001010000";
            chkcnt = 76;
        } else if (i_data[i_size] == 13 && i_code[i_size] == 65 || i_data[i_size] == 109 && i_code[i_size] == 66 || i_data[i_size] == 77 && i_code[i_size] == 67) {
            data = "11110111010";
            chkcnt = 77;
        } else if (i_data[i_size] == 14 && i_code[i_size] == 65 || i_data[i_size] == 110 && i_code[i_size] == 66 || i_data[i_size] == 78 && i_code[i_size] == 67) {
            data = "11000010100";
            chkcnt = 78;
        } else if (i_data[i_size] == 15 && i_code[i_size] == 65 || i_data[i_size] == 111 && i_code[i_size] == 66 || i_data[i_size] == 79 && i_code[i_size] == 67) {
            data = "10001111010";
            chkcnt = 79;
        } else if (i_data[i_size] == 16 && i_code[i_size] == 65 || i_data[i_size] == 112 && i_code[i_size] == 66 || i_data[i_size] == 80 && i_code[i_size] == 67) {
            data = "10100111100";
            chkcnt = 80;
        } else if (i_data[i_size] == 17 && i_code[i_size] == 65 || i_data[i_size] == 113 && i_code[i_size] == 66 || i_data[i_size] == 81 && i_code[i_size] == 67) {
            data = "10010111100";
            chkcnt = 81;
        } else if (i_data[i_size] == 18 && i_code[i_size] == 65 || i_data[i_size] == 114 && i_code[i_size] == 66 || i_data[i_size] == 82 && i_code[i_size] == 67) {
            data = "10010011110";
            chkcnt = 82;
        } else if (i_data[i_size] == 19 && i_code[i_size] == 65 || i_data[i_size] == 115 && i_code[i_size] == 66 || i_data[i_size] == 83 && i_code[i_size] == 67) {
            data = "10111100100";
            chkcnt = 83;
        } else if (i_data[i_size] == 20 && i_code[i_size] == 65 || i_data[i_size] == 116 && i_code[i_size] == 66 || i_data[i_size] == 84 && i_code[i_size] == 67) {
            data = "10011110100";
            chkcnt = 84;
        } else if (i_data[i_size] == 21 && i_code[i_size] == 65 || i_data[i_size] == 117 && i_code[i_size] == 66 || i_data[i_size] == 85 && i_code[i_size] == 67) {
            data = "10011110010";
            chkcnt = 85;
        } else if (i_data[i_size] == 22 && i_code[i_size] == 65 || i_data[i_size] == 118 && i_code[i_size] == 66 || i_data[i_size] == 86 && i_code[i_size] == 67) {
            data = "11110100100";
            chkcnt = 86;
        } else if (i_data[i_size] == 23 && i_code[i_size] == 65 || i_data[i_size] == 119 && i_code[i_size] == 66 || i_data[i_size] == 87 && i_code[i_size] == 67) {
            data = "11110010100";
            chkcnt = 87;
        } else if (i_data[i_size] == 24 && i_code[i_size] == 65 || i_data[i_size] == 120 && i_code[i_size] == 66 || i_data[i_size] == 88 && i_code[i_size] == 67) {
            data = "11110011010";
            chkcnt = 88;
        } else if (i_data[i_size] == 25 && i_code[i_size] == 65 || i_data[i_size] == 121 && i_code[i_size] == 66 || i_data[i_size] == 89 && i_code[i_size] == 67) {
            data = "11011011110";
            chkcnt = 89;
        } else if (i_data[i_size] == 26 && i_code[i_size] == 65 || i_data[i_size] == 122 && i_code[i_size] == 66 || i_data[i_size] == 90 && i_code[i_size] == 67) {
            data = "11011110110";
            chkcnt = 90;
        } else if (i_data[i_size] == 27 && i_code[i_size] == 65 || i_data[i_size] == 123 && i_code[i_size] == 66 || i_data[i_size] == 91 && i_code[i_size] == 67) {
            data = "11110110110";
            chkcnt = 91;
        } else if (i_data[i_size] == 28 && i_code[i_size] == 65 || i_data[i_size] == 124 && i_code[i_size] == 66 || i_data[i_size] == 92 && i_code[i_size] == 67) {
            data = "10101111000";
            chkcnt = 92;
        } else if (i_data[i_size] == 29 && i_code[i_size] == 65 || i_data[i_size] == 125 && i_code[i_size] == 66 || i_data[i_size] == 93 && i_code[i_size] == 67) {
            data = "10100011110";
            chkcnt = 93;
        } else if (i_data[i_size] == 30 && i_code[i_size] == 65 || i_data[i_size] == 126 && i_code[i_size] == 66 || i_data[i_size] == 94 && i_code[i_size] == 67) {
            data = "10001011110";
            chkcnt = 94;
        } else if (i_data[i_size] == 31 && i_code[i_size] == 65 || i_data[i_size] == 95 && i_code[i_size] == 67) {
            data = "10111101000";
            chkcnt = 95;
        } else if (i_data[i_size] == 96 && i_code[i_size] == 67) {
            data = "10111100010";
            chkcnt = 96;
        } else if (i_data[i_size] == 97 && i_code[i_size] == 67) {
            data = "11110101000";
            chkcnt = 97;
        } else if (i_data[i_size] == 98 && i_code[i_size] == 67) {
            data = "11110100010";
            chkcnt = 98;
        } else if (i_data[i_size] == 99 && i_code[i_size] == 67) {
            data = "10111011110";
            chkcnt = 99;
        } else if (i_data[i_size] == 100 && i_code[i_size] == 67) {
            data = "10111101110";
            chkcnt = 100;
        } else if (i_data[i_size] == 101 && i_code[i_size] == 67) {
            data = "11101011110";
            chkcnt = 101;
        } else if (i_data[i_size] == 102 && i_code[i_size] == 67) {
            data = "11110101110";
            chkcnt = 102;
        } else if (i_data[i_size] == 103 && i_code[i_size] == 67) {
            data = "11010000100";
            chkcnt = 103;
        } else if (i_data[i_size] == 104 && i_code[i_size] == 67) {
            data = "11010010000";
            chkcnt = 104;
        } else if (i_data[i_size] == 105 && i_code[i_size] == 67) {
            data = "11010011100";
            chkcnt = 105;
        }
        if (o_chkcnt != null) {
            if (i_size == 0) {
                o_chkcnt.setValue(chk_scnt * 1 + chkcnt * 1);
            }
            if (i_size != 0) {
                if (i_code[i_size] != i_code[i_size - 1]) {
                    o_chkcnt.setValue(chk_scnt * (i_size + dg_cnt));
                    o_chkcnt.plusCount(chkcnt * (i_size + ++dg_cnt));
                } else {
                    o_chkcnt.setValue(chk_scnt * (i_size + dg_cnt) + chkcnt * (i_size + dg_cnt));
                }
            }
        }
        if (!i_flg) {
            dg_cnt = 1;
        }
        String gdata = String.valueOf(sdata) + data;
        return gdata;
    }

    private int CODE128_SET(byte[] i_data, int i_size, byte[] o_code) {
        int cnt = i_size;
        int i = 0;
        while (i < cnt) {
            o_code[i] = i_data[i] <= 63 ? 65 : (i_data[i] >= 96 && i_data[i] <= 126 ? 66 : 67);
            ++i;
        }
        return 0;
    }

    private String IntToHex(int Value, int Digits) {
        String hex = "0123456789ABCDEF";
        byte[] s = new byte[100];
        s[Digits--] = 0;
        do {
            s[Digits] = hex.getBytes()[Value & 0xF];
            Value >>= 4;
        } while (--Digits > 0);
        return new String(s);
    }
}

