/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.bluetooth;

import java.io.InputStream;
import java.util.Arrays;
import npi.sdk.common.NCommon;
import npi.sdk.common.NLogWriter;
import npi.sdk.device.bluetooth.NBluetooth;

public class NBlthRecvThread
extends Thread {
    private NLogWriter NLog;
    private boolean flgLoop;
    private boolean mFlgEnd;
    private String mDeviceName;
    private boolean flgRetryConnect = false;
    private NBluetooth objBlth;
    private boolean mFlgCloseReq;

    public NBlthRecvThread(NBluetooth blthObj) {
        this.objBlth = blthObj;
        this.NLog = blthObj.getLogObj();
        this.flgLoop = true;
        this.mFlgEnd = false;
        this.mDeviceName = blthObj.getDeviceName();
        this.mFlgCloseReq = false;
    }

    protected void finalize() {
        this.flgLoop = false;
        this.close();
    }

    public boolean checkThreadEnd() {
        return this.mFlgEnd;
    }

    @Override
    public void run() {
        int nSize = 0;
        if (this.objBlth == null) {
            this.NLog.error("Bluetooth recv thread error");
            return;
        }
        this.NLog.func("Bluetooth recv thread start Thread Id:" + this.getId(), this.objBlth.getPrintername());
        InputStream inObj = this.objBlth.getStreamIn();
        int prtStatus = 255;
        byte[] buffer = new byte[1024];
        while (this.flgLoop) {
            if (this.flgRetryConnect) {
                switch (this.objBlth.reconnect()) {
                    case 0: {
                        this.NLog.warn("Bluetooth retry connect OK:" + this.mDeviceName + " ThreadID:" + this.getId());
                        this.flgRetryConnect = false;
                        inObj = this.objBlth.getStreamIn();
                        this.objBlth.setOpenFlg(0);
                        this.objBlth.setFlgRetry(false);
                        break;
                    }
                    case 1: {
                        NCommon.sleep(100L);
                        break;
                    }
                    default: {
                        this.objBlth.close(false);
                        this.flgLoop = false;
                        this.objBlth.setOpenFlg(-2);
                        this.objBlth.setFlgRetry(false);
                    }
                }
                if (this.flgRetryConnect) continue;
            }
            try {
                nSize = inObj.read(buffer);
                if (nSize > 0) {
                    this.objBlth.setOnline(true);
                    prtStatus = NCommon.AnalysisRecvData(Arrays.copyOfRange(buffer, 0, nSize), this.objBlth.getExtendInfo(), this.NLog, this.mDeviceName);
                    this.NLog.write("Bluetooth recv data size=" + nSize, Arrays.copyOfRange(buffer, 0, nSize), 4);
                    Arrays.fill(buffer, (byte)0);
                } else {
                    prtStatus = 255;
                    this.objBlth.setOnline(false);
                }
                this.objBlth.setPrinterStatus(prtStatus);
            }
            catch (Exception e) {
                if (this.mFlgCloseReq) {
                    this.NLog.func("Bluetooth thread close request detection");
                    break;
                }
                this.NLog.error(e);
                this.flgRetryConnect = true;
                this.objBlth.setFlgRetry(true);
            }
        }
        this.mFlgCloseReq = false;
        this.mFlgEnd = true;
        this.NLog.func("Bluetooth recv thread end... Thread Id:" + this.getId(), this.objBlth.getPrintername());
    }

    public boolean close() {
        InputStream inObj = this.objBlth.getStreamIn();
        this.mFlgCloseReq = true;
        if (inObj != null) {
            try {
                try {
                    inObj.close();
                }
                catch (Exception e) {
                    inObj = null;
                    return false;
                }
            }
            finally {
                inObj = null;
            }
        }
        return true;
    }
}

