/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.bluetooth;

import java.util.LinkedList;
import npi.sdk.common.NCommon;
import npi.sdk.common.NLogWriter;
import npi.sdk.device.bluetooth.NBluetooth;
import npi.sdk.device.usb.NSendData;

public class NBlthSendThread
extends Thread {
    private NLogWriter NLog;
    private NBluetooth objBlth;

    public NBlthSendThread(NLogWriter NLog, NBluetooth objBlth) {
        this.NLog = NLog;
        this.objBlth = objBlth;
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            this.NLog.func("Bluetooth send thread start Thread Id:" + this.getId(), this.objBlth.getPrintername());
            NSendData objData = null;
            LinkedList<NSendData> sendQueue = null;
            while (true) {
                if ((sendQueue = this.objBlth.getSendQueue(this.objBlth.getPrintername())) == null) {
                    this.NLog.error("Bluetooth send thread queue error", this.objBlth.getPrintername());
                    break block7;
                }
                LinkedList<NSendData> linkedList = sendQueue;
                synchronized (linkedList) {
                    objData = sendQueue.poll();
                }
                if (objData == null) {
                    if (!this.objBlth.getFlgSendStop()) {
                        NCommon.sleep(10L);
                        continue;
                    }
                    break block7;
                }
                if (!this.objBlth.sendData(objData.getSendBuf(), objData.getSendSize(), null)) break;
            }
            this.NLog.error("Bluetooth send data error!!", this.objBlth.getPrintername());
        }
        this.objBlth.close();
        this.objBlth.setOpenFlg(100);
        this.NLog.func("Bluetooth send thread end... Thread Id:" + this.getId(), this.objBlth.getPrintername());
    }
}

