/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import npi.sdk.common.NCommon;
import npi.sdk.common.NExData;
import npi.sdk.common.NExDataArray;
import npi.sdk.common.NLogWriter;
import npi.sdk.data.NInt;
import npi.sdk.device.usb.NPrmsReceiver;
import npi.sdk.device.usb.NSendData;
import npi.sdk.device.usb.NUsbBase;
import npi.sdk.device.usb.NUsbRecvThread;
import npi.sdk.device.usb.NUsbSendThread;

public class NUsb {
    private NLogWriter NLog;
    private UsbDevice mDevice;
    private UsbInterface mIntf;
    private UsbDeviceConnection mConnection;
    private UsbEndpoint mEndPointIn;
    private UsbEndpoint mEndPointOut;
    private Object lockObj;
    private NUsbRecvThread usbRecvThread;
    private NUsbSendThread usbSendThread;
    private Context context;
    private UsbManager mManager;
    private String printerName;
    private String deviceName;
    private int prtStatus;
    private NExDataArray extendInfArray;
    private boolean bOnline;
    private boolean bCheckedRecv;
    private HashMap<String, Integer> recvBufFlgMap;
    private boolean mFlgOpen;
    private boolean mFlgRetry;
    private HashMap<String, LinkedList<NSendData>> sendQueueMap;
    private HashSet<String> sendThreadStopSet;
    private HashMap<String, Integer> statusMap;

    public NUsb(Context context, NLogWriter NLog, NUsbBase usbBase, HashMap<String, Integer> recvBufferMap, HashMap<String, LinkedList<NSendData>> sendQueueMap, HashSet<String> sendThreadStopSet, HashMap<String, Integer> statusMap) {
        this.NLog = NLog;
        this.mDevice = null;
        this.mIntf = null;
        this.mConnection = null;
        this.mEndPointIn = null;
        this.mEndPointOut = null;
        this.usbRecvThread = null;
        this.lockObj = new Object();
        this.context = context;
        this.recvBufFlgMap = recvBufferMap;
        this.sendQueueMap = sendQueueMap;
        this.sendThreadStopSet = sendThreadStopSet;
        this.statusMap = statusMap;
        this.mManager = usbBase.getManager();
        this.extendInfArray = new NExDataArray();
        this.bCheckedRecv = false;
        this.setFlgOpen(false);
        this.setFlgRetry(false);
    }

    public boolean getFlgSendStop() {
        boolean flgSendStop = false;
        if (this.sendThreadStopSet.contains(this.printerName)) {
            this.sendThreadStopSet.remove(this.printerName);
            flgSendStop = true;
        }
        return flgSendStop;
    }

    public void setFlgSendStop(boolean flgSendStop) {
        if (flgSendStop && !this.sendThreadStopSet.contains(this.printerName)) {
            this.sendThreadStopSet.add(this.printerName);
        }
    }

    public int getOpenFlg() {
        int numRet = 100;
        if (this.statusMap.containsKey(this.printerName)) {
            numRet = this.statusMap.get(this.printerName);
        }
        return numRet;
    }

    public void setOpenFlg(int numOpenFlg) {
        if (this.statusMap.containsKey(this.printerName)) {
            this.statusMap.remove(this.printerName);
        }
        this.statusMap.put(this.printerName, new Integer(numOpenFlg));
    }

    public LinkedList<NSendData> getSendQueue(String prtName) {
        return this.sendQueueMap.get(prtName);
    }

    public void setCheckedRecv(boolean bFlg) {
        this.bCheckedRecv = bFlg;
    }

    public boolean getCheckedRecv() {
        return this.bCheckedRecv;
    }

    public int getUSBStatus() {
        if (!this.getOnline()) {
            return 255;
        }
        if (this.mConnection != null) {
            if (this.usbRecvThread != null) {
                long startTime = System.currentTimeMillis();
                while (!this.bCheckedRecv && startTime + 3000L > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.NLog.error(e);
                        break;
                    }
                }
                return this.prtStatus;
            }
            return this.usbManualRecv();
        }
        return 255;
    }

    public NExDataArray getUSBExtendArray() {
        return this.extendInfArray;
    }

    public NExDataArray getUSBExtendInfo() {
        if (this.mConnection != null) {
            if (this.usbRecvThread != null) {
                long startTime = System.currentTimeMillis();
                while (!this.bCheckedRecv && startTime + 3000L > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.NLog.error(e);
                        break;
                    }
                }
                return this.extendInfArray;
            }
            if (this.usbManualRecv() != 255) {
                return this.extendInfArray;
            }
        }
        return null;
    }

    private int usbManualRecv() {
        return this.usbManualRecv(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int usbManualRecv(boolean flgLogView) {
        int nSize;
        byte[] buffer = new byte[this.mEndPointIn.getMaxPacketSize()];
        Object object = this.lockObj;
        synchronized (object) {
            nSize = this.mConnection.bulkTransfer(this.mEndPointIn, buffer, buffer.length, this.mEndPointIn.getInterval());
        }
        if (nSize > 0) {
            if (flgLogView) {
                this.NLog.write("USB manual recv data size=" + nSize, Arrays.copyOfRange(buffer, 0, nSize), 4);
            }
            this.setOnline(true);
            this.prtStatus = NCommon.AnalysisRecvData(Arrays.copyOfRange(buffer, 0, nSize), this.extendInfArray, this.NLog, this.printerName);
        } else {
            if (flgLogView) {
                this.NLog.warn("USB manual recv data size=" + nSize);
            }
            this.setOnline(false);
        }
        this.bCheckedRecv = true;
        return this.prtStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int usbRecvForReadPrinter(byte[] o_buffer, int i_buffersize, NInt o_readsize) {
        int numRet;
        int nSize;
        Object object = this.lockObj;
        synchronized (object) {
            nSize = this.mConnection.bulkTransfer(this.mEndPointIn, o_buffer, i_buffersize, this.mEndPointIn.getInterval());
        }
        this.NLog.write("USB NReadPrinter recv data size=" + nSize, Arrays.copyOfRange(o_buffer, 0, nSize), 4);
        if (nSize > 0) {
            o_readsize.setValue(nSize);
            numRet = 0;
        } else {
            numRet = -14;
        }
        return numRet;
    }

    public boolean checkConnected() {
        return this.mConnection != null;
    }

    public int reconnect() {
        return this.connect(this.printerName, this.deviceName, false);
    }

    public int connect(String i_deviceKey, String i_devicePort, boolean flgRecv) {
        int numPrmRet = 0;
        HashMap deviceMap = null;
        this.printerName = i_deviceKey;
        this.deviceName = i_devicePort;
        deviceMap = this.mManager.getDeviceList();
        if (deviceMap == null || deviceMap.size() == 0) {
            return 1;
        }
        boolean flgDeviceFound = false;
        for (String key : deviceMap.keySet()) {
            UsbDevice tmpDevice = (UsbDevice)deviceMap.get(key);
            String tmpDeviceName = String.valueOf(Integer.toHexString(tmpDevice.getVendorId())) + Integer.toHexString(tmpDevice.getProductId());
            if (!i_devicePort.equals(tmpDeviceName)) continue;
            flgDeviceFound = true;
            this.mDevice = tmpDevice;
            break;
        }
        if (!flgDeviceFound) {
            return 1;
        }
        if (!this.mManager.hasPermission(this.mDevice)) {
            NPrmsReceiver perCheck = new NPrmsReceiver(this.context, this.NLog);
            PendingIntent prmsIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent("npi.sdk.usb.USB_PERMISSION"), (int)0);
            IntentFilter filter = new IntentFilter();
            filter.addAction("npi.sdk.usb.USB_PERMISSION");
            this.context.registerReceiver((BroadcastReceiver)perCheck, filter);
            this.setOpenFlg(101);
            this.mManager.requestPermission(this.mDevice, prmsIntent);
            while ((numPrmRet = perCheck.getPermission()) == 0) {
                NCommon.sleep(100L);
            }
            this.context.unregisterReceiver((BroadcastReceiver)perCheck);
            if (numPrmRet != 1) {
                this.setOpenFlg(103);
                this.NLog.error("USB Authority NG!");
                return 2;
            }
        }
        this.setOpenFlg(102);
        if (this.mDevice.getInterfaceCount() < 1) {
            return 2;
        }
        this.mIntf = this.mDevice.getInterface(0);
        if (this.mIntf.getEndpointCount() < 2) {
            this.NLog.error("I / O port of the USB device[" + i_deviceKey + "] could not be retrieved");
            return 2;
        }
        int index = 0;
        while (index < this.mIntf.getEndpointCount()) {
            UsbEndpoint tmpEndPoint = this.mIntf.getEndpoint(index);
            if (tmpEndPoint.getDirection() == 128) {
                this.mEndPointIn = tmpEndPoint;
            } else {
                this.mEndPointOut = tmpEndPoint;
            }
            ++index;
        }
        this.mConnection = this.mManager.openDevice(this.mDevice);
        if (this.mConnection != null && this.mConnection.claimInterface(this.mIntf, true)) {
            if (!this.getFlgRetry()) {
                this.usbSendThread = new NUsbSendThread(this.NLog, this);
                this.usbSendThread.start();
                if (flgRecv) {
                    this.usbRecvThread = new NUsbRecvThread(this);
                    this.usbRecvThread.start();
                }
            }
            this.setFlgOpen(true);
            return 0;
        }
        this.NLog.error("Failed to connect USB devices [" + i_deviceKey + "]");
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendData(byte[] i_Data, int nSendSize, NInt sentObj) {
        int nSendRemain = nSendSize;
        int nSendPosition = 0;
        byte[] sendBuffer = null;
        int nWriteSize = 0;
        try {
            while (nSendRemain > 0) {
                int nBufferRemain = this.checkBufferRemain();
                if (nBufferRemain == -1) {
                    nBufferRemain = 15000;
                } else {
                    if (nBufferRemain == -2) {
                        this.NLog.error("Recv remain size error.", this.printerName);
                        return false;
                    }
                    if (nBufferRemain == 0) {
                        Thread.sleep(50L);
                        continue;
                    }
                }
                sendBuffer = nSendRemain >= nBufferRemain ? new byte[nBufferRemain] : new byte[nSendRemain];
                System.arraycopy(i_Data, nSendPosition, sendBuffer, 0, sendBuffer.length);
                Object object = this.lockObj;
                synchronized (object) {
                    nWriteSize = this.mConnection.bulkTransfer(this.mEndPointOut, sendBuffer, sendBuffer.length, 0);
                }
                this.NLog.write("USB send data size=" + nWriteSize, Arrays.copyOfRange(sendBuffer, 0, nWriteSize), 5);
                nSendRemain -= nWriteSize;
                nSendPosition += nWriteSize;
            }
        }
        catch (Exception e) {
            this.NLog.error(e);
            return false;
        }
        if (sentObj != null) {
            sentObj.setValue(nWriteSize);
        }
        return true;
    }

    private int checkBufferRemain() {
        NExData dInfo = null;
        byte[] exBuff = null;
        int nRemain = -2;
        boolean bBufferCheck = true;
        if (this.recvBufFlgMap.containsKey(this.printerName) && this.recvBufFlgMap.get(this.printerName) == 1) {
            nRemain = -1;
        }
        if (nRemain == -2) {
            long nCheckStartTime = System.currentTimeMillis();
            while (nCheckStartTime + 3000L > System.currentTimeMillis()) {
                NExDataArray exArray = this.getUSBExtendInfo();
                if (exArray == null) break;
                dInfo = exArray.getData(1);
                if (nCheckStartTime < dInfo.getTimeStamp()) {
                    exBuff = dInfo.getBuffer();
                    nRemain = exBuff[3] * 1000;
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return nRemain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetPrinter() {
        byte[] buf = new byte[1];
        try {
            Object object = this.lockObj;
            synchronized (object) {
                int numRet = this.mConnection.controlTransfer(33, 2, 0, 0, buf, 0, 100);
            }
        }
        catch (Exception e) {
            this.NLog.error(e);
            return false;
        }
        return true;
    }

    public boolean close() {
        return this.close(true);
    }

    public synchronized boolean close(boolean bThreadStop) {
        int nCloseRet = 0;
        long startTime = System.currentTimeMillis();
        startTime = System.currentTimeMillis();
        if (bThreadStop && this.usbRecvThread != null) {
            while (!this.usbRecvThread.stopThread()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (startTime + 5000L > System.currentTimeMillis()) continue;
                this.NLog.error("USB recv thread stop error");
                nCloseRet += 2;
                break;
            }
            this.usbRecvThread = null;
        }
        if (this.mConnection != null) {
            if (this.mIntf != null) {
                this.mConnection.releaseInterface(this.mIntf);
            }
            this.mConnection.close();
            this.mConnection = null;
        }
        this.bCheckedRecv = false;
        this.setFlgOpen(false);
        this.setFlgRetry(false);
        return nCloseRet <= 0;
    }

    public void setOnline(boolean flg) {
        if (!flg) {
            this.prtStatus = 255;
        }
        this.bOnline = flg;
    }

    public boolean getOnline() {
        if (this.mConnection != null) {
            if (this.usbRecvThread == null) {
                this.usbManualRecv(false);
            } else {
                long startTime = System.currentTimeMillis();
                while (!this.bCheckedRecv && startTime + 3000L > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.NLog.error(e);
                        break;
                    }
                }
            }
        }
        return this.bOnline;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public UsbEndpoint getEndPointIn() {
        return this.mEndPointIn;
    }

    public Object getLockObj() {
        return this.lockObj;
    }

    public UsbDeviceConnection getConnection() {
        return this.mConnection;
    }

    public NLogWriter getLogObj() {
        return this.NLog;
    }

    public void setPrinterStatus(int prtStatus) {
        this.prtStatus = prtStatus;
    }

    public boolean getFlgOpen() {
        return this.mFlgOpen;
    }

    public void setFlgOpen(boolean flgOpen) {
        this.mFlgOpen = flgOpen;
    }

    public boolean getFlgRetry() {
        return this.mFlgRetry;
    }

    public void setFlgRetry(boolean mFlgRetry) {
        this.mFlgRetry = mFlgRetry;
    }

    protected void finalize() {
        this.close();
    }
}

