package npi.sample;

import java.text.SimpleDateFormat;
import java.util.Date;

import npi.sample.R;
import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import npi.sdk.common.NRet;
import npi.sdk.data.NInt;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Environment;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

/**
 * Main Activity
 * @author NPI
 *
 */
public class NPISDK extends Activity implements OnClickListener
{
	// NPI SDK Class
	private NPrinterLib objLib;

	// Button
	private Button btnPrtInf;			// Printer information
	private Button btnOpenPrt;			// Printer open
	private Button btnOpenResult;		// Printer get open result
	private Button btnClosePrt;		// Printer close
	private Button btnAllClosePrt;		// Printer all close
	private Button btnSetUSBProtocol;
	private Button btnPrint;			// Print
	private Button btnStatus;			// Status
	private Button btnResetFW;			// Reset printer / Firmware download
	private Button btnBarcode;			// Barcode print
	private Button btnReceiptTest;		// Receipt test
	private Button btnTicketTest;		// Ticket test
	private Button btnAppClose;		// Application close

	private Button btnNPITest;


	// TextView
	private TextView txtOpenRet;
	private TextView txtCloseRet;
	private TextView txtAllCloseRet;
	private TextView txtUSBProtocolRet;
	private TextView txtReceiptTest;
	private TextView txtTicketTest;



	// EditText
	private EditText edtPrtName;

	// CheckBox
	private CheckBox chkRecvThread;

	// Spinner
	private Spinner spnUSBProtocol;
	private Spinner spnReceiptType;
	private Spinner spnTicketType;



    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);		// Auto keyboard off
        setContentView(R.layout.activity_npisdk);

        // Printer name
        edtPrtName		= (EditText)findViewById(R.id.edtPrtName);

        // ----- Information / Setting -----
        btnPrtInf	 	= (Button)findViewById(R.id.PrinterInf);
        btnPrtInf.setOnClickListener(this);

        // ----- NOpenPrinter -----
        btnOpenPrt 		= (Button)findViewById(R.id.btnOpenPrinter);
        btnOpenPrt.setOnClickListener(this);

        chkRecvThread	= (CheckBox)findViewById(R.id.chkRecvThread);


        // ----- NOpenResult -----
        btnOpenResult	= (Button)findViewById(R.id.btnOpenResult);
        btnOpenResult.setOnClickListener(this);

        txtOpenRet		= (TextView)findViewById(R.id.txtOpenRet);

        // ----- NClosePrinter -----
        btnClosePrt		= (Button)findViewById(R.id.btnClosePrinter);
        btnClosePrt.setOnClickListener(this);

        txtCloseRet		= (TextView)findViewById(R.id.txtCloseRet);

        // ----- NClosePrinters(All Close) -----
        btnAllClosePrt	= (Button)findViewById(R.id.btnAllClosePrinter);
        btnAllClosePrt.setOnClickListener(this);

        txtAllCloseRet	= (TextView)findViewById(R.id.txtAllCloseRet);

		// ----- NSetUSBProtocol -----
        btnSetUSBProtocol	= (Button)findViewById(R.id.btnNSetUSBProtocol);
		btnSetUSBProtocol.setOnClickListener(this);

		spnUSBProtocol		= (Spinner)findViewById(R.id.spnUSBProtocol);

		txtUSBProtocolRet	= (TextView)findViewById(R.id.txtUSBProtocolRet);

        // ----- NPrint -----
        btnPrint		= (Button)findViewById(R.id.btnPrint);
        btnPrint.setOnClickListener(this);


        // ----- NGetStatus -----
        btnStatus		= (Button)findViewById(R.id.btnStatus);
        btnStatus.setOnClickListener(this);


        // ----- Reset / Firmware -----
        btnResetFW		= (Button)findViewById(R.id.btnResetFW);
        btnResetFW.setOnClickListener(this);

        // ----- Create barcode / Bitmap image -----
        btnBarcode		= (Button)findViewById(R.id.btnBarcode);
        btnBarcode.setOnClickListener(this);



        // ----- Receipt test -----
        btnReceiptTest	= (Button)findViewById(R.id.btnReceiptTest);
        btnReceiptTest.setOnClickListener(this);

        txtReceiptTest	= (TextView)findViewById(R.id.txtReceiptTestRet);
        spnReceiptType 	= (Spinner)findViewById(R.id.spnReceiptType);

        // ----- Ticket test -----
        btnTicketTest	= (Button)findViewById(R.id.btnTicketTest);
        btnTicketTest.setOnClickListener(this);

        txtTicketTest	= (TextView)findViewById(R.id.txtTicketTestRet);
        spnTicketType 	= (Spinner)findViewById(R.id.spnTicketType);

        // ----- NPI test -----
        btnNPITest = (Button)findViewById(R.id.btnNPITest);
        btnNPITest.setOnClickListener(this);



        // ----- Application close -----
        btnAppClose		= (Button)findViewById(R.id.btnFinish);
        btnAppClose.setOnClickListener(this);
        btnAppClose.setTextColor(Color.RED);





        //----------------------------------------------------------------------------------------------------------
        // NPI SDK class create
        objLib = new NPrinterLib(NPISDK.this);

        // Set to pass NPI SDK class to another screen
		NCarryLibrary objCarry = (NCarryLibrary) this.getApplication();
		objCarry.setLibrary(objLib);

        //----------------------------------------------------------------------------------------------------------
    }



    @Override
	public void onBackPressed()
    {
		super.onBackPressed();
		objLib.NClosePrinters();		// All Close printers
	}



	@Override
    public boolean onCreateOptionsMenu(Menu menu)
    {
        getMenuInflater().inflate(R.menu.activity_npisdk, menu);
        return true;
    }

	@Override
	public void onClick(View v)
	{
		Intent intent;
		int nmsRet;

		if(v == btnPrtInf)
		{
			intent = new Intent(this.getApplicationContext(), SubForm01.class);

			startActivity(intent);
    	}
		else if(v == btnOpenPrt)
		{
			objLib.NOpenPrinter(edtPrtName.getText().toString(), chkRecvThread.isChecked());
    	}
		else if(v == btnOpenResult)
		{
			nmsRet = objLib.NOpenResult(edtPrtName.getText().toString());
			txtOpenRet.setText(Integer.toString(nmsRet));

			if(nmsRet != NRet.SUCCESS)
			{
				txtOpenRet.setTextColor(Color.RED);
			}
			else
			{
				txtOpenRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnClosePrt)
		{
			nmsRet = objLib.NClosePrinter(edtPrtName.getText().toString());
			txtCloseRet.setText(Integer.toString(nmsRet));

			if(nmsRet != NRet.SUCCESS)
			{
				txtCloseRet.setTextColor(Color.RED);
			}
			else
			{
				txtCloseRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnAllClosePrt)
		{
			nmsRet = objLib.NClosePrinters();
			txtAllCloseRet.setText(Integer.toString(nmsRet));

			if(nmsRet != NRet.SUCCESS)
			{
				txtAllCloseRet.setTextColor(Color.RED);
			}
			else
			{
				txtAllCloseRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnSetUSBProtocol)
		{
			int numSetUSB = Integer.parseInt((String)spnUSBProtocol.getSelectedItem());

			nmsRet = objLib.NSetUSBProtocol(edtPrtName.getText().toString(), numSetUSB);

			txtUSBProtocolRet.setText(Integer.toString(nmsRet));

			if(nmsRet < NRet.SUCCESS)
			{
				txtUSBProtocolRet.setTextColor(Color.RED);
			}
			else
			{
				txtUSBProtocolRet.setTextColor(Color.BLACK);
			}
		}
		else if (v == btnPrint)
		{
			intent = new Intent(NPISDK.this, SubForm02.class);
			intent.putExtra("PRTNAME", edtPrtName.getText().toString());
			startActivity(intent);
		}
		else if(v == btnStatus)
		{
			intent = new Intent(NPISDK.this, SubForm03.class);
			intent.putExtra("PRTNAME", edtPrtName.getText().toString());
			startActivity(intent);
		}
		else if(v == btnResetFW)
		{
			intent = new Intent(NPISDK.this, SubForm04.class);
			intent.putExtra("PRTNAME", edtPrtName.getText().toString());
			startActivity(intent);
		}
		else if(v == btnBarcode)
		{
			intent = new Intent(NPISDK.this, SubForm05.class);
			intent.putExtra("PRTNAME", edtPrtName.getText().toString());
			startActivity(intent);
		}
		else if(v == btnReceiptTest)
		{
			this.receiptTest();
		}
		else if(v == btnTicketTest)
		{
			this.ticketTest();
		}
		else if(v == btnNPITest)
		{
			intent = new Intent(NPISDK.this, SubForm06.class);
			intent.putExtra("PRTNAME", edtPrtName.getText().toString());
			startActivity(intent);
		}
		else if(v == btnAppClose)
		{
			this.finish();
		}

	}


	private void receiptTest()
	{
		int nmsRet 				= NRet.SUCCESS;

		// NOpenResult
		nmsRet = objLib.NOpenResult(edtPrtName.getText().toString());
		if(nmsRet != NRet.SUCCESS && nmsRet != NRet.ERR_PRTALREADYOPEN)
		{
			setReceiptError(nmsRet, false);
			return;		// NOpenPrinter failed
		}

		// Get inch size
		String strInchType = (String)spnReceiptType.getSelectedItem();
		if(strInchType.equals("2inch"))
		{
			receiptTestFor2inch();
		}
		else
		{
			receiptTestFor3inch();
		}
	}

	private void receiptTestFor2inch()
	{
		int nmsRet;
		String strCommand 		= null;
		NInt objJobID 			= null;
		SimpleDateFormat sdf 	= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");



		objJobID = new NInt();

		// NStartDoc
		if((nmsRet = objLib.NStartDoc(edtPrtName.getText().toString(), objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, false);
			return;		// NStartDoc failed
		}

		// NImagePrintF
		String imagePath 	= Environment.getExternalStorageDirectory() + "/npi/npilogo_2inch.bmp";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imagePath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NImagePrintF failed
		}

		// ----- NPrint ------------------------------------------------------------------------------
		StringBuilder strCmdBuffer = new StringBuilder("1B40");

		strCmdBuffer.append("1B6101");
		strCmdBuffer.append("\"----- Receipt test print -----\"0A1B6100");
		strCmdBuffer.append("1B5C1500\"1-5-2, Unoki, Ohtaku, Tokyo\"0A");
		strCmdBuffer.append("1B5C1500\"146-8650 Japan\"0A");
		strCmdBuffer.append("1B5C1500\"TEL   : 81-3-3750-5817\"0A");
		strCmdBuffer.append("1B5C1500\"E-Mail: overseas@primex.co.jp\"0A");
		strCmdBuffer.append("1B5C1500\"*****************************\"0A");
		strCmdBuffer.append("1B21011B6101\"Thank you for the coming to the store.\"0A");
		strCmdBuffer.append("\"I rest and do business this month.\"1B21001B5C00000A");
		strCmdBuffer.append("1B61001B5C1500\"*****************************\"0A");
		strCmdBuffer.append("1B5C1000\"Date : ");
		strCmdBuffer.append(sdf.format(new Date()));
		strCmdBuffer.append("\"0A0A");
		strCmdBuffer.append("1B5C2000\"Coke\"0A");
		strCmdBuffer.append("1B5C2000\"    $ 2.00 * 2         $ 4.00\"0A");
		strCmdBuffer.append("1B5C2000\"Orange juice\"0A");
		strCmdBuffer.append("1B5C2000\"    $ 2.00 * 1         $ 2.00\"0A");
		strCmdBuffer.append("1B5C2000\"Beer\"0A");
		strCmdBuffer.append("1B5C2000\"    $ 6.00 * 3        $ 18.00\"0A");
		strCmdBuffer.append("1B5C1500\"------------------------------\"0A");
		strCmdBuffer.append("1B5C1500\"Total   \"1B21201C2104\"  USD 24.00\"1C21001B21000A");
		strCmdBuffer.append("1B5C1500\"------------------------------\"0A");
		strCmdBuffer.append("1B5C1500\"Deposit \"1B21201C2104\"  USD 30.00\"1C21001B21000A");
		strCmdBuffer.append("1B5C1500\"Change  \"1B21201C2104\"  USD  6.00\"1C21001B21000A");

		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NPrint failed
		}

		// -----------------------------------------------------------------------------------------
		// NImagePrintF
		String imgBcdPath 	= Environment.getExternalStorageDirectory() + "/npi/barcode2d_2inch.bmp";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imgBcdPath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NImagePrintF failed
		}

		// NPrint
		strCommand = "1B6101\"www.primex.co.jp\"1B61001B4A801B6D1B40";
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NPrint failed
		}


		// NEndDoc
		if((nmsRet = objLib.NEndDoc(edtPrtName.getText().toString())) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NEndDoc failed
		}

		setReceiptError(nmsRet, false);
	}

	private void receiptTestFor3inch()
	{
		int nmsRet;
		String strCommand;
		NInt objJobID;
		SimpleDateFormat sdf 	= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");


		objJobID = new NInt();

		// NStartDoc
		if((nmsRet = objLib.NStartDoc(edtPrtName.getText().toString(), objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, false);
			return;		// NStartDoc failed
		}

		// NImagePrintF
		String imagePath 	= Environment.getExternalStorageDirectory() + "/npi/npilogo.jpg";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imagePath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NImagePrintF failed
		}

		// ----- NPrint ------------------------------------------------------------------------------
		StringBuilder strCmdBuffer = new StringBuilder("1B40");

		strCmdBuffer.append("1B6101");
		strCmdBuffer.append("\"----- Receipt test print -----\"0A1B6100");
		strCmdBuffer.append("1B5C2000\"1-5-12, Unoki, Ohtaku, Tokyo 146-8650 Japan\"0A");
		strCmdBuffer.append("1B5C2000\"TEL    : 81-3-3750-5817\"0A");;
		strCmdBuffer.append("1B5C2000\"E-Mail : overseas@primex.co.jp\"0A");
		strCmdBuffer.append("1B5C2000\"******************************************\"0A");
		strCmdBuffer.append("1B6101\"Thank you for the coming to the store.\"0A");
		strCmdBuffer.append("\"I rest and do business this month.\"1B5C00000A");
		strCmdBuffer.append("1B61001B5C2000\"******************************************\"0A");

		strCmdBuffer.append("1B5C2000\"Date : ");
		strCmdBuffer.append(sdf.format(new Date()));
		strCmdBuffer.append("\"0A0A");

		strCmdBuffer.append("1B5C2000\"Coke\"0A");
		strCmdBuffer.append("1B5C2000\"     $ 2.00 * 2                   $ 4.00\"0A");
		strCmdBuffer.append("1B5C2000\"Orange juice\"0A");
		strCmdBuffer.append("1B5C2000\"     $ 2.00 * 1                   $ 2.00\"0A");
		strCmdBuffer.append("1B5C2000\"Beer\"0A");
		strCmdBuffer.append("1B5C2000\"     $ 6.00 * 3                  $ 18.00\"0A");

		strCmdBuffer.append("1B5C2000\"-------------------------------------------\"0A");
		strCmdBuffer.append("1B5C20001B21201C2104\"TOTAL    USD   24.00\"1C21001B21000A");
		strCmdBuffer.append("1B5C2000\"-------------------------------------------\"0A");

		strCmdBuffer.append("1B5C2000\"Deposit \"1B21201C2104\"     USD   30.00\"1C21001B21000A");
		strCmdBuffer.append("1B5C2000\"Change\"1B21201C2104\"      USD    6.00\"1C21001B21000A");


		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NPrint failed
		}

		// -----------------------------------------------------------------------------------------
		// NImagePrintF
		String imgBcdPath 	= Environment.getExternalStorageDirectory() + "/npi/barcode2D.jpg";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imgBcdPath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NImagePrintF failed
		}

		// NPrint
		strCommand = "1B5C2000\"http://www.primex.co.jp/npiweb/index_e.jsp\"1B4A991B6D1B40";
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NPrint failed
		}


		// NEndDoc
		if((nmsRet = objLib.NEndDoc(edtPrtName.getText().toString())) != NRet.SUCCESS)
		{
			setReceiptError(nmsRet, true);
			return;		// NEndDoc failed
		}

		setReceiptError(nmsRet, false);
	}

	private void setReceiptError(int nmsRet, boolean flgCancel)
	{
		txtReceiptTest.setText(Integer.toString(nmsRet));

		if(nmsRet == NRet.SUCCESS)
		{
			txtReceiptTest.setTextColor(Color.BLACK);
		}
		else
		{
			txtReceiptTest.setTextColor(Color.RED);
		}

		if(flgCancel)
		{
			objLib.NCancelDoc(edtPrtName.getText().toString());
		}
	}

	private void ticketTest()
	{
		int nmsRet 				= NRet.SUCCESS;

		// NOpenResult
		nmsRet = objLib.NOpenResult(edtPrtName.getText().toString());
		if(nmsRet != NRet.SUCCESS && nmsRet != NRet.ERR_PRTALREADYOPEN)
		{
			setTicketError(nmsRet, false);
			return;		// NOpenPrinter failed
		}


		// Get inch size
		String strInchType = (String)spnTicketType.getSelectedItem();
		if(strInchType.equals("2inch"))
		{
			ticketTestFor2inch();
		}
		else
		{
			ticketTestFor3inch();
		}

	}

	private void ticketTestFor2inch()
	{
		int nmsRet;
		String strCommand	 	= null;
		NInt objJobID 			= null;
		SimpleDateFormat sdf 	= new SimpleDateFormat("MM/dd/yyyy HH:mm");


		// NStartDoc
		objJobID = new NInt();
		if((nmsRet = objLib.NStartDoc(edtPrtName.getText().toString(), objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, false);
			return;		// NStartDoc failed
		}

		// NPrint(page mode start)
		StringBuilder strCmdBuffer = new StringBuilder("1B40");
		strCmdBuffer.append("1B5401");						// page mode rotate
		strCmdBuffer.append("1B6C4C");						// page mode length
		strCmdBuffer.append("1B5705004030");				// page mode size
		strCmdBuffer.append("1B4C11300005000001");			//

		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NPrint failed
		}


		// NImagePrintF
		String imagePath 	= Environment.getExternalStorageDirectory() + "/npi/npilogo_2inch.bmp";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imagePath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NImagePrintF failed
		}

		// NPrint
		strCmdBuffer = new StringBuilder("1B4C10");
		strCmdBuffer.append("1B4C11050060000001");
		strCmdBuffer.append("1B61001B5C2000\"Date of issuance    : ");
		strCmdBuffer.append(sdf.format(new Date()));
		strCmdBuffer.append("\"0A");
		//strCmdBuffer.append("1B6100\"Coupon type         : Ticket test print\"0A");
		strCmdBuffer.append("1B5C5000");
		strCmdBuffer.append("1B2138");
		strCmdBuffer.append("1B2D02");
		strCmdBuffer.append("\"All item 20% OFF!\"0A");
		strCmdBuffer.append("1B21000A");


		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NPrint failed
		}

		// NImagePrintF
		String imgBcdPath 	= Environment.getExternalStorageDirectory() + "/npi/ticket02.bmp";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imgBcdPath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NImagePrintF failed
		}



		// NPrint
		strCmdBuffer = new StringBuilder("1B5C9900");
		strCmdBuffer.append("\"www.primex.co.jp\"0A");
		strCmdBuffer.append("1B4C10");
		strCmdBuffer.append("1B0C00");
		strCmdBuffer.append("1B4A7F");		// Feed
		strCmdBuffer.append("1B6D");
		strCmdBuffer.append("1B40");
		strCmdBuffer.append("18");			// page mode buffer clear 2013.09.24 add kohta

		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NPrint failed
		}


		// NEndDoc
		if((nmsRet = objLib.NEndDoc(edtPrtName.getText().toString())) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NEndDoc failed
		}


		setTicketError(nmsRet, false);



	}

	private void ticketTestFor3inch()
	{
		int nmsRet;
		String strCommand	 	= null;
		NInt objJobID 			= null;
		SimpleDateFormat sdf 	= new SimpleDateFormat("MM/dd/yyyy HH:mm");


		// NStartDoc
		objJobID = new NInt();
		if((nmsRet = objLib.NStartDoc(edtPrtName.getText().toString(), objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, false);
			return;		// NStartDoc failed
		}

		// NPrint(page mode start)
		StringBuilder strCmdBuffer = new StringBuilder("1B40");
		strCmdBuffer.append("1B5401");						// page mode rotate
		strCmdBuffer.append("1B6C5C");						// page mode length
		strCmdBuffer.append("1B5705055055");				// page mode size
		strCmdBuffer.append("1B4C11300005000001");			//


		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NPrint failed
		}


		// NImagePrintF
		String imagePath 	= Environment.getExternalStorageDirectory() + "/npi/npilogo.jpg";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imagePath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NImagePrintF failed
		}


		// NPrint
		strCmdBuffer = new StringBuilder("1B4C10");
		strCmdBuffer.append("1B4C11050060000001");

		strCmdBuffer.append("1B6100\"Date of issuance    : ");
		strCmdBuffer.append(sdf.format(new Date()));
		strCmdBuffer.append("\"0A");
		strCmdBuffer.append("1B6100\"Coupon type         : Ticket test print\"0A");
		strCmdBuffer.append("1B6100\"Available places    : Nippon Primex Inc.\"0A");
		strCmdBuffer.append("1B6100\"Validity period     : 6 months from date of issuance\"0A0A");

		strCmdBuffer.append("1B5C8000");
		strCmdBuffer.append("1B2138");
		strCmdBuffer.append("1B2D02");
		strCmdBuffer.append("\"All item 20% OFF!\"0A0A");
		strCmdBuffer.append("1B2100");

		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NPrint failed
		}


		// NImagePrintF
		String imgBcdPath 	= Environment.getExternalStorageDirectory() + "/npi/barcode2D.jpg";
		if((nmsRet = objLib.NImagePrintF(edtPrtName.getText().toString(), imgBcdPath, (byte)0x10, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NImagePrintF failed
		}



		// NPrint
		strCmdBuffer = new StringBuilder("1B5C50001");
		strCmdBuffer.append("\"http://www.primex.co.jp/npiweb/index_e.jsp\"0A");
		strCmdBuffer.append("1B4C10");
		strCmdBuffer.append("1B0C00");
		strCmdBuffer.append("1B4A7F");		// Feed
		strCmdBuffer.append("1B6D");
		strCmdBuffer.append("1B40");
		strCmdBuffer.append("18");			// page mode buffer clear 2013.09.24 add kohta

		strCommand = strCmdBuffer.toString();
		if((nmsRet = objLib.NPrint(edtPrtName.getText().toString(), strCommand, strCommand.getBytes().length, objJobID)) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NPrint failed
		}


		// NEndDoc
		if((nmsRet = objLib.NEndDoc(edtPrtName.getText().toString())) != NRet.SUCCESS)
		{
			setTicketError(nmsRet, true);
			return;		// NEndDoc failed
		}


		setTicketError(nmsRet, false);
	}

	private void setTicketError(int nmsRet, boolean flgCancel)
	{
		txtTicketTest.setText(Integer.toString(nmsRet));

		if(nmsRet == NRet.SUCCESS)
		{
			txtTicketTest.setTextColor(Color.BLACK);
		}
		else
		{
			txtTicketTest.setTextColor(Color.RED);
		}

		if(flgCancel)
		{
			objLib.NCancelDoc(edtPrtName.getText().toString());
		}
	}
}
