package npi.sample;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import npi.sdk.common.NRet;
import npi.sdk.data.NInt;
import npi.sdk.data.NString;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

/**
 * NEnumPrinters, NRenamePrinter, NGetPrinterInf, NAutoOpen
 * @author NPI
 *
 */
public class SubForm01 extends Activity implements OnClickListener
{
	// NPI SDK Class
	private NPrinterLib objLib;

	// Button
	private Button btnEnumPrinter;
	private Button btnRenamePrinter;
	private Button btnGetPrtInf;
	private Button btnAutoOpen;
	private Button btnFilePathCheck;
	private Button btnSettingCreate;
	private Button btnVersionCheck;
	private Button btnBack01;

	// TextView
	private TextView txtEnumRet;
	private TextView txtRenameRet;
	private TextView txtGetPrtInfRet;
	private TextView txtDeviceType;
	private TextView txtAutoOpenRet;

	// EditText
	private EditText edtEnumData;
	private EditText edtBeforePrtName;
	private EditText edtAfterPrtName;
	private EditText edtInputPrt;
	private EditText edtGetPrtInf;

	// CheckBox
	private Spinner spnOpenflg;

	// File path dialog
	private AlertDialog.Builder dlgFilepath;

	// setting file create dialog
	private AlertDialog.Builder dlgSetting;

	// Version check dialog
	private AlertDialog.Builder dlgVerCheck;


	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.sub_form01);

		NCarryLibrary carryObj = (NCarryLibrary) this.getApplication();
		objLib = carryObj.getLibrary();


		// ----- NEnumPrinters -----
		btnEnumPrinter	 	= (Button)findViewById(R.id.btnNEnumPrinters);
		btnEnumPrinter.setOnClickListener(this);

		txtEnumRet			= (TextView)findViewById(R.id.EnumRet);
		edtEnumData			= (EditText)findViewById(R.id.EnumData);
		//edtEnumData.setBackgroundColor(0xffffcc);


		// ----- NRenamePrinter -----
		btnRenamePrinter	 	= (Button)findViewById(R.id.btnNRenamePrinter);
		btnRenamePrinter.setOnClickListener(this);

		txtRenameRet			= (TextView)findViewById(R.id.txtRenameRet);

		edtBeforePrtName		= (EditText)findViewById(R.id.edtBefPrtName);
		edtAfterPrtName		= (EditText)findViewById(R.id.edtAftPrtName);

		// ----- NGetPrinterInf -----
		btnGetPrtInf	 	= (Button)findViewById(R.id.btnNGetPrinterInf);
		btnGetPrtInf.setOnClickListener(this);

		txtGetPrtInfRet		= (TextView)findViewById(R.id.txtGetPrtInfRet);
		edtGetPrtInf		= (EditText)findViewById(R.id.edtPrtInfData);
		edtInputPrt			= (EditText)findViewById(R.id.edtInputPrt);

		//edtGetPrtInf.setBackgroundColor(0xffffcc);

		txtDeviceType		= (TextView)findViewById(R.id.txtDeviceType);

		// ----- NAutoOpen -----
		btnAutoOpen			= (Button)findViewById(R.id.btnNAutoOpen);
		btnAutoOpen.setOnClickListener(this);

		txtAutoOpenRet		= (TextView)findViewById(R.id.txtAutoOpen);

		spnOpenflg			= (Spinner)findViewById(R.id.spnAutoOpen);

		// ----- File path check -----
		btnFilePathCheck 	= (Button)findViewById(R.id.btnFilePathCheck);
		btnFilePathCheck.setOnClickListener(this);

		createFilePathDialog();

		// ----- Default setting file create -----
		btnSettingCreate 	= (Button)findViewById(R.id.btnSettingCreate);
		btnSettingCreate.setOnClickListener(this);

		createSettingFileDialog();

		// ----- Version check -----
		btnVersionCheck 	= (Button)findViewById(R.id.btnVersion);
		btnVersionCheck.setOnClickListener(this);

		createVersionDialog();

		// ----- back -----
		btnBack01			= (Button)findViewById(R.id.btnBack01);
		btnBack01.setOnClickListener(this);
		btnBack01.setTextColor(Color.RED);
	}

	private void createFilePathDialog()
	{
		dlgFilepath = new AlertDialog.Builder(this);
		dlgFilepath.setIcon(R.drawable.nichipuri);   	// icon setting
		dlgFilepath.setTitle("File path check");      	// title setting

		String strMsg = "Environment.getExternalStorageDirectory() = \n" + Environment.getExternalStorageDirectory();

		dlgFilepath.setMessage(strMsg);

		// OK Button setting
		dlgFilepath.setPositiveButton("OK", new DialogInterface.OnClickListener()
		{
			public void onClick(DialogInterface dialog, int which)
			{

			}
		});
	}

	private void createSettingFileDialog()
	{
		dlgSetting = new AlertDialog.Builder(this);
		dlgSetting.setIcon(R.drawable.nichipuri);   	// icon setting
		dlgSetting.setTitle("Default setting file create");      	// title setting


		dlgSetting.setMessage("In order to reload the configuration file, \nand then restart the application.");

		// OK Button setting
		dlgSetting.setPositiveButton("OK", new DialogInterface.OnClickListener()
		{
			public void onClick(DialogInterface dialog, int which)
			{

			}
		});
	}

	private void createVersionDialog()
	{
		PackageInfo pkgInfo 		= null;
		String staAppVersion 		= null;

		try
		{
			pkgInfo = getPackageManager().getPackageInfo("npi.sample", PackageManager.GET_META_DATA);
			staAppVersion 	= pkgInfo.versionCode + "\nVersionName : " + pkgInfo.versionName;
		}
		catch (Exception e)
		{
			staAppVersion = "Error";
		}

		dlgVerCheck = new AlertDialog.Builder(this);
		dlgVerCheck.setIcon(R.drawable.nichipuri);   	// icon setting
		dlgVerCheck.setTitle("Version check");      	// title setting

		StringBuilder strVersion = new StringBuilder();

		strVersion.append("SDK Version   : " + objLib.SDKVERSION);
		strVersion.append("\n");
		strVersion.append("App Version   : " + staAppVersion);

		dlgVerCheck.setMessage(strVersion);  			// message setting

		// OK Button setting
		dlgVerCheck.setPositiveButton("OK", new DialogInterface.OnClickListener()
		{
			public void onClick(DialogInterface dialog, int which)
			{

			}
		});
	}

	@Override
	public void onClick(View v)
	{
		int nmsRet = 0;
		NInt objnumSize = null;

		if(v == btnEnumPrinter)
		{
			NString strPrinter = new NString();
			objnumSize = new NInt();

			nmsRet = objLib.NEnumPrinters(strPrinter, objnumSize);

			txtEnumRet.setText(Integer.toString(nmsRet));

			if(nmsRet == NRet.SUCCESS)
			{
				txtEnumRet.setTextColor(Color.BLACK);
				edtEnumData.setText(strPrinter.getValue());
			}
			else
			{
				txtEnumRet.setTextColor(Color.RED);
				edtEnumData.setText("");
			}
		}
		else if(v == btnRenamePrinter)
		{
			nmsRet = objLib.NRenamePrinter(edtBeforePrtName.getText().toString(), edtAfterPrtName.getText().toString());
			txtRenameRet.setText(Integer.toString(nmsRet));

			if(nmsRet == NRet.SUCCESS)
			{
				txtRenameRet.setTextColor(Color.BLACK);
			}
			else
			{
				txtRenameRet.setTextColor(Color.RED);
			}
		}
		else if(v == btnGetPrtInf)
		{
			NString strInfo = new NString();
			objnumSize = new NInt();

			nmsRet = objLib.NGetPrinterInf(edtInputPrt.getText().toString(), strInfo, objnumSize);

			txtGetPrtInfRet.setText(Integer.toString(nmsRet));

			if(nmsRet == NRet.SUCCESS)
			{
				txtGetPrtInfRet.setTextColor(Color.BLACK);
				edtGetPrtInf.setText(strInfo.getValue());

				try
				{
					int numDeviceType = Integer.parseInt(strInfo.getValue().substring(0, 1));

					switch(numDeviceType)
					{
						case 0:
							txtDeviceType.setText("Serial");		// Not supported
							break;
						case 1:
							txtDeviceType.setText("USB");
							break;
						case 2:
							txtDeviceType.setText("Bluetooth");
							break;
						default:
							txtDeviceType.setText("---");
							break;
					}

				}
				catch(Exception e)
				{
					txtDeviceType.setText("---");
				}
			}
			else
			{
				txtGetPrtInfRet.setTextColor(Color.RED);
				edtGetPrtInf.setText("");
				txtDeviceType.setText("---");
			}
		}
		else if(v == btnAutoOpen)
		{
			boolean flgRet;
			int numAutoOpen = Integer.parseInt((String)spnOpenflg.getSelectedItem());


			flgRet = objLib.NAutoOpen(numAutoOpen);


			if(flgRet)
			{
				txtAutoOpenRet.setTextColor(Color.RED);
				txtAutoOpenRet.setText("ON");
			}
			else
			{
				txtAutoOpenRet.setTextColor(Color.BLACK);
				txtAutoOpenRet.setText("OFF");
			}
		}
		else if(v == btnFilePathCheck)
		{
			dlgFilepath.show();
		}
		else if(v == btnSettingCreate)
		{
			defaultSettingfileCreate();
		}
		else if(v == btnVersionCheck)
		{
			dlgVerCheck.show();
		}
		else if(v == btnBack01)
		{
			// Return top page
			finish();
		}
	}

	private void defaultSettingfileCreate()
	{
		InputStream objIn	= null;
		String filePath 	= Environment.getExternalStorageDirectory() + "/npi/";

		Resources res 		= this.getResources();

		// folder create
		File folder = new File(filePath);
		if(!folder.exists())
		{
			if(!folder.mkdir())
			{
				MessageBox("NPI folder create NG :" + filePath);
				return;
			}
		}

		String logFilePath = filePath + "log";
		File folder2 = new File(logFilePath);
		if(!folder2.exists())
		{
			if(!folder2.mkdir())
			{
				MessageBox("Log folder create NG :" + logFilePath);
				return;
			}
		}

		String imagePath = filePath + "image";
		File folder3 = new File(imagePath);
		if(!folder3.exists())
		{
			if(!folder3.mkdir())
			{
				MessageBox("Image folder create NG :" + logFilePath);
				return;
			}
		}


		// Log setting file
		File logFile = new File(filePath + "NLogInf");

		if(!logFile.exists())
		{
			objIn = res.openRawResource(R.raw.logsetting);

			if(!createFileWithInputStream(objIn, logFile))
			{
				return;
			}
		}


		// Barcode setting file
		File bcdFile = new File(filePath + "NBarcodeInf");

		if(!bcdFile.exists())
		{
			objIn = res.openRawResource(R.raw.barcodesetting);

			if(!createFileWithInputStream(objIn, bcdFile))
			{
				return;
			}
		}

		// test jpg file copy
		File jpgFile = new File(filePath + "printer.jpg");
		if(!jpgFile.exists())
		{
			objIn = res.openRawResource(R.drawable.test);

			if(!createFileWithInputStream(objIn, jpgFile))
			{
				return;
			}
		}

		File jpgFile2 = new File(filePath + "npilogo.jpg");
		if(!jpgFile2.exists())
		{
			objIn = res.openRawResource(R.drawable.npilogo);

			if(!createFileWithInputStream(objIn, jpgFile2))
			{
				return;
			}
		}

		File jpgFile3 = new File(filePath + "barcode2D.jpg");
		if(!jpgFile3.exists())
		{
			objIn = res.openRawResource(R.drawable.barcode2d);

			if(!createFileWithInputStream(objIn, jpgFile3))
			{
				return;
			}
		}

		File bmpFile = new File(filePath + "npilogo_2inch.bmp");
		if(!bmpFile.exists())
		{
			objIn = res.openRawResource(R.drawable.npilogo_2inch);

			if(!createFileWithInputStream(objIn, bmpFile))
			{
				return;
			}
		}

		File bmpFile2 = new File(filePath + "barcode2d_2inch.bmp");
		if(!bmpFile2.exists())
		{
			objIn = res.openRawResource(R.drawable.barcode2d_2inch);

			if(!createFileWithInputStream(objIn, bmpFile2))
			{
				return;
			}
		}

		File bmpFile3 = new File(filePath + "ticket02.bmp");
		if(!bmpFile3.exists())
		{
			objIn = res.openRawResource(R.drawable.ticket02);

			if(!createFileWithInputStream(objIn, bmpFile3))
			{
				return;
			}
		}


		dlgSetting.show();
	}

	private boolean createFileWithInputStream(InputStream inputStream, File destFile)
	{
	    byte[] buffer = new byte[1024];
	    int length = 0;
	    FileOutputStream fos = null;

	    try
	    {
	        fos = new FileOutputStream(destFile);

	        while ((length = inputStream.read(buffer)) > 0)
	        {
	            fos.write(buffer, 0, length);
	        }

	    }
	    catch(Exception e)
	    {
	    	MessageBox("file create NG : " + destFile.getName());
	    	return false;
	    }
	    finally
	    {
	        if (fos != null)
	        {
	            try
	            {
	                fos.close();
	            }
	            catch (IOException e)
	            {
	            }
	        }

	        if (inputStream != null)
	        {
	            try
	            {
	            	inputStream.close();
	            }
	            catch (IOException e)
	            {
	            }
	        }
	    }

	    return true;
	}

	private void MessageBox(String msg)
	{
		Toast.makeText(getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
	}
}
