/**
 * CITIZEN Android POS Print SDK
 * Copyright(C) 2012-2017 CITIZEN SYSTEMS JAPAN CO., LTD. All Rights Reserved.
 */
package com.citizen.sdk;

import com.citizen.csjposlib.libbase.LibPrinter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.hardware.usb.UsbDevice;

/**
 * Print control class
 * @version 1.18
 */
public class ESCPOSPrinter extends LibPrinter {

	public ESCPOSPrinter() {
	}

	/**
	 * This method is used to the USB connection and the search printer.
	 * @param context : Context (android.content.Context)
	 * @return Return value
	 */
	public int setContext(Context context) {
		return super.setContext(context);
	}

	/**
	 * This method is used to connect the printer.
	 * @param connectType : Connect type
	 * @param addr : IP address to connect or Bluetooth device address or Bluetooth device name
	 * @return Return value
	 */
	public int connect(int connectType, String addr) {
		return super.connect(connectType, addr);
	}

	/**
	 * This method is used to connect the printer.
	 * @param connectType : Connect type
	 * @param addr : IP address to connect or Bluetooth device address or Bluetooth device name
	 * @param port : Connection port numberc
	 * @return Return value
	 */
	public int connect(int connectType, String addr, int port) {
		return super.connect(connectType, addr, port);
	}

	/**
	 * This method is used to connect the printer.
	 * @param connectType : Connect type
	 * @param addr :IP address to connect or Bluetooth device address or Bluetooth device name
	 * @param port : Connection port number
	 * @param timeout : Timeout (msec)
	 * @return Return value
	 */
	public int connect(int connectType, String addr, int port, int timeout) {
		return super.connect(connectType, addr, port, timeout);
	}

	/**
	 * This method is used to connect the printer.
	 * @param connectType : Connect type
	 * @param device : UsbDevice class (android.hardware.usb.UsbDevice)
	 * @return Return value
	 */
	public int connect(int connectType, UsbDevice device) {
		return super.connect(connectType, device);
	}

	/**
	 * This method is used to disconnect the printer connection.
	 * @return Return value
	 */
	public int disconnect() {
		return super.disconnect();
	}

	/**
	 * This method is used to set the encoding of the send data to the printer.
	 * @param charset : Charcter set name
	 * @return Return value
	 */
	public int setEncoding(String charset) {
		return super.setEncoding(charset);
	}

	/**
	 * This method is used to send the command to get the status of the printer.
	 * @return Return value
	 */
	public int printerCheck() {
		return super.printerCheck();
	}

	/**
	 * This method is used to get the status of the printer obtained by the printerCheck method.
	 * @return Status
	 */
	public int status() {
		return super.status();
	}

	/**
	 * This method is used to get the status of the printer obtained by the printerCheck method.
	 * @param mask : Status type
	 * @return Status
	 */
	public int status(int mask) {
		return super.status(mask);
	}

	/**
	 * This method is used to print text which specifies alignment and attribute and size.
	 * @param data : Text data
	 * @param alignment : Text alignment
	 * @param attribute : Text attribute
	 * @param textSize : Text size
	 * @return Return value
	 */
	public int printText(String data, int alignment, int attribute, int textSize) {
		return super.printText(data, alignment, attribute, textSize);
	}

	/**
	 * This method is used to print text of fonts installed in the terminal which specifies alignment, font, size, style, and ratio.
	 * @param data : Text data
	 * @param alignment : Text alignment
	 * @param attribute : Text attribute
	 * @param textSize : Text size
	 * @return Return value
	 */

	/**
	 * This method is used to print text with space padding which specifies attribute and size and length of the single-byte character equivalent and side where space is added.
	 * @param data : Text data
	 * @param attribute : Text attribute
	 * @param textSize : Text size
	 * @param length : Print length
	 * @param side : Space add side
	 * @return Return value
	 */
	public int printPaddingText(String data, int attribute, int textSize, int length, int side) {
		return super.printPaddingText(data, attribute, textSize, length, side);
	}

	/**
	 * This method is used to print text by using a font installed in the computer, which specifies alignment, font, size, style, and ratio.
	 * @param data : Text data
	 * @param alignment : Text alignment
	 * @param fontType : Font type
	 * @param point : Font size
	 * @param style : Font style
	 * @param hRatio : Horizontal enlargement ratio
	 * @param vRatio : Vertical enlargement ratio
	 * @return Return value
	 */
	public int printTextLocalFont(String data, int alignment, Typeface fontType, int point, int style, int hRatio, int vRatio) {
		return super.printTextLocalFont(data, alignment, fontType, point, style, hRatio, vRatio);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param fileName : Bitmap file name
	 * @param alignment : Bitmap alignment
	 * @return Return value
	 */
	public int printBitmap(String fileName, int alignment) {
		return super.printBitmap(fileName, alignment);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param fileName : Bitmap file name
	 * @param width : Bitmap width
	 * @param alignment : Bitmap alignment
	 * @return Return value
	 */
	public int printBitmap(String fileName, int width, int alignment) {
		return super.printBitmap(fileName, width, alignment);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param fileName : Bitmap file name
	 * @param width : Bitmap width
	 * @param alignment : Bitmap alignment
	 * @param mode : Bitmap mode
	 * @return Return value
	 */
	public int printBitmap(String fileName, int width, int alignment, int mode) {
		return super.printBitmap(fileName, width, alignment, mode);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param bitmap : Bitmap type data
	 * @param alignment : Bitmap alignment
	 * @return Return value
	 */
	public int printBitmap(Bitmap bitmap, int alignment) {
		return super.printBitmap(bitmap, alignment);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param bitmap : Bitmap type data
	 * @param width : Bitmap width
	 * @param alignment : Bitmap alignment
	 * @return Return value
	 */
	public int printBitmap(Bitmap bitmap, int width, int alignment) {
		return super.printBitmap(bitmap, width, alignment);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param bitmap : Bitmap type data
	 * @param width : Bitmap width
	 * @param alignment : Bitmap alignment
	 * @param mode : Bitmap mode
	 * @return Return value
	 */
	public int printBitmap(Bitmap bitmap, int width, int alignment, int mode) {
		return super.printBitmap(bitmap, width, alignment, mode);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param byteData : Byte array representation of the bitmap
	 * @param alignment : Bitmap alignment
	 * @return Return value
	 */
	public int printBitmap(byte[] byteData, int alignment) {
		return super.printBitmap(byteData, alignment);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param byteData : Byte array representation of the bitmap
	 * @param width : Bitmap width
	 * @param alignment : Bitmap alignment
	 * @return Return value
	 */
	public int printBitmap(byte[] byteData, int width, int alignment) {
		return super.printBitmap(byteData, width, alignment);
	}

	/**
	 * This method is used to print bitmap which specifies file name or bitmap and width and alignment.
	 * @param byteData : Byte array representation of the bitmap
	 * @param width : Bitmap width
	 * @param alignment : Bitmap alignmentd
	 * @param mode : Bitmap mode
	 * @return Return value
	 */
	public int printBitmap(byte[] byteData, int width, int alignment, int mode) {
		return super.printBitmap(byteData, width, alignment, mode);
	}

	/**
	 * This method is used to store bitmap which specifies number, file name, width as parameters.
	 * @param number : Number of bitmap to store in the flash memory of the printer
	 * @param fileName : Bitmap file name
	 * @param width : Bitmap width
	 * @return Return value
	 */
	public int setNVBitmap(int number, String fileName, int width) {
		return super.setNVBitmap(number, fileName, width);
	}

	/**
	 * This method is used to store bitmap which specifies number, file name, width, mode as parameters.
	 * @param number : Number of bitmap to store in the flash memory of the printer
	 * @param fileName : Bitmap file name
	 * @param width : Bitmap width
	 * @param mode : Bitmap mode
	 * @return Return value
	 */
	public int setNVBitmap(int number, String fileName, int width, int mode) {
		return super.setNVBitmap(number, fileName, width, mode);
	}

	/**
	 * This method is used to print bitmap image (Logo) that is stored in the flash memory of the printer.
	 * @param nvImageNumber : Bitmap image number that is stored in the flash memory of the printer
	 * @return Return value
	 */
	public int printNVBitmap(int nvImageNumber) {
		return super.printNVBitmap(nvImageNumber);
	}

	/**
	 * This method is used to print one-dimensional barcode.
	 * @param data : Barcode data
	 * @param symbology : Barcode symbol type
	 * @param height : Barcode height
	 * @param width : Barcode horizontal size (magnification)
	 * @param alignment : Barcode alignment
	 * @param textPosition : HRI characters position
	 * @return Return value
	 */
	public int printBarCode(String data, int symbology, int height, int width,
			int alignment, int textPosition) {
		return super.printBarCode(data, symbology, height, width, alignment, textPosition);
	}

	/**
	 * This method is used to print PDF-417 barcode.
	 * @param data : Barcode data
	 * @param digits : Digits number
	 * @param steps : Steps number
	 * @param moduleWidth : Module width
	 * @param stepHeight : Height of step
	 * @param ECLevel : Error correction level
	 * @param alignment : Barcode alignment
	 * @return Return values
	 */
	public int printPDF417(String data, int digits, int steps, int moduleWidth,
			int stepHeight, int ECLevel, int alignment) {
		return super.printPDF417(data, digits, steps, moduleWidth, stepHeight, ECLevel, alignment);
	}

	/**
	 * This method is used to print QRCode barcode.
	 * @param data : Barcode data
	 * @param moduleSize : Module width
	 * @param ECLevel : Error correction level
	 * @param alignment : Barcode alignment
	 * @return Return value
	 */
	public int printQRCode(String data, int moduleSize, int ECLevel,
			int alignment) {
		return super.printQRCode(data, moduleSize, ECLevel, alignment);
	}

	/**
	 * This method is used to print 2-dimensional GS1 DataBar barcode.
	 * @param data : Barcode data
	 * @param symbology : Barcode symbol type
	 * @param moduleSize : Module width
	 * @param maxWidth : Max width
	 * @param alignment : Barcode alignment
	 * @return Return value
	 */
	public int printGS1DataBarStacked(String data, int symbology, int moduleSize, int maxWidth,
			int alignment) {
		return super.printGS1DataBarStacked(data, symbology, moduleSize, maxWidth, alignment);
	}

	/**
	 * This method is used to cut the paper.
	 * @param percentage : Cut type
	 * @return Return value
	 */
	public int cutPaper(int percentage) {
		return super.cutPaper(percentage);
	}

	/**
	 * This method is used to feed the paper in dot units.
	 * @param lfCount : Number of paper feed
	 * @return Return value
	 */
	public int unitFeed(int lfCount) {
		return super.unitFeed(lfCount);
	}

	/**
	 * This method is used to utilize label paper and black mark paper.
	 * @param type : Handling type of label paper or black mark paper
	 * @return Return value
	 */
	public int markFeed(int type) {
		return super. markFeed(type);
	}

	/**
	 * This method is used to open the cash drawer is connected to the printer.
	 * @param drawer : Cash drawer number
	 * @param pulseLen : Signal length
	 * @return Return value
	 */
	public int openDrawer(int drawer, int pulseLen) {
		return super.openDrawer(drawer, pulseLen);
	}

	/**
	 * This method is used to start or end a transaction mode.
	 * @param control : Transaction control
	 * @return Return value
	 */
	public int transactionPrint(int control) {
		return super.transactionPrint(control);
	}

	/**
	 * This method is used to start or end a rotation print mode.
	 * @param rotation : Direction of rotation
	 * @return Return value
	 */
	public int rotatePrint(int rotation) {
		return super.rotatePrint(rotation);
	}

	/**
	 * This method is used to start or end a Page Mode.
	 * @param control : Page Mode control
	 * @return Return value
	 */
	public int pageModePrint(int control) {
		return super.pageModePrint(control);
	}

	/**
	 * This method is used to clear the area defined by the PageModePrintArea property.
	 * @return Return value
	 */
	public int clearPrintArea() {
		return super.clearPrintArea();
	}

	/**
	 * This method is used to clear all buffered output data by tranzactionPrint method and pageModePrint method.
	 * @return Return value
	 */
	public int clearOutput() {
		return super.clearOutput();
	}

	/**
	 * This method is used to send data bytes to the printer directly.
	 * @param data : Send data
	 * @return Return value
	 */
	public int printData(byte[] data) {
		return super.printData(data);
	}

	/**
	 * This method is used to print using the escape sequences that are defined in the OPOS.
	 * @param data : Print data (Support OPOS escape sequence)
	 * @return Return value
	 */
	public int printNormal(String data) {
		return super.printNormal(data);
	}

	/**
	 * This method is used to get a numerical value for the version number of this library.
	 * @return Version code
	 */
	public int getVersionCode() {
		return super.getVersionCode();
	}

	/**
	 * This method is used to get a string for the version number of this library.
	 * @return Version Name
	 */
	public String getVersionName() {
		return super.getVersionName();
	}

	/**
	 * This method is used to print watermark.
	 * @param start : The start / Stop of the watermark print
	 * @param nvImageNumber : The NV image number that is stored in the flash memory of the printer
	 * @param pass : The first start position (vertical direction) of the watermark
	 * @param feed : The blank length each waternark
	 * @param repeat : The print number of times of the watermark
	 * @return Return value
	 */
	public int watermarkPrint(int start, int nvImageNumber, int pass, int feed, int repeat){
		return super.watermarkPrint(start, nvImageNumber, pass, feed, repeat);
	}

	/**
	 * This method is used to search the printer and get the list of printer information.
	 * @param ifType : Connect type
	 * @param searchTime : Search time
	 * @param status : Error code
	 * @return Return value
	 */
	public CitizenPrinterInfo[] searchCitizenPrinter(int ifType, int searchTime, int[] status)
	{
		return super.searchCitizenPrinter(ifType, searchTime, status);
	}

	/**
	 * This method is used to search the printer and get the list of addresses.
	 * @param ifType : Connect type
	 * @param searchTime : Search time
	 * @param status : Error code
	 * @return Return value
	 */
	public String[] searchESCPOSPrinter(int ifType, int searchTime, int[] status)
	{
		return super.searchESCPOSPrinter(ifType, searchTime, status);
	}

	/**
	 * Sets the logging function.
	 * @param mode : Logging mode
	 * @param path : File path to store
	 * @param maxSize : Maximum Log Size
	 */
	public void setLog(int mode, String path, int maxSize)
	{
		super.setLog(mode, path, maxSize);
	}

	/**
	 * @deprecated
	 */
	public int writeData(byte[] data) {
		return super.writeData(data);
	}

	/**
	 * @deprecated
	 */
	public byte[] readData(int timeout, int[] status) {
		return super.readData(timeout, status);
	}

	/**
	 * @deprecated
	 */
	public int getPageModeDescriptor() {
		return super.getPageModeDescriptor();
	}

	/**
	 * @deprecated
	 */
	public int getPageModeStation() {
		return super.getPageModeStation();
	}

	/**
	 * This property holds the page area.<br>
	 * Returns the page area as the return value.
	 * @return Page mode area
	 */
	public String getPageModeArea() {
		return super.getPageModeArea();
	}

	/**
	 * This property holds the print area of Page Mode.<br>
	 * Returns the Page Mode print area that is set as the return value.
	 * @return Page mode print area
	 */
	public String getPageModePrintArea() {
		return super.getPageModePrintArea();
	}

	/**
	 * This property holds the print area of Page Mode.<br>
	 * Please specify the property value that you want to set in the parameter.
	 * @param area : page mode print area
	 * @return Return value
	 */
	public int setPageModePrintArea(String area) {
		return super.setPageModePrintArea(area);
	}

	/**
	 * This property holds the print direction of the Page Mode print area.<br>
	 * Returns the print direction of Page Mode print area that is set as the return value.
	 * @return Page mode print direction
	 */
	public int getPageModePrintDirection() {
		return super.getPageModePrintDirection();
	}

	/**
	 * This property holds the print direction of the Page Mode print area.<br>
	 * Please specify the property value that you want to set in the parameter.
	 * @param direction : page mode print direction
	 * @return Return value
	 */
	public int setPageModePrintDirection(int direction) {
		return super.setPageModePrintDirection(direction);
	}

	/**
	 * This property holds the horizontal start position offset within the Page Mode print area.<br>
	 * Returns the horizontal position of Page Mode print area that is set as the return value.
	 * @return Page mode horizontal position
	 */
	public int getPageModeHorizontalPosition() {
		return super.getPageModeHorizontalPosition();
	}

	/**
	 * This property holds the horizontal start position offset within the Page Mode print area.<br>
	 * Please specify the property value that you want to set in the parameter.
	 * @param position : mode horizontal position
	 * @return Return value
	 */
	public int setPageModeHorizontalPosition(int position) {
		return super.setPageModeHorizontalPosition(position);
	}

	/**
	 * This property holds the vertical start position offset within the Page Mode print area.<br>
	 * Returns the vertical position of Page Mode print area that is set as the return value.
	 * @return Page mode vertical position
	 */
	public int getPageModeVerticalPosition() {
		return super.getPageModeVerticalPosition();
	}

	/**
	 * This property holds the vertical start position offset within the Page Mode print area.<br>
	 * Please specify the property value that you want to set in the parameter.
	 * @param position : page mode vertical position
	 * @return Return value
	 */
	public int setPageModeVerticalPosition(int position) {
		return super.setPageModeVerticalPosition(position);
	}

	/**
	 * This property holds the spacing of each single-high print line, including both the printed line height plus the whitespace between each pair of lines.<br>
	 * Returns the spacing of each single-high print line that is set as the return value.
	 * @return Line spacing
	 */
	public int getRecLineSpacing() {
		return super.getRecLineSpacing();
	}

	/**
	 * This property holds the spacing of each single-high print line, including both the printed line height plus the whitespace between each pair of lines.<br>
	 * Please specify the property value that you want to set in the parameter.
	 * @param space : rec line space
	 * @return Return value
	 */
	public int setRecLineSpacing(int space) {
		return super.setRecLineSpacing(space);
	}

	/**
	 * This property holds the mapping mode of the printer.<br>
	 * Returns the mapping mode that is set as the return value.
	 * @return Map mode
	 */
	public int getMapMode() {
		return super.getMapMode();
	}

	/**
	 * This property holds the mapping mode of the printer.<br>
	 * Please specify the property value that you want to set in the parameter.
	 * @param mode : Map mode
	 * @return Return value
	 */
	public int setMapMode(int mode) {
		return super.setMapMode(mode);
	}

	/**
	 * @deprecated
	 */
	public int getMapmode() {
		return super.getMapMode();
	}

	/**
	 * @deprecated
	 */
	public int getRecLineWidth() {
		return super.getRecLineWidth();
	}

	/**
	 * @deprecated
	 */
	public int setRecLineWidth(int width) {
		return super.setRecLineWidth(width);
	}

}
