package com.citizen.app.pos.sample2;

import com.citizen.sdk.ESCPOSConst;
import com.citizen.sdk.ESCPOSPrinter;

import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.hardware.usb.UsbDevice;
//----------------------------------------------------------------------------------------------
//<English>
// Caution
// This application is a smallest print example program that was used CSJPOSLib_Android.jar.
// If you tap the button on the screen continuously, this application may be forced termination
// by ANR keyDispatchingTimedOut because the code is minimal. Please acknowledge it.
// If you want to avoid a forced termination, please do not be able to tap the button on
// the screen continuously.
//----------------------------------------------------------------------------------------------
//<Japanese>
// 注意
// 本アプリケーションは、CSJPOSLib_Android.jar を利用した最小の印刷プログラム例です。
// 最小限のコードのため、実行画面のボタンを連続でタップした場合に本アプリケーションは、
// ANR keyDispatchingTimedOut により強制終了する場合があります。ご了承ください。
// 強制終了を回避する場合は、実行画面のボタンを連続でタップできないようにしてください。
//----------------------------------------------------------------------------------------------
public class MainActivity extends Activity {
//	private ESCPOSPrinter posPtr = null;
	private EditText editText_Address_WiFi;
	private Button button_Status_WiFi;
	private Button button_Print_WiFi;
	private Button button_Connect_WiFi;
	private Button button_Disconnect_WiFi;
	private EditText editText_Address_Bluetooth;
	private Button button_Status_Bluetooth;
	private Button button_Print_Bluetooth;
	private Button button_Connect_Bluetooth;
	private Button button_Disconnect_Bluetooth;
//	private EditText editText_UsbDevice;
	private Button button_Status_USB;
	private Button button_Print_USB;
	private Button button_Connect_USB;
	private Button button_Disconnect_USB;

	final String PREFERENCES_NAME = "Citizen_PSample_for_PosPrinterLibraly";
	final String PRE_KEY_IP_ADDRESS = "IP_Address";
	final String DEFAULT_IP_ADDRESS = "192.168.129.222";
	final String PRE_KEY_BLUETOOTH_ADDRESS = "Bluetooth_Address";
	final String DEFAULT_BLUETOOTH_ADDRESS = "00:01:90:E8:03:33";
	//
	private ESCPOSPrinter posPtr_WiFi;
	private ESCPOSPrinter posPtr_Bluetooth;
	private ESCPOSPrinter posPtr_USB;


	@Override
	public void onCreate( Bundle savedInstanceState ) {
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_main );

		//
		editText_Address_WiFi = ( EditText ) findViewById( R.id.editText_Address_WiFi );
		editText_Address_Bluetooth = ( EditText ) findViewById( R.id.editText_Address_Bluetooth );
//		editText_UsbDevice = ( EditText ) findViewById( R.id.editText_UsbDevice );
		//
		editText_Address_WiFi.setText( loadAddress( ESCPOSConst.CMP_PORT_WiFi ) );
		editText_Address_Bluetooth.setText( loadAddress( ESCPOSConst.CMP_PORT_Bluetooth ) );
//		editText_UsbDevice.setText( R.string.hint_usbdevice );
		//
		posPtr_WiFi = new ESCPOSPrinter();			// for Wi-Fi
		posPtr_Bluetooth = new ESCPOSPrinter();		// for Bluetooth
		posPtr_USB = new ESCPOSPrinter();			// for USB
		posPtr_USB.setContext( this );				// for USB only


		//
		// Connect Button - Wi-Fi
		//
		button_Connect_WiFi = ( Button ) findViewById( R.id.button_Connect_WiFi );
		button_Connect_WiFi.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				//
				// Get Address
				String addr = editText_Address_WiFi.getText().toString();
				//
				// Connect
				connect( posPtr_WiFi, ESCPOSConst.CMP_PORT_WiFi, addr );
			}
		} );
		//
		// Disconnect Button - Wi-Fi
		//
		button_Disconnect_WiFi = ( Button ) findViewById( R.id.button_Disconnect_WiFi );
		button_Disconnect_WiFi.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				disconnect( posPtr_WiFi );
			}
		} );
		//
		// Printer Status Button - Wi-Fi
		//
		button_Status_WiFi = ( Button ) findViewById( R.id.button_Status_WiFi );
		button_Status_WiFi.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				printerCheck( posPtr_WiFi );
			}
		} );
		//
		// Print Button - Wi-Fi
		//
		button_Print_WiFi = ( Button ) findViewById( R.id.button_Print_WiFi );
		button_Print_WiFi.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				boolean b = print( posPtr_WiFi );
			}
		} );


		//
		// Connect Button - Bluetooth
		//
		button_Connect_Bluetooth = ( Button ) findViewById( R.id.button_Connect_Bluetooth );
		button_Connect_Bluetooth.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				//
				// Get Address
				String addr = editText_Address_Bluetooth.getText().toString();
				//
				// Connect
//				connect( posPtr_Bluetooth, ESCPOSConst.CMP_PORT_Bluetooth, addr );				// Android 2.3.2 ( API Level 9 ) or before
				connect( posPtr_Bluetooth, ESCPOSConst.CMP_PORT_Bluetooth_Insecure, addr );		// Android 2.3.3 ( API Level 10 ) or later
			}
		} );
		//
		// Disconnect Button - Bluetooth
		//
		button_Disconnect_Bluetooth = ( Button ) findViewById( R.id.button_Disconnect_Bluetooth );
		button_Disconnect_Bluetooth.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				disconnect( posPtr_Bluetooth );
			}
		} );
		//
		// Printer Status Button - Bluetooth
		//
		button_Status_Bluetooth = ( Button ) findViewById( R.id.button_Status_Bluetooth );
		button_Status_Bluetooth.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				printerCheck( posPtr_Bluetooth );
			}
		} );
		//
		// Print Button - Bluetooth
		//
		button_Print_Bluetooth = ( Button ) findViewById( R.id.button_Print_Bluetooth );
		button_Print_Bluetooth.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				print( posPtr_Bluetooth );
			}
		} );


		//
		// Connect Button - USB
		//
		button_Connect_USB = ( Button ) findViewById( R.id.button_Connect_USB );
		button_Connect_USB.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				//
				// Get UsbDevice
//				String addr = editText_UsbDevice.getText().toString();
				UsbDevice usbDevice = null;										// null (Automatic detection)
				//
				// Connect
				connect( posPtr_USB, ESCPOSConst.CMP_PORT_USB, usbDevice );		// Android 3.1 ( API Level 12 ) or later
			}
		} );
		//
		// Disconnect Button - USB
		//
		button_Disconnect_USB = ( Button ) findViewById( R.id.button_Disconnect_USB );
		button_Disconnect_USB.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				disconnect( posPtr_USB );
			}
		} );
		//
		// Printer Status Button - USB
		//
		button_Status_USB = ( Button ) findViewById( R.id.button_Status_USB );
		button_Status_USB.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				printerCheck( posPtr_USB );
			}
		} );
		//
		// Print Button - USB
		//
		button_Print_USB = ( Button ) findViewById( R.id.button_Print_USB );
		button_Print_USB.setOnClickListener( new OnClickListener()
		{
			public void onClick( View v )
			{
				print( posPtr_USB );
			}
		} );

	}


	//
	// connect - Wi-Fi / Bluetooth
	//
	private boolean connect( ESCPOSPrinter posPtr, int connectType, String addr )
	{
		int result;
		boolean bRet = false;

		if ( null == posPtr )
		{
			toast( "ESCPOSPrinter() : Instance is not created", Toast.LENGTH_LONG );
			return bRet;
		}
		//
		// Connect
		result = posPtr.connect( connectType, addr );
		if ( ESCPOSConst.CMP_SUCCESS == result )
		{
			// connect() Success
			bRet = true;
			toast( "connect() : Success", Toast.LENGTH_SHORT );
			saveAddress( connectType, addr );
		}
		else
		{
			// connect() Error
			toast( "connect() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
		}
		return bRet;
	}
	//
	// connect - USB
	//
	private boolean connect( ESCPOSPrinter posPtr, int connectType, UsbDevice usbDevice )
	{
		int result;
		boolean bRet = false;

		if ( null == posPtr )
		{
			toast( "ESCPOSPrinter() : Instance is not created", Toast.LENGTH_LONG );
			return bRet;
		}
		//
		// Connect
		result = posPtr.connect( connectType, usbDevice );
		if ( ESCPOSConst.CMP_SUCCESS == result )
		{
			// connect() Success
			bRet = true;
			toast( "connect() : Success", Toast.LENGTH_SHORT );
		}
		else
		{
			// connect() Error
			toast( "connect() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
		}
		return bRet;
	}


	//
	// disconnect
	//
	private boolean disconnect( ESCPOSPrinter posPtr )
	{
		int result;
		boolean bRet = false;

		if ( null == posPtr )
		{
			toast( "ESCPOSPrinter() : Instance is not created", Toast.LENGTH_LONG );
			return bRet;
		}
		//
		// Disconnect
		result = posPtr.disconnect();
		if ( ESCPOSConst.CMP_SUCCESS == result )
		{
			toast( "disconnect() : Success", Toast.LENGTH_SHORT );
		}
		else
		{
			toast( "disconnect() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
		}
		return bRet;
	}


	//
	// Printer Check & Status
	//
	private boolean printerCheck( ESCPOSPrinter posPtr )
	{
		int result;
		boolean bRet = false;
		String msg = "";

		//
		if ( null == posPtr )
		{
			msg += "\nESCPOSPrinter() : Instance is not created";
		}
		else
		{
			//
			// Printer Check
			result = posPtr.printerCheck();
			if ( ESCPOSConst.CMP_SUCCESS == result ) {
				msg += "\nprinterCheck() : Success\n";
				//
				// Get Status
				int status = posPtr.status();
				msg += "\nstatus() : ";
				//
				// Status Check
				if ( ESCPOSConst.CMP_STS_NORMAL == status ) {
					//
					// No Error
					bRet = true;
					msg += "\n\t * Normal ( No Error )";
				} else {
					if ( ( ESCPOSConst.CMP_STS_COVER_OPEN & status ) > 0 ) {
						//
						// Cover Open
						msg += "\n\t * Cover Open";
					}
					if ( ( ESCPOSConst.CMP_STS_PAPER_EMPTY & status ) > 0 ) {
						//
						// Paper Empty
						msg += "\n\t * Paper Empty";
					}
					if ( ( ESCPOSConst.CMP_STS_PRINTEROFF & status ) > 0 ) {
						//
						// Printer Offline
						msg += "\n\t * Printer Offline";
					}
				}
			} else {
				//
				// printerCheck() Error
				msg += "\nprinterCheck() Error : " + Integer.toString( result );
			}
		}
		if ( !msg.equals( "" ) )
		{
			alertDialog( "printerCheck() & staus() result", msg );
		}
		return bRet;
	}
	private void alertDialog( String title, String message )
	{
		new AlertDialog.Builder( this )
		.setTitle( title )
		.setMessage( message )
		.setPositiveButton( "OK", null )
		.show();
	}


	//
	// print
	//
	private boolean print( ESCPOSPrinter posPtr )
	{
		int result;

		if ( null == posPtr )
		{
			toast( "ESCPOSPrinter() : Instance is not created", Toast.LENGTH_LONG );
			return false;
		}

		// Printer Check
		result = posPtr.printerCheck();
		if ( ESCPOSConst.CMP_SUCCESS != result ) {
			toast( "printerCheck() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
			return false;
		}

		// Get Status
		result = posPtr.status();
		if ( ESCPOSConst.CMP_STS_NORMAL != result ) {
			toast( "Status Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
			return false;
		}

		// Character set
		result = posPtr.setEncoding( "ISO-8859-1" );	// Latin-1
		//result = posPtr.setEncoding( "Shift_JIS" );		// Japanese 日本語を印字する場合は、この行を有効にしてください.
		if ( ESCPOSConst.CMP_SUCCESS != result )
		{
			toast( "setEncoding() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
			return false;
		}

		try{
			// Start Transaction ( Batch )
			result = posPtr.transactionPrint( ESCPOSConst.CMP_TP_TRANSACTION );
			if ( ESCPOSConst.CMP_SUCCESS != result )
			{
				toast( "transactionPrint() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
				throw new RuntimeException();
			}

			// Print text
			result = posPtr.printText( getString( R.string.app_name ) + "\n\n- Sample Print -\n1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT );
			if ( ESCPOSConst.CMP_SUCCESS != result )
			{
				toast( "printText() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
				throw new RuntimeException();
			}

			// Partial Cut with Pre-Feed
			result = posPtr.cutPaper( ESCPOSConst.CMP_CUT_PARTIAL_PREFEED );
			if ( ESCPOSConst.CMP_SUCCESS != result )
			{
				toast( "cutPaper() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
				throw new RuntimeException();
			}

			// End Transaction ( Batch )
			result = posPtr.transactionPrint( ESCPOSConst.CMP_TP_NORMAL );
			if ( ESCPOSConst.CMP_SUCCESS != result )
			{
				toast( "transactionPrint() Error : " + Integer.toString( result ), Toast.LENGTH_LONG );
				throw new RuntimeException();
			}
		}
		catch (RuntimeException e)
		{
			// Clear all buffered output data by tranzactionPrint.
			posPtr.clearOutput();
			return false;
		}
		toast( "Print Success ", Toast.LENGTH_LONG );
		return true;
	}
	private void toast( String message, int duration )
	{
		Toast toast = Toast.makeText( getApplicationContext(), message, duration );
		toast.setGravity( Gravity.CENTER, 0, 0 );
		toast.show();
	}


	//
	// Save & Load Address
	//
	private void saveAddress( int portType, String address )
	{
		switch ( portType )
		{
		case ESCPOSConst.CMP_PORT_WiFi:
			savePreferences( PRE_KEY_IP_ADDRESS, address );
			break;
		case ESCPOSConst.CMP_PORT_Bluetooth:
		case ESCPOSConst.CMP_PORT_Bluetooth_Insecure:
			savePreferences( PRE_KEY_BLUETOOTH_ADDRESS, address );
			break;
		default:
			break;
		}
	}
	private String loadAddress( int portType )
	{
		String address = "";
		switch ( portType )
		{
		case ESCPOSConst.CMP_PORT_WiFi:
			address = loadPreferences( PRE_KEY_IP_ADDRESS, DEFAULT_IP_ADDRESS );
			break;
		case ESCPOSConst.CMP_PORT_Bluetooth:
		case ESCPOSConst.CMP_PORT_Bluetooth_Insecure:
			address = loadPreferences( PRE_KEY_BLUETOOTH_ADDRESS, DEFAULT_BLUETOOTH_ADDRESS );
			break;
		default:
			break;
		}
		return address;
	}
	private void savePreferences( String sKeyName, String sValue )
	{
		SharedPreferences sp = getSharedPreferences( PREFERENCES_NAME, Activity.MODE_PRIVATE );
		Editor e = sp.edit();
		e.putString( sKeyName, sValue );
		e.commit();
	}
	private String loadPreferences( String sKeyName, String sDefaultValue )
	{
		SharedPreferences sp = getSharedPreferences( PREFERENCES_NAME, Activity.MODE_PRIVATE );
		return sp.getString( sKeyName, sDefaultValue );
	}

}
