#!/bin/sh
#\
	exec tcl "$0" "$@"

set PORT ""
set IMAGE_HOME [lindex $argv 0]

set format \
{%s
[Desktop Entry]
SwallowExec=
SwallowTitle=
Name=MASTouch
BinaryPattern=
MimeType=
Exec=tclsh /usr/local/TouchKit/diag/touchkit.tcl /usr/local/TouchKit/
Icon=/usr/local/TouchKit/image/touch.png
TerminalOptions=
Type=Application
Terminal=0
}

set InstallMode [string compare $IMAGE_HOME remove]


set HomeList [glob -nocomplain /usr/share/applications]
lappend HomeList /root /etc/skel
foreach HOME $HomeList {
	foreach COMMENT {""} \
		ENV	{""} \
		NAME	{"TouchKit.desktop"} 	{
		if { $InstallMode } {
			if { ! [catch {open $HOME/$NAME "w"} file] } {
				puts $file [format $format $COMMENT $ENV $PORT $IMAGE_HOME]
				close $file
				set tokens [split $HOME "/"]
				set username [lindex $tokens end]
				catch {exec chown $username:$username $WHERE/$NAME}
				catch {exec chmod +x $WHERE/$NAME}
			}
		} else {
			catch {file delete -force $HOME/$NAME}
		}
	}
}

