/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.api;

import com.meiglobal.ebds.api.AuditContainer;
import com.meiglobal.ebds.api.EBDS_SerialPort;
import com.meiglobal.ebds.api.Message;
import com.meiglobal.ebds.api.Messenger;
import com.meiglobal.ebds.api.WrappedSerialPort;
import com.meiglobal.ebds.api.event.AcceptorEvent;
import com.meiglobal.ebds.api.event.AcceptorEventListener;
import com.meiglobal.ebds.api.event.AcceptorEventSource;
import com.meiglobal.ebds.api.event.CalibrateFinishEvent;
import com.meiglobal.ebds.api.event.CalibrateProgressEvent;
import com.meiglobal.ebds.api.event.CalibrateStartEvent;
import com.meiglobal.ebds.api.event.CashBoxAttachedEvent;
import com.meiglobal.ebds.api.event.CashBoxCleanlinessDetected;
import com.meiglobal.ebds.api.event.CashBoxRemovedEvent;
import com.meiglobal.ebds.api.event.CheatedEvent;
import com.meiglobal.ebds.api.event.ClearAuditCompleteEvent;
import com.meiglobal.ebds.api.event.ConnectedEvent;
import com.meiglobal.ebds.api.event.DisconnectedEvent;
import com.meiglobal.ebds.api.event.DownloadFinishEvent;
import com.meiglobal.ebds.api.event.DownloadProgressEvent;
import com.meiglobal.ebds.api.event.DownloadRestartEvent;
import com.meiglobal.ebds.api.event.DownloadStartEvent;
import com.meiglobal.ebds.api.event.EscrowEvent;
import com.meiglobal.ebds.api.event.FailureClearedEvent;
import com.meiglobal.ebds.api.event.FailureDetectedEvent;
import com.meiglobal.ebds.api.event.InvalidCommandEvent;
import com.meiglobal.ebds.api.event.JamClearedEvent;
import com.meiglobal.ebds.api.event.JamDetectedEvent;
import com.meiglobal.ebds.api.event.NoteRetrievedEvent;
import com.meiglobal.ebds.api.event.PUPEscrowEvent;
import com.meiglobal.ebds.api.event.PauseClearedEvent;
import com.meiglobal.ebds.api.event.PauseDetectedEvent;
import com.meiglobal.ebds.api.event.PowerUpCompleteEvent;
import com.meiglobal.ebds.api.event.PowerUpEvent;
import com.meiglobal.ebds.api.event.RejectedEvent;
import com.meiglobal.ebds.api.event.ReturnedEvent;
import com.meiglobal.ebds.api.event.SendMessageFailureEvent;
import com.meiglobal.ebds.api.event.StackedEvent;
import com.meiglobal.ebds.api.event.StackerFullClearedEvent;
import com.meiglobal.ebds.api.event.StackerFullEvent;
import com.meiglobal.ebds.api.event.StallClearedEvent;
import com.meiglobal.ebds.api.event.StallDetectedEvent;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.AuditLifeTimeTotals;
import com.meiglobal.ebds.api.pub.AuditPerformance;
import com.meiglobal.ebds.api.pub.AuditQP;
import com.meiglobal.ebds.api.pub.BNFErrorStatus;
import com.meiglobal.ebds.api.pub.BNFStatus;
import com.meiglobal.ebds.api.pub.Bezel;
import com.meiglobal.ebds.api.pub.Bill;
import com.meiglobal.ebds.api.pub.CashBoxCleanlinessEnum;
import com.meiglobal.ebds.api.pub.Coupon;
import com.meiglobal.ebds.api.pub.DocumentType;
import com.meiglobal.ebds.api.pub.Orientation;
import com.meiglobal.ebds.api.pub.OrientationControl;
import com.meiglobal.ebds.api.pub.PowerUp;
import com.meiglobal.ebds.api.pub.PupExt;
import com.meiglobal.ebds.api.pub.State;
import com.meiglobal.ebds.api.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acceptor
extends AcceptorEventSource
implements AcceptorEventListener {
    private static final String VERSION = "V2.80, 286030280";
    private static final byte CMD_OMNIBUS = 16;
    private static final byte CMD_CALIBRATE = 64;
    private static final byte CMD_FLASH_DOWNLOAD = 80;
    private static final byte CMD_AUXILIARY = 96;
    private static final byte CMD_EXPANDED = 112;
    private static final byte CMD_AUX_QUERY_SOFTWARE_CRC = 0;
    private static final byte CMD_AUX_QUERY_CASHBOX_TOTAL = 1;
    private static final byte CMD_AUX_QUERY_DEVICE_RESETS = 2;
    private static final byte CMD_AUX_CLEAR_CASHBOX_TOTAL = 3;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_TYPE = 4;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_SN = 5;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_BPN = 6;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_APN = 7;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_VN = 8;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_VPN = 9;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_AUDIT_LTT = 10;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_AUDIT_QPM = 11;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_AUDIT_PM = 12;
    private static final byte CMD_AUX_QUERY_DEVICE_CAPABILITIES = 13;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_AID = 14;
    private static final byte CMD_AUX_QUERY_ACCEPTOR_VID = 15;
    private static final byte CMD_AUX_QUERY_BNF_STATUS = 16;
    private static final byte CMD_AUX_SET_BEZEL = 17;
    private static final byte CMD_AUX_QUERY_ASSET_NUMBER = 21;
    static final int COMMUNICATION_DISCONNECT_TIMEOUT = 30000;
    static final int POWERUP_REARM_TIME = 2000;
    private static final int TIMEOUT_CALIBRATE = 3000;
    private static final double[] COUPON_VALUES = new double[]{0.0, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0};
    private EBDS_SerialPort _transport = null;
    private boolean _connected = false;
    private boolean _isInFailedState = false;
    private boolean _autoStack;
    private boolean _enableAcceptance;
    private State _deviceState = State.Disconnected;
    private boolean _docTypeWasSetOnEscrow;
    private BNFStatus _bnfStatus = BNFStatus.Unknown;
    private boolean _suppressStandardPoll;
    private boolean _replyAcked = false;
    private boolean _isVeryFirstPoll = true;
    private boolean _inSoftResetWaitForReply = false;
    private boolean _capabilitiesProcessed = false;
    private int _disconnectTimeout = 30000;
    private boolean _bDisabledWhileAccpeting = false;
    private BNFErrorStatus _bnfErrorStatus = BNFErrorStatus.NoError;
    private FlashDownloadThread _flashDownloadThread = null;
    private ConnectorThread _openThread = null;
    private Messenger _workerThread = null;
    private int _transactionTimeout = 50;
    private int _downloadTimeout = 250;
    private String _port;
    private PowerUp _powerUp = null;
    private String _barCode;
    private Bill _bill;
    private Coupon _coupon;
    private DocumentType _docType;
    private String _debugLogPath = ".";
    private boolean _debugLog;
    private BufferedWriter _logWriter;
    private SimpleDateFormat _logFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private List<Bill> _lstBillTypes = new LinkedList<Bill>();
    private List<Bill> _lstBillValues = new LinkedList<Bill>();
    private List<Boolean> _lstBillValueEnables = new LinkedList<Boolean>();
    private List<Boolean> _lstBillTypeEnables = new LinkedList<Boolean>();
    private Orientation _escrowOrientation;
    private boolean _enableBookmarks;
    private boolean _highSecurity;
    private OrientationControl _orientationControl = OrientationControl.FourWay;
    private OrientationControl _orientationControlExt = OrientationControl.FourWay;
    private boolean _enableNoPush;
    private boolean _enableBarCodes;
    private boolean _expandedNoteReporting;
    private boolean _enableCouponExt;
    private boolean _cheated;
    private boolean _isDeviceJammed;
    private boolean _cashBoxFull;
    private boolean _cashBoxAttached;
    private boolean _devicePaused;
    private boolean _isPoweredUp;
    private boolean _isQueryDeviceCapabilitiesSupported;
    private long _deviceModel;
    private long _deviceRevision;
    LinkedList<Message> _cmdQueue;
    LinkedList<byte[]> _replyQueue;
    boolean _inSoftResetOneSecondIgnore;
    private boolean _raiseConnectedEvent;
    private boolean _raiseDisconnectedEvent;
    private boolean _raiseEscrowEvent;
    private boolean _raisePUPEscrowEvent;
    private boolean _raiseStackedEvent;
    private boolean _raiseReturnedEvent;
    private boolean _raiseRejectedEvent;
    private boolean _raiseCheatedEvent;
    private boolean _raiseStackerFullEvent;
    private boolean _raiseStackerFullClearedEvent;
    private boolean _raiseCalibrateProgressEvent;
    private boolean _raiseCalibrateFinishEvent;
    private boolean _raiseDownloadRestartEvent;
    private boolean _raisePauseDetectedEvent;
    private boolean _raisePauseClearedEvent;
    private boolean _raiseStallDetectedEvent;
    private boolean _raiseStallClearedEvent;
    private boolean _raiseJamDetectedEvent;
    private boolean _raiseJamClearedEvent;
    boolean _raisePowerUpEvent;
    private boolean _raisePowerUpCompleteEvent;
    private boolean _raiseCashBoxAttachedEvent;
    private boolean _raiseCashBoxRemovedEvent;
    private boolean _raiseFailureDetectedEvent;
    private boolean _raiseFailureClearedEvent;
    private boolean _capAdvBookmark;
    private boolean _capApplicationId;
    private boolean _capApplicationPN;
    private boolean _capAssetNumber;
    private boolean _capAudit;
    private boolean _capBarCodes;
    private boolean _capBarCodesExt;
    private boolean _capBNFStatus;
    private boolean _capBookmark;
    private boolean _capBootPN;
    private boolean _capCalibrate;
    private boolean _capCashBoxTotal;
    private boolean _capClearAudit;
    private boolean _capCouponExt;
    private boolean _capDevicePaused;
    private boolean _capDeviceSoftReset;
    private boolean _capDeviceType;
    private boolean _capDeviceResets;
    private boolean _capDeviceSerialNumber;
    private boolean _capEasitrax;
    private boolean _capEscrowTimeout;
    private boolean _capFlashDownload;
    private boolean _capNoPush;
    private boolean _capNoteRetrieved;
    private boolean _capOrientationExt;
    private boolean _capPupExt;
    private boolean _capSetBezel;
    private boolean _capTestDoc;
    private boolean _capVariantId;
    private boolean _capVariantPN;

    public Acceptor() {
        this.addAcceptorEventListener(this);
        this._debugLog = false;
        this.init();
    }

    private void init() {
        this._capabilitiesProcessed = false;
        this._deviceModel = Long.MIN_VALUE;
        this._deviceRevision = Long.MIN_VALUE;
        this._cmdQueue = new LinkedList();
        this._replyQueue = new LinkedList();
        this._inSoftResetOneSecondIgnore = false;
        this._raiseConnectedEvent = false;
        this._raiseDisconnectedEvent = false;
        this._raiseEscrowEvent = true;
        this._raisePUPEscrowEvent = true;
        this._raiseStackedEvent = false;
        this._raiseReturnedEvent = false;
        this._raiseRejectedEvent = false;
        this._raiseCheatedEvent = false;
        this._raiseStackerFullEvent = true;
        this._raiseStackerFullClearedEvent = false;
        this._raiseCalibrateProgressEvent = true;
        this._raiseCalibrateFinishEvent = false;
        this._raiseDownloadRestartEvent = true;
        this._raisePauseDetectedEvent = true;
        this._raisePauseClearedEvent = false;
        this._raiseStallDetectedEvent = true;
        this._raiseStallClearedEvent = false;
        this._raiseJamDetectedEvent = true;
        this._raiseJamClearedEvent = false;
        this._raisePowerUpEvent = true;
        this._raisePowerUpCompleteEvent = false;
        this._raiseCashBoxAttachedEvent = false;
        this._raiseCashBoxRemovedEvent = true;
        this._raiseFailureDetectedEvent = true;
        this._raiseFailureClearedEvent = false;
    }

    public static String[] listPorts() {
        return WrappedSerialPort.listPorts();
    }

    public boolean getSupressStandardPoll() {
        return this._suppressStandardPoll;
    }

    public boolean stopDownload() {
        if (this._flashDownloadThread != null && this._flashDownloadThread.isAlive()) {
            this._flashDownloadThread.stopThread();
        }
        return true;
    }

    public void open(String port) throws AcceptorException {
        this.open(port, PowerUp.A);
    }

    public void open(String port, PowerUp powerUp) throws AcceptorException {
        if (this._connected) {
            throw new AcceptorException("Open cannot be called when Connected == true");
        }
        this.init();
        this._transport = new EBDS_SerialPort(this);
        this._powerUp = powerUp == null ? PowerUp.A : powerUp;
        this._port = port;
        if (this._debugLog) {
            this.openLogFile();
        }
        this._transport.openPort(this._port);
        this._openThread = new ConnectorThread();
        this._openThread.setName("open thread");
        this._openThread.start();
        this._workerThread = new Messenger(this);
        this._workerThread.setName("worker thread");
        this._workerThread.start();
    }

    public void close() {
        if (this._flashDownloadThread != null && this._flashDownloadThread.isAlive()) {
            try {
                this._flashDownloadThread.stopThread();
                this._flashDownloadThread.join();
            }
            catch (InterruptedException ie) {
                this.log("Exception while waiting for flashdownloadthread to finish: " + ie.getMessage());
            }
        } else if (!this._connected && this._openThread != null && this._openThread.isAlive()) {
            this._raiseDisconnectedEvent = true;
            this._openThread.stopThread();
        }
        boolean bNeedOneMorePoll = this._enableAcceptance;
        this._enableAcceptance = false;
        try {
            if (this._workerThread != null) {
                this._workerThread.stopThread(bNeedOneMorePoll);
                this._workerThread.join();
            }
        }
        catch (InterruptedException ie) {
            this.log("Exception while waiting for workerthread to finish: " + ie.getMessage());
        }
        if (this._transport != null) {
            this._transport.close();
        }
        this._port = "";
        this._connected = false;
        if (this._raiseDisconnectedEvent) {
            this.raiseDisconnectedEvent();
        }
        if (this._debugLog) {
            this.closeLogFile();
        }
    }

    public void escrowReturn() throws AcceptorException {
        this.verifyConnected("EscrowReturn");
        byte[] payload = this.constructOmnibusCommand(4, (byte)16, 1);
        payload[2] = (byte)(payload[2] | 0x40);
        this.sendAsynchronousCommand(payload, "EscrowReturn command");
    }

    public void escrowStack() throws AcceptorException {
        this.verifyConnected("EscrowStack");
        byte[] payload = this.constructOmnibusCommand(4, (byte)16, 1);
        payload[2] = (byte)(payload[2] | 0x20);
        this.sendAsynchronousCommand(payload, "EscrowStack command");
    }

    public String getApplicationId() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capApplicationId, "ApplicationID");
        byte[] payload = new byte[]{96, 0, 0, 14};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryApplicationID");
        if (thisReply.length == 14) {
            byte[] response = new byte[9];
            System.arraycopy(thisReply, 3, response, 0, 9);
            return new String(response);
        }
        return "";
    }

    public String getApplicationPN() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capApplicationPN, "ApplicationPN");
        byte[] payload = new byte[]{96, 0, 0, 7};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryApplicationPN");
        if (thisReply.length == 14) {
            byte[] response = new byte[9];
            System.arraycopy(thisReply, 3, response, 0, 9);
            return new String(response);
        }
        return "";
    }

    public AuditLifeTimeTotals GetAuditLifeTimeTotals() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capAudit, "AuditLifeTimeTotals");
        ArrayList<Integer> values = null;
        int counter = 0;
        do {
            values = new ArrayList<Integer>();
            byte[] payload = new byte[]{96, 0, 0, 10};
            byte[] thisReply = this.sendSynchronousCommand(payload, "QryAuditLifeTimeTotals");
            if (thisReply.length < 13 || (thisReply.length - 5) % 8 != 0) {
                return new AuditLifeTimeTotals();
            }
            int fieldCount = (thisReply[1] - 5) / 8;
            for (int i = 0; i < fieldCount; ++i) {
                int value = ((thisReply[8 * i + 3] & 0xF) << 28) + ((thisReply[8 * i + 4] & 0xF) << 24) + ((thisReply[8 * i + 5] & 0xF) << 20) + ((thisReply[8 * i + 6] & 0xF) << 16) + ((thisReply[8 * i + 7] & 0xF) << 12) + ((thisReply[8 * i + 8] & 0xF) << 8) + ((thisReply[8 * i + 9] & 0xF) << 4) + (thisReply[8 * i + 10] & 0xF);
                values.add(value);
            }
        } while (values.size() != 6 && ++counter < 3);
        return new AuditLifeTimeTotals(values);
    }

    public AuditPerformance GetAuditPerformance() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capAudit, "AuditPerformance");
        ArrayList<Integer> values = null;
        int counter = 0;
        do {
            values = new ArrayList<Integer>();
            byte[] payload = new byte[]{96, 0, 0, 12};
            byte[] thisReply = this.sendSynchronousCommand(payload, "QryAuditPerformance");
            if (thisReply.length < 9 || (thisReply.length - 5) % 4 != 0) {
                return new AuditPerformance();
            }
            int fieldCount = (thisReply[1] - 5) / 4;
            for (int i = 0; i < fieldCount; ++i) {
                int value = ((thisReply[4 * i + 3] & 0xF) << 12) + ((thisReply[4 * i + 4] & 0xF) << 8) + ((thisReply[4 * i + 5] & 0xF) << 4) + (thisReply[4 * i + 6] & 0xF);
                values.add(value);
            }
        } while (values.size() != 17 && ++counter < 3);
        return new AuditPerformance(values);
    }

    public AuditQP GetAuditQP() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capAudit, "AuditQP");
        ArrayList<Integer> values = new ArrayList<Integer>();
        byte[] payload = new byte[]{96, 0, 0, 11};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryAuditQP");
        if (thisReply.length < 9 || (thisReply.length - 5) % 4 != 0) {
            return new AuditQP();
        }
        int fieldCount = (thisReply[1] - 5) / 4;
        for (int i = 0; i < fieldCount; ++i) {
            values.add(((thisReply[4 * i + 3] & 0xF) << 12) + ((thisReply[4 * i + 4] & 0xF) << 8) + ((thisReply[4 * i + 5] & 0xF) << 4) + (thisReply[4 * i + 6] & 0xF));
        }
        if (values.size() != 14) {
            return new AuditQP();
        }
        return new AuditQP(values);
    }

    public boolean getAutoStack() {
        return this._autoStack;
    }

    public void setAutoStack(boolean autoStack) throws AcceptorException {
        this.verifyConnected("AutoStack");
        this._autoStack = autoStack;
        if (autoStack && this._deviceState == State.Escrow) {
            this.escrowStack();
        }
    }

    public String getBarCode() throws AcceptorException {
        if (this._docType != DocumentType.Barcode) {
            throw new AcceptorException("The BarCode property is not valid when DocType != DocumentType.Barcode");
        }
        return this._barCode;
    }

    public Bill getBill() throws AcceptorException {
        if (this._docType != DocumentType.Bill) {
            throw new AcceptorException("The Bill property is not valid when DocType != DocumentType.Bill");
        }
        return this._bill;
    }

    public List<Bill> getBillTypes() {
        return this._lstBillTypes;
    }

    public List<Boolean> getBillTypeEnables() {
        return this._lstBillTypeEnables;
    }

    public void setBillTypesEnables(List<Boolean> enablesTypes) throws AcceptorException {
        if (!this._connected) {
            throw new AcceptorException("Calling BillTypeEnables not allowed when not connected.");
        }
        if (this._deviceState != State.Idling) {
            throw new AcceptorException("Calling BillTypeEnables not allowed when device state != Idling");
        }
        if (this._lstBillTypeEnables.size() != this._lstBillTypes.size()) {
            throw new AcceptorException("BillTypeEnables size must match BillTypes size.");
        }
        this._lstBillTypeEnables = enablesTypes;
        if (this._expandedNoteReporting) {
            byte[] payload = this.constructOmnibusCommand(15, (byte)112, 2);
            payload[1] = 3;
            for (int i = 0; i < this._lstBillTypeEnables.size(); ++i) {
                int enableIndex = i / 7;
                int bitPosition = i % 7;
                int bit = 1 << bitPosition;
                if (!this._lstBillTypeEnables.get(i).booleanValue()) continue;
                int n = 5 + enableIndex;
                payload[n] = (byte)(payload[n] | (char)bit);
            }
            this.sendAsynchronousCommand(payload, "SetBillTypesEnables");
        }
    }

    public List<Bill> getBillValues() {
        return this._lstBillValues;
    }

    public List<Boolean> getBillValueEnables() {
        return this._lstBillValueEnables;
    }

    public void setBillValueEnables(List<Boolean> enablesValue) throws AcceptorException {
        this.verifyConnected("BillValueEnables");
        if (enablesValue.size() != this._lstBillValues.size()) {
            throw new AcceptorException("BillTypeEnables.size must match BillTypes.size.");
        }
        this._lstBillValueEnables = enablesValue;
        for (int i = 0; i < this._lstBillValueEnables.size(); ++i) {
            for (int j = 0; j < this._lstBillTypes.size(); ++j) {
                if (this._lstBillTypes.get(j).getValue() != this._lstBillValues.get(i).getValue() || !this._lstBillTypes.get(j).getCountry().equals(this._lstBillValues.get(i).getCountry())) continue;
                this._lstBillTypeEnables.set(j, this._lstBillValueEnables.get(i));
            }
        }
        byte[] payload = this.constructOmnibusCommand(15, (byte)112, 2);
        payload[1] = 3;
        for (int i = 0; i < this._lstBillTypeEnables.size(); ++i) {
            int enableIndex = i / 7;
            int bitPosition = i % 7;
            int bit = 1 << bitPosition;
            if (!this._lstBillTypeEnables.get(i).booleanValue()) continue;
            int n = 5 + enableIndex;
            payload[n] = (byte)(payload[n] | (char)bit);
        }
        this.sendAsynchronousCommand(payload, "SetBillValueEnables");
    }

    public BNFStatus GetBNFStatus() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capBNFStatus, "BNFStatus");
        byte[] payload = new byte[]{96, 0, 0, 16};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryBNFStatus");
        this._bnfErrorStatus = BNFErrorStatus.NoError;
        if (thisReply.length == 11) {
            if (thisReply[3] == 0) {
                this._bnfStatus = BNFStatus.NotAttached;
            } else if (thisReply[4] == 0) {
                this._bnfStatus = BNFStatus.OK;
            } else {
                this._bnfErrorStatus = BNFErrorStatus.FromByte(thisReply[5]);
                this._bnfStatus = BNFStatus.Error;
            }
        } else {
            this._bnfStatus = BNFStatus.Unknown;
        }
        return this._bnfStatus;
    }

    public BNFErrorStatus GetLastBNFError() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capBNFStatus, "BNFStatus");
        return this._bnfErrorStatus;
    }

    public String getBootPN() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capBootPN, "BootPN");
        byte[] payload = new byte[]{96, 0, 0, 6};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryBootPN");
        if (thisReply.length == 14) {
            byte[] response = new byte[9];
            System.arraycopy(thisReply, 3, response, 0, 9);
            return new String(response);
        }
        return "";
    }

    public boolean getCapAdvBookmark() {
        return this._capAdvBookmark;
    }

    public boolean getCapApplicationId() {
        return this._capApplicationId;
    }

    public boolean getCapApplicationPN() {
        return this._capApplicationPN;
    }

    public boolean getCapDeviceSoftReset() {
        return this._capDeviceSoftReset;
    }

    public boolean getCapAssetNumber() {
        return this._capAssetNumber;
    }

    public boolean getCapAudit() {
        return this._capAudit;
    }

    public boolean getCapBarCodes() {
        return this._capBarCodes;
    }

    public boolean getCapBarCodesExt() {
        return this._capBarCodesExt;
    }

    public boolean getCapBNFStatus() {
        return this._capBNFStatus;
    }

    public boolean getCapBookmark() {
        return this._capBookmark;
    }

    public boolean getCapBootPN() {
        return this._capBootPN;
    }

    public boolean getCapCalibrate() {
        return this._capCalibrate;
    }

    public boolean getCapCashBoxTotal() {
        return this._capCashBoxTotal;
    }

    public boolean getCapClearAudit() {
        return this._capClearAudit;
    }

    public boolean getCapCouponExt() {
        return this._capCouponExt;
    }

    public boolean getCapDevicePaused() {
        return this._capDevicePaused;
    }

    public boolean getCapDeviceType() {
        return this._capDeviceType;
    }

    public boolean getCapDeviceResets() {
        return this._capDeviceResets;
    }

    public boolean getCapDeviceSerialNumber() {
        return this._capDeviceSerialNumber;
    }

    public boolean getCapEasitrax() {
        return this._capEasitrax;
    }

    public boolean getCapEscrowTimeout() {
        return this._capEscrowTimeout;
    }

    public boolean getCapFlashDownload() {
        return this._capFlashDownload;
    }

    public boolean getCapNoPush() {
        return this._capNoPush;
    }

    public boolean getCapNoteRetrieved() {
        return this._capNoteRetrieved;
    }

    public boolean getCapOrientationExt() {
        return this._capOrientationExt;
    }

    public boolean getCapPupExt() {
        return this._capPupExt;
    }

    public boolean getCapTestDoc() {
        return this._capTestDoc;
    }

    public boolean getCapSetBezel() {
        return this._capSetBezel;
    }

    public boolean getCapVariantId() {
        return this._capVariantId;
    }

    public boolean getCapVariantPN() {
        return this._capVariantPN;
    }

    public boolean getCashBoxAttached() {
        return this._cashBoxAttached;
    }

    public boolean getCashBoxFull() {
        return this._cashBoxFull;
    }

    public long getCashBoxTotal() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capCashBoxTotal, "CashBoxTotal");
        byte[] payload = new byte[]{96, 0, 0, 1};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryCashBoxTotal");
        long total = thisReply.length != 11 ? 0L : (long)(((thisReply[3] & 0xF) << 20) + ((thisReply[4] & 0xF) << 16) + ((thisReply[5] & 0xF) << 12) + ((thisReply[6] & 0xF) << 8) + ((thisReply[7] & 0xF) << 4) + (thisReply[8] & 0xF));
        return total;
    }

    public boolean getConnected() {
        return this._connected;
    }

    void setConnected(boolean b) {
        if (!this._connected && b) {
            this._raiseConnectedEvent = true;
        }
        this._connected = b;
    }

    public Coupon getCoupon() throws AcceptorException {
        if (this._docType != DocumentType.Coupon) {
            throw new AcceptorException("The Coupon property is not valid when DocType != DocumentType.Coupon");
        }
        return this._coupon;
    }

    public boolean getDebugLog() {
        return this._debugLog;
    }

    public void setDebugLog(boolean newVal) throws AcceptorException {
        if (newVal) {
            if (!this._debugLog && this._connected) {
                this.openLogFile();
            }
            this._debugLog = newVal;
        } else {
            if (this._debugLog && this._connected) {
                this.closeLogFile();
            }
            this._debugLog = newVal;
        }
    }

    public String getDebugLogPath() {
        return this._debugLogPath;
    }

    public void setDebugLogPath(String debugLogPath) {
        this._debugLogPath = debugLogPath;
    }

    public boolean getDeviceBusy() {
        return this._deviceState != State.Idling;
    }

    public long getDeviceCRC() throws AcceptorException {
        this.verifyPropertyIsAllowed(true, "DeviceCRC");
        byte[] payload = new byte[]{96, 0, 0, 0};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryDeviceCRC");
        long crc = thisReply.length < 7 ? 0L : (long)(((thisReply[3] & 0xF) << 12) + ((thisReply[4] & 0xF) << 8) + ((thisReply[5] & 0xF) << 4) + (thisReply[6] & 0xF));
        return crc;
    }

    public boolean getDeviceFailure() {
        return this.getDeviceState() == State.Failed;
    }

    public boolean getDeviceJammed() {
        return this._isDeviceJammed;
    }

    public long getDeviceModel() {
        return this._deviceModel;
    }

    public boolean getDevicePaused() {
        return this._devicePaused;
    }

    public PowerUp getDevicePowerUp() {
        return this._powerUp;
    }

    public long getDeviceResets() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capDeviceResets, "DeviceResets");
        byte[] payload = new byte[]{96, 0, 0, 2};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryDeviceResets");
        long resets = thisReply.length != 11 ? 0L : (long)(((thisReply[3] & 0xF) << 20) + ((thisReply[4] & 0xF) << 16) + ((thisReply[5] & 0xF) << 12) + ((thisReply[6] & 0xF) << 8) + ((thisReply[7] & 0xF) << 4) + (thisReply[8] & 0xF));
        return resets;
    }

    public long getDeviceRevision() {
        return this._deviceRevision;
    }

    public String getDeviceSerialNumber() throws AcceptorException {
        int validCharIndex;
        this.verifyConnected("DeviceSerialNumber");
        byte[] payload = new byte[]{96, 0, 0, 5};
        byte[] reply = this.sendSynchronousCommand(payload, "QryDeviceSerialNumber");
        if (reply.length != 25) {
            return "";
        }
        for (validCharIndex = 3; validCharIndex < reply.length && reply[validCharIndex] > 32 && reply[validCharIndex] < 127 && validCharIndex <= 22; ++validCharIndex) {
        }
        try {
            byte[] tmp = Arrays.copyOfRange(reply, 3, validCharIndex);
            return new String(tmp, "UTF8");
        }
        catch (Exception ex) {
            this.log("Failed to fetch serial Number: " + ex.getMessage());
            return "";
        }
    }

    public State getDeviceState() {
        if (this._isInFailedState && this._connected) {
            return State.Failed;
        }
        return this._deviceState;
    }

    public String getDeviceType() throws AcceptorException {
        int validCharIndex;
        this.verifyPropertyIsAllowed(this._capDeviceType, "DeviceType");
        byte[] payload = new byte[]{96, 0, 0, 4};
        byte[] reply = this.sendSynchronousCommand(payload, "QryDeviceType");
        for (validCharIndex = 3; validCharIndex < reply.length && reply[validCharIndex] > 32 && reply[validCharIndex] < 127 && validCharIndex <= 22; ++validCharIndex) {
        }
        try {
            byte[] tmp = Arrays.copyOfRange(reply, 3, validCharIndex);
            return new String(tmp, "UTF8");
        }
        catch (Exception ex) {
            this.log("Failed to fetch Device Type: " + ex.getMessage());
            return "";
        }
    }

    public DocumentType getDocType() {
        return this._docType;
    }

    public int getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setTransactionTimeout(int timeout) {
        this._transactionTimeout = timeout;
    }

    public int getDisconnectTimeout() {
        return this._disconnectTimeout;
    }

    public void setDisconnectTimeout(int timeout) throws AcceptorException {
        if (timeout <= 0) {
            throw new AcceptorException("Timeout value must be a positive non-zero integer");
        }
        this._disconnectTimeout = timeout;
    }

    public int getDownloadTimeout() {
        return this._downloadTimeout;
    }

    public void setDownloadTimeout(int downloadTimeout) {
        this._downloadTimeout = downloadTimeout;
    }

    public boolean getEnableAcceptance() {
        return this._enableAcceptance;
    }

    public void setEnableAcceptance(boolean enableAcceptance) throws AcceptorException {
        this.verifyConnected("EnableAcceptance");
        this._enableAcceptance = enableAcceptance;
        State currentState = this._deviceState;
        if (!this._enableAcceptance) {
            if (currentState == State.Accepting) {
                this._bDisabledWhileAccpeting = true;
            } else if (currentState == State.Escrow) {
                this.escrowReturn();
            }
        }
    }

    public boolean getEnableBarCodes() {
        return this._enableBarCodes;
    }

    public void setEnableBarCodes(boolean enableBarCodes) throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capBarCodes, "EnableBarCodes");
        this._enableBarCodes = enableBarCodes;
    }

    public boolean getEnableBookmarks() {
        return this._enableBookmarks;
    }

    public void setEnableBookmarks(boolean enableBookmarks) throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capBookmark, "EnableBookmarks");
        this._enableBookmarks = enableBookmarks;
    }

    public boolean getEnableCouponExt() {
        return this._enableCouponExt;
    }

    public void setEnableCouponExt(boolean enableCouponExt) throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capCouponExt, "EnableCouponExt");
        this._enableCouponExt = enableCouponExt;
    }

    public boolean getEnableNoPush() {
        return this._enableNoPush;
    }

    public void setEnableNoPush(boolean enableNoPush) throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capNoPush, "EnableNoPush");
        this._enableNoPush = enableNoPush;
    }

    public Orientation getEscrowOrientation() {
        if (this._capOrientationExt) {
            return this._escrowOrientation;
        }
        return Orientation.UnknownOrientation;
    }

    public boolean getHighSecurity() {
        return this._highSecurity;
    }

    public void setHighSecurity(boolean highSecurity) {
        this._highSecurity = highSecurity;
    }

    public OrientationControl getOrientationControl() {
        return this._orientationControl;
    }

    public void setOrientationControl(OrientationControl orientationControl) {
        this._orientationControl = orientationControl;
    }

    public OrientationControl getOrientationCtlExt() {
        return this._orientationControlExt;
    }

    public void SetOrientationCtlExt(OrientationControl orientationControlExt) {
        this._orientationControlExt = orientationControlExt;
    }

    public String getPort() {
        return this._port;
    }

    public List<String> getVariantNames() throws AcceptorException {
        this.verifyPropertyIsAllowed(true, "VariantNames");
        byte[] payload = new byte[]{96, 0, 0, 8};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryVariantNames");
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int startingIndex = 3; startingIndex < thisReply.length - 2; ++startingIndex) {
            byte bt = thisReply[startingIndex];
            if (bt <= 25 || bt >= 127) continue;
            if (bt == 95) {
                if (sb.length() != 0) {
                    names.add(sb.toString());
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append((char)bt);
        }
        if (sb.length() != 0) {
            names.add(sb.toString());
        }
        return names;
    }

    public String getVariantID() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capVariantId, "VariantID");
        byte[] payload = new byte[]{96, 0, 0, 15};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryVariantID");
        if (thisReply.length == 14) {
            byte[] response = new byte[9];
            System.arraycopy(thisReply, 3, response, 0, 9);
            return new String(response);
        }
        return "";
    }

    public String getVariantPN() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capVariantPN, "VariantPN");
        byte[] payload = new byte[]{96, 0, 0, 9};
        byte[] thisReply = this.sendSynchronousCommand(payload, "QryVariantPN");
        if (thisReply.length == 14) {
            byte[] response = new byte[9];
            System.arraycopy(thisReply, 3, response, 0, 9);
            return new String(response);
        }
        return "";
    }

    public static String getVersion() {
        return VERSION;
    }

    public void calibrate() throws AcceptorException {
        this.verifyConnected("Calibrate");
        if (this._deviceState != State.Idling) {
            throw new AcceptorException("Calibrate allowed only when DeviceState == Idling.");
        }
        byte[] payload = new byte[]{64, 0, 0, 0};
        byte[] thisReply = null;
        this._suppressStandardPoll = true;
        this._deviceState = State.CalibrateStart;
        this.raiseCalibrateStartEvent();
        this._raiseCalibrateProgressEvent = true;
        long startTickCount = System.currentTimeMillis();
        while ((thisReply = this.sendSynchronousCommand(payload, "Calibrate Command")).length != 11 || (thisReply[2] & 0x70) != 64) {
            if (System.currentTimeMillis() - startTickCount <= 3000L) continue;
            this.raiseCalibrateFinishEvent();
            break;
        }
        this._suppressStandardPoll = false;
    }

    public void flashDownload(String filePath) throws AcceptorException {
        if (!this._connected && this._deviceState != State.DownloadRestart) {
            throw new AcceptorException("FlashDownload not allowed when not connected.");
        }
        if (this._deviceState != State.Idling && this._deviceState != State.DownloadRestart) {
            throw new AcceptorException("FlashDownload allowed only when DeviceState == Idling.");
        }
        File f = new File(filePath);
        if (!f.exists()) {
            throw new AcceptorException("File does not exists");
        }
        if (f.isDirectory()) {
            throw new AcceptorException("File is a directory");
        }
        if (!f.canRead()) {
            throw new AcceptorException("File is locked and can't be read");
        }
        if (f.length() % 32L != 0L) {
            throw new AcceptorException("Flash download file size must be divisible by 32.");
        }
        this._raiseDownloadRestartEvent = false;
        this._flashDownloadThread = new FlashDownloadThread(f, f.length());
        this._flashDownloadThread.start();
    }

    public byte[] rawTransaction(byte[] command) throws AcceptorException {
        byte[] thisReply = this.sendSynchronousCommand(command, "Raw Transaction command");
        this.processReply(thisReply);
        return thisReply;
    }

    public void clearCashBoxTotal() throws AcceptorException {
        this.verifyConnected("ClearCashBoxTotal");
        byte[] payload = new byte[]{96, 0, 0, 3};
        byte[] thisReply = this.sendSynchronousCommand(payload, "ClearCashBoxTotal command");
        this.processReply(thisReply);
    }

    public String getAssetNumber() throws AcceptorException {
        this.verifyConnected("QryAssetNumber");
        this.verifyPropertyIsAllowed(this._capEasitrax, "AssetNumber");
        byte[] payload = new byte[]{96, 0, 0, 21};
        byte[] tmpReply = this.sendSynchronousCommand(payload, "QryAssetNumber");
        try {
            byte[] tmp = Arrays.copyOfRange(tmpReply, 3, 19);
            return new String(tmp, "UTF8");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void setAssetNumber(String asset) throws AcceptorException {
        this.verifyConnected("SetAssetNumber");
        this.verifyPropertyIsAllowed(this._capEasitrax, "AssetNumber");
        if (this._deviceState != State.Idling && this._deviceState != State.Failed) {
            throw new AcceptorException("Setting the AssetNumber is only allowed when idle or failed.");
        }
        if (asset.length() > 16) {
            throw new AcceptorException("Asset Number is too long.");
        }
        byte[] payload = this.constructOmnibusCommand(21, (byte)112, 2);
        payload[1] = 5;
        char[] assetArray = asset.toCharArray();
        for (int i = 0; i < assetArray.length && i <= 16; ++i) {
            payload[i + 5] = (byte)assetArray[i];
        }
        this.sendAsynchronousCommand(payload, "SetAssetNumber command");
    }

    public void setBezel(Bezel bezel) throws AcceptorException {
        this.verifyConnected("SetBezelNumber");
        byte[] payload = new byte[]{96, (byte)bezel.ordinal(), 0, 17};
        this.sendAsynchronousCommand(payload, "SetBezel command");
    }

    public void SoftReset() throws AcceptorException {
        this.verifyConnected("SoftReset");
        this._docType = DocumentType.NoValue;
        byte[] payload = new byte[]{96, 127, 127, 127};
        this.sendAsynchronousCommand(payload, "SoftReset command", true);
        this._inSoftResetOneSecondIgnore = true;
        this._inSoftResetWaitForReply = true;
    }

    public void specifyEscrowTimeout(int billTimeout, int barcodeTimeout) throws AcceptorException {
        this.verifyConnected("SpecifyEscrowTimeout");
        byte[] payload = this.constructOmnibusCommand(7, (byte)112, 2);
        payload[1] = 4;
        payload[5] = (byte)billTimeout;
        payload[6] = (byte)barcodeTimeout;
        byte[] thisReply = this.sendSynchronousCommand(payload, "SpecifyEscrowTimeout command");
        this.processReply(thisReply);
    }

    public void specifyPupExt(char pupMode, PupExt preEscrow, PupExt atEscrow, PupExt postEscrow, PupExt preStack) throws AcceptorException {
    }

    public boolean enterAdvancedBookmarkMode() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capAdvBookmark, "Advanced Bookmark Mode");
        byte[] payload = this.constructOmnibusCommand(6, (byte)112, 2);
        payload[1] = 13;
        payload[5] = 1;
        byte[] thisReply = this.sendSynchronousCommand(payload, "Advanced Bookmark Mode command");
        this.processReply(thisReply);
        return thisReply[10] == 1;
    }

    public boolean cancelAdvancedBookmarkMode() throws AcceptorException {
        this.verifyPropertyIsAllowed(this._capAdvBookmark, "Advanced Bookmark Mode");
        byte[] payload = this.constructOmnibusCommand(6, (byte)112, 2);
        payload[1] = 13;
        payload[5] = 0;
        byte[] thisReply = this.sendSynchronousCommand(payload, "Advanced Bookmark Mode command");
        this.processReply(thisReply);
        return thisReply[10] == 1;
    }

    public boolean clearAudit() throws AcceptorException {
        this.verifyConnected("Clear Audit");
        if (this._deviceState != State.Idling && this._deviceState != State.Failed) {
            throw new AcceptorException("Clear Audit is only allowed when DeviceState == (Idling or Failed).");
        }
        byte[] payload = this.constructOmnibusCommand(5, (byte)112, 2);
        payload[1] = 29;
        byte[] reply = this.sendSynchronousCommand(payload, "Clear Audit Reporting");
        this.processReply(reply);
        return reply[10] == 1;
    }

    public AuditContainer getBanknoteAuditData() throws AcceptorException {
        boolean bPreviousAcceptanceState = this.getEnableAcceptance();
        this.setEnableAcceptance(false);
        long lStartTime = System.currentTimeMillis();
        while (this.getDeviceState() != State.Idling && this.getDeviceState() != State.Failed) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (System.currentTimeMillis() - lStartTime >= 5000L) continue;
            throw new AcceptorException(String.format("Device has not reached Idle state in the expected amount of time. Current state == '%s'", new Object[]{this.getDeviceState()}));
        }
        byte[] arrPayload = new byte[]{96, 0, 0, 22};
        byte[] arrReply = this.sendSynchronousCommand(arrPayload, "Query Audit Total Documents Reporting Structure");
        if (arrReply.length == 0) {
            throw new AcceptorException("Reporting Structure response was null");
        }
        if (arrReply.length != 11) {
            throw new AcceptorException(String.format("Reporting Structure response did not contain the expected number of bytes. Expected 0x%s but detected only 0x%s", Integer.toHexString(11), Integer.toHexString(arrReply.length)));
        }
        if ((arrReply[2] & 0xF0) != 96) {
            throw new AcceptorException(String.format("Reporting Structure response was not of the correct message type. Expected 0x{0:X2} but detected only 0x{1:X2}", (byte)96, arrReply[2] & 0xF0));
        }
        AuditContainer auditObject = new AuditContainer(arrReply[4], arrReply[5], arrReply[6]);
        for (int iFieldTmp = 23; iFieldTmp < 26; ++iFieldTmp) {
            String strFieldTmp;
            switch (iFieldTmp) {
                case 23: {
                    strFieldTmp = "Recognized";
                    break;
                }
                case 24: {
                    strFieldTmp = "Validated";
                    break;
                }
                case 25: {
                    strFieldTmp = "Stacked";
                    break;
                }
                default: {
                    throw new AcceptorException("Critical Error: Passed the maximum number of fields");
                }
            }
            for (int iOrientationTmp = 0; iOrientationTmp < 4; ++iOrientationTmp) {
                for (int iDatasetTmp = 0; iDatasetTmp < auditObject.getNumberOfDatasets(); ++iDatasetTmp) {
                    arrPayload = new byte[]{96, (byte)iOrientationTmp, (byte)iDatasetTmp, (byte)iFieldTmp};
                    arrReply = this.sendSynchronousCommand(arrPayload, String.format("Query Audit Total Documents %s", strFieldTmp));
                    if (arrReply.length == 0) {
                        throw new AcceptorException(String.format("Total Documents %s response was null", strFieldTmp));
                    }
                    if ((arrReply[2] & 0xF0) != 96) {
                        throw new AcceptorException(String.format("Total Documents %s response was not of the correct message type. Expected 0x%s but detected only 0x%s", strFieldTmp, Integer.toHexString(96), Integer.toHexString(arrReply[2] & 0xF0)));
                    }
                    byte[] arrDataCopy = new byte[arrReply.length - 5];
                    System.arraycopy(arrReply, 3, arrDataCopy, 0, arrDataCopy.length);
                    auditObject.appendResults(iFieldTmp, iOrientationTmp, iDatasetTmp, arrDataCopy);
                }
            }
        }
        this.setEnableAcceptance(bPreviousAcceptanceState);
        return auditObject;
    }

    public boolean disableCashboxCleanlinessReporting() throws AcceptorException {
        this.verifyConnected("Disable Cashbox Cleanliness Reporting");
        byte[] payload = this.constructOmnibusCommand(6, (byte)112, 2);
        payload[1] = 16;
        payload[5] = 0;
        byte[] reply = this.sendSynchronousCommand(payload, "Cashbox Cleanliness Reporting");
        this.processReply(reply);
        return reply[10] == 1;
    }

    public boolean enableCashboxCleanlinessReporting() throws AcceptorException {
        this.verifyConnected("Enable Cashbox Cleanliness Reporting");
        byte[] payload = this.constructOmnibusCommand(6, (byte)112, 2);
        payload[1] = 16;
        payload[5] = 1;
        byte[] reply = this.sendSynchronousCommand(payload, "Cashbox Cleanliness Reporting");
        this.processReply(reply);
        return reply[10] == 1;
    }

    void log(String message) {
        this.log(message, Calendar.getInstance().getTime());
    }

    synchronized void log(String message, Date time) {
        if (this._logWriter == null) {
            return;
        }
        try {
            this._logWriter.write(String.format("%s: %s", this._logFormatter.format(time), message));
            this._logWriter.newLine();
            this._logWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildHardCodedBillTable() {
        switch ((int)this._deviceModel) {
            case 1: 
            case 12: 
            case 23: 
            case 30: 
            case 31: 
            case 74: 
            case 88: {
                this._lstBillTypes.add(new Bill("USD", 1.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 2.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 100.0, 42, 42, 42, 42));
                break;
            }
            case 80: {
                this._lstBillTypes.add(new Bill("USD", 1.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 2.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("USD", 20.0, 42, 42, 42, 42));
                break;
            }
            case 71: {
                this._lstBillTypes.add(new Bill());
                this._lstBillTypes.add(new Bill("ARS", 2.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("ARS", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("ARS", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("ARS", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("ARS", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("ARS", 100.0, 42, 42, 42, 42));
                break;
            }
            case 65: {
                this._lstBillTypes.add(new Bill("AUD", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("AUD", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("AUD", 100.0, 42, 42, 42, 42));
                break;
            }
            case 15: {
                this._lstBillTypes.add(new Bill());
                this._lstBillTypes.add(new Bill());
                this._lstBillTypes.add(new Bill("AUD", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("AUD", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("AUD", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("AUD", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("AUD", 100.0, 42, 42, 42, 42));
                break;
            }
            case 87: {
                this._lstBillTypes.add(new Bill("BRL", 1.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("BRL", 2.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("BRL", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("BRL", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("BRL", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("BRL", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("BRL", 100.0, 42, 42, 42, 42));
                break;
            }
            case 67: {
                this._lstBillTypes.add(new Bill());
                this._lstBillTypes.add(new Bill());
                this._lstBillTypes.add(new Bill("CAD", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("CAD", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("CAD", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("CAD", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("CAD", 100.0, 42, 42, 42, 42));
                break;
            }
            case 68: {
                this._lstBillTypes.add(new Bill("EUR", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("EUR", 10.0, 42, 42, 42, 42));
                break;
            }
            case 77: {
                this._lstBillTypes.add(new Bill("MXP", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("MXP", 50.0, 42, 42, 42, 42));
                break;
            }
            case 66: {
                this._lstBillTypes.add(new Bill("RUR", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("RUR", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("RUR", 100.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("RUR", 500.0, 42, 42, 42, 42));
                break;
            }
            default: {
                this._lstBillTypes.add(new Bill("***", 1.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("***", 2.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("***", 5.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("***", 10.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("***", 20.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("***", 50.0, 42, 42, 42, 42));
                this._lstBillTypes.add(new Bill("***", 100.0, 42, 42, 42, 42));
            }
        }
        for (int i = 0; i < this._lstBillTypes.size(); ++i) {
            this._lstBillTypeEnables.add(this._lstBillTypes.get(i).getValue() > 0.0);
        }
    }

    private void BuildBillValues() {
        int billValuesCount = 0;
        for (int i = 0; i < this._lstBillTypes.size(); ++i) {
            boolean valueExists = false;
            for (int j = 0; j < billValuesCount; ++j) {
                if (this._lstBillTypes.get(i).getValue() != this._lstBillValues.get(j).getValue() || !this._lstBillTypes.get(i).getCountry().equals(this._lstBillValues.get(j).getCountry())) continue;
                valueExists = true;
                break;
            }
            if (valueExists) continue;
            this._lstBillValues.add(new Bill(this._lstBillTypes.get(i).getCountry(), this._lstBillTypes.get(i).getValue(), 42, 42, 42, 42));
            ++billValuesCount;
            this._lstBillValueEnables.add(this._lstBillTypes.get(i).getValue() > 0.0);
        }
    }

    private void setUpBillTable() throws AcceptorException {
        this.clearBillTable();
        if (this._expandedNoteReporting) {
            this.retrieveBillTable();
        } else {
            this.buildHardCodedBillTable();
        }
        this.BuildBillValues();
    }

    protected byte[] constructOmnibusCommand(int payloadLength, byte controlCode, int data0Index) {
        byte[] payload = new byte[payloadLength];
        payload[0] = controlCode;
        if (this._enableBookmarks && this._enableAcceptance && this._deviceState != State.Calibrating) {
            payload[0] = (byte)(payload[0] | 0x20);
        }
        int data0 = 0;
        if (this._enableAcceptance && this._deviceState != State.Calibrating) {
            if (this._expandedNoteReporting) {
                data0 = (byte)(data0 | 0x7F);
            } else if (this._lstBillTypeEnables.size() == 0) {
                data0 = (byte)(data0 | 0x7F);
            } else {
                data0 = 0;
                for (int i = 0; i < this._lstBillTypeEnables.size(); ++i) {
                    int enableBit = 1 << i;
                    if (!this._lstBillTypeEnables.get(i).booleanValue()) continue;
                    data0 = (byte)(data0 | (byte)enableBit);
                }
            }
        }
        int data1 = 0;
        if (this._highSecurity) {
            data1 = (byte)(data1 | 2);
        }
        switch (this._orientationControl) {
            case OneWay: {
                break;
            }
            case TwoWay: {
                data1 = (byte)(data1 | 4);
                break;
            }
            case FourWay: {
                data1 = (byte)(data1 | 0xC);
            }
        }
        data1 = (byte)(data1 | 0x10);
        byte data2 = 0;
        if (this._enableNoPush) {
            data2 = (byte)(data2 | 1);
        }
        if (this._enableBarCodes && this._enableAcceptance && this._deviceState != State.Calibrating) {
            data2 = (byte)(data2 | 2);
        }
        switch (this._powerUp) {
            case A: {
                break;
            }
            case E: {
                break;
            }
            case B: {
                data2 = (byte)(data2 | 4);
                break;
            }
            case C: {
                data2 = (byte)(data2 | 8);
            }
        }
        if (this._expandedNoteReporting) {
            data2 = (byte)(data2 | 0x10);
        }
        if (this._enableCouponExt && this._capCouponExt) {
            data2 = (byte)(data2 | 0x20);
        }
        payload[data0Index] = data0;
        payload[data0Index + 1] = data1;
        payload[data0Index + 2] = data2;
        return payload;
    }

    private byte GetPupExtValueCode(PupExt pupExt) {
        switch (pupExt) {
            case OutOfService: {
                return 0;
            }
            case StackNoCredit: {
                return 1;
            }
            case Return: {
                return 2;
            }
            case Stack: {
                return 3;
            }
            case WaitNoCredit: {
                return 4;
            }
            case Wait: {
                return 5;
            }
        }
        return 6;
    }

    private Bill parseBillData(byte[] reply, int extDataIndex) {
        Bill thisBill = new Bill();
        if (reply.length != 30) {
            return thisBill;
        }
        byte[] country = new byte[3];
        System.arraycopy(reply, extDataIndex + 1, country, 0, 3);
        thisBill.setCountry(new String(country));
        byte[] value = new byte[3];
        System.arraycopy(reply, extDataIndex + 4, value, 0, 3);
        String valueString = new String(value);
        double billValue = 0.0;
        if (!valueString.trim().equals("")) {
            billValue = Double.parseDouble(valueString.trim());
        }
        byte exponentSign = reply[extDataIndex + 7];
        byte[] exponentString = new byte[3];
        System.arraycopy(reply, extDataIndex + 8, exponentString, 0, 3);
        exponentString[2] = 0;
        int exponent = 0;
        String ex = new String(exponentString);
        if (!ex.trim().equals("")) {
            exponent = Integer.parseInt(ex.trim());
        }
        if (exponentSign == 43) {
            for (int i = 1; i <= exponent; ++i) {
                billValue *= 10.0;
            }
        } else {
            for (int i = 1; i <= exponent; ++i) {
                billValue /= 10.0;
            }
        }
        thisBill.setValue(billValue);
        this._docType = this._connected && billValue > 0.0 ? DocumentType.Bill : DocumentType.NoValue;
        this._docTypeWasSetOnEscrow = this._deviceState == State.Escrow;
        switch (reply[extDataIndex + 10]) {
            case 0: {
                this._escrowOrientation = Orientation.RightUp;
                break;
            }
            case 1: {
                this._escrowOrientation = Orientation.RightDown;
                break;
            }
            case 2: {
                this._escrowOrientation = Orientation.LeftUp;
                break;
            }
            case 3: {
                this._escrowOrientation = Orientation.LeftDown;
            }
        }
        thisBill.setType(reply[extDataIndex + 11]);
        thisBill.setSeries(reply[extDataIndex + 12]);
        thisBill.setCompatibility(reply[extDataIndex + 13]);
        thisBill.setVersion(reply[extDataIndex + 14]);
        return thisBill;
    }

    protected void processReply(byte[] reply) throws AcceptorException {
        if (reply.length < 5 || reply.length != reply[1]) {
            return;
        }
        byte ctrl = reply[2];
        if ((ctrl & 0x70) == 32) {
            this.processStandardOmnibusReply(reply);
        }
        if ((ctrl & 0x70) == 80) {
            this._deviceState = State.DownloadRestart;
            this._capFlashDownload = true;
            if (this._raiseDownloadRestartEvent) {
                this.raiseDownloadRestartEvent();
            }
        }
        if ((ctrl & 0x70) == 112) {
            byte subType = reply[3];
            if (subType == 1) {
                this.processExtendedOmnibusBarCodeReply(reply);
            } else if (subType == 2) {
                this.processExtendedOmnibusExpandedNoteReply(reply);
                if (this._deviceState == State.Escrow || this._deviceState == State.Stacked && !this._docTypeWasSetOnEscrow) {
                    this._bill = this.parseBillData(reply, 10);
                    if (this._capOrientationExt) {
                        if (this._orientationControlExt == OrientationControl.OneWay) {
                            if (this._escrowOrientation != Orientation.RightUp) {
                                this._raiseEscrowEvent = false;
                                this.escrowReturn();
                            }
                        } else if (this._orientationControlExt == OrientationControl.TwoWay) {
                            if (this._escrowOrientation != Orientation.RightUp && this._escrowOrientation != Orientation.LeftUp) {
                                this._raiseEscrowEvent = false;
                                this.escrowReturn();
                            }
                        } else if (this._orientationControlExt == OrientationControl.FourWay) {
                            // empty if block
                        }
                    }
                }
            } else if (subType == 4) {
                this.processExtendedOmnibusExpandedCouponReply(reply);
            } else if (subType == 11) {
                this.processData4(reply[8]);
                this.processData0(reply[4]);
                this.processData1(reply[5]);
                this.processData2(reply[6]);
                this.processData3(reply[7]);
                this.processData5(reply[9]);
                this.raiseEvents();
                if (reply.length == 13 && reply[10] == 127) {
                    this.raiseNoteRetrievedEvent();
                }
            } else if (subType == 16) {
                this.processData4(reply[8]);
                this.processData0(reply[4]);
                this.processData1(reply[5]);
                this.processData2(reply[6]);
                this.processData3(reply[7]);
                this.processData5(reply[9]);
                if (reply.length == 13 && (reply[10] == 17 || reply[10] == 16)) {
                    this.raiseCashboxCleanlinessEvent(reply[10]);
                }
            } else if (subType == 29) {
                this.processData4(reply[8]);
                this.processData0(reply[4]);
                this.processData1(reply[5]);
                this.processData2(reply[6]);
                this.processData3(reply[7]);
                this.processData5(reply[9]);
                if (reply.length == 13 && (reply[10] == 17 || reply[10] == 16)) {
                    this.raiseClearAuditEvent(reply[10] == 17);
                }
            }
            this.raiseEvents();
        }
        if (this._deviceState == State.Escrow && this._raiseEscrowEvent && this._connected && (this._autoStack || !this._enableAcceptance)) {
            this._raiseEscrowEvent = false;
            if (this._enableAcceptance) {
                this.escrowStack();
            } else {
                this.escrowReturn();
            }
        }
        if (this._deviceState != State.Escrow && this._deviceState != State.Stacking) {
            this._docTypeWasSetOnEscrow = false;
        }
    }

    private void processExtendedOmnibusBarCodeReply(byte[] reply) {
        if (reply.length != 40) {
            return;
        }
        this.processData4(reply[8]);
        this.processData0(reply[4]);
        this.processData1(reply[5]);
        this.processData2(reply[6]);
        this.processData3(reply[7]);
        this.processData5(reply[9]);
        if (this._deviceState == State.Escrow) {
            StringBuffer tmpBarCode = new StringBuffer();
            for (int i = 10; i < 38 && reply[i] != 40; ++i) {
                tmpBarCode.append((char)reply[i]);
            }
            this._barCode = tmpBarCode.toString();
            this._docType = DocumentType.Barcode;
        }
    }

    private void processExtendedOmnibusExpandedNoteReply(byte[] reply) {
        if (reply.length != 30) {
            return;
        }
        this.processData4(reply[8]);
        this.processData0(reply[4]);
        this.processData1(reply[5]);
        this.processData2(reply[6]);
        this.processData3(reply[7]);
        this.processData5(reply[9]);
    }

    private void processExtendedOmnibusExpandedCouponReply(byte[] reply) {
        if (reply.length != 18) {
            return;
        }
        this.processData4(reply[8]);
        this.processData0(reply[4]);
        this.processData1(reply[5]);
        this.processData2(reply[6]);
        this.processData3(reply[7]);
        this.processData5(reply[9]);
        if (this._deviceState == State.Escrow || this._deviceState == State.Stacked && !this._docTypeWasSetOnEscrow) {
            int couponData = ((reply[10] & 0xF) << 12) + ((reply[11] & 0xF) << 8) + ((reply[12] & 0xF) << 4) + (reply[13] & 0xF);
            double value = COUPON_VALUES[couponData & 7];
            int ownerId = (couponData & 0xFFF8) >> 3;
            this._coupon = new Coupon(ownerId, value);
            this._docType = DocumentType.Coupon;
            this._docTypeWasSetOnEscrow = this._deviceState == State.Escrow;
        }
    }

    private void processStandardOmnibusReply(byte[] reply) {
        if (reply.length != 11) {
            return;
        }
        this.processData4(reply[7]);
        this.processData0(reply[3]);
        this.processData1(reply[4]);
        this.processData2(reply[5]);
        this.processData3(reply[6]);
        this.processData5(reply[8]);
        this.raiseEvents();
    }

    private void processData0(byte data0) {
        if (data0 == 0) {
            this._deviceState = State.Idling;
            return;
        }
        if ((data0 & 1) != 0 && this._deviceState != State.Calibrating && this._deviceState != State.CalibrateStart) {
            this._deviceState = State.Idling;
        }
        if ((data0 & 2) != 0) {
            if (!this._enableAcceptance) {
                this._bDisabledWhileAccpeting = true;
            }
            if (this._deviceState != State.Calibrating && this._deviceState != State.CalibrateStart) {
                this._deviceState = State.Accepting;
            }
        }
        if ((data0 & 4) != 0) {
            this._deviceState = State.Escrow;
        } else if (!this._raiseEscrowEvent) {
            this._raiseEscrowEvent = true;
        }
        if ((data0 & 8) != 0) {
            this._deviceState = State.Stacking;
        }
        if ((data0 & 0x10) != 0) {
            this._deviceState = State.Stacked;
            this._raiseStackedEvent = true;
        }
        if ((data0 & 0x20) != 0) {
            this._deviceState = State.Returning;
        }
        if ((data0 & 0x40) != 0) {
            this._deviceState = State.Returned;
            this._bill = new Bill();
            this._docType = DocumentType.NoValue;
            this._raiseReturnedEvent = true;
        }
    }

    private void processData1(byte data1) {
        if ((data1 & 1) != 0) {
            this._cheated = true;
            this._raiseCheatedEvent = true;
        } else {
            this._cheated = false;
        }
        if ((data1 & 2) != 0) {
            this._deviceState = State.Rejected;
            this._docType = DocumentType.NoValue;
            this._raiseRejectedEvent = true;
        }
        if ((data1 & 4) != 0) {
            this._deviceState = State.Jammed;
            this._isDeviceJammed = true;
            this._raiseJamClearedEvent = true;
        } else {
            this._isDeviceJammed = false;
            this._raiseJamDetectedEvent = true;
        }
        if ((data1 & 8) != 0) {
            this._cashBoxFull = true;
            this._raiseStackerFullClearedEvent = true;
        } else {
            this._cashBoxFull = false;
            this._raiseStackerFullEvent = true;
        }
        boolean bl = this._cashBoxAttached = (data1 & 0x10) != 0;
        if (!this._cashBoxAttached) {
            this._docType = DocumentType.NoValue;
            this._raiseCashBoxAttachedEvent = true;
        } else {
            this._raiseCashBoxRemovedEvent = true;
        }
        if ((data1 & 0x20) != 0) {
            this._devicePaused = true;
            this._raisePauseClearedEvent = true;
        } else {
            this._devicePaused = false;
            this._raisePauseDetectedEvent = true;
        }
        if ((data1 & 0x40) != 0) {
            this._deviceState = State.Calibrating;
            if (this._raiseCalibrateProgressEvent) {
                this.raiseCalibrateProgressEvent();
            }
        } else if (this._deviceState == State.Calibrating) {
            this._raiseCalibrateFinishEvent = true;
            this._deviceState = State.Idling;
        }
    }

    private void processData2(byte data2) {
        try {
            if (!this._expandedNoteReporting) {
                int billTypeIndex = (data2 & 0x38) >> 3;
                if (billTypeIndex > 0) {
                    if (this._deviceState == State.Escrow || this._deviceState == State.Stacked && !this._docTypeWasSetOnEscrow) {
                        this._bill = this._lstBillTypes.get(billTypeIndex - 1);
                        this._docType = DocumentType.Bill;
                        this._docTypeWasSetOnEscrow = this._deviceState == State.Escrow;
                    }
                } else {
                    if (this._deviceState == State.Stacked || this._deviceState == State.Escrow) {
                        this._bill = new Bill();
                        this._docType = DocumentType.NoValue;
                    }
                    this._docTypeWasSetOnEscrow = false;
                }
            } else if (this._deviceState == State.Stacked) {
                if (this._docType == DocumentType.Bill && this._bill.getValue() == 0.0) {
                    this._docType = DocumentType.NoValue;
                }
            } else if (this._deviceState == State.Escrow) {
                this._bill = new Bill();
                this._docType = DocumentType.NoValue;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if ((data2 & 1) != 0) {
            this._isPoweredUp = true;
            this._docType = DocumentType.NoValue;
            this._raiseEscrowEvent = this._raisePowerUpEvent;
        } else {
            this._raisePowerUpEvent = true;
            if (!this._isVeryFirstPoll) {
                this._isPoweredUp = false;
            }
        }
        if ((data2 & 2) != 0) {
            this.raiseInvalidCommandEvent();
        }
        if ((data2 & 4) != 0) {
            this._deviceState = State.Failed;
            this._isInFailedState = true;
        } else {
            this._isInFailedState = false;
        }
    }

    private void processData3(byte data3) {
        if ((data3 & 1) != 0) {
            this._deviceState = State.Stalled;
            this._raiseStallClearedEvent = true;
        } else {
            this._raiseStallDetectedEvent = true;
        }
        if ((data3 & 2) != 0) {
            this._deviceState = State.DownloadRestart;
            if (this._raiseDownloadRestartEvent) {
                this.raiseDownloadRestartEvent();
            }
        }
        if ((data3 & 8) != 0) {
            this._capBarCodesExt = true;
        }
        this._isQueryDeviceCapabilitiesSupported = (data3 & 0x10) != 0;
    }

    private void processData4(byte data4) {
        if (this._capabilitiesProcessed) {
            return;
        }
        if (data4 != 0) {
            this._capabilitiesProcessed = true;
        }
        this._deviceModel = data4 & 0x7F;
        char m = (char)this._deviceModel;
        this._capApplicationPN = m == 'T' || m == 'U';
        this._capAssetNumber = m == 'T' || m == 'U';
        this._capAudit = m == 'T' || m == 'U';
        this._capBarCodes = m == 'T' || m == 'U' || this._deviceModel == 15L || this._deviceModel == 23L;
        this._capBookmark = true;
        this._capBootPN = m == 'T' || m == 'U';
        this._capCalibrate = true;
        this._capCashBoxTotal = m == 'A' || m == 'B' || m == 'C' || m == 'D' || m == 'G' || m == 'M' || m == 'P' || m == 'W' || m == 'X';
        this._capCouponExt = m == 'P' || m == 'X';
        this._capDevicePaused = m == 'P' || m == 'X' || this._deviceModel == 31L;
        this._capDeviceSoftReset = m == 'A' || m == 'B' || m == 'C' || m == 'D' || m == 'G' || m == 'M' || m == 'P' || m == 'T' || m == 'U' || m == 'W' || m == 'X' || this._deviceModel == 31L;
        this._capDeviceType = m == 'T' || m == 'U';
        this._capDeviceResets = m == 'A' || m == 'B' || m == 'C' || m == 'D' || m == 'G' || m == 'M' || m == 'P' || m == 'T' || m == 'U' || m == 'W' || m == 'X';
        this._capDeviceSerialNumber = m == 'T' || m == 'U';
        this._capFlashDownload = true;
        this._capEscrowTimeout = m == 'T' || m == 'U';
        this._capNoPush = m == 'P' || m == 'X' || this._deviceModel == 31L || this._deviceModel == 23L;
        this._capVariantPN = m == 'T' || m == 'U';
        this._expandedNoteReporting = m == 'T' || m == 'U';
    }

    private void processData5(byte data5) {
        this._deviceRevision = this._deviceModel < 23L || this._deviceModel == 30L || this._deviceModel == 31L || this._deviceModel == 74L || this._deviceModel == 84L || this._deviceModel == 85L ? (long)(data5 & 0x7F) : (long)((data5 & 0xF) + (data5 & 0x70) * 10);
    }

    private void queryDeviceCapabilities() throws AcceptorException {
        if (!this._isQueryDeviceCapabilitiesSupported) {
            return;
        }
        byte[] payload = new byte[]{96, 0, 0, 13};
        byte[] replyLocal = this.sendSynchronousCommand(payload, "QryDevCaps command");
        if (replyLocal.length != 11) {
            return;
        }
        this._capPupExt = (replyLocal[3] & 1) != 0;
        boolean bl = this._capOrientationExt = (replyLocal[3] & 2) != 0;
        if ((replyLocal[3] & 4) != 0) {
            this._capApplicationId = true;
            this._capVariantId = true;
        } else {
            this._capApplicationId = false;
            this._capVariantId = false;
        }
        this._capBNFStatus = (replyLocal[3] & 8) != 0;
        this._capTestDoc = (replyLocal[3] & 0x10) != 0;
        this._capSetBezel = (replyLocal[3] & 0x20) != 0;
        this._capEasitrax = (replyLocal[3] & 0x40) != 0;
        this._capNoteRetrieved = (replyLocal[4] & 1) != 0;
        this._capAdvBookmark = (replyLocal[4] & 2) != 0;
        this._capClearAudit = (replyLocal[4] & 8) != 0;
    }

    EBDS_SerialPort getTransport() {
        return this._transport;
    }

    void setReplyAcked(boolean replyAcked) {
        this._replyAcked = replyAcked;
    }

    private void openLogFile() throws AcceptorException {
        try {
            File f;
            if (this._logWriter != null) {
                try {
                    this._logWriter.close();
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            if ((f = new File(this._debugLogPath)).isDirectory()) {
                String logFileName = f.getAbsolutePath() + File.separator + "MPOST_Log_" + this._port.substring(this._port.lastIndexOf("/") + 1) + ".txt";
                this._logWriter = new BufferedWriter(new FileWriter(logFileName));
                this.log("--------------------------------------------------------------------------------");
                this.log(String.format("M/POST version %s log opened %s.", Acceptor.getVersion(), new SimpleDateFormat("dd/MM/yyyy").format(Calendar.getInstance().getTime())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeLogFile() {
        this._transport.flushIdenticalCommands();
        this.log("Log closed.");
        if (this._logWriter != null) {
            try {
                this._logWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._logWriter = null;
    }

    private void raiseCalibrateFinishEvent() {
        this._raiseCalibrateFinishEvent = false;
        this.fireAcceptorEvent(new CalibrateFinishEvent(this));
    }

    private void raiseCalibrateProgressEvent() {
        this._raiseCalibrateProgressEvent = false;
        this.fireAcceptorEvent(new CalibrateProgressEvent(this));
    }

    private void raiseCalibrateStartEvent() {
        this.fireAcceptorEvent(new CalibrateStartEvent(this));
    }

    private void raiseCashboxCleanlinessEvent(byte eventValue) {
        CashBoxCleanlinessEnum value;
        switch (eventValue) {
            case 17: {
                value = CashBoxCleanlinessEnum.CleaningRecommended;
                break;
            }
            case 16: {
                value = CashBoxCleanlinessEnum.CleaningRequired;
                break;
            }
            default: {
                return;
            }
        }
        this.fireAcceptorEvent(new CashBoxCleanlinessDetected(this, value));
    }

    private void raiseCashBoxAttachedEvent() {
        this._raiseCashBoxAttachedEvent = false;
        this.fireAcceptorEvent(new CashBoxAttachedEvent(this));
    }

    private void raiseCashBoxRemovedEvent() {
        this._raiseCashBoxRemovedEvent = false;
        this.fireAcceptorEvent(new CashBoxRemovedEvent(this));
    }

    private void raiseFailureDetectedEvent() {
        this._raiseFailureDetectedEvent = false;
        this._raiseFailureClearedEvent = true;
        this.fireAcceptorEvent(new FailureDetectedEvent(this));
    }

    private void raiseFailureClearedEvent() {
        this._raiseFailureClearedEvent = false;
        this._raiseFailureDetectedEvent = true;
        this.fireAcceptorEvent(new FailureClearedEvent(this));
    }

    private void raiseCheatedEvent() {
        this._raiseCheatedEvent = false;
        this.fireAcceptorEvent(new CheatedEvent(this));
    }

    private void raiseClearAuditEvent(boolean success) {
        this.fireAcceptorEvent(new ClearAuditCompleteEvent(this, success));
    }

    private void raiseDownloadStartEvent(int finalPacketNum) {
        this.fireAcceptorEvent(new DownloadStartEvent(this, finalPacketNum));
    }

    private void raiseDownloadProgressEvent(int packetNum) {
        this.fireAcceptorEvent(new DownloadProgressEvent(this, packetNum));
    }

    private void raiseDownloadRestartEvent() {
        this._raiseDownloadRestartEvent = false;
        this.fireAcceptorEvent(new DownloadRestartEvent(this));
    }

    private void raiseDownloadFinishEvent(boolean success) {
        this._flashDownloadThread = null;
        this.fireAcceptorEvent(new DownloadFinishEvent(this, success));
    }

    void raiseConnectedEvent() {
        this._raiseConnectedEvent = false;
        this._raiseDisconnectedEvent = true;
        this.fireAcceptorEvent(new ConnectedEvent(this));
    }

    private void raiseEscrowEvent() {
        this._raiseEscrowEvent = false;
        this._raisePUPEscrowEvent = false;
        this.fireAcceptorEvent(new EscrowEvent(this));
    }

    void raiseSendMessageErrorEvent(Message message) {
        this.fireAcceptorEvent(new SendMessageFailureEvent(this, message));
    }

    private void raiseEvents() {
        if (this._isPoweredUp && this._raisePowerUpEvent) {
            this.raisePowerUpEvent();
        }
        if (this._isVeryFirstPoll) {
            this._isVeryFirstPoll = false;
            return;
        }
        if (this._raiseConnectedEvent) {
            this.raiseConnectedEvent();
        }
        if (!this._connected) {
            return;
        }
        if (!this._isPoweredUp && this._raisePowerUpCompleteEvent) {
            if (this._raiseStackedEvent) {
                this.raiseStackedEvent();
            }
            this.raisePowerUpCompleteEvent();
        }
        if (!this._isPoweredUp && this._cashBoxAttached && this._raiseCashBoxAttachedEvent) {
            this.raiseCashBoxAttachedEvent();
        }
        if (this._deviceState == State.Escrow) {
            if (this._isPoweredUp && this._raisePUPEscrowEvent) {
                this.raisePUPEscrowEvent();
            } else if (this._raiseEscrowEvent && !this._autoStack && this._connected && !this._bDisabledWhileAccpeting) {
                this.raiseEscrowEvent();
            }
            this._bDisabledWhileAccpeting = false;
        }
        if (this._raiseStackedEvent) {
            this.raiseStackedEvent();
        }
        if (this._raiseReturnedEvent) {
            this.raiseReturnedEvent();
        }
        if (this._raiseRejectedEvent) {
            this._bDisabledWhileAccpeting = false;
            this.raiseRejectedEvent();
        }
        if (this._deviceState == State.Stalled && this._raiseStallDetectedEvent) {
            this.raiseStallDetectedEvent();
        }
        if (this._deviceState != State.Stalled && this._raiseStallClearedEvent) {
            this.raiseStallClearedEvent();
        }
        if (this._cashBoxFull && this._raiseStackerFullEvent) {
            this.raiseStackerFullEvent();
        }
        if (!this._isPoweredUp && !this._cashBoxFull && this._raiseStackerFullClearedEvent) {
            this.raiseStackerFullClearedEvent();
        }
        if (this._cheated && this._raiseCheatedEvent) {
            this.raiseCheatedEvent();
        }
        if (!this._cashBoxAttached && this._raiseCashBoxRemovedEvent) {
            this.raiseCashBoxRemovedEvent();
        }
        if (this._devicePaused && this._raisePauseDetectedEvent) {
            this.raisePauseDetectedEvent();
        }
        if (!this._devicePaused && this._raisePauseClearedEvent) {
            this.raisePauseClearedEvent();
        }
        if (this._isDeviceJammed && this._raiseJamDetectedEvent) {
            this.raiseJamDetectedEvent();
        }
        if (!this._isPoweredUp && !this._isDeviceJammed && this._raiseJamClearedEvent) {
            this.raiseJamClearedEvent();
        }
        if (this._raiseCalibrateFinishEvent) {
            this.raiseCalibrateFinishEvent();
        }
        if (this._isInFailedState && this._raiseFailureDetectedEvent) {
            this.raiseFailureDetectedEvent();
        }
        if (!this._isPoweredUp && !this._isInFailedState && this._raiseFailureClearedEvent) {
            this.raiseFailureClearedEvent();
        }
    }

    private void clearBillTable() {
        this._lstBillTypes.clear();
        this._lstBillTypeEnables.clear();
        this._lstBillValues.clear();
        this._lstBillValueEnables.clear();
    }

    private void retrieveBillTable() throws AcceptorException {
        int index = 1;
        int iTry = 0;
        while (true) {
            byte[] payload = this.constructOmnibusCommand(6, (byte)112, 2);
            payload[1] = 2;
            payload[5] = (byte)index;
            byte[] thisReply = null;
            while (true) {
                if (iTry >= 3) {
                    throw new AcceptorException("Error Retrieving Bill Information for Index " + index + ".");
                }
                thisReply = this.sendSynchronousCommand(payload, "QryBillData");
                if (thisReply.length == 30) break;
                ++iTry;
                Util.sleep(100L);
            }
            byte ctl = thisReply[2];
            if ((ctl & 0x70) != 112 || thisReply[3] != 2) {
                ++iTry;
                break;
            }
            this.processExtendedOmnibusExpandedNoteReply(thisReply);
            this.raiseEvents();
            if (thisReply[10] == 0) {
                ++iTry;
                break;
            }
            Bill billFromTable = this.parseBillData(thisReply, 10);
            this._lstBillTypes.add(billFromTable);
            ++index;
            iTry = 0;
        }
        for (int i = 0; i < this._lstBillTypes.size(); ++i) {
            this._lstBillTypeEnables.add(Boolean.TRUE);
        }
    }

    private void sendAsynchronousCommand(byte[] payload, String description) {
        this.sendAsynchronousCommand(payload, description, false);
    }

    private void sendAsynchronousCommand(byte[] payload, String description, boolean noReplyExpected) {
        this._cmdQueue.add(new Message(payload, false, description, noReplyExpected));
    }

    private byte[] sendSynchronousCommand(byte[] payload, String description) throws AcceptorException {
        assert (this._replyQueue.size() == 0);
        this._replyQueue.clear();
        this._cmdQueue.add(new Message(payload, true, description, false));
        long startTime = System.currentTimeMillis();
        while (this._replyQueue.isEmpty() && System.currentTimeMillis() - startTime < 5000L) {
            Util.sleep(10L);
        }
        if (!this._replyQueue.isEmpty()) {
            return this._replyQueue.remove();
        }
        throw new AcceptorException("Unexpected timeout detected in sendSynchronousCommand function");
    }

    private void verifyPropertyIsAllowed(boolean capabilityFlag, String propertyName) throws AcceptorException {
        if (!this._connected) {
            throw new AcceptorException("Calling " + propertyName + " not allowed when not connected.");
        }
        if (!capabilityFlag) {
            throw new AcceptorException("Device does not support " + propertyName + ".");
        }
        if (this._deviceState == State.DownloadStart || this._deviceState == State.Downloading) {
            throw new AcceptorException("Calling " + propertyName + " not allowed during flash download.");
        }
        if (this._deviceState == State.CalibrateStart || this._deviceState == State.Calibrating) {
            throw new AcceptorException("Calling " + propertyName + " not allowed during calibration.");
        }
    }

    private void verifyConnected(String functionName) throws AcceptorException {
        if (!this._connected) {
            throw new AcceptorException("Calling " + functionName + " not allowed when not connected.");
        }
    }

    @Override
    public void acceptorEventOccurred(AcceptorEvent evt) {
        this.log("EVNT: " + evt.getDescription());
    }

    public boolean isInSoftResetWaitForReply() {
        return this._inSoftResetWaitForReply;
    }

    void setInSoftResetWaitForReply(boolean inSoftResetWaitForReply) {
        this._inSoftResetWaitForReply = inSoftResetWaitForReply;
    }

    void raiseDisconnectedEvent() {
        this._raiseDisconnectedEvent = false;
        this._raiseFailureDetectedEvent = true;
        this._raiseJamDetectedEvent = true;
        this._raiseStackerFullEvent = true;
        this._raiseEscrowEvent = true;
        this._raiseCashBoxRemovedEvent = true;
        this.fireAcceptorEvent(new DisconnectedEvent(this));
    }

    void raiseInvalidCommandEvent() {
        this.fireAcceptorEvent(new InvalidCommandEvent(this));
    }

    private void raiseJamClearedEvent() {
        this._raiseJamClearedEvent = false;
        this.fireAcceptorEvent(new JamClearedEvent(this));
    }

    private void raiseJamDetectedEvent() {
        this._raiseJamDetectedEvent = false;
        this.fireAcceptorEvent(new JamDetectedEvent(this));
    }

    private void raiseNoteRetrievedEvent() {
        this.fireAcceptorEvent(new NoteRetrievedEvent(this));
    }

    private void raisePUPEscrowEvent() {
        this._raisePUPEscrowEvent = false;
        this._raiseEscrowEvent = false;
        this.fireAcceptorEvent(new PUPEscrowEvent(this));
    }

    private void raisePauseClearedEvent() {
        this._raisePauseClearedEvent = false;
        this.fireAcceptorEvent(new PauseClearedEvent(this));
    }

    private void raisePauseDetectedEvent() {
        this._raisePauseDetectedEvent = false;
        this.fireAcceptorEvent(new PauseDetectedEvent(this));
    }

    private void raisePowerUpEvent() {
        this._raisePowerUpEvent = false;
        this._raisePUPEscrowEvent = true;
        this._raisePowerUpCompleteEvent = true;
        this.fireAcceptorEvent(new PowerUpEvent(this));
        if (this._capNoteRetrieved) {
            byte[] payload = this.constructOmnibusCommand(6, (byte)112, 2);
            payload[1] = 11;
            payload[5] = 1;
            this.sendAsynchronousCommand(payload, "Enable Note Retrieved Event");
        }
    }

    private void raisePowerUpCompleteEvent() {
        this._raisePowerUpCompleteEvent = false;
        this.fireAcceptorEvent(new PowerUpCompleteEvent(this));
    }

    private void raiseRejectedEvent() {
        this._raiseRejectedEvent = false;
        this.fireAcceptorEvent(new RejectedEvent(this));
    }

    private void raiseReturnedEvent() {
        this._raiseReturnedEvent = false;
        this.fireAcceptorEvent(new ReturnedEvent(this));
    }

    private void raiseStackedEvent() {
        this._raiseStackedEvent = false;
        this.fireAcceptorEvent(new StackedEvent(this));
    }

    private void raiseStackerFullEvent() {
        this._raiseStackerFullEvent = false;
        this.fireAcceptorEvent(new StackerFullEvent(this));
    }

    private void raiseStackerFullClearedEvent() {
        this._raiseStackerFullClearedEvent = false;
        this.fireAcceptorEvent(new StackerFullClearedEvent(this));
    }

    private void raiseStallClearedEvent() {
        this._raiseStallClearedEvent = false;
        this.fireAcceptorEvent(new StallClearedEvent(this));
    }

    private void raiseStallDetectedEvent() {
        this._raiseStallDetectedEvent = false;
        this.fireAcceptorEvent(new StallDetectedEvent(this));
    }

    boolean connectorThreadIsRunning() {
        return this._openThread != null && this._openThread.isAlive();
    }

    private class FlashDownloadThread
    extends Thread {
        private File _downloadFile;
        private long _downloadSize;
        private boolean _stopThread;

        public FlashDownloadThread(File downloadFile, long downloadFileSize) {
            this._downloadFile = downloadFile;
            this._downloadSize = downloadFileSize;
            this._stopThread = false;
        }

        public void stopThread() {
            this._stopThread = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] reply = new byte[]{};
                byte[] payload = new byte[]{16, 0, 0, 0};
                int packetNum = 0;
                int finalPacketNum = (int)(this._downloadSize / 32L);
                if (Acceptor.this._deviceState != State.DownloadRestart) {
                    Acceptor.this._suppressStandardPoll = true;
                    Util.sleep(1000L);
                    Acceptor.this._deviceState = State.DownloadStart;
                    do {
                        if (this._stopThread) {
                            Acceptor.this._deviceState = State.Idling;
                            Acceptor.this._suppressStandardPoll = false;
                            return;
                        }
                        reply = Acceptor.this.sendSynchronousCommand(payload, "Poll before download");
                        if (Acceptor.this._connected) continue;
                        Acceptor.this.raiseDownloadFinishEvent(false);
                        Acceptor.this._deviceState = State.Idling;
                        Acceptor.this._suppressStandardPoll = false;
                        return;
                    } while (reply.length == 0);
                    if ((reply[2] & 0x70) == 32) {
                        byte[] payload2 = new byte[]{80, 0, 0, 0};
                        while ((reply = Acceptor.this.sendSynchronousCommand(payload2, "Download command")).length != 11 || (reply[6] & 7) != 2) {
                        }
                        Acceptor.this.raiseDownloadStartEvent(finalPacketNum);
                    } else {
                        packetNum = ((reply[3] & 0xF) << 12) + ((reply[4] & 0xF) << 8) + ((reply[5] & 0xF) << 4) + ((reply[6] & 0xF) + 1) & 0xFFFF;
                    }
                } else {
                    Acceptor.this._deviceState = State.DownloadStart;
                    Acceptor.this._suppressStandardPoll = true;
                    Acceptor.this.raiseDownloadStartEvent(finalPacketNum);
                    Util.sleep(1000L);
                }
                RandomAccessFile raf = new RandomAccessFile(this._downloadFile, "r");
                byte[] payload3 = new byte[69];
                payload3[0] = 80;
                long timeoutStartTickCount = System.currentTimeMillis();
                do {
                    if (this._stopThread) {
                        Acceptor.this._deviceState = State.Idling;
                        Acceptor.this._suppressStandardPoll = false;
                        return;
                    }
                    payload3[1] = (byte)((packetNum & 0xF000) >> 12);
                    payload3[2] = (byte)((packetNum & 0xF00) >> 8);
                    payload3[3] = (byte)((packetNum & 0xF0) >> 4);
                    payload3[4] = (byte)(packetNum & 0xF);
                    byte[] dataBuffer = new byte[32];
                    raf.seek(packetNum * 32);
                    raf.read(dataBuffer);
                    for (int i = 0; i < 32; ++i) {
                        payload3[5 + i * 2] = (byte)((dataBuffer[i] & 0xF0) >> 4);
                        payload3[6 + i * 2] = (byte)(dataBuffer[i] & 0xF);
                    }
                    Acceptor.this._cmdQueue.clear();
                    reply = Acceptor.this.sendSynchronousCommand(payload3, "Download Packet: " + packetNum);
                    if (reply.length == 9 && Acceptor.this._replyAcked && (reply[3] & reply[4] & reply[5] & reply[6] & 0xF) != 15) {
                        timeoutStartTickCount = System.currentTimeMillis();
                        Acceptor.this._deviceState = State.Downloading;
                        Acceptor.this.raiseDownloadProgressEvent(packetNum);
                        ++packetNum;
                    } else {
                        Util.sleep(200L);
                        if (reply.length == 9) {
                            packetNum = ((reply[3] & 0xF) << 12) + ((reply[4] & 0xF) << 8) + ((reply[5] & 0xF) << 4) + ((reply[6] & 0xF) + 1) & 0xFFFF;
                        }
                    }
                    if (System.currentTimeMillis() - timeoutStartTickCount <= 30000L) continue;
                    Acceptor.this.raiseDownloadFinishEvent(false);
                    Acceptor.this._deviceState = State.Idling;
                    Acceptor.this._suppressStandardPoll = false;
                    return;
                } while (packetNum < finalPacketNum);
                raf.close();
                Util.sleep(30000L);
                long startTime = System.currentTimeMillis();
                reply = new byte[]{};
                while (reply.length == 0) {
                    if (this._stopThread) {
                        Acceptor.this._suppressStandardPoll = false;
                        return;
                    }
                    byte[] payloadInitial = new byte[]{16, 0, 16, 0};
                    Acceptor.this._cmdQueue.clear();
                    reply = Acceptor.this.sendSynchronousCommand(payloadInitial, "Initial Poll");
                    if (System.currentTimeMillis() - startTime <= 30000L) continue;
                    if (Acceptor.this._raiseDisconnectedEvent) {
                        Acceptor.this.raiseDisconnectedEvent();
                    }
                    startTime = System.currentTimeMillis();
                }
                Acceptor.this.processReply(reply);
                Acceptor.this.queryDeviceCapabilities();
                Acceptor.this.setUpBillTable();
                Acceptor.this.raiseDownloadFinishEvent(reply.length == 11);
                Acceptor.this._connected = true;
                if (Acceptor.this._capNoteRetrieved) {
                    byte[] payloadNoteRetrieved = Acceptor.this.constructOmnibusCommand(6, (byte)112, 2);
                    payloadNoteRetrieved[1] = 11;
                    payloadNoteRetrieved[5] = 1;
                    Acceptor.this.sendAsynchronousCommand(payloadNoteRetrieved, "Enable Note Retrieved Event");
                }
                Acceptor.this.raiseConnectedEvent();
            }
            catch (IOException ioe) {
                Acceptor.this.log("Error while reading the download file on flash download thread, aborting: " + ioe.getMessage());
                Acceptor.this.raiseDownloadFinishEvent(false);
            }
            catch (Exception e) {
                Acceptor.this.log("Error on flash download thread, aborting: " + e.getMessage());
                Acceptor.this.raiseDownloadFinishEvent(false);
            }
            finally {
                Acceptor.this._deviceState = State.Idling;
                Acceptor.this._suppressStandardPoll = false;
            }
        }
    }

    private class ConnectorThread
    extends Thread {
        private boolean _stopThread = false;

        public void stopThread() {
            this._stopThread = true;
        }

        public void run() {
            byte[] reply = new byte[]{};
            try {
                long startTime = System.currentTimeMillis();
                while (reply.length == 0) {
                    Util.sleep(100L);
                    if (this._stopThread) {
                        Acceptor.this._transport.close();
                        return;
                    }
                    byte[] payloadInitial = new byte[]{16, 0, 16, 0};
                    Acceptor.this._cmdQueue.clear();
                    reply = Acceptor.this.sendSynchronousCommand(payloadInitial, "Initial Poll");
                    if (System.currentTimeMillis() - startTime <= 30000L) continue;
                    throw new AcceptorException("Timeout. Could not connect in the given amount of time.");
                }
                Acceptor.this.processReply(reply);
                Acceptor.this.queryDeviceCapabilities();
                if (Acceptor.this._deviceState != State.DownloadRestart && Acceptor.this._deviceState != State.DownloadStart) {
                    Acceptor.this.setUpBillTable();
                    if (Acceptor.this._capNoteRetrieved) {
                        byte[] payload = Acceptor.this.constructOmnibusCommand(6, (byte)112, 2);
                        payload[1] = 11;
                        payload[5] = 1;
                        Acceptor.this.sendAsynchronousCommand(payload, "Enable Note Retrieved Event");
                    }
                    Acceptor.this._connected = true;
                    Acceptor.this.raiseConnectedEvent();
                }
            }
            catch (AcceptorException ex) {
                Acceptor.this.log("Failed to Open Connection: " + ex.getMessage());
                if (Acceptor.this._workerThread != null) {
                    Acceptor.this._workerThread.stopThread(false);
                }
                Acceptor.this.raiseDisconnectedEvent();
            }
        }
    }
}

