/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.api;

import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.Orientation;
import java.util.ArrayList;
import java.util.List;

public class AuditContainer {
    static final int INT_MAX_ORIENTATIONS = 4;
    private static final int INT_MAX_FIELDS = 3;
    public static final int INT_RIGHT_UP = 0;
    public static final int INT_RIGHT_DOWN = 1;
    public static final int INT_LEFT_UP = 2;
    public static final int INT_LEFT_DOWN = 3;
    static final int INT_FIELD_RECOGNIZED = 23;
    static final int INT_FIELD_VALIDATED = 24;
    static final int INT_FIELD_STACKED = 25;
    static final int INT_FIELD_MAX_VALUE = 26;
    private List<int[]> _lstRecognized;
    private List<int[]> _lstValidated;
    private List<int[]> _lstStacked;
    private int _iMaxNotes;
    private int _iFieldsPerQuery;
    private int _iNumDatasets;
    private int _iDataWidth;

    public int getMaximumNoteCount() {
        return this._iMaxNotes;
    }

    int getNumberOfDatasets() {
        return this._iNumDatasets;
    }

    int getDataWidth() {
        return this._iDataWidth;
    }

    AuditContainer(int maxNotes, int numFieldsPerQuery, int dataWidth) {
        int i;
        this._iMaxNotes = maxNotes;
        if (this._iMaxNotes == 127) {
            this._iMaxNotes = 128;
        }
        this._iFieldsPerQuery = numFieldsPerQuery;
        this._iNumDatasets = this._iMaxNotes / numFieldsPerQuery;
        if (this._iMaxNotes % numFieldsPerQuery != 0) {
            ++this._iNumDatasets;
        }
        this._iDataWidth = dataWidth;
        this._lstRecognized = new ArrayList<int[]>();
        for (i = 0; i < 4; ++i) {
            this._lstRecognized.add(new int[this._iMaxNotes]);
        }
        this._lstValidated = new ArrayList<int[]>();
        for (i = 0; i < 4; ++i) {
            this._lstValidated.add(new int[this._iMaxNotes]);
        }
        this._lstStacked = new ArrayList<int[]>();
        for (i = 0; i < 4; ++i) {
            this._lstStacked.add(new int[this._iMaxNotes]);
        }
    }

    void appendResults(int field, int orientation, int dataset, byte[] data) throws AcceptorException {
        int[] arrTmp;
        int iStartingIndex = 0;
        ArrayList<Integer> lstParsedValues = new ArrayList<Integer>();
        int iParseTmp = 0;
        if (orientation < 0 || orientation >= 4) {
            throw new AcceptorException(String.format("'Orientation' must be a positive value less than %d. Detected %d", 4, orientation));
        }
        switch (field) {
            case 23: {
                arrTmp = this._lstRecognized.get(orientation);
                break;
            }
            case 24: {
                arrTmp = this._lstValidated.get(orientation);
                break;
            }
            case 25: {
                arrTmp = this._lstStacked.get(orientation);
                break;
            }
            default: {
                throw new AcceptorException(String.format("'Field' must be a positive value less than %d. Detected %d", 3, field));
            }
        }
        if (data.length % this._iDataWidth != 0) {
            throw new AcceptorException(String.format("Unexpected number of data bytes. Length must be divisible by %d but detected a length of %d", this._iDataWidth, data.length));
        }
        for (int i = 0; i < data.length; ++i) {
            if (i != 0 && i % this._iDataWidth == 0) {
                lstParsedValues.add(iParseTmp);
                iParseTmp = 0;
            }
            int iShiftTmp = 4 * (this._iDataWidth - 1 - i % this._iDataWidth);
            iParseTmp |= (data[i] & 0xF) << iShiftTmp;
        }
        lstParsedValues.add(iParseTmp);
        iStartingIndex = dataset * this._iFieldsPerQuery;
        if (iStartingIndex + lstParsedValues.size() > arrTmp.length) {
            throw new AcceptorException(String.format("Inserting the data will result in an overflow. Data requires 0x%s bytes but only 0x%s locations remain", Integer.toHexString(lstParsedValues.size()), Integer.toHexString(arrTmp.length - iStartingIndex)));
        }
        int[] arrUnboxed = new int[lstParsedValues.size()];
        for (int i = 0; i < lstParsedValues.size(); ++i) {
            arrUnboxed[i] = (Integer)lstParsedValues.get(i);
        }
        System.arraycopy(arrUnboxed, 0, arrTmp, iStartingIndex, arrUnboxed.length);
    }

    public int[] getRecognizedData(Orientation orientation) throws AcceptorException {
        switch (orientation) {
            case RightUp: {
                return this.getRecognizedData(0);
            }
            case RightDown: {
                return this.getRecognizedData(1);
            }
            case LeftUp: {
                return this.getRecognizedData(2);
            }
            case LeftDown: {
                return this.getRecognizedData(3);
            }
        }
        throw new AcceptorException(String.format("Unable to fetch recognized data for orientation '%s'", orientation.toString()));
    }

    public int[] getRecognizedData(int orientationValue) throws AcceptorException {
        if (orientationValue < 0 || orientationValue >= 4) {
            throw new AcceptorException(String.format("'orientationValue' must be a positive value less than %d. Detected %d", 4, orientationValue));
        }
        return this._lstRecognized.get(orientationValue);
    }

    public int[] getValidatedData(Orientation orientation) throws AcceptorException {
        switch (orientation) {
            case RightUp: {
                return this.getValidatedData(0);
            }
            case RightDown: {
                return this.getValidatedData(1);
            }
            case LeftUp: {
                return this.getValidatedData(2);
            }
            case LeftDown: {
                return this.getValidatedData(3);
            }
        }
        throw new AcceptorException(String.format("Unable to fetch recognized data for orientation '%s'", orientation.toString()));
    }

    public int[] getValidatedData(int orientationValue) throws AcceptorException {
        if (orientationValue < 0 || orientationValue >= 4) {
            throw new AcceptorException(String.format("'orientationValue' must be a positive value less than %d. Detected %d", 4, orientationValue));
        }
        return this._lstValidated.get(orientationValue);
    }

    public int[] getStackedData(Orientation orientation) throws AcceptorException {
        switch (orientation) {
            case RightUp: {
                return this.getStackedData(0);
            }
            case RightDown: {
                return this.getStackedData(1);
            }
            case LeftUp: {
                return this.getStackedData(2);
            }
            case LeftDown: {
                return this.getStackedData(3);
            }
        }
        throw new AcceptorException(String.format("Unable to fetch recognized data for orientation '%s'", orientation.toString()));
    }

    public int[] getStackedData(int orientationValue) throws AcceptorException {
        if (orientationValue < 0 || orientationValue >= 4) {
            throw new AcceptorException(String.format("'orientationValue' must be a positive value less than %d. Detected %d", 4, orientationValue));
        }
        return this._lstStacked.get(orientationValue);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("Number of documents supported: %d", this._iMaxNotes));
        for (int b : this._lstRecognized.get(0)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstRecognized.get(1)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstRecognized.get(2)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstRecognized.get(3)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstValidated.get(0)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstValidated.get(1)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstValidated.get(2)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstValidated.get(3)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstStacked.get(0)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstStacked.get(1)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstStacked.get(2)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        for (int b : this._lstStacked.get(3)) {
            sb.append(String.format("%d ", b));
        }
        sb.append('\n');
        return sb.toString();
    }
}

