/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.api;

import com.meiglobal.ebds.api.Acceptor;
import com.meiglobal.ebds.api.Message;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.State;
import com.meiglobal.ebds.api.util.CustomTimer;
import com.meiglobal.ebds.api.util.SerialReadTimeout;
import com.meiglobal.ebds.api.util.Timeoutable;
import com.meiglobal.ebds.api.util.Util;
import java.io.IOException;

class Messenger
extends Thread
implements Timeoutable {
    private static final int MAX_RETRIES = 10;
    private static final int POLL_PACE = 5;
    private static final byte CMD_OMNIBUS = 16;
    private Acceptor _acceptor;
    private boolean _wasDisconnected;
    private boolean _stopThread;
    private boolean _bSendOneLastPoll = false;
    CustomTimer _customTimer;
    private boolean _timeoutOccured;

    public Messenger(Acceptor a) {
        this._acceptor = a;
        this._wasDisconnected = false;
        this._stopThread = false;
        this._customTimer = new CustomTimer(250L);
        this._customTimer.addTimeoutObserver(this);
    }

    public void stopThread(boolean allowOneMorePoll) {
        this._stopThread = true;
        this._bSendOneLastPoll = allowOneMorePoll;
    }

    public void timeoutOccured(CustomTimer ct) {
        this._timeoutOccured = true;
    }

    public void run() {
        byte[] payload = new byte[]{};
        byte[] reply = new byte[]{};
        boolean blnLostComms = false;
        boolean bLastPollSent = false;
        int loopCycleCounter = 0;
        long timeoutStartCount = System.currentTimeMillis();
        block5: while (!this._stopThread || this._bSendOneLastPoll) {
            Message message;
            if (this._acceptor.isInSoftResetWaitForReply()) {
                Util.sleep(200L);
            } else {
                Util.sleep(25L);
            }
            if (!this._acceptor.getTransport().isOpen() && !blnLostComms) continue;
            if (System.currentTimeMillis() - timeoutStartCount > 2000L) {
                this._acceptor._raisePowerUpEvent = true;
            }
            if (System.currentTimeMillis() - timeoutStartCount > (long)this._acceptor.getDisconnectTimeout()) {
                if (this._acceptor.getDeviceState() != State.Downloading && this._acceptor.getDeviceState() != State.DownloadRestart && this._acceptor.getConnected()) {
                    this._acceptor.setConnected(false);
                    this._acceptor.raiseDisconnectedEvent();
                    this._wasDisconnected = true;
                }
                timeoutStartCount = System.currentTimeMillis();
            }
            this._timeoutOccured = false;
            if (this._acceptor._cmdQueue.size() > 0) {
                message = this._acceptor._cmdQueue.remove();
                if (message.isSynchronous()) {
                    this._customTimer.start();
                }
            } else {
                message = null;
            }
            for (int i = 0; i < 11; ++i) {
                try {
                    if (i > 0) {
                        Util.sleep(25L);
                    }
                    if (i == 10) {
                        blnLostComms = true;
                        if (message == null) continue block5;
                        this._acceptor.raiseSendMessageErrorEvent(message);
                        continue block5;
                    }
                    if (this._timeoutOccured) {
                        this._acceptor._replyQueue.add(new byte[0]);
                        message = null;
                        continue block5;
                    }
                    if (message != null) {
                        loopCycleCounter = 0;
                        if (message.getPayload() == null || message.getPayload().length == 0) {
                            this._acceptor.raiseInvalidCommandEvent();
                            if (message.isSynchronous()) {
                                this._acceptor._replyQueue.add(new byte[0]);
                            }
                            message = null;
                            continue block5;
                        }
                        this._acceptor.getTransport().sendData(message.getPayload());
                        if (message.isNoReplyExpected()) {
                            continue block5;
                        }
                    } else {
                        if (this._acceptor.getSupressStandardPoll()) {
                            timeoutStartCount = System.currentTimeMillis();
                            loopCycleCounter = 0;
                            continue block5;
                        }
                        if (++loopCycleCounter < 5) continue block5;
                        loopCycleCounter = 0;
                        if (this._bSendOneLastPoll) {
                            bLastPollSent = true;
                        }
                        payload = this._acceptor.constructOmnibusCommand(4, (byte)16, 1);
                        this._acceptor.getTransport().sendData(payload);
                    }
                    reply = this._acceptor.getTransport().receive();
                    this._customTimer.stop();
                    timeoutStartCount = System.currentTimeMillis();
                    if (this._wasDisconnected) {
                        this._wasDisconnected = false;
                        if (!this._acceptor.connectorThreadIsRunning() && (reply[2] & 0x70) != 80) {
                            this._acceptor.setConnected(true);
                        }
                    }
                    if (this._acceptor.isInSoftResetWaitForReply()) {
                        this._acceptor.setInSoftResetWaitForReply(false);
                    }
                    this._acceptor.setReplyAcked(this._acceptor.getTransport().getReplyAcked(reply));
                    if (message != null && message.isSynchronous()) {
                        this._acceptor._replyQueue.add(reply);
                    } else {
                        this._acceptor.processReply(reply);
                    }
                    if (bLastPollSent && message == null) {
                        bLastPollSent = false;
                        this._bSendOneLastPoll = false;
                    }
                    blnLostComms = false;
                    continue block5;
                }
                catch (NullPointerException npEx) {
                    Util.sleep(1000L);
                    this._acceptor.getTransport().resetPort();
                    continue;
                }
                catch (IOException ioEx) {
                    this._acceptor.log(String.format("Exception with Port. Attempting Reset. - %s", ioEx.getMessage()));
                    this._acceptor.getTransport().resetPort();
                    if (this._acceptor.getTransport().isOpen()) continue;
                    blnLostComms = true;
                    continue;
                }
                catch (AcceptorException aEx) {
                    continue;
                }
                catch (SerialReadTimeout srtEx) {
                    // empty catch block
                }
            }
        }
        this._acceptor._cmdQueue.clear();
        this._acceptor.getTransport().close();
    }
}

