/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.event.AcceptorEvent;
import com.meiglobal.ebds.api.event.AcceptorEventListener;
import com.meiglobal.ebds.api.event.StackedEvent;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.gui.TestGUI;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DeviceInfoDialog
extends JDialog
implements AcceptorEventListener {
    TestGUI gui;
    JLabel lCashBoxTotal;
    JButton CashClearButton;
    private JPanel pMain;

    public DeviceInfoDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.gui = (TestGUI)parent;
        this.initComponents();
        this.createLabels();
    }

    private void bClearActionPerformed(ActionEvent evt) {
        try {
            this.gui.getAcceptor().clearCashBoxTotal();
            String cashBoxTotal = "Cash Box Total: " + String.valueOf(this.gui.getAcceptor().getCashBoxTotal());
            this.lCashBoxTotal.setText(cashBoxTotal);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void acceptorEventOccurred(AcceptorEvent evt) {
        if (evt instanceof StackedEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DeviceInfoDialog.this.gui.getAcceptor().getCapCashBoxTotal()) {
                        try {
                            String cashBoxTotal = "Cash Box Total: " + String.valueOf(DeviceInfoDialog.this.gui.getAcceptor().getCashBoxTotal());
                            DeviceInfoDialog.this.lCashBoxTotal.setText(cashBoxTotal);
                        }
                        catch (AcceptorException ae) {
                            ae.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private void createLabels() {
        try {
            JLabel lVariantId;
            JLabel lApplicationId;
            JLabel lApplicationPN;
            JLabel lDeviceBootPartNumber;
            JLabel lDeviceType;
            this.enableEvents(128L);
            this.gui.getAcceptor().addAcceptorEventListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(3, 3, 3, 3);
            JLabel lDeviceTitle = new JLabel("DEVICE INFO:");
            this.pMain.add((Component)lDeviceTitle, gbc);
            ++gbc.gridy;
            if (this.gui.getAcceptor().getCapDeviceType()) {
                lDeviceType = new JLabel("Device type: " + this.gui.getAcceptor().getDeviceType());
                this.pMain.add((Component)lDeviceType, gbc);
                ++gbc.gridy;
            } else {
                lDeviceType = new JLabel("Device type: Not supported");
                this.pMain.add((Component)lDeviceType, gbc);
                ++gbc.gridy;
            }
            JLabel lDeviceCRC = new JLabel("Device CRC: " + String.format("%04X", this.gui.getAcceptor().getDeviceCRC()));
            this.pMain.add((Component)lDeviceCRC, gbc);
            ++gbc.gridy;
            JLabel lDeviceSerial = new JLabel("Serial #: " + this.gui.getAcceptor().getDeviceSerialNumber());
            this.pMain.add((Component)lDeviceSerial, gbc);
            ++gbc.gridy;
            if (this.gui.getAcceptor().getCapBootPN()) {
                lDeviceBootPartNumber = new JLabel("Boot part #: " + this.gui.getAcceptor().getBootPN());
                this.pMain.add((Component)lDeviceBootPartNumber, gbc);
                ++gbc.gridy;
            } else {
                lDeviceBootPartNumber = new JLabel("Boot part #: Not supported");
                this.pMain.add((Component)lDeviceBootPartNumber, gbc);
                ++gbc.gridy;
            }
            if (this.gui.getAcceptor().getCapApplicationPN()) {
                lApplicationPN = new JLabel("Application PN: " + this.gui.getAcceptor().getApplicationPN());
                this.pMain.add((Component)lApplicationPN, gbc);
                ++gbc.gridy;
            } else {
                lApplicationPN = new JLabel("Application PN: Not Supported");
                this.pMain.add((Component)lApplicationPN, gbc);
                ++gbc.gridy;
            }
            if (this.gui.getAcceptor().getCapApplicationId()) {
                lApplicationId = new JLabel("Application Id: " + this.gui.getAcceptor().getApplicationId());
                this.pMain.add((Component)lApplicationId, gbc);
                ++gbc.gridy;
            } else {
                lApplicationId = new JLabel("Application Id: Not supported");
                this.pMain.add((Component)lApplicationId, gbc);
                ++gbc.gridy;
            }
            JLabel lVariantPN = null;
            JLabel lVariantName = null;
            lVariantPN = this.gui.getAcceptor().getCapVariantPN() ? new JLabel("Variant PN: " + this.gui.getAcceptor().getVariantPN()) : new JLabel("Variant PN: Not supported");
            this.pMain.add((Component)lVariantPN, gbc);
            ++gbc.gridy;
            if (this.gui.getAcceptor().getCapVariantId()) {
                lVariantId = new JLabel("Variant Id: " + this.gui.getAcceptor().getVariantID());
                this.pMain.add((Component)lVariantId, gbc);
                ++gbc.gridy;
            } else {
                lVariantId = new JLabel("Variant Id: Not supported");
                this.pMain.add((Component)lVariantId, gbc);
                ++gbc.gridy;
            }
            if (this.gui.getAcceptor().getCapVariantPN()) {
                String variants = "Variant Names: ";
                List<String> names = this.gui.getAcceptor().getVariantNames();
                for (String name : names) {
                    variants = variants + name + System.getProperty("line.separator");
                }
                lVariantName = new JLabel(variants);
            } else {
                lVariantName = new JLabel("Variant Names: Not supported");
            }
            this.pMain.add((Component)lVariantName, gbc);
            ++gbc.gridy;
            JLabel lCasseteStatus = new JLabel("Cassette: " + (this.gui.getAcceptor().getCashBoxAttached() ? "Installed" : "Not installed"));
            this.pMain.add((Component)lCasseteStatus, gbc);
            ++gbc.gridy;
            String cashBoxTotal = "Cash Box Total: " + (this.gui.getAcceptor().getCapCashBoxTotal() ? String.valueOf(this.gui.getAcceptor().getCashBoxTotal()) : "Not supported");
            this.lCashBoxTotal = new JLabel(cashBoxTotal);
            this.pMain.add((Component)this.lCashBoxTotal, gbc);
            ++gbc.gridy;
            if (this.gui.getAcceptor().getCapCashBoxTotal()) {
                this.CashClearButton = new JButton();
                this.CashClearButton.setText("Clear");
                this.CashClearButton.setToolTipText("Clear the Cash box total.");
                this.CashClearButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        DeviceInfoDialog.this.bClearActionPerformed(evt);
                    }
                });
                this.pMain.add((Component)this.CashClearButton, gbc);
                ++gbc.gridy;
            }
            JLabel lResets = new JLabel(String.valueOf("Resets: " + this.gui.getAcceptor().getDeviceResets()));
            this.pMain.add((Component)lResets, gbc);
            ++gbc.gridy;
            JLabel lPath = new JLabel("Bill path: " + String.valueOf(this.gui.getAcceptor().getDeviceJammed() ? "Jammed" : "Clear"));
            this.pMain.add((Component)lPath, gbc);
            ++gbc.gridy;
            long model = this.gui.getAcceptor().getDeviceModel();
            String modelString = "Model: " + model;
            if (model >= 32L) {
                modelString = modelString + " (" + (char)model + ")";
            }
            JLabel lModel = new JLabel(modelString);
            this.pMain.add((Component)lModel, gbc);
            ++gbc.gridy;
            JLabel lBNFStatus = new JLabel("BNF Status: " + (this.gui.getAcceptor().getCapBNFStatus() ? this.gui.getAcceptor().GetBNFStatus() : "Not supported"));
            this.pMain.add((Component)lBNFStatus, gbc);
            this.pack();
        }
        catch (AcceptorException ae) {
            ae.printStackTrace();
        }
    }

    private void initComponents() {
        this.pMain = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Device Info");
        this.pMain.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pack();
    }
}

