/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.pub.Bill;
import com.meiglobal.ebds.gui.TestGUI;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BillValuesDialog
extends JDialog {
    TestGUI gui;
    List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private JPanel pMain;

    public BillValuesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.gui = (TestGUI)parent;
        List<Bill> bills = this.gui.getAcceptor().getBillValues();
        List<Boolean> billsEnable = this.gui.getAcceptor().getBillValueEnables();
        this.createHeader();
        int counter = 0;
        for (Bill bill : bills) {
            this.createBillComponents(bill, counter);
            ++counter;
        }
        counter = 0;
        for (Boolean bl : billsEnable) {
            this.checkBoxes.get(counter).setSelected(bl);
            ++counter;
        }
        this.addListeners();
        this.pack();
    }

    private void addListeners() {
        for (JCheckBox cb : this.checkBoxes) {
            cb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    List<Boolean> bills = BillValuesDialog.this.gui.getAcceptor().getBillValueEnables();
                    bills.set(Integer.parseInt(((JCheckBox)evt.getSource()).getActionCommand()), evt.getStateChange() == 1);
                    System.out.println("setting " + (evt.getStateChange() == 1) + " to " + ((JCheckBox)evt.getSource()).getActionCommand());
                    try {
                        BillValuesDialog.this.gui.getAcceptor().setBillValueEnables(bills);
                    }
                    catch (Exception ex) {
                        System.out.println("Exception with setting bills: " + ex.getMessage());
                    }
                }
            });
        }
    }

    private void createBillComponents(Bill b, int index) {
        JCheckBox cb = new JCheckBox();
        cb.setActionCommand(String.valueOf(index));
        JLabel lNumber = new JLabel();
        JLabel lValue = new JLabel();
        JLabel lIsoCode = new JLabel();
        JLabel lAttributes = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        Insets i = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = index + 1;
        gbc.insets = i;
        this.pMain.add((Component)cb, gbc);
        lNumber.setText(String.valueOf(index + 1));
        gbc.gridx = 1;
        this.pMain.add((Component)lNumber, gbc);
        gbc.gridx = 2;
        lIsoCode.setText(b.getCountry());
        this.pMain.add((Component)lIsoCode, gbc);
        gbc.gridx = 3;
        lValue.setText(String.valueOf(b.getValue()));
        this.pMain.add((Component)lValue, gbc);
        gbc.gridx = 4;
        lAttributes.setText((char)b.getType() + " " + (char)b.getSeries() + " " + (char)b.getCompatibility() + " " + (char)b.getVersion());
        this.pMain.add((Component)lAttributes, gbc);
        this.checkBoxes.add(cb);
    }

    private void createHeader() {
        GridBagConstraints gbc = new GridBagConstraints();
        Insets i = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = i;
        gbc.fill = 2;
        this.pMain.add((Component)new JLabel(), gbc);
        gbc.gridx = 1;
        this.pMain.add((Component)new JLabel("#"), gbc);
        gbc.gridx = 2;
        this.pMain.add((Component)new JLabel("ISO Code"), gbc);
        gbc.gridx = 3;
        this.pMain.add((Component)new JLabel("Value"), gbc);
        gbc.gridx = 4;
        this.pMain.add((Component)new JLabel("Attributes"), gbc);
    }

    private void initComponents() {
        this.pMain = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Bill Values");
        this.pMain.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pack();
    }
}

