/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.Acceptor;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.gui.TestGUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class GUI
extends JFrame {
    private List<TestGUI> instances = new ArrayList<TestGUI>();
    private JButton bConnect;
    private JButton bRetrievePorts;
    private JComboBox cPorts;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lVersion;

    public GUI() {
        this.initComponents();
        this.lVersion.setText("API Version in Use: " + Acceptor.getVersion());
        this.center();
        this.doRetrievePorts();
    }

    void addPort(String port) {
        this.cPorts.addItem(port);
    }

    private void center() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 2;
        Point p = new Point((int)(d.getWidth() / 2.0 - (double)x), (int)(d.getHeight() / 2.0 - (double)y));
        this.setLocation(p);
    }

    private void initComponents() {
        this.cPorts = new JComboBox();
        this.bRetrievePorts = new JButton();
        this.jLabel1 = new JLabel();
        this.bConnect = new JButton();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.lVersion = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("M/POST Java Demo V2.80");
        this.getContentPane().setLayout(new GridBagLayout());
        this.cPorts.setPreferredSize(new Dimension(200, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cPorts, gridBagConstraints);
        this.bRetrievePorts.setText("Retrieve Ports");
        this.bRetrievePorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.bRetrievePortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.bRetrievePorts, gridBagConstraints);
        this.jLabel1.setText("Available Ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.bConnect.setText("Start");
        this.bConnect.setToolTipText("Launch a Bill Acceptor control panel.");
        this.bConnect.setEnabled(false);
        this.bConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.bConnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.bConnect, gridBagConstraints);
        this.jLabel2.setText("Retrieve the available ports and then click open to initiate the instance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jButton1.setText("Exit");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.ExitDemoButton(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.lVersion.setHorizontalAlignment(11);
        this.lVersion.setText("API Version in Use:");
        this.lVersion.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lVersion, gridBagConstraints);
        this.pack();
    }

    private void bRetrievePortsActionPerformed(ActionEvent evt) {
        this.doRetrievePorts();
    }

    private void doRetrievePorts() {
        String[] ports = Acceptor.listPorts();
        ArrayList<String> freePorts = new ArrayList<String>();
        for (String port : ports) {
            boolean found = false;
            for (TestGUI gui : this.instances) {
                if (!port.equals(gui.getPort())) continue;
                found = true;
                break;
            }
            if (found) continue;
            freePorts.add(port);
        }
        this.cPorts.setModel(new DefaultComboBoxModel<Object>(freePorts.toArray()));
        this.bConnect.setEnabled(true);
    }

    private void bConnectActionPerformed(ActionEvent evt) {
        try {
            String port = (String)this.cPorts.getSelectedItem();
            TestGUI instance = new TestGUI(this, port);
            this.instances.add(instance);
            instance.center();
            this.cPorts.removeItem(port);
            instance.setVisible(true);
        }
        catch (AcceptorException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "There has been an error instantiating the demo app", "Error", 0);
        }
    }

    private void ExitDemoButton(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            Logger.getLogger(TestGUI.class.getName()).severe("Could not initialize system look and feel");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GUI().setVisible(true);
            }
        });
    }
}

