package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.event.*;
import com.meiglobal.ebds.api.pub.*;
import com.meiglobal.ebds.api.Acceptor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import java.util.ArrayList;
import javax.swing.Timer;

public class TestGUI extends javax.swing.JFrame implements AcceptorEventListener
{

   JFileChooser jfc = new JFileChooser();
   Acceptor a = null;
   String port;
   GUI gui;
   BillSetDialog bsd;
   BillValuesDialog bvd;
   AuditLifetimeTotalsDialog altd;
   AuditPerformanceDialog apd;
   DeviceInfoDialog did;
   AuditQPDialog aqp;
   FlashDownloadDialog fdd;
   PropertiesFrame pf;

   /** Creates new form TestGUI
    * @param gui
    * @param port
    * @throws AcceptorException
    */
   public TestGUI(GUI gui, String port) throws AcceptorException
   {
      this.gui = gui;
      this.setTitle("Demo application controling device on port " + port);
      initComponents();
      a = new Acceptor();
      a.addAcceptorEventListener(this);
      a.setDebugLogPath(".");
      tDebugLog.setText(a.getDebugLogPath());
      a.setDebugLog(false);
      this.port = port;
      lPort.setText("Port: " + port);
      tEscrowBar.setDocument(new ShortDocument());
      tEscrowBill.setDocument(new ShortDocument());
      cPowerUp.setModel(new DefaultComboBoxModel(PowerUp.values()));

      // Create a timer class to update the device state label every second
      Timer t = new Timer(1000, new ActionListener()
      {

         public void actionPerformed(ActionEvent ae)
         {
            lDeviceState.setText(a.getDeviceState().toString());
         }
      });
      t.start();

   }

   public void center()
   {
      Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
      int x = getWidth() / 2;
      int y = getHeight() / 2;
      Point p = new Point((int) (d.getWidth() / 2 - x), (int) (d.getHeight() / 2 - y));
      this.setLocation(p);
   }

   public void acceptorEventOccurred(AcceptorEvent evt)
   {
      try
      {
         if (evt.getDescription() == null)
         {
            return;
         }

         if (evt instanceof EscrowEvent)
         {
            String message = "Doc Type: " + a.getDocType();
            if (DocumentType.Bill.equals(a.getDocType()))
            {
               Bill b = a.getBill();
               message = message + " " + b.getCountry() + " " + b.getValue() + " " + (char) b.getSeries() + " " + (char) b.getType() + " " + (char) b.getCompatibility() + " " + (char) b.getVersion();
            }
            tOutput.append(evt.getDescription() + " " + message);
         }
         else if (evt instanceof StackedEvent)
         {
            String message = "Doc Type: " + a.getDocType();
            if (DocumentType.Bill.equals(a.getDocType()))
            {
               Bill b = a.getBill();
               message = message + " " + b.getCountry() + " " + b.getValue() + " " + (char) b.getSeries() + " " + (char) b.getType() + " " + (char) b.getCompatibility() + " " + (char) b.getVersion();
            }
            tOutput.append(evt.getDescription() + " " + message);
         }
         else if (evt instanceof DownloadStartEvent)
         {
            tOutput.append("Download start at: " + new SimpleDateFormat("hh:mm:ss").format(System.currentTimeMillis()));
         }
         else if (evt instanceof DownloadProgressEvent)
         {
            //lets not echo this one
            return;
         }
         else if (evt instanceof DownloadFinishEvent)
         {
            tOutput.append("Download complete at: " + new SimpleDateFormat("hh:mm:ss").format(System.currentTimeMillis()));
         }
         else if (evt instanceof PUPEscrowEvent)
         {
            String message = "Doc Type: " + a.getDocType();
            if (DocumentType.Bill.equals(a.getDocType()))
            {
               Bill b = a.getBill();
               message = message + " " + b.getCountry() + " " + b.getValue() + " " + (char) b.getSeries() + " " + (char) b.getType() + " " + (char) b.getCompatibility() + " " + (char) b.getVersion();
            }
            tOutput.append(evt.getDescription() + " " + message);
         }
         else
         {
            tOutput.append(evt.getDescription());
         }

         if (evt instanceof DownloadRestartEvent)
         {
            if (fdd == null)
            {
               setButtonsEnabled(false);
               bDownload.setEnabled(true);
               bClose.setEnabled(true);
               bDebugLog.setEnabled(true);
               jfc.setApproveButtonText("Select");
               jfc.setMultiSelectionEnabled(false);
               jfc.setDialogTitle("Select a flash file to download.");
               jfc.setFileSelectionMode(JFileChooser.FILES_ONLY);
               if (jfc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
               {
                  File f = jfc.getSelectedFile();
                  fdd = new FlashDownloadDialog(this, f.getAbsolutePath(), false);
                  centerDialog(fdd);
                  fdd.setVisible(true);
               }
               else
               {
                  JOptionPane.showMessageDialog(this, "Cannot resume download process, please resume download process manually", "Error, flash file not selected", JOptionPane.ERROR_MESSAGE);
               }
            }
         }
         else if (evt instanceof ConnectedEvent)
         {
            a.setEnableAcceptance(true);
            setButtonsEnabled(true);
         }
         else if (evt instanceof DisconnectedEvent)
         {
            setButtonsEnabled(false);
         }

         tOutput.append(System.getProperty("line.separator"));
         tOutput.setCaretPosition(tOutput.getText().length() - 1);
      }
      catch (AcceptorException aex)
      {
         System.out.println("Exception in AcceptorEventOccured: " + aex.getMessage());
      }


   }

   @Override
   public void dispose()
   {
      gui.addPort(this.port);

      closeDialogs();

      if (a.getConnected())
      {
         a.close();
      }

      super.dispose();
   }

   String getPort()
   {
      return this.port;
   }

   private void centerDialog(JDialog d)
   {
      Point p = this.getLocationOnScreen();
      Point center = new Point((int) p.getX() + getWidth() / 2, (int) p.getY() + getHeight() / 2);
      d.setLocation(new Point((int) center.getX() - d.getWidth() / 2, (int) center.getY() - d.getHeight() / 2));
   }

   private void centerFrame(JFrame frame)
   {
      Point p = this.getLocationOnScreen();
      Point center = new Point((int) p.getX() + getWidth() / 2, (int) p.getY() + getHeight() / 2);
      frame.setLocation(new Point((int) center.getX() - frame.getWidth() / 2, (int) center.getY() - frame.getHeight() / 2));
   }

   private void closeDialogs()
   {
      if (bsd != null)
      {
         bsd.dispose();
      }

      if (bvd != null)
      {
         bvd.dispose();
      }

      if (altd != null)
      {
         altd.dispose();
      }

      if (apd != null)
      {
         apd.dispose();
      }

      if (did != null)
      {
         did.dispose();
      }

      if (aqp != null)
      {
         aqp.dispose();
      }

      if (fdd != null)
      {
         fdd.dispose();
      }

      if (pf != null)
      {
         pf.dispose();
      }

   }

   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      jPanel1 = new javax.swing.JPanel();
      jPanel2 = new javax.swing.JPanel();
      bCapabilities = new javax.swing.JButton();
      bProperties = new javax.swing.JButton();
      bStack = new javax.swing.JButton();
      bReturn = new javax.swing.JButton();
      bBillTypes = new javax.swing.JButton();
      bBillValues = new javax.swing.JButton();
      bDeviceInfo = new javax.swing.JButton();
      bAuditPerformance = new javax.swing.JButton();
      bAuditPerformanceQP = new javax.swing.JButton();
      bLifeTimeValues = new javax.swing.JButton();
      bCalibrate = new javax.swing.JButton();
      bDownload = new javax.swing.JButton();
      bDebugLog = new javax.swing.JButton();
      tDebugLog = new javax.swing.JTextField();
      jSeparator1 = new javax.swing.JSeparator();
      bReset = new javax.swing.JButton();
      bConnect = new javax.swing.JButton();
      bClose = new javax.swing.JButton();
      jSeparator2 = new javax.swing.JSeparator();
      lPort = new javax.swing.JLabel();
      lEscrowBar = new javax.swing.JLabel();
      lEscrow = new javax.swing.JLabel();
      tEscrowTimeout = new javax.swing.JButton();
      tEscrowBill = new javax.swing.JTextField();
      tEscrowBar = new javax.swing.JTextField();
      lEscrowBill = new javax.swing.JLabel();
      lPort1 = new javax.swing.JLabel();
      cPowerUp = new javax.swing.JComboBox();
      jDebugCheckBox = new javax.swing.JCheckBox();
      jRawCommandField = new javax.swing.JTextField();
      jLabel1 = new javax.swing.JLabel();
      jSeparator3 = new javax.swing.JSeparator();
      jSeparator4 = new javax.swing.JSeparator();
      jExecute = new javax.swing.JButton();
      jLabel2 = new javax.swing.JLabel();
      lDeviceState = new javax.swing.JLabel();
      bClearAudit = new javax.swing.JButton();
      jPanel4 = new javax.swing.JPanel();
      jScrollPane1 = new javax.swing.JScrollPane();
      tOutput = new javax.swing.JTextArea();

      setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

      jPanel1.setLayout(new java.awt.BorderLayout());

      jPanel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
      jPanel2.setLayout(new java.awt.GridBagLayout());

      bCapabilities.setText("Capabilities");
      bCapabilities.setEnabled(false);
      bCapabilities.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bCapabilitiesActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bCapabilities, gridBagConstraints);

      bProperties.setText("Properties");
      bProperties.setEnabled(false);
      bProperties.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bPropertiesActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bProperties, gridBagConstraints);

      bStack.setText("Stack");
      bStack.setEnabled(false);
      bStack.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bStackActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bStack, gridBagConstraints);

      bReturn.setText("Return");
      bReturn.setEnabled(false);
      bReturn.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bReturnActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bReturn, gridBagConstraints);

      bBillTypes.setText("Bill Set");
      bBillTypes.setEnabled(false);
      bBillTypes.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bBillTypesActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bBillTypes, gridBagConstraints);

      bBillValues.setText("Bill Values");
      bBillValues.setEnabled(false);
      bBillValues.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bBillValuesActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 5;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bBillValues, gridBagConstraints);

      bDeviceInfo.setText("Device Info");
      bDeviceInfo.setEnabled(false);
      bDeviceInfo.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bDeviceInfoActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bDeviceInfo, gridBagConstraints);

      bAuditPerformance.setText("Performance");
      bAuditPerformance.setEnabled(false);
      bAuditPerformance.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bAuditPerformanceActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bAuditPerformance, gridBagConstraints);

      bAuditPerformanceQP.setText("Performance QP");
      bAuditPerformanceQP.setEnabled(false);
      bAuditPerformanceQP.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bAuditPerformanceQPActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 5;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bAuditPerformanceQP, gridBagConstraints);

      bLifeTimeValues.setText("Lifetime Values");
      bLifeTimeValues.setEnabled(false);
      bLifeTimeValues.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bLifeTimeValuesActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bLifeTimeValues, gridBagConstraints);

      bCalibrate.setText("Calibrate");
      bCalibrate.setEnabled(false);
      bCalibrate.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bCalibrateActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 5;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bCalibrate, gridBagConstraints);

      bDownload.setText("Download Flash");
      bDownload.setEnabled(false);
      bDownload.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bDownloadActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 5;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bDownload, gridBagConstraints);

      bDebugLog.setText("Change");
      bDebugLog.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bDebugLogActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 9;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bDebugLog, gridBagConstraints);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 9;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(tDebugLog, gridBagConstraints);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.gridwidth = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(10, 3, 10, 3);
      jPanel2.add(jSeparator1, gridBagConstraints);

      bReset.setText("Reset");
      bReset.setEnabled(false);
      bReset.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bResetActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bReset, gridBagConstraints);

      bConnect.setText("Connect");
      bConnect.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bConnectActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bConnect, gridBagConstraints);

      bClose.setText("Disconnect");
      bClose.setEnabled(false);
      bClose.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bCloseActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(bClose, gridBagConstraints);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 8;
      gridBagConstraints.gridwidth = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(10, 3, 10, 3);
      jPanel2.add(jSeparator2, gridBagConstraints);

      lPort.setText("Port: ");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(lPort, gridBagConstraints);

      lEscrowBar.setText("Barcode Timeout");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 16;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(lEscrowBar, gridBagConstraints);

      lEscrow.setText("Escrow Timeout (0 to 127 seconds, 0 means no timeout)");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 14;
      gridBagConstraints.gridwidth = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(lEscrow, gridBagConstraints);

      tEscrowTimeout.setText("Set Timeout");
      tEscrowTimeout.setEnabled(false);
      tEscrowTimeout.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            tEscrowTimeoutActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 15;
      gridBagConstraints.gridheight = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(tEscrowTimeout, gridBagConstraints);

      tEscrowBill.setText("0");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 15;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(tEscrowBill, gridBagConstraints);

      tEscrowBar.setText("0");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 16;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(tEscrowBar, gridBagConstraints);

      lEscrowBill.setText("Bill Timeout");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 15;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(lEscrowBill, gridBagConstraints);

      lPort1.setText("Power Up Mode");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(lPort1, gridBagConstraints);

      cPowerUp.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(cPowerUp, gridBagConstraints);

      jDebugCheckBox.setText("Debug Enabled");
      jDebugCheckBox.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            jDebugCheckBoxActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 9;
      jPanel2.add(jDebugCheckBox, gridBagConstraints);

      jRawCommandField.setHorizontalAlignment(javax.swing.JTextField.LEFT);
      jRawCommandField.setEnabled(false);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 12;
      gridBagConstraints.gridwidth = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
      jPanel2.add(jRawCommandField, gridBagConstraints);

      jLabel1.setText("Enter a command in HEX and click execute.");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 11;
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(jLabel1, gridBagConstraints);
      jLabel1.getAccessibleContext().setAccessibleName("");

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 13;
      gridBagConstraints.gridwidth = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(10, 3, 10, 3);
      jPanel2.add(jSeparator3, gridBagConstraints);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 10;
      gridBagConstraints.gridwidth = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(5, 3, 5, 3);
      jPanel2.add(jSeparator4, gridBagConstraints);

      jExecute.setText("Execute");
      jExecute.setEnabled(false);
      jExecute.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            jExecuteActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 12;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      jPanel2.add(jExecute, gridBagConstraints);

      jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jLabel2.setText("                  State");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 1;
      jPanel2.add(jLabel2, gridBagConstraints);

      lDeviceState.setText("-----");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 3;
      gridBagConstraints.gridy = 1;
      jPanel2.add(lDeviceState, gridBagConstraints);

      bClearAudit.setText("Clear Audit");
      bClearAudit.setEnabled(false);
      bClearAudit.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bClearAuditActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 6;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add(bClearAudit, gridBagConstraints);

      jPanel1.add(jPanel2, java.awt.BorderLayout.NORTH);

      jPanel4.setLayout(new java.awt.BorderLayout());

      tOutput.setColumns(20);
      tOutput.setRows(5);
      jScrollPane1.setViewportView(tOutput);

      jPanel4.add(jScrollPane1, java.awt.BorderLayout.CENTER);

      jPanel1.add(jPanel4, java.awt.BorderLayout.CENTER);

      getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

      pack();
   }// </editor-fold>//GEN-END:initComponents

    private void bConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bConnectActionPerformed
      try
      {

         a.open(port, (PowerUp) cPowerUp.getSelectedItem());

         a.setDisconnectTimeout(4000);
      }
      catch (Exception ex)
      {
         showError(ex);
      }
   }
	//GEN-LAST:event_bConnectActionPerformed
    private void bCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCloseActionPerformed
       if (a != null)
       {
          a.close();
          setButtonsEnabled(false);
       }
    }//GEN-LAST:event_bCloseActionPerformed

private void bBillTypesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBillTypesActionPerformed
   bsd = new BillSetDialog(this, false);
   centerDialog(bsd);
   bsd.setVisible(true);
}//GEN-LAST:event_bBillTypesActionPerformed

private void bBillValuesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBillValuesActionPerformed
   bvd = new BillValuesDialog(this, false);
   centerDialog(bvd);
   bvd.setVisible(true);
}//GEN-LAST:event_bBillValuesActionPerformed

private void bResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bResetActionPerformed
   try
   {
      a.SoftReset();
   }
   catch (Exception ex)
   {
      showError(ex);
   }
	}//GEN-LAST:event_bResetActionPerformed

private void bLifeTimeValuesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLifeTimeValuesActionPerformed
   altd = new AuditLifetimeTotalsDialog(this, false);
   centerDialog(altd);
   altd.setVisible(true);
}//GEN-LAST:event_bLifeTimeValuesActionPerformed

private void bAuditPerformanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bAuditPerformanceActionPerformed
   apd = new AuditPerformanceDialog(this, false);
   centerDialog(apd);
   apd.setVisible(true);
}//GEN-LAST:event_bAuditPerformanceActionPerformed

private void bDeviceInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDeviceInfoActionPerformed
   did = new DeviceInfoDialog(this, false);
   centerDialog(did);
   did.setVisible(true);
}//GEN-LAST:event_bDeviceInfoActionPerformed

private void bAuditPerformanceQPActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bAuditPerformanceQPActionPerformed
   aqp = new AuditQPDialog(this, false);
   centerDialog(aqp);
   aqp.setVisible(true);
}//GEN-LAST:event_bAuditPerformanceQPActionPerformed

private void bStackActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStackActionPerformed
   try
   {
            a.escrowStack();//GEN-LAST:event_bStackActionPerformed
      }
      catch (Exception ex)
      {
         showError(ex);
      }
   }

private void bReturnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bReturnActionPerformed
   try
   {
      a.escrowReturn();
   }
   catch (Exception ex)
   {
      showError(ex);
   }
}//GEN-LAST:event_bReturnActionPerformed

private void bCalibrateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCalibrateActionPerformed
   try
   {
      a.calibrate();
   }
   catch (Exception e)
   {
      showError(e);
   }
}//GEN-LAST:event_bCalibrateActionPerformed

private void bDownloadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDownloadActionPerformed
   fdd = new FlashDownloadDialog(this, false);
   centerDialog(fdd);
   fdd.setVisible(true);
}//GEN-LAST:event_bDownloadActionPerformed

private void bDebugLogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDebugLogActionPerformed
   jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
   jfc.setDialogTitle("Select debug log path");
   jfc.setMultiSelectionEnabled(false);
   if (jfc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
   {
      a.setDebugLogPath(jfc.getSelectedFile().getAbsolutePath());
      tDebugLog.setText(a.getDebugLogPath());
   }
}//GEN-LAST:event_bDebugLogActionPerformed

private void bPropertiesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bPropertiesActionPerformed
   pf = new PropertiesFrame(this);
   centerFrame(pf);
   pf.setVisible(true);
}//GEN-LAST:event_bPropertiesActionPerformed

private void bCapabilitiesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCapabilitiesActionPerformed
   if (a != null)
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("Application ID: ");
      buffer.append(getSupported(a.getCapApplicationId()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Application PN: ");
      buffer.append(getSupported(a.getCapApplicationPN()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Asset Number: ");
      buffer.append(getSupported(a.getCapAssetNumber()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Audit: ");
      buffer.append(getSupported(a.getCapAudit()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Bar Codes: ");
      buffer.append(getSupported(a.getCapBarCodes()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Bar Codes Ext: ");
      buffer.append(getSupported(a.getCapBarCodesExt()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("BNF Status: ");
      buffer.append(getSupported(a.getCapBNFStatus()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Bookmark: ");
      buffer.append(getSupported(a.getCapBookmark()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Boot PN: ");
      buffer.append(getSupported(a.getCapBootPN()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Calibrate: ");
      buffer.append(getSupported(a.getCapCalibrate()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Cash box total: ");
      buffer.append(getSupported(a.getCapCashBoxTotal()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Clear Audit: ");
      buffer.append(getSupported(a.getCapClearAudit()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Coupon Ext: ");
      buffer.append(getSupported(a.getCapCouponExt()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Device Paused: ");
      buffer.append(getSupported(a.getCapDevicePaused()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Device type: ");
      buffer.append(getSupported(a.getCapDeviceType()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Device resets: ");
      buffer.append(getSupported(a.getCapDeviceResets()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Device Serial Number: ");
      buffer.append(getSupported(a.getCapDeviceSerialNumber()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Soft Reset: ");
      buffer.append(getSupported(a.getCapDeviceSoftReset()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Escrow Timeout: ");
      buffer.append(getSupported(a.getCapEscrowTimeout()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Flash Download: ");
      buffer.append(getSupported(a.getCapFlashDownload()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("No push: ");
      buffer.append(getSupported(a.getCapNoPush()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Orientation ext: ");
      buffer.append(getSupported(a.getCapOrientationExt()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Pup ext: ");
      buffer.append(getSupported(a.getCapPupExt()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Set Bezel Type: ");
      buffer.append(getSupported(a.getCapSetBezel()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Variant ID: ");
      buffer.append(getSupported(a.getCapVariantId()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Variant PN: ");
      buffer.append(getSupported(a.getCapVariantPN()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Easitrax: ");
      buffer.append(getSupported(a.getCapEasitrax()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Test Doc: ");
      buffer.append(getSupported(a.getCapTestDoc()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Note Retrieved Event: ");
      buffer.append(getSupported(a.getCapNoteRetrieved()));
      buffer.append(System.getProperty("line.separator"));
      buffer.append("Advanced Bookmark Mode: ");
      buffer.append(getSupported(a.getCapAdvBookmark()));
      buffer.append(System.getProperty("line.separator"));
      JOptionPane.showMessageDialog(this, buffer.toString());
   }
}//GEN-LAST:event_bCapabilitiesActionPerformed

private void tEscrowTimeoutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tEscrowTimeoutActionPerformed
   try
   {
      int billTimeout = 0;
      int barTimeout = 0;
      try
      {
         billTimeout = Integer.parseInt(tEscrowBill.getText());
         if (billTimeout > 127)
         {
            billTimeout = 127;
         }
      }
      catch (Exception nfe)
      {
      }
      try
      {
         barTimeout = Integer.parseInt(tEscrowBar.getText());
         if (barTimeout > 127)
         {
            barTimeout = 127;
         }
      }
      catch (Exception nfe)
      {
      }
      a.specifyEscrowTimeout(billTimeout, barTimeout);
   }
   catch (Exception e)
   {
      showError(e);
   }


}//GEN-LAST:event_tEscrowTimeoutActionPerformed

private void jDebugCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jDebugCheckBoxActionPerformed
   try
   {
      a.setDebugLog(jDebugCheckBox.isSelected());
      bDebugLog.setEnabled(!jDebugCheckBox.isSelected());
   }
   catch (Exception e)
   {
   }

}//GEN-LAST:event_jDebugCheckBoxActionPerformed

private void jExecuteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jExecuteActionPerformed
   // Execute clicked. Execute a RAW command and display the results.
   String s = jRawCommandField.getText().toUpperCase();
   boolean active = false;
   int i;
   byte b = 0;

   ArrayList<Byte> cmd = new ArrayList();
   byte reply[];

   for (i = 0; i < s.length(); i++)
   {
      char c = s.charAt(i);

      if (c >= '0' && c <= '9')
      {
         active = true;
         b <<= 4;
         b += (c - '0');
      }
      else if (c >= 'A' && c <= 'F')
      {
         active = true;
         b <<= 4;
         b += (c - 'A' + 10);
      }
      else if (active)
      {
         cmd.add(b);
         active = false;
         b = 0;
      }
   }

   if (active)
   {
      cmd.add(b);
   }

   if (cmd.size() == 0)
   {
      return;
   }

   try
   {
      byte z[] = new byte[cmd.size()];

      for (i = 0; i < z.length; i++)
      {
         z[i] = cmd.get(i);
      }

      reply = a.rawTransaction(z);
   }
   catch (Exception e)
   {
      tOutput.append("Raw Command Error: " + e.getMessage());
      return;
   }

   String r = "Raw Reply: ";
   String asc = " ";

   for (i = 0; i < reply.length; i++)
   {
      if (reply[i] >= 32 && reply[i] < 127)
      {
         asc = asc + (char) reply[i];
      }
      else
      {
         asc = asc + ".";
      }

      r = r + String.format("%02X ", reply[i]);
   }

   tOutput.append(r + asc);
   tOutput.append(System.getProperty("line.separator"));
   tOutput.setCaretPosition(tOutput.getText().length() - 1);
}//GEN-LAST:event_jExecuteActionPerformed

private void bClearAuditActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bClearAuditActionPerformed
{//GEN-HEADEREND:event_bClearAuditActionPerformed
   try
   {
      boolean acked = a.clearAudit();
      tOutput.append("Clear Audit command: " + (acked ? "Acknowledged" : "NAK'd"));
      tOutput.append(System.getProperty("line.separator"));
   }
   catch (Exception e)
   {
      showError(e);
   }
}//GEN-LAST:event_bClearAuditActionPerformed

   private String getSupported(boolean supported)
   {
      return supported ? "Supported" : "Not Supported";
   }
   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JButton bAuditPerformance;
   private javax.swing.JButton bAuditPerformanceQP;
   private javax.swing.JButton bBillTypes;
   private javax.swing.JButton bBillValues;
   private javax.swing.JButton bCalibrate;
   private javax.swing.JButton bCapabilities;
   private javax.swing.JButton bClearAudit;
   private javax.swing.JButton bClose;
   private javax.swing.JButton bConnect;
   private javax.swing.JButton bDebugLog;
   private javax.swing.JButton bDeviceInfo;
   private javax.swing.JButton bDownload;
   private javax.swing.JButton bLifeTimeValues;
   private javax.swing.JButton bProperties;
   private javax.swing.JButton bReset;
   private javax.swing.JButton bReturn;
   private javax.swing.JButton bStack;
   private javax.swing.JComboBox cPowerUp;
   private javax.swing.JCheckBox jDebugCheckBox;
   private javax.swing.JButton jExecute;
   private javax.swing.JLabel jLabel1;
   private javax.swing.JLabel jLabel2;
   private javax.swing.JPanel jPanel1;
   private javax.swing.JPanel jPanel2;
   private javax.swing.JPanel jPanel4;
   private javax.swing.JTextField jRawCommandField;
   private javax.swing.JScrollPane jScrollPane1;
   private javax.swing.JSeparator jSeparator1;
   private javax.swing.JSeparator jSeparator2;
   private javax.swing.JSeparator jSeparator3;
   private javax.swing.JSeparator jSeparator4;
   private javax.swing.JLabel lDeviceState;
   private javax.swing.JLabel lEscrow;
   private javax.swing.JLabel lEscrowBar;
   private javax.swing.JLabel lEscrowBill;
   private javax.swing.JLabel lPort;
   private javax.swing.JLabel lPort1;
   private javax.swing.JTextField tDebugLog;
   private javax.swing.JTextField tEscrowBar;
   private javax.swing.JTextField tEscrowBill;
   private javax.swing.JButton tEscrowTimeout;
   private javax.swing.JTextArea tOutput;
   // End of variables declaration//GEN-END:variables

   private void setButtonsEnabled(boolean b)
   {
      bClose.setEnabled(b);
      bConnect.setEnabled(!b);
      bCapabilities.setEnabled(b);
      bProperties.setEnabled(b);
      bBillTypes.setEnabled(b);
      bBillValues.setEnabled(b);
      bDeviceInfo.setEnabled(b);

      if (a.getCapAudit())
      {
         bAuditPerformanceQP.setEnabled(b);
         bLifeTimeValues.setEnabled(b);
         bAuditPerformance.setEnabled(b);
      }
      bDeviceInfo.setEnabled(b);
      bReset.setEnabled(b);
      bStack.setEnabled(b);
      bReturn.setEnabled(b);
      bCalibrate.setEnabled(b);
      bDownload.setEnabled(b);
      //bDebugLog.setEnabled(b);
      tEscrowTimeout.setEnabled(b && a.getCapEscrowTimeout());
      jRawCommandField.setEnabled(b);
      jExecute.setEnabled(b);

      bClearAudit.setEnabled(b);
   }

   public Acceptor getAcceptor()
   {
      return this.a;
   }

   private void showError(Exception ex)
   {
      JOptionPane.showMessageDialog(this, "An exception has been thrown by the driver while executing the command" + System.getProperty("line.separator") + ex.getMessage(), "Error executing command", JOptionPane.ERROR_MESSAGE);
      ex.printStackTrace();
   }
}
