package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.event.AcceptorEvent;
import com.meiglobal.ebds.api.event.AcceptorEventListener;
import com.meiglobal.ebds.api.event.DownloadFinishEvent;
import com.meiglobal.ebds.api.event.DownloadProgressEvent;
import com.meiglobal.ebds.api.event.DownloadRestartEvent;
import com.meiglobal.ebds.api.event.DownloadStartEvent;
import com.meiglobal.ebds.api.pub.AcceptorException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 * Dialog that allows for the flash download process.
 */
public class FlashDownloadDialog extends javax.swing.JDialog implements AcceptorEventListener {

    TestGUI gui;
    JFileChooser chooser = new JFileChooser();
    int currentPacket=0;
    int maxNumber=0;
    /** Creates new form DeviceInfoDialog
     * @param parent
     * @param modal
     */
    public FlashDownloadDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.gui = (TestGUI) parent;
        initComponents();
        pProgress.setIndeterminate(true);
        pProgress.setStringPainted(true);
        chooser.setApproveButtonText("Select");
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Select a flash file to download.");
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        gui.getAcceptor().addAcceptorEventListener(this);
    }

    FlashDownloadDialog(TestGUI parent, String absolutePath, boolean modal) {
        this(parent,modal);
        try {
            tFile.setText(absolutePath);
            pProgress.setIndeterminate(false);
            bOpen.setEnabled(false);
            bStart.setEnabled(false);
            gui.getAcceptor().flashDownload(absolutePath);
        } catch (AcceptorException ex) {
            JOptionPane.showMessageDialog(this,"Error while trying to restart the download: "+ex.getMessage(),"Error on download restart", JOptionPane.ERROR_MESSAGE);
            bOpen.setEnabled(true);
            bStart.setEnabled(true);
        }
    }

    public void acceptorEventOccurred(AcceptorEvent evt) {
        if(evt instanceof DownloadStartEvent)
        {
            pProgress.setMinimum(0);
            maxNumber=((DownloadStartEvent)evt).getPacketCount();
            pProgress.setMaximum(maxNumber);
            pProgress.setValue(0);
            lProgress.setText("Sent: 0 of "+maxNumber+" packets");
        }
        else if(evt instanceof DownloadProgressEvent)
        {
            currentPacket = 1 + ((DownloadProgressEvent)evt).getPacketNumber();

            if (currentPacket % 10 == 0)
            {
                pProgress.setValue(currentPacket);
                lProgress.setText("Sent: "+currentPacket+" of "+maxNumber+" packets");
            }
            else if (currentPacket > maxNumber - 25)
            {
                pProgress.setValue(currentPacket);
                lProgress.setText("Sent: "+currentPacket+" of "+maxNumber+" packets");
            }
        }
        else if(evt instanceof DownloadFinishEvent)
        {
            boolean success = ((DownloadFinishEvent)evt).successful();
            if(success)
            {
                pProgress.setValue(pProgress.getMaximum());
                lProgress.setText("Flash download successful");
            }
            else
            {
                pProgress.setIndeterminate(true);
                lProgress.setText("An error occurred trying to download the new flash file");
            }
            bOpen.setEnabled(true);
            bStart.setEnabled(true);
        }
        else if(evt instanceof DownloadRestartEvent)
        {
            try
            {
                gui.getAcceptor().flashDownload(tFile.getText());
            } 
            catch (AcceptorException ex)
            {
                JOptionPane.showMessageDialog(this,"Error while restarting the download process"+System.getProperty("line.separator")+ex.getMessage(), "Error on download restart",JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void dispose(){
        if(!gui.getAcceptor().stopDownload()) {
            JOptionPane.showMessageDialog(this, "Could not stop flash download thread, restarting the application is recommended", "Error", JOptionPane.ERROR_MESSAGE);
        }
        gui.fdd=null;
        super.dispose();
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        pMain = new javax.swing.JPanel();
        lFile = new javax.swing.JLabel();
        tFile = new javax.swing.JTextField();
        bOpen = new javax.swing.JButton();
        pProgress = new javax.swing.JProgressBar();
        bStart = new javax.swing.JButton();
        lProgress = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Flash Download");

        pMain.setLayout(new java.awt.GridBagLayout());

        lFile.setText("File");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        pMain.add(lFile, gridBagConstraints);

        tFile.setMinimumSize(new java.awt.Dimension(250, 20));
        tFile.setPreferredSize(new java.awt.Dimension(400, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        pMain.add(tFile, gridBagConstraints);

        bOpen.setText("Open");
        bOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        pMain.add(bOpen, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        pMain.add(pProgress, gridBagConstraints);

        bStart.setText("Start");
        bStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        pMain.add(bStart, gridBagConstraints);

        lProgress.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lProgress.setText("Select File and click start");
        lProgress.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        pMain.add(lProgress, gridBagConstraints);

        getContentPane().add(pMain, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void bOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bOpenActionPerformed
    if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
        tFile.setText(chooser.getSelectedFile().getAbsolutePath());
    }
}//GEN-LAST:event_bOpenActionPerformed

private void bStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStartActionPerformed
    try{
        pProgress.setIndeterminate(false);
        bOpen.setEnabled(false);
        bStart.setEnabled(false);
        gui.getAcceptor().flashDownload(tFile.getText());
    }catch(Exception e){
        JOptionPane.showMessageDialog(this,e.getMessage(),"Exception occured",JOptionPane.ERROR_MESSAGE);
    }
}//GEN-LAST:event_bStartActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bOpen;
    private javax.swing.JButton bStart;
    private javax.swing.JLabel lFile;
    private javax.swing.JLabel lProgress;
    private javax.swing.JPanel pMain;
    private javax.swing.JProgressBar pProgress;
    private javax.swing.JTextField tFile;
    // End of variables declaration//GEN-END:variables
}
