package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.pub.OrientationControl;
import javax.swing.DefaultComboBoxModel;

/**
 * Dialog that shows the device's properties.
 */
public class PropertiesFrame extends javax.swing.JFrame {

    private TestGUI gui;

    /** Creates new form PropertiesFrame */
    public PropertiesFrame(TestGUI gui) {
        this.gui = gui;
        initComponents();
        cBasicOrientation.setModel(new DefaultComboBoxModel(OrientationControl.values()));
        cExtendedOrientation.setModel(new DefaultComboBoxModel(OrientationControl.values()));
        cAcceptance.setSelected(gui.getAcceptor().getEnableAcceptance());
        cAutoStack.setSelected(gui.getAcceptor().getAutoStack());
        cBarCodes.setSelected(gui.getAcceptor().getEnableBarCodes());
        cBookmarks.setSelected(gui.getAcceptor().getEnableBookmarks());
        cExtendedCoupon.setSelected(gui.getAcceptor().getEnableCouponExt());
        cNoPush.setSelected(gui.getAcceptor().getEnableNoPush());
        cHighSecurity.setSelected(gui.getAcceptor().getHighSecurity());
        cBasicOrientation.setSelectedItem(gui.getAcceptor().getOrientationControl());
        cExtendedOrientation.setSelectedItem(gui.getAcceptor().getOrientationCtlExt());


        cBarCodes.setEnabled(gui.getAcceptor().getCapBarCodes());
        cBookmarks.setEnabled(gui.getAcceptor().getCapBookmark());
        cExtendedCoupon.setEnabled(gui.getAcceptor().getCapCouponExt());
        cNoPush.setEnabled(gui.getAcceptor().getCapNoPush());
        cExtendedOrientation.setEnabled(gui.getAcceptor().getCapOrientationExt());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      pAssetNumber = new javax.swing.JPanel();
      jLabel1 = new javax.swing.JLabel();
      bSetAssetNumber = new javax.swing.JButton();
      tAssetNumber = new javax.swing.JTextField();
      bQueryAssetNumber = new javax.swing.JButton();
      pComboboxes = new javax.swing.JPanel();
      lBasicorientation = new javax.swing.JLabel();
      cBasicOrientation = new javax.swing.JComboBox();
      lExtendedOrientation = new javax.swing.JLabel();
      cExtendedOrientation = new javax.swing.JComboBox();
      jLabel2 = new javax.swing.JLabel();
      jPanel1 = new javax.swing.JPanel();
      btnAdvBookmarkEnable = new javax.swing.JButton();
      btnAdvBookmarkCancel = new javax.swing.JButton();
      jLabel4 = new javax.swing.JLabel();
      jPanel3 = new javax.swing.JPanel();
      btnEnableCashBoxCleanlinessReporting = new javax.swing.JButton();
      btnDisableCashBoxCleanlinessReporting = new javax.swing.JButton();
      jLabel3 = new javax.swing.JLabel();
      jPanel2 = new javax.swing.JPanel();
      txtDisconnectTimeout = new javax.swing.JTextField();
      btnDisconnectTimeout = new javax.swing.JButton();
      pCheckboxes = new javax.swing.JPanel();
      cAcceptance = new javax.swing.JCheckBox();
      cAutoStack = new javax.swing.JCheckBox();
      cBarCodes = new javax.swing.JCheckBox();
      cBookmarks = new javax.swing.JCheckBox();
      cExtendedCoupon = new javax.swing.JCheckBox();
      cNoPush = new javax.swing.JCheckBox();
      cHighSecurity = new javax.swing.JCheckBox();

      setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
      setTitle("Properties");
      getContentPane().setLayout(new java.awt.GridBagLayout());

      pAssetNumber.setLayout(new java.awt.GridBagLayout());

      jLabel1.setText("Asset Number:");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.ipady = 7;
      pAssetNumber.add(jLabel1, gridBagConstraints);

      bSetAssetNumber.setText("Set");
      bSetAssetNumber.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bSetAssetNumberActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 1;
      pAssetNumber.add(bSetAssetNumber, gridBagConstraints);

      tAssetNumber.setMinimumSize(new java.awt.Dimension(10, 20));
      tAssetNumber.setPreferredSize(new java.awt.Dimension(15, 20));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      pAssetNumber.add(tAssetNumber, gridBagConstraints);

      bQueryAssetNumber.setText("Query");
      bQueryAssetNumber.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bQueryAssetNumberActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 1;
      pAssetNumber.add(bQueryAssetNumber, gridBagConstraints);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
      getContentPane().add(pAssetNumber, gridBagConstraints);

      pComboboxes.setMinimumSize(new java.awt.Dimension(103, 160));
      pComboboxes.setLayout(new java.awt.GridLayout(0, 1, 0, 3));

      lBasicorientation.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
      lBasicorientation.setText("Basic Orientation");
      pComboboxes.add(lBasicorientation);

      cBasicOrientation.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
      cBasicOrientation.addItemListener(new java.awt.event.ItemListener() {
         public void itemStateChanged(java.awt.event.ItemEvent evt) {
            cBasicOrientationItemStateChanged(evt);
         }
      });
      pComboboxes.add(cBasicOrientation);

      lExtendedOrientation.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
      lExtendedOrientation.setText("Extended Orientation");
      pComboboxes.add(lExtendedOrientation);

      cExtendedOrientation.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
      cExtendedOrientation.addItemListener(new java.awt.event.ItemListener() {
         public void itemStateChanged(java.awt.event.ItemEvent evt) {
            cExtendedOrientationItemStateChanged(evt);
         }
      });
      pComboboxes.add(cExtendedOrientation);

      jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
      jLabel2.setText("Advanced Boomark Mode");
      pComboboxes.add(jLabel2);

      jPanel1.setLayout(new java.awt.GridLayout(1, 2));

      btnAdvBookmarkEnable.setText("Enable");
      btnAdvBookmarkEnable.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnAdvBookmarkEnableActionPerformed(evt);
         }
      });
      jPanel1.add(btnAdvBookmarkEnable);

      btnAdvBookmarkCancel.setText("Cancel");
      btnAdvBookmarkCancel.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnAdvBookmarkCancelActionPerformed(evt);
         }
      });
      jPanel1.add(btnAdvBookmarkCancel);

      pComboboxes.add(jPanel1);

      jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
      jLabel4.setText("CashBox Cleanliness Reporting");
      pComboboxes.add(jLabel4);

      jPanel3.setLayout(new java.awt.GridLayout(1, 2));

      btnEnableCashBoxCleanlinessReporting.setText("Enable");
      btnEnableCashBoxCleanlinessReporting.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnEnableCashBoxCleanlinessReportingActionPerformed(evt);
         }
      });
      jPanel3.add(btnEnableCashBoxCleanlinessReporting);

      btnDisableCashBoxCleanlinessReporting.setText("Disable");
      btnDisableCashBoxCleanlinessReporting.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnDisableCashBoxCleanlinessReportingActionPerformed(evt);
         }
      });
      jPanel3.add(btnDisableCashBoxCleanlinessReporting);

      pComboboxes.add(jPanel3);

      jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
      jLabel3.setText("Disconnect Timeout");
      pComboboxes.add(jLabel3);

      jPanel2.setLayout(new java.awt.GridLayout(1, 2, 25, 0));

      txtDisconnectTimeout.setText("30000");
      jPanel2.add(txtDisconnectTimeout);

      btnDisconnectTimeout.setText("Set");
      btnDisconnectTimeout.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnDisconnectTimeoutActionPerformed(evt);
         }
      });
      jPanel2.add(btnDisconnectTimeout);

      pComboboxes.add(jPanel2);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
      getContentPane().add(pComboboxes, gridBagConstraints);

      pCheckboxes.setMinimumSize(new java.awt.Dimension(200, 219));
      pCheckboxes.setPreferredSize(new java.awt.Dimension(200, 219));
      pCheckboxes.setLayout(new java.awt.GridLayout(0, 1, 0, 5));

      cAcceptance.setText("Enable Acceptance");
      cAcceptance.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cAcceptanceActionPerformed(evt);
         }
      });
      pCheckboxes.add(cAcceptance);

      cAutoStack.setText("Auto Stack");
      cAutoStack.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cAutoStackActionPerformed(evt);
         }
      });
      pCheckboxes.add(cAutoStack);

      cBarCodes.setText("Bar Codes Vouchers");
      cBarCodes.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cBarCodesActionPerformed(evt);
         }
      });
      pCheckboxes.add(cBarCodes);

      cBookmarks.setText("Bookmarks");
      cBookmarks.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cBookmarksActionPerformed(evt);
         }
      });
      pCheckboxes.add(cBookmarks);

      cExtendedCoupon.setText("Extended Coupon");
      cExtendedCoupon.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cExtendedCouponActionPerformed(evt);
         }
      });
      pCheckboxes.add(cExtendedCoupon);

      cNoPush.setText("No Push Mode");
      cNoPush.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cNoPushActionPerformed(evt);
         }
      });
      pCheckboxes.add(cNoPush);

      cHighSecurity.setText("High Security Mode");
      cHighSecurity.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cHighSecurityActionPerformed(evt);
         }
      });
      pCheckboxes.add(cHighSecurity);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.ipadx = 16;
      getContentPane().add(pCheckboxes, gridBagConstraints);

      pack();
   }// </editor-fold>//GEN-END:initComponents

    private void cNoPushActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cNoPushActionPerformed
        try { gui.getAcceptor().setEnableNoPush(cNoPush.isSelected()); }
        catch (Exception ex) {  System.out.println("Ex with setting NoPush: " + ex.getMessage()); }
    }//GEN-LAST:event_cNoPushActionPerformed

private void cExtendedOrientationItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cExtendedOrientationItemStateChanged
    if (evt.getStateChange() == evt.SELECTED) {
        gui.getAcceptor().SetOrientationCtlExt((OrientationControl) evt.getItem());

    }
}//GEN-LAST:event_cExtendedOrientationItemStateChanged

private void cBasicOrientationItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cBasicOrientationItemStateChanged
    if (evt.getStateChange() == evt.SELECTED) {
        gui.getAcceptor().setOrientationControl((OrientationControl) evt.getItem());

    }
}//GEN-LAST:event_cBasicOrientationItemStateChanged

private void cHighSecurityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cHighSecurityActionPerformed
    gui.getAcceptor().setHighSecurity(cHighSecurity.isSelected());
}//GEN-LAST:event_cHighSecurityActionPerformed

private void cExtendedCouponActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cExtendedCouponActionPerformed
    try { gui.getAcceptor().setEnableCouponExt(cExtendedCoupon.isSelected()); }
    catch (Exception ex) { System.out.println("Ex setting CouponExt: " + ex.getMessage()); }
}//GEN-LAST:event_cExtendedCouponActionPerformed

private void cBookmarksActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cBookmarksActionPerformed
    try { gui.getAcceptor().setEnableBookmarks(cBookmarks.isSelected()); }
    catch (Exception ex) { System.out.println("Ex setting Bookmarks: " + ex.getMessage()); }
}//GEN-LAST:event_cBookmarksActionPerformed

private void cBarCodesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cBarCodesActionPerformed
    try { gui.getAcceptor().setEnableBarCodes(cBarCodes.isSelected()); }
    catch (Exception ex) { System.out.println("Ex setting BarCodes: " + ex.getMessage()); }
}//GEN-LAST:event_cBarCodesActionPerformed

private void cAutoStackActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cAutoStackActionPerformed
    try { gui.getAcceptor().setAutoStack(cAutoStack.isSelected()); }
    catch (Exception ex) { System.out.println("Ex setting AutoStack: " + ex.getMessage()); }
}//GEN-LAST:event_cAutoStackActionPerformed

private void cAcceptanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cAcceptanceActionPerformed
  
    try { gui.getAcceptor().setEnableAcceptance(cAcceptance.isSelected()); }
    catch (Exception ex) { System.out.println("Ex setting EnableAcceptance: " + ex.getMessage()); }

}//GEN-LAST:event_cAcceptanceActionPerformed

private void bSetAssetNumberActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bSetAssetNumberActionPerformed
{//GEN-HEADEREND:event_bSetAssetNumberActionPerformed
   try { gui.getAcceptor().setAssetNumber(tAssetNumber.getText()); }
   catch (Exception ex) { System.out.println("Ex setting Asset Number: " + ex.getMessage()); }
}//GEN-LAST:event_bSetAssetNumberActionPerformed

private void bQueryAssetNumberActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bQueryAssetNumberActionPerformed
{//GEN-HEADEREND:event_bQueryAssetNumberActionPerformed
   try { tAssetNumber.setText(gui.getAcceptor().getAssetNumber()); }
   catch (Exception ex) { System.out.println("Ex getting Asset Number: " + ex.getMessage()); }
}//GEN-LAST:event_bQueryAssetNumberActionPerformed

private void btnAdvBookmarkEnableActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnAdvBookmarkEnableActionPerformed
{//GEN-HEADEREND:event_btnAdvBookmarkEnableActionPerformed
   try { gui.getAcceptor().enterAdvancedBookmarkMode(); }
   catch (Exception ex) { System.out.println("Ex entering Advanced Bookmark Mode: " + ex.getMessage()); }
}//GEN-LAST:event_btnAdvBookmarkEnableActionPerformed

private void btnAdvBookmarkCancelActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnAdvBookmarkCancelActionPerformed
{//GEN-HEADEREND:event_btnAdvBookmarkCancelActionPerformed
   try { gui.getAcceptor().cancelAdvancedBookmarkMode(); }
   catch (Exception ex) { System.out.println("Ex cancelling Advanced Bookmark Mode: " + ex.getMessage()); }
}//GEN-LAST:event_btnAdvBookmarkCancelActionPerformed

private void btnDisconnectTimeoutActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnDisconnectTimeoutActionPerformed
{//GEN-HEADEREND:event_btnDisconnectTimeoutActionPerformed
   try { gui.getAcceptor().setDisconnectTimeout(Integer.parseInt(txtDisconnectTimeout.getText())); }
   catch (Exception ex) { System.out.println("Ex setting Disconnect Timeout: " + ex.getMessage()); }
}//GEN-LAST:event_btnDisconnectTimeoutActionPerformed

private void btnEnableCashBoxCleanlinessReportingActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnEnableCashBoxCleanlinessReportingActionPerformed
{//GEN-HEADEREND:event_btnEnableCashBoxCleanlinessReportingActionPerformed
   try { gui.getAcceptor().enableCashboxCleanlinessReporting(); }
   catch (Exception ex) { System.out.println("Ex enabling CashBox Cleanliness Reporting: " + ex.getMessage()); }
}//GEN-LAST:event_btnEnableCashBoxCleanlinessReportingActionPerformed

private void btnDisableCashBoxCleanlinessReportingActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnDisableCashBoxCleanlinessReportingActionPerformed
{//GEN-HEADEREND:event_btnDisableCashBoxCleanlinessReportingActionPerformed
   try { gui.getAcceptor().disableCashboxCleanlinessReporting(); }
   catch (Exception ex) { System.out.println("Ex disabling CashBox Cleanliness Reporting: " + ex.getMessage()); }
}//GEN-LAST:event_btnDisableCashBoxCleanlinessReportingActionPerformed


   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JButton bQueryAssetNumber;
   private javax.swing.JButton bSetAssetNumber;
   private javax.swing.JButton btnAdvBookmarkCancel;
   private javax.swing.JButton btnAdvBookmarkEnable;
   private javax.swing.JButton btnDisableCashBoxCleanlinessReporting;
   private javax.swing.JButton btnDisconnectTimeout;
   private javax.swing.JButton btnEnableCashBoxCleanlinessReporting;
   private javax.swing.JCheckBox cAcceptance;
   private javax.swing.JCheckBox cAutoStack;
   private javax.swing.JCheckBox cBarCodes;
   private javax.swing.JComboBox cBasicOrientation;
   private javax.swing.JCheckBox cBookmarks;
   private javax.swing.JCheckBox cExtendedCoupon;
   private javax.swing.JComboBox cExtendedOrientation;
   private javax.swing.JCheckBox cHighSecurity;
   private javax.swing.JCheckBox cNoPush;
   private javax.swing.JLabel jLabel1;
   private javax.swing.JLabel jLabel2;
   private javax.swing.JLabel jLabel3;
   private javax.swing.JLabel jLabel4;
   private javax.swing.JPanel jPanel1;
   private javax.swing.JPanel jPanel2;
   private javax.swing.JPanel jPanel3;
   private javax.swing.JLabel lBasicorientation;
   private javax.swing.JLabel lExtendedOrientation;
   private javax.swing.JPanel pAssetNumber;
   private javax.swing.JPanel pCheckboxes;
   private javax.swing.JPanel pComboboxes;
   private javax.swing.JTextField tAssetNumber;
   private javax.swing.JTextField txtDisconnectTimeout;
   // End of variables declaration//GEN-END:variables
}
