﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using com.citizen.sdk;

namespace IpSettings_sample_CS
{
	public partial class Form1 : Form
	{
		private int defaultSearchTime = 3;
		private string defaultMacAddress = "00:0D:AC:xx:xx:xx";
		private string defaultIpAddress = "192.168.1.100";
		private string defaultSubnetMask = "255.255.255.0";
		private string defaultDefaultGateway = "192.168.1.1";
		private enum DGColumn { IPAddress = 0, MACAddress };


		public Form1()
		{
			InitializeComponent();
		}

		// Form1 Load
		private void Form1_Load(object sender, EventArgs e)
		{
			// Title
			this.Text = "IP Settings Sample";

			// Default settings
			textBox_SearchTime.Text = defaultSearchTime.ToString();
			textBox_MacAddress.Text = defaultMacAddress;
			textBox_IpAddress.Text = defaultIpAddress;
			textBox_SubnetMask.Text = defaultSubnetMask;
			textBox_DefaultGateway.Text = defaultDefaultGateway;

			// Initialize DataGridView
			initDataGridView();

			// Default focus
			this.ActiveControl = button_SearchCitizenPrinter;
		}

		// button_SearchCitizenPrinter Click
		private void button_SearchCitizenPrinter_Click(object sender, EventArgs e)
		{
			// Set search time
			int searchTime = defaultSearchTime;
			try
			{
				searchTime = int.Parse(textBox_SearchTime.Text);
			}
			catch
			{
			}

			// Change the cursor icon to the standby state.
			Cursor.Current = Cursors.WaitCursor;


			// Constructor
			ESCPOSPrinter posPtr = new ESCPOSPrinter();

			//
			// Search network printers
			//
			int result;
			CitizenPrinterInfo[] infoList = posPtr.SearchCitizenPrinter(ESCPOSConst.CMP_PORT_WiFi, searchTime, out result);

			// Update DataGridView
			updateDataGridView(infoList);


			// Return the cursor icon to the default.
			Cursor.Current = Cursors.Default;

			if (ESCPOSConst.CMP_SUCCESS == result)
			{
				// Success
				MessageBox.Show("SearchCitizenPrinter() : Success", this.Text, MessageBoxButtons.OK, MessageBoxIcon.None);
			}
			else
			{
				// Error
				MessageBox.Show("SearchCitizenPrinter() Error : " + result.ToString(), this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}

		// button_SetIpSetting Click
		private void button_SetIpSetting_Click(object sender, EventArgs e)
		{
			string ipAddress = textBox_IpAddress.Text;
			string subnetMask = textBox_SubnetMask.Text;
			string defaultGateway = textBox_DefaultGateway.Text;

			if (checkBox_IpAddress.Checked) ipAddress = null;
			if (checkBox_SubnetMask.Checked) subnetMask = null;
			if (checkBox_DefaultGateway.Checked) defaultGateway = null;

			// Change the cursor icon to the standby state.
			Cursor.Current = Cursors.WaitCursor;


			// Constructor
			ESCPOSPrinter posPtr = new ESCPOSPrinter();

			//
			// Set IP settings
			//
			int result;
			result = posPtr.SetIPSettings(textBox_MacAddress.Text, checkBox_DHCP.Checked, ipAddress, subnetMask, defaultGateway);


			// Return the cursor icon to the default.
			Cursor.Current = Cursors.Default;

			if (ESCPOSConst.CMP_SUCCESS == result)
			{
				// Success
				MessageBox.Show("SetIPSettings() : Success", this.Text, MessageBoxButtons.OK, MessageBoxIcon.None);
			}
			else
			{
				// Error
				MessageBox.Show("SetIPSettings() Error : " + result.ToString(), this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}


		// Initialize DataGridView
		private void initDataGridView()
		{
			dataGridView1.AllowUserToAddRows = false;
			dataGridView1.AllowUserToDeleteRows = false;
			dataGridView1.EditMode = DataGridViewEditMode.EditProgrammatically;
			dataGridView1.MultiSelect = false;
			dataGridView1.ReadOnly = true;
			dataGridView1.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
			dataGridView1.DefaultCellStyle.WrapMode = DataGridViewTriState.True;
			dataGridView1.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.AllCells;
			dataGridView1.DefaultCellStyle.Padding = new Padding(2, 2, 2, 2);
		}
		// Update DataGridView
		private void updateDataGridView(CitizenPrinterInfo[] infoList)
		{
			// Clear rows
			dataGridView1.Rows.Clear();

			// Add rows
			foreach (CitizenPrinterInfo info in infoList)
			{
				dataGridView1.Rows.Add();
				// Set data to row
				int rowIndex = dataGridView1.RowCount - 1;
				dataGridView1[(int)DGColumn.IPAddress, rowIndex].Value = info.ipAddress;
				dataGridView1[(int)DGColumn.MACAddress, rowIndex].Value = info.macAddress;
			}
			// Sort by IP address
			dataGridView1.Sort(dataGridView1.Columns[(int)DGColumn.IPAddress], System.ComponentModel.ListSortDirection.Ascending);
			// Clear Serction
			dataGridView1.ClearSelection();
		}
		// Get selected item in DataGridView
		private string getSelectedDataGridView(int column)
		{
			string str = "";

			foreach (DataGridViewRow row in dataGridView1.SelectedRows)
			{
				str = dataGridView1[column, row.Index].Value.ToString();
				break;
			}
			return str;
		}
		//
		private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
		{
			// Get address from DataGridView
			string ipAddress = getSelectedDataGridView((int)DGColumn.IPAddress);
			string macAddress = getSelectedDataGridView((int)DGColumn.MACAddress);

			// Set address to TextBox
			textBox_MacAddress.Text = macAddress;
			textBox_IpAddress.Text = ipAddress;
		}

		// checkBox_DHCP CheckedChanged
		private void checkBox_DHCP_CheckedChanged(object sender, EventArgs e)
		{
			checkBox_IpAddress.Checked = checkBox_DHCP.Checked;
			checkBox_SubnetMask.Checked = checkBox_DHCP.Checked;
			checkBox_DefaultGateway.Checked = checkBox_DHCP.Checked;
		}
		// checkBox_IpAddress CheckedChanged
		private void checkBox_IpAddress_CheckedChanged(object sender, EventArgs e)
		{
			textBox_IpAddress.Enabled = !checkBox_IpAddress.Checked;
		}
		// checkBox_SubnetMask CheckedChanged
		private void checkBox_SubnetMask_CheckedChanged(object sender, EventArgs e)
		{
			textBox_SubnetMask.Enabled = !checkBox_SubnetMask.Checked;
		}
		// checkBox_DefaultGateway CheckedChanged
		private void checkBox_DefaultGateway_CheckedChanged(object sender, EventArgs e)
		{
			textBox_DefaultGateway.Enabled = !checkBox_DefaultGateway.Checked;
		}
	}
}
