﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using com.citizen.sdk;

namespace Citizen_POS_sample2_CS
{
    public partial class Form1 : Form
    {
        ESCPOSPrinter posPtr;

        public Form1()
        {
            InitializeComponent();

            // ComboBoxColumnで使用するDataTableの作成
            DataTable dataTable1 = new DataTable("ComboBox");
            dataTable1.Columns.Add("Display", typeof(string));
            dataTable1.Columns.Add("Value", typeof(int));
            dataTable1.Rows.Add("WiFi", ESCPOSConst.CMP_PORT_WiFi);
            dataTable1.Rows.Add("USB", ESCPOSConst.CMP_PORT_USB);
            dataTable1.Rows.Add("COM", ESCPOSConst.CMP_PORT_COM);
            dataTable1.Rows.Add("LPT", ESCPOSConst.CMP_PORT_LPT);
            dataTable1.Rows.Add("Bluetooth", ESCPOSConst.CMP_PORT_Bluetooth);
            comboBox1.DataSource = dataTable1;
            comboBox1.DisplayMember = "Display";
            comboBox1.ValueMember = "Value";
            comboBox1.SelectedIndex = 0;

            // Constructor
            posPtr = new ESCPOSPrinter();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // Get Address
            String addr = textBox1.Text;

            // Get I/F Type
            int type = (int)comboBox1.SelectedValue;

            // Set COMM Properties
            if (ESCPOSConst.CMP_PORT_COM == type)
            {
                posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR);
            }

            // Connect
            int result = posPtr.Connect(type, addr);
            if (ESCPOSConst.CMP_SUCCESS == result)
            {
                // Connect Success
                MessageBox.Show("Connect() : Success", "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.None);
            }
            else
            {
                // Connect Error
                MessageBox.Show("Connect() Error : " + result.ToString(), "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            // Printer Check
            int result = posPtr.PrinterCheck();
            if (ESCPOSConst.CMP_SUCCESS == result)
            {
                String msg = "PrinterCheck() : Success\n";
                //
                // Get Status
                int status = posPtr.Status();
                msg += "\nStatus() : ";
                //
                // Status Check
                if (ESCPOSConst.CMP_STS_NORMAL == status)
                {
                    // No Error
                    msg += "\n\t * Normal ( No Error )";
                }
                else
                {
                    if ((ESCPOSConst.CMP_STS_COVER_OPEN & status) > 0)
                    {
                        // Cover Open
                        msg += "\n\t * Cover Open";
                    }
                    if ((ESCPOSConst.CMP_STS_PAPER_EMPTY & status) > 0)
                    {
                        // Paper Empty
                        msg += "\n\t * Paper Empty";
                    }
                    if ((ESCPOSConst.CMP_STS_PRINTEROFF & status) > 0)
                    {
                        // Printer Offline
                        msg += "\n\t * Printer Offline";
                    }
                }
                MessageBox.Show(msg, "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.None);
            }
            else
            {
                // PrinterCheck Error
                MessageBox.Show("PrinterCheck() Error : " + result.ToString(), "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            int result;
            String msg = "";

            // Printer Check
            result = posPtr.PrinterCheck();
            if (ESCPOSConst.CMP_SUCCESS != result)
            {
                MessageBox.Show("PrinterCheck() Error : " + result.ToString(), "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            // Get Status
            result = posPtr.Status();
            if (ESCPOSConst.CMP_STS_NORMAL != result)
            {
                MessageBox.Show("Status Error : " + result.ToString(), "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            // Character set
            result = posPtr.SetEncoding("ISO-8859-1");	// Latin-1
            //result = posPtr.SetEncoding( "Shift_JIS" );	// Japanese 日本語を印字する場合は、この行を有効にしてください.
            if (ESCPOSConst.CMP_SUCCESS != result)
            {
                MessageBox.Show("SetEncoding() Error : " + result.ToString(), "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            try
            {
                // Start Transaction ( Batch )
                result = posPtr.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);
                if (ESCPOSConst.CMP_SUCCESS != result)
                {
                    msg = "TransactionPrint() Error : " + result.ToString();
                    throw new Exception();
                }

                // Print text
                result = posPtr.PrintText("Citizen_POS_sample2\n\n- Sample Print -\n1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);
                if (ESCPOSConst.CMP_SUCCESS != result)
                {
                    msg = "PrintText() Error : " + result.ToString();
                    throw new Exception();
                }

                // Partial Cut with Pre-Feed
                result = posPtr.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
                if (ESCPOSConst.CMP_SUCCESS != result)
                {
                    msg = "CutPaper() Error : " + result.ToString();
                    throw new Exception();
                }

                // End Transaction ( Batch )
                result = posPtr.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL);
                if (ESCPOSConst.CMP_SUCCESS != result)
                {
                    msg = "TransactionPrint() Error : " + result.ToString();
                    throw new Exception();
                }

                // Connect Success
                MessageBox.Show("Print : Success", "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.None);
            }
            catch
            {
                // Clear all buffered output data by TransactionPrint.
                posPtr.ClearOutput();

                // Print Error
                MessageBox.Show(msg, "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            // Disconnect
            int result = posPtr.Disconnect();
            if (ESCPOSConst.CMP_SUCCESS == result)
            {
                // Disconnect Success
                MessageBox.Show("Disconnect() : Success", "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.None);
            }
            else
            {
                // Disconnect Error
                MessageBox.Show("Disconnect() Error : " + result.ToString(), "Citizen_POS_sample2", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
