/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.event.AcceptorEvent;
import com.meiglobal.ebds.api.event.AcceptorEventListener;
import com.meiglobal.ebds.api.event.DownloadFinishEvent;
import com.meiglobal.ebds.api.event.DownloadProgressEvent;
import com.meiglobal.ebds.api.event.DownloadRestartEvent;
import com.meiglobal.ebds.api.event.DownloadStartEvent;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.gui.TestGUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class FlashDownloadDialog
extends JDialog
implements AcceptorEventListener {
    TestGUI gui;
    JFileChooser chooser = new JFileChooser();
    int currentPacket = 0;
    int maxNumber = 0;
    private JButton bOpen;
    private JButton bStart;
    private JLabel lFile;
    private JLabel lProgress;
    private JPanel pMain;
    private JProgressBar pProgress;
    private JTextField tFile;

    public FlashDownloadDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.gui = (TestGUI)parent;
        this.initComponents();
        this.pProgress.setIndeterminate(true);
        this.pProgress.setStringPainted(true);
        this.chooser.setApproveButtonText("Select");
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setDialogTitle("Select a flash file to download.");
        this.chooser.setFileSelectionMode(0);
        this.gui.getAcceptor().addAcceptorEventListener(this);
    }

    FlashDownloadDialog(TestGUI parent, String absolutePath, boolean modal) {
        this((Frame)parent, modal);
        try {
            this.tFile.setText(absolutePath);
            this.pProgress.setIndeterminate(false);
            this.bOpen.setEnabled(false);
            this.bStart.setEnabled(false);
            this.gui.getAcceptor().flashDownload(absolutePath);
        }
        catch (AcceptorException ex) {
            JOptionPane.showMessageDialog(this, "Error while trying to restart the download: " + ex.getMessage(), "Error on download restart", 0);
            this.bOpen.setEnabled(true);
            this.bStart.setEnabled(true);
        }
    }

    public void acceptorEventOccurred(AcceptorEvent evt) {
        if (evt instanceof DownloadStartEvent) {
            this.pProgress.setMinimum(0);
            this.maxNumber = ((DownloadStartEvent)evt).getPacketCount();
            this.pProgress.setMaximum(this.maxNumber);
            this.pProgress.setValue(0);
            this.lProgress.setText("Sent: 0 of " + this.maxNumber + " packets");
        } else if (evt instanceof DownloadProgressEvent) {
            this.currentPacket = 1 + ((DownloadProgressEvent)evt).getPacketNumber();
            if (this.currentPacket % 10 == 0) {
                this.pProgress.setValue(this.currentPacket);
                this.lProgress.setText("Sent: " + this.currentPacket + " of " + this.maxNumber + " packets");
            } else if (this.currentPacket > this.maxNumber - 25) {
                this.pProgress.setValue(this.currentPacket);
                this.lProgress.setText("Sent: " + this.currentPacket + " of " + this.maxNumber + " packets");
            }
        } else if (evt instanceof DownloadFinishEvent) {
            boolean success = ((DownloadFinishEvent)evt).successful();
            if (success) {
                this.pProgress.setValue(this.pProgress.getMaximum());
                this.lProgress.setText("Flash download successful");
            } else {
                this.pProgress.setIndeterminate(true);
                this.lProgress.setText("An error occurred trying to download the new flash file");
            }
            this.bOpen.setEnabled(true);
            this.bStart.setEnabled(true);
        } else if (evt instanceof DownloadRestartEvent) {
            try {
                this.gui.getAcceptor().flashDownload(this.tFile.getText());
            }
            catch (AcceptorException ex) {
                JOptionPane.showMessageDialog(this, "Error while restarting the download process" + System.getProperty("line.separator") + ex.getMessage(), "Error on download restart", 0);
                ex.printStackTrace();
            }
        }
    }

    public void dispose() {
        if (!this.gui.getAcceptor().stopDownload()) {
            JOptionPane.showMessageDialog(this, "Could not stop flash download thread, restarting the application is recommended", "Error", 0);
        }
        this.gui.fdd = null;
        super.dispose();
    }

    private void initComponents() {
        this.pMain = new JPanel();
        this.lFile = new JLabel();
        this.tFile = new JTextField();
        this.bOpen = new JButton();
        this.pProgress = new JProgressBar();
        this.bStart = new JButton();
        this.lProgress = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Flash Download");
        this.pMain.setLayout(new GridBagLayout());
        this.lFile.setText("File");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pMain.add((Component)this.lFile, gridBagConstraints);
        this.tFile.setMinimumSize(new Dimension(250, 20));
        this.tFile.setPreferredSize(new Dimension(400, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pMain.add((Component)this.tFile, gridBagConstraints);
        this.bOpen.setText("Open");
        this.bOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FlashDownloadDialog.this.bOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pMain.add((Component)this.bOpen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pMain.add((Component)this.pProgress, gridBagConstraints);
        this.bStart.setText("Start");
        this.bStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FlashDownloadDialog.this.bStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pMain.add((Component)this.bStart, gridBagConstraints);
        this.lProgress.setHorizontalAlignment(0);
        this.lProgress.setText("Select File and click start");
        this.lProgress.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pMain.add((Component)this.lProgress, gridBagConstraints);
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pack();
    }

    private void bOpenActionPerformed(ActionEvent evt) {
        if (this.chooser.showOpenDialog(this) == 0) {
            this.tFile.setText(this.chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void bStartActionPerformed(ActionEvent evt) {
        try {
            this.pProgress.setIndeterminate(false);
            this.bOpen.setEnabled(false);
            this.bStart.setEnabled(false);
            this.gui.getAcceptor().flashDownload(this.tFile.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Exception occured", 0);
        }
    }
}

