/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.api;

import com.meiglobal.ebds.api.pub.AcceptorException;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;

public class WrappedSerialPort
implements SerialPortEventListener {
    private static final int TRANSFER_RATE = 9600;
    private CommPort _commPort = null;
    private InputStream _in = null;
    private OutputStream _out = null;
    protected String _strPortName = "";
    protected byte[] _buffer = new byte[256];
    protected int _iRead = 0;
    protected int _iWrite = 0;

    public boolean isOpen() {
        return this._commPort != null && this._in != null && this._out != null;
    }

    public static String[] listPorts() {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> ports = new ArrayList<String>();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            ports.add(portIdentifier.getName());
        }
        return ports.toArray(new String[ports.size()]);
    }

    public boolean openPort(String portName) throws AcceptorException {
        this._strPortName = portName;
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
            if (portIdentifier.isCurrentlyOwned()) {
                throw new AcceptorException("The specified port is currently in use");
            }
            this._commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (this._commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)this._commPort;
                serialPort.setSerialPortParams(9600, 7, 1, 2);
                serialPort.addEventListener(this);
                serialPort.notifyOnDataAvailable(true);
                this._in = serialPort.getInputStream();
                this._out = serialPort.getOutputStream();
                return true;
            }
            throw new AcceptorException("Error: Only serial ports are handled by this application.");
        }
        catch (TooManyListenersException tmlEx) {
            throw new AcceptorException("Could not initialize the listener for the Serial Port object." + tmlEx.getMessage());
        }
        catch (NoSuchPortException nspe) {
            throw new AcceptorException("The specified port does not exist");
        }
        catch (PortInUseException piux) {
            throw new AcceptorException("The specified port port is currently in use");
        }
        catch (UnsupportedCommOperationException ucox) {
            throw new AcceptorException("Error in port configuration");
        }
        catch (IOException ioe) {
            this._in = null;
            this._out = null;
            throw new AcceptorException("Internal error please retry");
        }
    }

    public void close() {
        if (this._commPort != null) {
            try {
                if (this._in != null) {
                    this._in.close();
                    this._in = null;
                }
                if (this._out != null) {
                    this._out.close();
                    this._out = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._commPort.close();
        }
    }

    public synchronized void send(byte[] data) throws IOException {
        this._out.write(data);
    }

    protected void flushInputStream() {
        this._iRead = 0;
        this._iWrite = 0;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                int btAvail = 0;
                try {
                    btAvail = this._in.available();
                    if (btAvail <= 0) break;
                    this._in.read(this._buffer, this._iWrite, btAvail);
                    this._iWrite += btAvail;
                }
                catch (IOException e) {
                    this.flushInputStream();
                }
                break;
            }
        }
    }
}

