package com.meiglobal.ebds.gui;


import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.AuditLifeTimeTotals;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;

/**
 * Dialog that shows the audit life time totals.
 */
public class AuditLifetimeTotalsDialog extends javax.swing.JDialog {
    TestGUI gui;
    /** Creates new form DeviceInfoDialog
     * @param parent
     * @param modal
     */
    public AuditLifetimeTotalsDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.gui= (TestGUI) parent;
        initComponents();
        createLabels();
    }

    private void createLabels() {
        try{
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx=0;
        gbc.gridy=0;
        gbc.fill=GridBagConstraints.HORIZONTAL;
        gbc.insets=new Insets(3,3,3,3);
        gbc.anchor=GridBagConstraints.WEST;
        if(gui.getAcceptor().getCapAudit()){
            JLabel lPerformance = new JLabel("Audit Lifetime Totals: ");
            pMain.add(lPerformance,gbc);
            AuditLifeTimeTotals auditTotals = gui.getAcceptor().GetAuditLifeTimeTotals();
            gbc.gridy++;
            JLabel lDataMap = new JLabel("Data map: "+auditTotals.getDataMap());
            pMain.add(lDataMap,gbc);
            gbc.gridy++;
            JLabel lOpHours = new JLabel("Total Op Hours: "+auditTotals.getOpHours());
            pMain.add(lOpHours,gbc);
            gbc.gridy++;
            JLabel lMotStarts = new JLabel("Total Mot Starts: "+auditTotals.getMotStart());
            pMain.add(lMotStarts,gbc);
            gbc.gridy++;
            JLabel lEscrow = new JLabel("Total Escrow: "+auditTotals.getEscrow());
            pMain.add(lEscrow,gbc);
            gbc.gridy++;
            JLabel lRecognized = new JLabel("Total Recognized: "+auditTotals.getRecognized());
            pMain.add(lRecognized,gbc);
            gbc.gridy++;
            JLabel lValidated = new JLabel("Total Validated: "+auditTotals.getValidated());
            pMain.add(lValidated,gbc);
        }else{
            JLabel lPerformance = new JLabel("Audit Lifetime Totals not supported");
            pMain.add(lPerformance,gbc);
        }
        pack();
        }catch(AcceptorException ae){
            ae.printStackTrace();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pMain = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Audit Life Time Totals");

        pMain.setLayout(new java.awt.GridBagLayout());
        getContentPane().add(pMain, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pMain;
    // End of variables declaration//GEN-END:variables

}
