package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.Acceptor;
import com.meiglobal.ebds.api.pub.AcceptorException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/**
 * Main GUI class, used to launch instances.
 */
public class GUI extends javax.swing.JFrame {

    private List<TestGUI> instances = new ArrayList<TestGUI>();

    /** Creates new form GUI */
    public GUI() {
        initComponents();
        lVersion.setText("API Version in Use: "+Acceptor.getVersion());
        center();
        doRetrievePorts();
    }

    void addPort(String port) {
        cPorts.addItem(port);
    }

    private void center() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = getWidth() / 2;
        int y = getHeight() / 2;
        Point p = new Point((int) (d.getWidth() / 2 - x), (int) (d.getHeight() / 2 - y));
        this.setLocation(p);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      cPorts = new javax.swing.JComboBox();
      bRetrievePorts = new javax.swing.JButton();
      jLabel1 = new javax.swing.JLabel();
      bConnect = new javax.swing.JButton();
      jLabel2 = new javax.swing.JLabel();
      jButton1 = new javax.swing.JButton();
      lVersion = new javax.swing.JLabel();

      setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
      setTitle("M/POST Java Demo V2.80");
      getContentPane().setLayout(new java.awt.GridBagLayout());

      cPorts.setPreferredSize(new java.awt.Dimension(200, 20));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(cPorts, gridBagConstraints);

      bRetrievePorts.setText("Retrieve Ports");
      bRetrievePorts.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bRetrievePortsActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(bRetrievePorts, gridBagConstraints);

      jLabel1.setText("Available Ports");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(jLabel1, gridBagConstraints);

      bConnect.setText("Start");
      bConnect.setToolTipText("Launch a Bill Acceptor control panel.");
      bConnect.setEnabled(false);
      bConnect.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            bConnectActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(bConnect, gridBagConstraints);

      jLabel2.setText("Retrieve the available ports and then click open to initiate the instance");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.gridwidth = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(jLabel2, gridBagConstraints);

      jButton1.setText("Exit");
      jButton1.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            ExitDemoButton(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 4;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(jButton1, gridBagConstraints);

      lVersion.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
      lVersion.setText("API Version in Use:");
      lVersion.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(lVersion, gridBagConstraints);

      pack();
   }// </editor-fold>//GEN-END:initComponents

private void bRetrievePortsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRetrievePortsActionPerformed
    doRetrievePorts();
}//GEN-LAST:event_bRetrievePortsActionPerformed

private void doRetrievePorts()
{
    String[] ports = Acceptor.listPorts();
    List<String> freePorts = new ArrayList<String>();
    
    for (String port : ports)
    {
        boolean found = false;
        for (TestGUI gui : instances)
        {
            if (port.equals(gui.getPort()))
            {
                found = true;
                break;
            }

        }

        if (!found)
        {
            freePorts.add(port);
        }
    }

    cPorts.setModel(new DefaultComboBoxModel(freePorts.toArray()));
    bConnect.setEnabled(true);

}

private void bConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bConnectActionPerformed
    try {
        String port = (String) cPorts.getSelectedItem();
        TestGUI instance = new TestGUI(this, port);
        instances.add(instance);
        instance.center();
        cPorts.removeItem(port);
        instance.setVisible(true);
    } catch (AcceptorException ex) {
        Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
        JOptionPane.showMessageDialog(this, "There has been an error instantiating the demo app", "Error", JOptionPane.ERROR_MESSAGE);
    }


}//GEN-LAST:event_bConnectActionPerformed

private void ExitDemoButton(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ExitDemoButton
    System.exit(0);
}//GEN-LAST:event_ExitDemoButton

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
         try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            Logger.getLogger(TestGUI.class.getName()).severe("Could not initialize system look and feel");
        }
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new GUI().setVisible(true);
            }
        });
    }

   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JButton bConnect;
   private javax.swing.JButton bRetrievePorts;
   private javax.swing.JComboBox cPorts;
   private javax.swing.JButton jButton1;
   private javax.swing.JLabel jLabel1;
   private javax.swing.JLabel jLabel2;
   private javax.swing.JLabel lVersion;
   // End of variables declaration//GEN-END:variables

}
