package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.pub.AcceptorException;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

/**
 * Dialog that shows the device information.
 */
public class DeviceInfoDialog extends javax.swing.JDialog implements com.meiglobal.ebds.api.event.AcceptorEventListener {
    TestGUI gui;
    JLabel lCashBoxTotal;
    javax.swing.JButton CashClearButton;

    /** Creates new form DeviceInfoDialog */
    public DeviceInfoDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.gui= (TestGUI) parent;
        initComponents();
        createLabels();
    }

    private void bClearActionPerformed(java.awt.event.ActionEvent evt) {
        try
        {
            gui.getAcceptor().clearCashBoxTotal();
            String cashBoxTotal= "Cash Box Total: " + (String.valueOf(gui.getAcceptor().getCashBoxTotal()));
            lCashBoxTotal.setText(cashBoxTotal);
        }
        catch (Exception e)
        {
        }
    }

    public void acceptorEventOccurred(com.meiglobal.ebds.api.event.AcceptorEvent evt)
    {
        if (evt instanceof com.meiglobal.ebds.api.event.StackedEvent)
        {
           SwingUtilities.invokeLater(new Runnable()
           {
               public void run()
               {
                  if(gui.getAcceptor().getCapCashBoxTotal())
                  {
                     try
                     {
                        String cashBoxTotal= "Cash Box Total: " + (String.valueOf(gui.getAcceptor().getCashBoxTotal()));
                        lCashBoxTotal.setText(cashBoxTotal);
                     }
                     catch(AcceptorException ae)
                     {
                        ae.printStackTrace();
                     }
                  }
               }
           });
        }
    }
    
    private void createLabels()
    {
        try
        {
            this.enableEvents(java.awt.AWTEvent.ACTION_EVENT_MASK);
            gui.getAcceptor().addAcceptorEventListener(this);

            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx=0;
            gbc.gridy=0;
            gbc.fill=GridBagConstraints.HORIZONTAL;
            gbc.anchor=gbc.WEST;
            gbc.insets=new Insets(3,3,3,3);
            JLabel lDeviceTitle = new JLabel("DEVICE INFO:");
            pMain.add(lDeviceTitle,gbc);
            gbc.gridy++;

            if (gui.getAcceptor().getCapDeviceType())
            {
                JLabel lDeviceType = new JLabel("Device type: " + gui.getAcceptor().getDeviceType());
                pMain.add(lDeviceType,gbc);
                gbc.gridy++;
            }
            else
            {
                JLabel lDeviceType = new JLabel("Device type: Not supported");
                pMain.add(lDeviceType,gbc);
                gbc.gridy++;
            }

            JLabel lDeviceCRC = new JLabel("Device CRC: " + String.format("%04X", gui.getAcceptor().getDeviceCRC()));
            pMain.add(lDeviceCRC,gbc);
            gbc.gridy++;

            JLabel lDeviceSerial = new JLabel("Serial #: "+gui.getAcceptor().getDeviceSerialNumber());
            pMain.add(lDeviceSerial,gbc);
            gbc.gridy++;

            if (gui.getAcceptor().getCapBootPN())
            {
                JLabel lDeviceBootPartNumber = new JLabel("Boot part #: "+gui.getAcceptor().getBootPN());
                pMain.add(lDeviceBootPartNumber,gbc);
                gbc.gridy++;
            }
            else
            {
                JLabel lDeviceBootPartNumber = new JLabel("Boot part #: Not supported");
                pMain.add(lDeviceBootPartNumber,gbc);
                gbc.gridy++;
            }

            if (gui.getAcceptor().getCapApplicationPN())
            {
                JLabel lApplicationPN = new JLabel("Application PN: "+gui.getAcceptor().getApplicationPN());
                pMain.add(lApplicationPN,gbc);
                gbc.gridy++;
            }
            else
            {
                JLabel lApplicationPN = new JLabel("Application PN: Not Supported");
                pMain.add(lApplicationPN,gbc);
                gbc.gridy++;
            }

            if (gui.getAcceptor().getCapApplicationId())
            {
                JLabel lApplicationId = new JLabel("Application Id: "+gui.getAcceptor().getApplicationId());
                pMain.add(lApplicationId,gbc);
                gbc.gridy++;
            }
            else
            {
                JLabel lApplicationId = new JLabel("Application Id: Not supported");
                pMain.add(lApplicationId,gbc);
                gbc.gridy++;
            }


            JLabel lVariantPN = null;
            JLabel lVariantName = null;

            if(gui.getAcceptor().getCapVariantPN())
            {
                lVariantPN = new JLabel("Variant PN: "+gui.getAcceptor().getVariantPN());
            }
            else
            {
                lVariantPN = new JLabel("Variant PN: Not supported");
            }

            pMain.add(lVariantPN,gbc);
            gbc.gridy++;

            if (gui.getAcceptor().getCapVariantId())
            {
                JLabel lVariantId = new JLabel("Variant Id: "+gui.getAcceptor().getVariantID());
                pMain.add(lVariantId,gbc);
                gbc.gridy++;
            }
            else
            {
                JLabel lVariantId = new JLabel("Variant Id: Not supported");
                pMain.add(lVariantId,gbc);
                gbc.gridy++;
            }

            if(gui.getAcceptor().getCapVariantPN())
            {
                String variants = "Variant Names: ";
                List<String> names = gui.getAcceptor().getVariantNames();

                for(String name : names)
                {
                    variants = variants + name + System.getProperty("line.separator");
                }

                lVariantName=new JLabel(variants);
            }
            else
            {
                lVariantName=new JLabel("Variant Names: Not supported");
            }

            pMain.add(lVariantName,gbc);
            gbc.gridy++;

            JLabel lCasseteStatus = new JLabel("Cassette: "+(gui.getAcceptor().getCashBoxAttached()?"Installed":"Not installed"));
            pMain.add(lCasseteStatus,gbc);
            gbc.gridy++;

            String cashBoxTotal= "Cash Box Total: "+ (gui.getAcceptor().getCapCashBoxTotal()==true?String.valueOf(gui.getAcceptor().getCashBoxTotal()):"Not supported");
            lCashBoxTotal = new JLabel(cashBoxTotal);
            pMain.add(lCashBoxTotal,gbc);
            gbc.gridy++;

            if (gui.getAcceptor().getCapCashBoxTotal())
            {
                CashClearButton = new javax.swing.JButton();
                CashClearButton.setText("Clear");
                CashClearButton.setToolTipText("Clear the Cash box total.");
                CashClearButton.addActionListener(new java.awt.event.ActionListener()
                {
                    public void actionPerformed(java.awt.event.ActionEvent evt)
                    {
                        bClearActionPerformed(evt);
                    };
                } );

                pMain.add(CashClearButton, gbc);
                gbc.gridy++;
            }

            JLabel lResets = new JLabel(String.valueOf("Resets: "+gui.getAcceptor().getDeviceResets()));
            pMain.add(lResets,gbc);
            gbc.gridy++;
            JLabel lPath = new JLabel("Bill path: "+String.valueOf(gui.getAcceptor().getDeviceJammed()?"Jammed":"Clear"));
            pMain.add(lPath,gbc);
            gbc.gridy++;
            long model = gui.getAcceptor().getDeviceModel();
            String modelString = "Model: "+model;

            if(model>=32)
            {
                modelString = modelString + " ("+(char)model+")";
            }

            JLabel lModel = new JLabel(modelString);
            pMain.add(lModel,gbc);
            gbc.gridy++;
            JLabel lBNFStatus = new JLabel("BNF Status: "+(gui.getAcceptor().getCapBNFStatus()?gui.getAcceptor().GetBNFStatus():"Not supported"));
            pMain.add(lBNFStatus,gbc);
            pack();
        }
        catch(AcceptorException ae)
        {
            ae.printStackTrace();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pMain = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Device Info");

        pMain.setLayout(new java.awt.GridBagLayout());
        getContentPane().add(pMain, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pMain;
    // End of variables declaration//GEN-END:variables

}
